/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.core;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.cdt.core.AbstractCExtension;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IPathEntry;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.IScannerInfoChangeListener;
import org.eclipse.cdt.core.parser.IScannerInfoProvider;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IBuildObject;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IManagedConfigElement;
import org.eclipse.cdt.managedbuilder.core.IManagedConfigElementProvider;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.ITarget;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolReference;
import org.eclipse.cdt.managedbuilder.core.ManagedBuilderCorePlugin;
import org.eclipse.cdt.managedbuilder.internal.core.Configuration;
import org.eclipse.cdt.managedbuilder.internal.core.DefaultManagedConfigElement;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedMakeMessages;
import org.eclipse.cdt.managedbuilder.internal.core.Target;
import org.eclipse.cdt.managedbuilder.internal.core.Tool;
import org.eclipse.cdt.managedbuilder.makegen.IManagedBuilderMakefileGenerator;
import org.eclipse.cdt.managedbuilder.makegen.IManagedDependencyGenerator;
import org.eclipse.cdt.managedbuilder.makegen.gnu.GnuMakefileGenerator;
import org.eclipse.cdt.managedbuilder.scannerconfig.IManagedScannerInfoCollector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.PluginVersionIdentifier;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;

public class ManagedBuildManager
extends AbstractCExtension
implements IScannerInfoProvider {
    private static final QualifiedName buildInfoProperty = new QualifiedName(ManagedBuilderCorePlugin.getUniqueIdentifier(), "managedBuildInfo");
    private static final String ROOT_NODE_NAME = "ManagedProjectBuildInfo";
    public static final String SETTINGS_FILE_NAME = ".cdtbuild";
    private static final ITarget[] emptyTargets = new ITarget[0];
    public static final String INTERFACE_IDENTITY = String.valueOf(ManagedBuilderCorePlugin.getUniqueIdentifier()) + ".ManagedBuildManager";
    public static final String EXTENSION_POINT_ID = String.valueOf(ManagedBuilderCorePlugin.getUniqueIdentifier()) + ".ManagedBuildInfo";
    private static final String REVISION_ELEMENT_NAME = "managedBuildRevision";
    private static final String VERSION_ELEMENT_NAME = "fileVersion";
    private static final String MANIFEST_VERSION_ERROR = "ManagedBuildManager.error.manifest.version.error";
    private static final String PROJECT_VERSION_ERROR = "ManagedBuildManager.error.project.version.error";
    private static final PluginVersionIdentifier buildInfoVersion = new PluginVersionIdentifier(2, 0, 0);
    private static Map depCalculatorsMap;
    private static boolean extensionTargetsLoaded;
    private static Map extensionTargetMap;
    private static List extensionTargets;
    private static Map extensionToolMap;
    private static Map configElementMap;
    private static Map buildModelListeners;

    static {
        extensionTargetsLoaded = false;
    }

    public static ITarget[] getDefinedTargets(IProject project) {
        try {
            ManagedBuildManager.loadExtensions();
        }
        catch (BuildException e) {
            e.printStackTrace();
        }
        List definedTargets = null;
        int size = extensionTargets != null ? extensionTargets.size() + (definedTargets != null ? definedTargets.size() : 0) : 0;
        ITarget[] targets = new ITarget[size];
        int n = 0;
        int i = 0;
        while (i < extensionTargets.size()) {
            targets[n++] = (ITarget)extensionTargets.get(i);
            ++i;
        }
        if (definedTargets != null) {
            i = 0;
            while (i < definedTargets.size()) {
                targets[n++] = (ITarget)definedTargets.get(i);
                ++i;
            }
        }
        return targets;
    }

    public static IManagedDependencyGenerator getDependencyGenerator(String toolId) {
        return (IManagedDependencyGenerator)ManagedBuildManager.getExtensionDepCalcMap().get(toolId);
    }

    public static IManagedDependencyGenerator createDependencyGenerator(String toolId) {
        try {
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IExtensionPoint extension = registry.getExtensionPoint(EXTENSION_POINT_ID);
            if (extension != null) {
                IExtension[] extensions = extension.getExtensions();
                int i = 0;
                while (i < extensions.length) {
                    IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
                    int j = 0;
                    while (j < configElements.length) {
                        IConfigurationElement element = configElements[j];
                        if (element.getName().equals("tool")) {
                            if (element.getAttribute("id").equals(toolId) && element.getAttribute("dependencyCalculator") != null) {
                                return (IManagedDependencyGenerator)element.createExecutableExtension("dependencyCalculator");
                            }
                        } else if (element.getName().equals("target")) {
                            IConfigurationElement[] children = element.getChildren("tool");
                            int k = 0;
                            while (k < children.length) {
                                IConfigurationElement child = children[k];
                                if (child.getAttribute("id").equals(toolId) && child.getAttribute("dependencyCalculator") != null) {
                                    return (IManagedDependencyGenerator)child.createExecutableExtension("dependencyCalculator");
                                }
                                ++k;
                            }
                        }
                        ++j;
                    }
                    ++i;
                }
            }
        }
        catch (CoreException coreException) {}
        return null;
    }

    protected static Map getExtensionDepCalcMap() {
        if (depCalculatorsMap == null) {
            depCalculatorsMap = new HashMap();
        }
        return depCalculatorsMap;
    }

    protected static Map getExtensionTargetMap() {
        if (extensionTargetMap == null) {
            extensionTargetMap = new HashMap();
        }
        return extensionTargetMap;
    }

    protected static Map getExtensionToolMap() {
        if (extensionToolMap == null) {
            extensionToolMap = new HashMap();
        }
        return extensionToolMap;
    }

    public static ITarget[] getTargets(IResource resource) {
        IManagedBuildInfo buildInfo = ManagedBuildManager.getBuildInfo(resource);
        if (buildInfo != null) {
            List targets = buildInfo.getTargets();
            return targets.toArray(new ITarget[targets.size()]);
        }
        return emptyTargets;
    }

    public static ITool getTool(String id) {
        return (ITool)ManagedBuildManager.getExtensionToolMap().get(id);
    }

    public static ITarget getTarget(IResource resource, String id) {
        IManagedBuildInfo buildInfo;
        ITarget target = null;
        if (resource != null && (buildInfo = ManagedBuildManager.getBuildInfo(resource)) != null) {
            target = buildInfo.getTarget(id);
        }
        if (target == null) {
            target = (ITarget)ManagedBuildManager.getExtensionTargetMap().get(id);
        }
        return target;
    }

    public static void setDefaultConfiguration(IProject project, IConfiguration newDefault) {
        if (project == null || newDefault == null) {
            return;
        }
        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)project);
        if (info != null) {
            info.setDefaultConfiguration(newDefault);
        }
    }

    public static void setSelectedTarget(IProject project, ITarget target) {
        if (project == null || target == null) {
            return;
        }
        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)project);
        if (info != null) {
            info.setSelectedTarget(target);
        }
    }

    public static IManagedBuilderMakefileGenerator getMakefileGenerator(String targetId) {
        try {
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IExtensionPoint extension = registry.getExtensionPoint(EXTENSION_POINT_ID);
            if (extension != null) {
                IExtension[] extensions = extension.getExtensions();
                int i = 0;
                while (i < extensions.length) {
                    IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
                    int j = 0;
                    while (j < configElements.length) {
                        IConfigurationElement element = configElements[j];
                        if (element.getName().equals("target") && element.getAttribute("id").equals(targetId) && element.getAttribute("makefileGenerator") != null) {
                            return (IManagedBuilderMakefileGenerator)element.createExecutableExtension("makefileGenerator");
                        }
                        ++j;
                    }
                    ++i;
                }
            }
        }
        catch (CoreException coreException) {}
        return new GnuMakefileGenerator();
    }

    public static IManagedScannerInfoCollector getScannerInfoCollector(String targetId) {
        try {
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IExtensionPoint extension = registry.getExtensionPoint(EXTENSION_POINT_ID);
            if (extension != null) {
                IExtension[] extensions = extension.getExtensions();
                int i = 0;
                while (i < extensions.length) {
                    IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
                    int j = 0;
                    while (j < configElements.length) {
                        IConfigurationElement element = configElements[j];
                        if (element.getName().equals("target") && element.getAttribute("id").equals(targetId) && element.getAttribute("scannerInfoCollector") != null) {
                            return (IManagedScannerInfoCollector)element.createExecutableExtension("scannerInfoCollector");
                        }
                        ++j;
                    }
                    ++i;
                }
            }
        }
        catch (CoreException coreException) {}
        return null;
    }

    public static ITarget getSelectedTarget(IProject project) {
        if (project == null) {
            return null;
        }
        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)project);
        if (info != null) {
            return info.getSelectedTarget();
        }
        return null;
    }

    private static void notifyListeners(IConfiguration config, IOption option) {
        if (option.getValueType() != 4 && option.getValueType() != 5) {
            return;
        }
        IResource resource = config.getOwner();
        List listeners = (List)ManagedBuildManager.getBuildModelListeners().get(resource);
        if (listeners == null) {
            return;
        }
        ListIterator iter = listeners.listIterator();
        while (iter.hasNext()) {
            ((IScannerInfoChangeListener)iter.next()).changeNotification(resource, (IScannerInfo)ManagedBuildManager.getBuildInfo(resource));
        }
    }

    public static void setNewProjectVersion(IProject newProject) {
        ManagedBuildInfo info = ManagedBuildManager.findBuildInfo((IResource)newProject);
        info.setVersion(buildInfoVersion.toString());
    }

    public static void setOption(IConfiguration config, IOption option, boolean value) {
        try {
            config.setOption(option, value);
            ManagedBuildManager.notifyListeners(config, option);
        }
        catch (BuildException buildException) {
            return;
        }
    }

    public static void setOption(IConfiguration config, IOption option, String value) {
        try {
            config.setOption(option, value);
            ManagedBuildManager.notifyListeners(config, option);
        }
        catch (BuildException buildException) {
            return;
        }
    }

    public static void setOption(IConfiguration config, IOption option, String[] value) {
        try {
            config.setOption(option, value);
            ManagedBuildManager.notifyListeners(config, option);
        }
        catch (BuildException buildException) {
            return;
        }
    }

    public static void setToolCommand(IConfiguration config, ITool tool, String command) {
        if (tool instanceof IToolReference) {
            ((IToolReference)tool).setToolCommand(command);
        } else {
            config.setToolCommand(tool, command);
        }
    }

    public static void saveBuildInfo(IProject project, boolean force) {
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = builder.newDocument();
            ManagedBuildInfo buildInfo = (ManagedBuildInfo)ManagedBuildManager.getBuildInfo((IResource)project);
            if (buildInfo != null && (force || buildInfo.isDirty())) {
                String projectVersion = buildInfo.getVersion();
                if (projectVersion != null) {
                    ProcessingInstruction instruction = doc.createProcessingInstruction(VERSION_ELEMENT_NAME, projectVersion);
                    doc.appendChild(instruction);
                }
                Element rootElement = doc.createElement(ROOT_NODE_NAME);
                doc.appendChild(rootElement);
                buildInfo.serialize(doc, rootElement);
                ByteArrayOutputStream stream = new ByteArrayOutputStream();
                Transformer transformer = TransformerFactory.newInstance().newTransformer();
                transformer.setOutputProperty("method", "xml");
                transformer.setOutputProperty("indent", "yes");
                DOMSource source = new DOMSource(doc);
                StreamResult result = new StreamResult(stream);
                transformer.transform(source, result);
                IFile projectFile = project.getFile(SETTINGS_FILE_NAME);
                String utfString = stream.toString("UTF8");
                if (projectFile.exists()) {
                    projectFile.setContents((InputStream)new ByteArrayInputStream(utfString.getBytes()), 1, null);
                } else {
                    projectFile.create((InputStream)new ByteArrayInputStream(utfString.getBytes()), 1, null);
                }
                stream.close();
            }
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (FactoryConfigurationError e) {
            e.printStackTrace();
        }
        catch (TransformerConfigurationException e1) {
            e1.printStackTrace();
        }
        catch (TransformerFactoryConfigurationError e1) {
            e1.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public static void removeBuildInfo(IResource resource) {
        try {
            resource.setSessionProperty(buildInfoProperty, null);
        }
        catch (CoreException coreException) {}
    }

    public static void resetConfiguration(IProject project, IConfiguration configuration) {
        try {
            ManagedBuildManager.loadExtensions();
        }
        catch (BuildException e) {
            e.printStackTrace();
        }
        IConfiguration parentConfig = configuration.getParent();
        IManagedConfigElement configElement = ManagedBuildManager.getConfigElement(parentConfig);
        ((Configuration)configuration).reset(configElement);
    }

    public static void addExtensionTarget(Target target) {
        if (extensionTargets == null) {
            extensionTargets = new ArrayList();
        }
        extensionTargets.add(target);
        ManagedBuildManager.getExtensionTargetMap().put(target.getId(), target);
    }

    public static void addExtensionTool(Tool tool) {
        ManagedBuildManager.getExtensionToolMap().put(tool.getId(), tool);
        ManagedBuildManager.getExtensionDepCalcMap().put(tool.getId(), ManagedBuildManager.createDependencyGenerator(tool.getId()));
    }

    public static ITarget createTarget(IResource resource, ITarget parentTarget) throws BuildException {
        IResource owner = parentTarget.getOwner();
        if (owner != null && owner.equals((Object)resource)) {
            return parentTarget;
        }
        if (resource instanceof IProject) {
            if (owner != null) {
                throw new BuildException(ManagedMakeMessages.getResourceString("ManagedBuildManager.error.owner_not_null"));
            }
        } else {
            if (owner == null) {
                throw new BuildException(ManagedMakeMessages.getResourceString("ManagedBuildManager.error.null_owner"));
            }
            if (!owner.equals((Object)resource.getProject())) {
                throw new BuildException(ManagedMakeMessages.getResourceString("ManagedBuildManager.error.owner_not_project"));
            }
        }
        return new Target(resource, parentTarget);
    }

    public static IStatus initBuildInfoContainer(IResource resource) {
        ManagedBuildInfo buildInfo = null;
        try {
            buildInfo = ManagedBuildManager.findBuildInfo((IResource)resource.getProject());
            ManagedBuildManager.initBuildInfoContainer(buildInfo);
        }
        catch (CoreException e) {
            return new Status(4, ManagedBuilderCorePlugin.getUniqueIdentifier(), 4, e.getLocalizedMessage(), (Throwable)e);
        }
        return new Status(0, ManagedBuilderCorePlugin.getUniqueIdentifier(), 0, ManagedMakeMessages.getFormattedString("ManagedBuildInfo.message.init.ok", resource.getName()), null);
    }

    private static void initBuildInfoContainer(ManagedBuildInfo info) throws CoreException {
        if (info == null) {
            throw new CoreException((IStatus)new Status(4, ManagedBuilderCorePlugin.getUniqueIdentifier(), 4, new String(), null));
        }
        ICProject cProject = info.getCProject();
        IPathEntry[] entries = cProject.getRawPathEntries();
        ArrayList<IPathEntry> newEntries = new ArrayList<IPathEntry>(Arrays.asList(entries));
        if (!newEntries.contains(ManagedBuildInfo.containerEntry)) {
            newEntries.add((IPathEntry)ManagedBuildInfo.containerEntry);
            cProject.setRawPathEntries(newEntries.toArray(new IPathEntry[newEntries.size()]), (IProgressMonitor)new NullProgressMonitor());
            info.setContainerCreated(true);
        }
    }

    private static boolean isVersionCompatible(IExtension extension) {
        PluginVersionIdentifier version = null;
        IConfigurationElement[] elements = extension.getConfigurationElements();
        int index = 0;
        while (index < elements.length) {
            IConfigurationElement element = elements[index];
            if (element.getName().equals(REVISION_ELEMENT_NAME)) {
                version = new PluginVersionIdentifier(element.getAttribute(VERSION_ELEMENT_NAME));
                break;
            }
            ++index;
        }
        if (version == null) {
            return true;
        }
        return buildInfoVersion.isCompatibleWith(version);
    }

    private static ManagedBuildInfo loadBuildInfo(IProject project) {
        ManagedBuildInfo buildInfo = null;
        IFile file = project.getFile(SETTINGS_FILE_NAME);
        if (!file.exists()) {
            return null;
        }
        try {
            NodeList nodes;
            InputStream stream = file.getContents();
            DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = parser.parse(stream);
            String fileVersion = null;
            Node rootElement = document.getFirstChild();
            if (rootElement.getNodeType() == 7) {
                fileVersion = rootElement.getNodeValue();
                PluginVersionIdentifier version = new PluginVersionIdentifier(fileVersion);
                if (!buildInfoVersion.isCompatibleWith(version)) {
                    throw new BuildException(ManagedMakeMessages.getResourceString(PROJECT_VERSION_ERROR));
                }
                buildInfoVersion.isGreaterThan(version);
            }
            if ((nodes = document.getElementsByTagName(ROOT_NODE_NAME)).getLength() > 0) {
                Node node = nodes.item(0);
                buildInfo = new ManagedBuildInfo((IResource)project, (Element)node);
                if (fileVersion != null) {
                    buildInfo.setVersion(fileVersion);
                }
                project.setSessionProperty(buildInfoProperty, (Object)buildInfo);
            }
        }
        catch (Exception exception) {
            buildInfo = null;
        }
        return buildInfo;
    }

    private static void loadExtensions() throws BuildException {
        if (extensionTargetsLoaded) {
            return;
        }
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(EXTENSION_POINT_ID);
        IExtension[] extensions = extensionPoint.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IExtension extension = extensions[i];
            if (!ManagedBuildManager.isVersionCompatible(extension)) {
                throw new BuildException(ManagedMakeMessages.getResourceString(MANIFEST_VERSION_ERROR));
            }
            IConfigurationElement[] elements = extension.getConfigurationElements();
            ManagedBuildManager.loadConfigElements(DefaultManagedConfigElement.convertArray(elements));
            ++i;
        }
        Iterator toolIter = ManagedBuildManager.getExtensionToolMap().values().iterator();
        while (toolIter.hasNext()) {
            try {
                Tool tool = (Tool)toolIter.next();
                tool.resolveReferences();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        Iterator targetIter = ManagedBuildManager.getExtensionTargetMap().values().iterator();
        while (targetIter.hasNext()) {
            try {
                Target target = (Target)targetIter.next();
                target.resolveReferences();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        extensionTargetsLoaded = true;
    }

    private static void loadConfigElements(IManagedConfigElement[] elements) {
        int toolIndex = 0;
        while (toolIndex < elements.length) {
            try {
                IManagedConfigElement element = elements[toolIndex];
                if (element.getName().equals("tool")) {
                    new Tool(element);
                } else if (element.getName().equals("target")) {
                    new Target(element);
                } else if (element.getName().equals("dynamicElementProvider") && element instanceof DefaultManagedConfigElement) {
                    IManagedConfigElementProvider provider = ManagedBuildManager.createConfigProvider((DefaultManagedConfigElement)element);
                    IManagedConfigElement[] providedConfigs = provider.getConfigElements();
                    ManagedBuildManager.loadConfigElements(providedConfigs);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            ++toolIndex;
        }
    }

    public static void createBuildInfo(IResource resource) {
        ManagedBuildInfo buildInfo = new ManagedBuildInfo(resource);
        try {
            resource.setSessionProperty(buildInfoProperty, (Object)buildInfo);
        }
        catch (CoreException coreException) {
            buildInfo = null;
        }
    }

    private static IManagedConfigElementProvider createConfigProvider(DefaultManagedConfigElement element) throws CoreException {
        return (IManagedConfigElementProvider)element.getConfigurationElement().createExecutableExtension("class");
    }

    public static boolean manages(IResource resource) {
        IProject project = null;
        if (resource instanceof IProject) {
            project = (IProject)resource;
        } else if (resource instanceof IFile) {
            project = ((IFile)resource).getProject();
        } else {
            return false;
        }
        IFile file = project.getFile(SETTINGS_FILE_NAME);
        if (file.exists()) {
            try {
                InputStream stream = file.getContents();
                DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                Document document = parser.parse(stream);
                NodeList nodes = document.getElementsByTagName(ROOT_NODE_NAME);
                return nodes.getLength() > 0;
            }
            catch (Exception exception) {
                return false;
            }
        }
        return false;
    }

    private static ManagedBuildInfo findBuildInfo(IResource resource) {
        if (resource == null) {
            return null;
        }
        try {
            ManagedBuildManager.loadExtensions();
        }
        catch (BuildException e) {
            e.printStackTrace();
            return null;
        }
        ManagedBuildInfo buildInfo = null;
        try {
            buildInfo = (ManagedBuildInfo)resource.getSessionProperty(buildInfoProperty);
            if (buildInfo != null) {
                buildInfo.updateOwner(resource);
            }
        }
        catch (CoreException coreException) {
            return null;
        }
        if (buildInfo == null && resource instanceof IProject) {
            buildInfo = ManagedBuildManager.loadBuildInfo((IProject)resource);
            try {
                ManagedBuildManager.initBuildInfoContainer(buildInfo);
            }
            catch (CoreException coreException) {}
        }
        return buildInfo;
    }

    public static IManagedBuildInfo getBuildInfo(IResource resource) {
        return ManagedBuildManager.findBuildInfo((IResource)resource.getProject());
    }

    public static PluginVersionIdentifier getBuildInfoVersion() {
        return buildInfoVersion;
    }

    private static Map getBuildModelListeners() {
        if (buildModelListeners == null) {
            buildModelListeners = new HashMap();
        }
        return buildModelListeners;
    }

    public IScannerInfo getScannerInformation(IResource resource) {
        return (IScannerInfo)ManagedBuildManager.getBuildInfo((IResource)resource.getProject());
    }

    public synchronized void subscribe(IResource resource, IScannerInfoChangeListener listener) {
        IResource project = null;
        if (resource instanceof IProject) {
            project = resource;
        } else if (resource instanceof IFile) {
            project = ((IFile)resource).getProject();
        } else {
            return;
        }
        Map map = ManagedBuildManager.getBuildModelListeners();
        ArrayList<IScannerInfoChangeListener> list = (ArrayList<IScannerInfoChangeListener>)map.get(project);
        if (list == null) {
            list = new ArrayList<IScannerInfoChangeListener>();
        }
        if (!list.contains(listener)) {
            list.add(listener);
            map.put(project, list);
        }
    }

    public synchronized void unsubscribe(IResource resource, IScannerInfoChangeListener listener) {
        IResource project = null;
        if (resource instanceof IProject) {
            project = resource;
        } else if (resource instanceof IFile) {
            project = ((IFile)resource).getProject();
        } else {
            return;
        }
        Map map = ManagedBuildManager.getBuildModelListeners();
        List list = (List)map.get(project);
        if (list != null && !list.isEmpty()) {
            list.remove(listener);
            map.put(project, list);
        }
    }

    private static Map getConfigElementMap() {
        if (configElementMap == null) {
            configElementMap = new HashMap();
        }
        return configElementMap;
    }

    public static void putConfigElement(IBuildObject buildObj, IManagedConfigElement configElement) {
        ManagedBuildManager.getConfigElementMap().put(buildObj, configElement);
    }

    public static IManagedConfigElement getConfigElement(IBuildObject buildObj) {
        return (IManagedConfigElement)ManagedBuildManager.getConfigElementMap().get(buildObj);
    }
}

