/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.core.scannerconfig;

import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.cdt.make.core.scannerconfig.IScannerInfoConsoleParser;

public class ConsoleOutputStreamSniffer
extends OutputStream {
    private StringBuffer currentLine = new StringBuffer();
    private OutputStream outputStream;
    private int nOpens = 0;
    private IScannerInfoConsoleParser[] parsers;

    public ConsoleOutputStreamSniffer(IScannerInfoConsoleParser[] parsers) {
        this.parsers = parsers;
    }

    public ConsoleOutputStreamSniffer(OutputStream outputStream, IScannerInfoConsoleParser[] parsers) {
        this(parsers);
        this.nOpens = 1;
        this.outputStream = outputStream;
    }

    public void write(int b) throws IOException {
        this.currentLine.append((char)b);
        this.checkLine(false);
        if (this.outputStream != null) {
            this.outputStream.write(b);
        }
    }

    private void checkLine(boolean flush) {
        String buffer = this.currentLine.toString();
        int i = 0;
        while ((i = buffer.indexOf(10)) != -1) {
            String line = buffer.substring(0, i).trim();
            this.processLine(line);
            buffer = buffer.substring(i + 1);
        }
        this.currentLine.setLength(0);
        if (flush) {
            if (buffer.length() > 0) {
                this.processLine(buffer);
            }
        } else {
            this.currentLine.append(buffer);
        }
    }

    private void processLine(String line) {
        int i = 0;
        while (i < this.parsers.length) {
            this.parsers[i].processLine(line);
            ++i;
        }
    }

    public void close() throws IOException {
        if (this.nOpens > 0 && --this.nOpens == 0) {
            this.checkLine(true);
            if (this.outputStream != null) {
                this.outputStream.close();
            }
        }
        int i = 0;
        while (i < this.parsers.length) {
            this.parsers[i].shutdown();
            ++i;
        }
    }

    public void flush() throws IOException {
        if (this.outputStream != null) {
            this.outputStream.flush();
        }
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off != 0 || len < 0 || len > b.length) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        this.currentLine.append(new String(b, 0, len));
        this.checkLine(false);
        if (this.outputStream != null) {
            this.outputStream.write(b, off, len);
        }
    }
}

