/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.browser.cbrowsing;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.core.browser.AllTypesCache;
import org.eclipse.cdt.core.browser.ITypeInfo;
import org.eclipse.cdt.core.browser.ITypeReference;
import org.eclipse.cdt.core.browser.ITypeSearchScope;
import org.eclipse.cdt.core.browser.TypeSearchScope;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICElementVisitor;
import org.eclipse.cdt.core.model.ICModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IParent;
import org.eclipse.cdt.core.model.ISourceRoot;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.core.resources.FileStorage;
import org.eclipse.cdt.internal.ui.browser.cbrowsing.CBrowsingMessages;
import org.eclipse.cdt.internal.ui.browser.cbrowsing.MembersView;
import org.eclipse.cdt.internal.ui.browser.cbrowsing.NamespacesView;
import org.eclipse.cdt.internal.ui.browser.cbrowsing.StatusBarUpdater;
import org.eclipse.cdt.internal.ui.browser.cbrowsing.TypeInfoComparator;
import org.eclipse.cdt.internal.ui.browser.cbrowsing.TypeInfoSorter;
import org.eclipse.cdt.internal.ui.browser.opentype.OpenTypeMessages;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.internal.ui.util.EditorUtility;
import org.eclipse.cdt.internal.ui.util.ExceptionHandler;
import org.eclipse.cdt.internal.ui.util.ProblemTableViewer;
import org.eclipse.cdt.internal.ui.viewsupport.CElementLabels;
import org.eclipse.cdt.internal.ui.viewsupport.IViewPartInputProvider;
import org.eclipse.cdt.internal.ui.workingsets.WorkingSetFilterActionGroup;
import org.eclipse.cdt.ui.CElementLabelProvider;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.IWorkingCopyManager;
import org.eclipse.cdt.ui.PreferenceConstants;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.IProgressService;
import org.eclipse.ui.texteditor.ITextEditor;

public abstract class CBrowsingPart
extends ViewPart
implements IMenuListener,
ISelectionListener,
IViewPartInputProvider {
    private static final String TAG_SELECTED_ELEMENTS = "selectedElements";
    private static final String TAG_SELECTED_ELEMENT = "selectedElement";
    private static final String TAG_LOGICAL_PACKAGE = "logicalPackage";
    private static final String TAG_SELECTED_ELEMENT_PATH = "selectedElementPath";
    private LabelProvider fLabelProvider;
    private ILabelProvider fTitleProvider;
    private StructuredViewer fViewer;
    private IMemento fMemento;
    private TypeInfoComparator fTypeComparator;
    private WorkingSetFilterActionGroup fWorkingSetFilterActionGroup;
    private boolean fHasWorkingSetFilter = true;
    private boolean fHasCustomFilter = true;
    protected IWorkbenchPart fPreviousSelectionProvider;
    protected Object fPreviousSelectedElement;
    private boolean fLinkingEnabled;
    private boolean fProcessSelectionEvents = true;
    private IPartListener2 fPartListener = new IPartListener2(){

        public void partActivated(IWorkbenchPartReference ref) {
            CBrowsingPart.this.setSelectionFromEditor(ref);
        }

        public void partBroughtToTop(IWorkbenchPartReference ref) {
            CBrowsingPart.this.setSelectionFromEditor(ref);
        }

        public void partInputChanged(IWorkbenchPartReference ref) {
            CBrowsingPart.this.setSelectionFromEditor(ref);
        }

        public void partClosed(IWorkbenchPartReference ref) {
        }

        public void partDeactivated(IWorkbenchPartReference ref) {
        }

        public void partOpened(IWorkbenchPartReference ref) {
        }

        public void partVisible(IWorkbenchPartReference ref) {
            if (ref != null && ref.getId() == CBrowsingPart.this.getSite().getId()) {
                CBrowsingPart.this.fProcessSelectionEvents = true;
                IWorkbenchPage page = CBrowsingPart.this.getSite().getWorkbenchWindow().getActivePage();
                if (page != null) {
                    CBrowsingPart.this.selectionChanged(page.getActivePart(), page.getSelection());
                }
            }
        }

        public void partHidden(IWorkbenchPartReference ref) {
            if (ref != null && ref.getId() == CBrowsingPart.this.getSite().getId()) {
                CBrowsingPart.this.fProcessSelectionEvents = false;
            }
        }
    };
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public CBrowsingPart() {
        this.initLinkingEnabled();
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.fMemento = memento;
    }

    public void saveState(IMemento memento) {
        if (this.fViewer == null) {
            if (this.fMemento != null) {
                memento.putMemento(this.fMemento);
            }
            return;
        }
        if (this.fHasWorkingSetFilter) {
            this.fWorkingSetFilterActionGroup.saveState(memento);
        }
        this.saveSelectionState(memento);
        this.saveLinkingEnabled(memento);
    }

    private void saveLinkingEnabled(IMemento memento) {
        memento.putInteger(this.getLinkToEditorKey(), this.fLinkingEnabled ? 1 : 0);
    }

    private void saveSelectionState(IMemento memento) {
    }

    protected void restoreState(IMemento memento) {
        if (this.fHasWorkingSetFilter) {
            this.fWorkingSetFilterActionGroup.restoreState(memento);
        }
        if (this.fHasCustomFilter || this.fHasWorkingSetFilter) {
            this.fViewer.getControl().setRedraw(false);
            this.fViewer.refresh();
            this.fViewer.getControl().setRedraw(true);
        }
    }

    private ISelection restoreSelectionState(IMemento memento) {
        return null;
    }

    private void restoreLinkingEnabled(IMemento memento) {
        Integer val = memento.getInteger(this.getLinkToEditorKey());
        if (val != null) {
            this.fLinkingEnabled = val != 0;
        }
    }

    public void createPartControl(Composite parent) {
        Assert.isTrue((this.fViewer == null ? 1 : 0) != 0);
        this.fTypeComparator = new TypeInfoComparator();
        this.fViewer = this.createViewer(parent);
        this.initDragAndDrop();
        this.fLabelProvider = this.createLabelProvider();
        this.fViewer.setLabelProvider((IBaseLabelProvider)this.fLabelProvider);
        this.fViewer.setSorter((ViewerSorter)this.createTypeInfoSorter());
        this.fViewer.setUseHashlookup(true);
        this.fTitleProvider = this.createTitleProvider();
        this.createContextMenu();
        this.getSite().setSelectionProvider((ISelectionProvider)this.fViewer);
        if (this.fMemento != null) {
            this.restoreLinkingEnabled(this.fMemento);
        }
        this.createActions();
        this.addKeyListener();
        if (this.fMemento != null) {
            this.restoreState(this.fMemento);
        }
        this.getSite().setSelectionProvider((ISelectionProvider)this.fViewer);
        IStatusLineManager slManager = this.getViewSite().getActionBars().getStatusLineManager();
        this.fViewer.addSelectionChangedListener((ISelectionChangedListener)this.createStatusBarUpdater(slManager));
        this.hookViewerListeners();
        this.addFilters();
        this.fViewer.setContentProvider(this.createContentProvider());
        this.setInitialInput();
        this.setInitialSelection();
        this.fMemento = null;
        this.getViewSite().getPage().addPostSelectionListener((ISelectionListener)this);
        this.getViewSite().getPage().addPartListener(this.fPartListener);
        this.fillActionBars(this.getViewSite().getActionBars());
        this.setHelp();
    }

    public Object getAdapter(Class key) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.part.IShowInSource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (key == clazz) {
            return this.getShowInSource();
        }
        return super.getAdapter(key);
    }

    protected IShowInSource getShowInSource() {
        return new IShowInSource(){

            public ShowInContext getShowInContext() {
                return new ShowInContext(null, CBrowsingPart.this.getSite().getSelectionProvider().getSelection());
            }
        };
    }

    protected TypeInfoSorter createTypeInfoSorter() {
        return new TypeInfoSorter();
    }

    protected StatusBarUpdater createStatusBarUpdater(IStatusLineManager slManager) {
        return new StatusBarUpdater(slManager);
    }

    protected void createContextMenu() {
        MenuManager menuManager = new MenuManager("#PopupMenu");
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener((IMenuListener)this);
        Menu contextMenu = menuManager.createContextMenu(this.fViewer.getControl());
        this.fViewer.getControl().setMenu(contextMenu);
        this.getSite().registerContextMenu(menuManager, (ISelectionProvider)this.fViewer);
    }

    protected void initDragAndDrop() {
    }

    protected void fillActionBars(IActionBars actionBars) {
        IToolBarManager toolBar = actionBars.getToolBarManager();
        this.fillToolBar(toolBar);
        if (this.fHasWorkingSetFilter) {
            this.fWorkingSetFilterActionGroup.fillActionBars(this.getViewSite().getActionBars());
        }
        actionBars.updateActionBars();
    }

    public void setFocus() {
        this.fViewer.getControl().setFocus();
    }

    public void dispose() {
        if (this.fViewer != null) {
            this.getViewSite().getPage().removePostSelectionListener((ISelectionListener)this);
            this.getViewSite().getPage().removePartListener(this.fPartListener);
            this.fViewer = null;
        }
        if (this.fWorkingSetFilterActionGroup != null) {
            this.fWorkingSetFilterActionGroup.dispose();
        }
        super.dispose();
    }

    protected void addKeyListener() {
        this.fViewer.getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent event) {
                CBrowsingPart.this.handleKeyReleased(event);
            }
        });
    }

    protected void handleKeyReleased(KeyEvent event) {
        if (event.stateMask != 0) {
            return;
        }
        int key = event.keyCode;
    }

    protected void fillToolBar(IToolBarManager tbm) {
    }

    public void menuAboutToShow(IMenuManager menu) {
        CUIPlugin.createStandardGroups(menu);
        IStructuredSelection selection = (IStructuredSelection)this.fViewer.getSelection();
        int size = selection.size();
        Object element = selection.getFirstElement();
        if (size == 1) {
            this.addOpenNewWindowAction(menu, element);
        }
    }

    private void addOpenNewWindowAction(IMenuManager menu, Object element) {
        if (element instanceof ICElement) {
            element = ((ICElement)element).getResource();
        }
        if (!(element instanceof IContainer)) {
            return;
        }
    }

    protected void createActions() {
        if (this.fHasWorkingSetFilter) {
            String viewId = this.getConfigurationElement().getAttribute("id");
            Assert.isNotNull((Object)viewId);
            IPropertyChangeListener workingSetListener = new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    CBrowsingPart.this.doWorkingSetChanged(event);
                }
            };
            this.fWorkingSetFilterActionGroup = new WorkingSetFilterActionGroup(viewId, this.getShell(), workingSetListener);
            this.fViewer.addFilter(this.fWorkingSetFilterActionGroup.getWorkingSetFilter());
        }
    }

    private void doWorkingSetChanged(PropertyChangeEvent event) {
        String property = event.getProperty();
        if ("workingSetNameChange".equals(property)) {
            this.updateTitle();
        } else if ("workingSetContentChange".equals(property)) {
            this.updateTitle();
            this.fViewer.getControl().setRedraw(false);
            this.fViewer.refresh();
            this.fViewer.getControl().setRedraw(true);
        }
    }

    Shell getShell() {
        return this.fViewer.getControl().getShell();
    }

    protected final Display getDisplay() {
        return this.fViewer.getControl().getDisplay();
    }

    ISelectionProvider getSelectionProvider() {
        return this.fViewer;
    }

    protected abstract boolean isValidInput(Object var1);

    protected boolean exists(Object element) {
        if (element == null) {
            return false;
        }
        if (element instanceof ICElement) {
            return ((ICElement)element).exists();
        }
        if (element instanceof ITypeInfo) {
            return ((ITypeInfo)element).exists();
        }
        return false;
    }

    protected ICProject findCProject(ICElement element) {
        return element.getCProject();
    }

    protected ICProject findCProject(ITypeInfo info) {
        IProject project = info.getEnclosingProject();
        if (project != null) {
            try {
                ICProject[] cProjects = CoreModel.getDefault().getCModel().getCProjects();
                if (cProjects != null) {
                    int i = 0;
                    while (i < cProjects.length) {
                        ICProject cProject = cProjects[i];
                        if (cProject.getProject().equals((Object)project)) {
                            return cProject;
                        }
                        ++i;
                    }
                }
            }
            catch (CModelException cModelException) {}
        }
        return null;
    }

    protected ISourceRoot findSourceRoot(ICElement element) {
        while (element != null) {
            if (element instanceof ISourceRoot) {
                return (ISourceRoot)element;
            }
            if (element instanceof ICProject) {
                return null;
            }
            element = element.getParent();
        }
        return null;
    }

    protected ISourceRoot findSourceRoot(ITypeInfo info) {
        ICProject cProject = this.findCProject(info);
        if (cProject != null) {
            try {
                ISourceRoot[] roots = cProject.getAllSourceRoots();
                if (roots != null) {
                    int i = 0;
                    while (i < roots.length) {
                        ISourceRoot root = roots[i];
                        if (!this.isProjectSourceRoot(root)) {
                            TypeSearchScope scope = new TypeSearchScope();
                            scope.add((ICElement)root);
                            if (info.isEnclosed((ITypeSearchScope)scope)) {
                                return root;
                            }
                        }
                        ++i;
                    }
                }
            }
            catch (CModelException cModelException) {}
        }
        return null;
    }

    protected boolean isProjectSourceRoot(ISourceRoot root) {
        IResource resource = root.getResource();
        return resource instanceof IProject;
    }

    protected boolean isValidNamespace(Object element) {
        ITypeInfo[] types;
        ITypeInfo info;
        if (element instanceof ITypeInfo && (info = (ITypeInfo)element).exists() && info.getCElementType() == 61 && (types = info.getEnclosedTypes()) != null) {
            int i = 0;
            while (i < types.length) {
                if (types[i].getCElementType() != 61) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    protected Object getNamespaceInput(Object element) {
        ICProject cProject;
        ISourceRoot root;
        if (element instanceof ICModel) {
            return null;
        }
        if ((element instanceof ICProject || element instanceof ISourceRoot) && this.exists(element)) {
            return element;
        }
        if (element instanceof ITypeInfo) {
            ITypeInfo info = (ITypeInfo)element;
            root = this.findSourceRoot(info);
            if (this.exists(root)) {
                return root;
            }
            cProject = this.findCProject(info);
            if (this.exists(cProject)) {
                return cProject;
            }
        }
        if (element instanceof ICElement) {
            ICElement cElem = (ICElement)element;
            root = this.findSourceRoot(cElem);
            if (this.exists(root)) {
                return root;
            }
            cProject = this.findCProject(cElem);
            if (this.exists(cProject)) {
                return cProject;
            }
        }
        return null;
    }

    private static boolean hasChild(ICElement parent, final ICElement child) {
        final boolean[] foundChild = new boolean[1];
        ICElementVisitor visitor = new ICElementVisitor(){

            public boolean visit(ICElement element) throws CoreException {
                if (foundChild[0]) {
                    return false;
                }
                if (element.equals(child)) {
                    foundChild[0] = true;
                    return false;
                }
                return true;
            }
        };
        try {
            parent.accept(visitor);
        }
        catch (CoreException coreException) {}
        return foundChild[0];
    }

    protected Object getTypesInput(Object element) {
        if (element instanceof ICModel || element instanceof ICProject || element instanceof ISourceRoot) {
            return null;
        }
        if (element instanceof ICElement) {
            TypeSearchScope scope = new TypeSearchScope();
            ICElement cElem = ((ICElement)element).getParent();
            ISourceRoot root = this.findSourceRoot(cElem);
            if (root != null) {
                scope.add((ICElement)root);
            } else {
                ICProject cProject = this.findCProject(cElem);
                if (cProject != null) {
                    scope.add((ICElement)cProject);
                }
            }
            ITypeInfo[] namespaces = AllTypesCache.getNamespaces((ITypeSearchScope)scope, (boolean)true);
            if (namespaces != null) {
                int i = 0;
                while (i < namespaces.length) {
                    ITypeInfo[] enclosedTypes = namespaces[i].getEnclosedTypes();
                    int j = 0;
                    while (j < enclosedTypes.length) {
                        ICElement typeElem;
                        ITypeInfo enclosedType = enclosedTypes[j];
                        if (enclosedType.getResolvedReference() != null && (typeElem = enclosedType.getCElement()) != null && (typeElem.equals(cElem) || typeElem instanceof IParent && CBrowsingPart.hasChild(typeElem, cElem))) {
                            return namespaces[i];
                        }
                        ++j;
                    }
                    ++i;
                }
            }
            return null;
        }
        if (element instanceof ITypeInfo) {
            ITypeInfo info = (ITypeInfo)element;
            if (info.getCElementType() == 61 && this.exists(info)) {
                return info;
            }
            ITypeInfo namespace = info.getEnclosingType(new int[]{61});
            if (namespace == null) {
                namespace = info.getRootNamespace(true);
            }
            if (this.exists(namespace)) {
                return namespace;
            }
        }
        return null;
    }

    protected Object getMembersInput(Object element) {
        ITypeInfo info;
        if (element instanceof ICModel || element instanceof ICProject || element instanceof ISourceRoot) {
            return null;
        }
        if (element instanceof ITypeInfo && (info = (ITypeInfo)element).getCElementType() != 61 && this.exists(info)) {
            return info;
        }
        if (element instanceof ICElement) {
            TypeSearchScope scope = new TypeSearchScope();
            ICElement cElem = ((ICElement)element).getParent();
            ISourceRoot root = this.findSourceRoot(cElem);
            if (root != null) {
                scope.add((ICElement)root);
            } else {
                ICProject cProject = this.findCProject(cElem);
                if (cProject != null) {
                    scope.add((ICElement)cProject);
                }
            }
            ITypeInfo[] namespaces = AllTypesCache.getNamespaces((ITypeSearchScope)scope, (boolean)true);
            if (namespaces != null) {
                int i = 0;
                while (i < namespaces.length) {
                    ITypeInfo[] enclosedTypes = namespaces[i].getEnclosedTypes();
                    int j = 0;
                    while (j < enclosedTypes.length) {
                        ICElement typeElem;
                        ITypeInfo enclosedType = enclosedTypes[j];
                        if (enclosedType.getResolvedReference() != null && (typeElem = enclosedType.getCElement()) != null && (typeElem.equals(cElem) || typeElem instanceof IParent && CBrowsingPart.hasChild(typeElem, cElem))) {
                            return enclosedType;
                        }
                        ++j;
                    }
                    ++i;
                }
            }
            return null;
        }
        return null;
    }

    protected abstract boolean isValidElement(Object var1);

    private boolean isInputResetBy(Object newInput, Object input, IWorkbenchPart part) {
        if (newInput == null) {
            return part == this.fPreviousSelectionProvider;
        }
        if (input instanceof ICElement && newInput instanceof ICElement) {
            return this.getTypeComparator().compare(newInput, input) > 0;
        }
        return newInput instanceof List && part instanceof NamespacesView;
    }

    private boolean isInputResetBy(IWorkbenchPart part) {
        if (!(part instanceof CBrowsingPart)) {
            return true;
        }
        Object thisInput = this.getViewer().getInput();
        Object partInput = ((CBrowsingPart)part).getViewer().getInput();
        if (thisInput instanceof Collection) {
            thisInput = ((Collection)thisInput).iterator().next();
        }
        if (partInput instanceof Collection) {
            partInput = ((Collection)partInput).iterator().next();
        }
        if ((thisInput instanceof ICElement || thisInput instanceof ITypeInfo) && (partInput instanceof ICElement || partInput instanceof ITypeInfo)) {
            return this.getTypeComparator().compare(partInput, thisInput) > 0;
        }
        return true;
    }

    protected boolean isAncestorOf(Object ancestor, Object element) {
        if (element instanceof ICElement && ancestor instanceof ICElement) {
            return !element.equals(ancestor) && this.internalIsAncestorOf((ICElement)ancestor, (ICElement)element);
        }
        if (element instanceof ITypeInfo) {
            ICProject cProject;
            if ((ancestor instanceof ISourceRoot || ancestor instanceof ICProject || ancestor instanceof ICModel) && (cProject = ((ICElement)ancestor).getCProject()) != null) {
                IProject proj = ((ITypeInfo)element).getEnclosingProject();
                return proj != null && proj.equals((Object)cProject.getProject());
            }
            if (ancestor instanceof ITypeInfo) {
                return ((ITypeInfo)ancestor).encloses((ITypeInfo)element);
            }
        }
        return false;
    }

    private boolean internalIsAncestorOf(ICElement ancestor, ICElement element) {
        if (element != null) {
            return element.equals(ancestor) || this.internalIsAncestorOf(ancestor, element.getParent());
        }
        return false;
    }

    private boolean isSearchResultView(IWorkbenchPart part) {
        return false;
    }

    protected boolean needsToProcessSelectionChanged(IWorkbenchPart part, ISelection selection) {
        if (!this.fProcessSelectionEvents || part == this || this.isSearchResultView(part)) {
            if (part == this) {
                this.fPreviousSelectionProvider = part;
            }
            return false;
        }
        return true;
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (!this.needsToProcessSelectionChanged(part, selection)) {
            return;
        }
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        Object selectedElement = this.getSingleElementFromSelection(selection);
        if (selectedElement != null && (part == null || part.equals(this.fPreviousSelectionProvider)) && selectedElement.equals(this.fPreviousSelectedElement)) {
            return;
        }
        this.fPreviousSelectedElement = selectedElement;
        Object currentInput = this.getViewer().getInput();
        if (selectedElement != null && selectedElement.equals(currentInput)) {
            Object elementToSelect = this.findElementToSelect(selectedElement);
            if (elementToSelect != null && this.getTypeComparator().compare(selectedElement, elementToSelect) < 0) {
                this.setSelection((ISelection)new StructuredSelection(elementToSelect), true);
            } else if (elementToSelect == null && this instanceof MembersView) {
                this.setSelection((ISelection)StructuredSelection.EMPTY, true);
                this.fPreviousSelectedElement = StructuredSelection.EMPTY;
            }
            this.fPreviousSelectionProvider = part;
            return;
        }
        if (part != this.fPreviousSelectionProvider && selectedElement != null && !selectedElement.equals(currentInput) && this.isInputResetBy(selectedElement, currentInput, part)) {
            if (!this.isAncestorOf(selectedElement, currentInput)) {
                this.setInput(null);
            }
            this.fPreviousSelectionProvider = part;
            return;
        }
        if (selection.isEmpty() && !this.isInputResetBy(part)) {
            this.fPreviousSelectionProvider = part;
            return;
        }
        if (selectedElement == null && part == this.fPreviousSelectionProvider) {
            this.setInput(null);
            this.fPreviousSelectionProvider = part;
            return;
        }
        this.fPreviousSelectionProvider = part;
        this.adjustInputAndSetSelection(selectedElement);
    }

    void setHasWorkingSetFilter(boolean state) {
        this.fHasWorkingSetFilter = state;
    }

    void setHasCustomSetFilter(boolean state) {
        this.fHasCustomFilter = state;
    }

    protected Object getInput() {
        return this.fViewer.getInput();
    }

    protected void setInput(Object input) {
        this.setViewerInput(input);
        this.updateTitle();
    }

    boolean isLinkingEnabled() {
        return this.fLinkingEnabled;
    }

    private void initLinkingEnabled() {
        this.fLinkingEnabled = PreferenceConstants.getPreferenceStore().getBoolean(this.getLinkToEditorKey());
    }

    private void setViewerInput(Object input) {
        this.fProcessSelectionEvents = false;
        this.fViewer.setInput(input);
        this.fProcessSelectionEvents = true;
    }

    protected void updateTitle() {
        this.setTitleToolTip(this.getToolTipText(this.fViewer.getInput()));
    }

    String getToolTipText(Object element) {
        IPath path;
        String result = !(element instanceof IResource) ? CElementLabels.getTextLabel(element, 1090519049) : ((path = ((IResource)element).getFullPath()).isRoot() ? this.getConfigurationElement().getAttribute("name") : path.makeRelative().toString());
        if (this.fWorkingSetFilterActionGroup == null || this.fWorkingSetFilterActionGroup.getWorkingSet() == null) {
            return result;
        }
        IWorkingSet ws = this.fWorkingSetFilterActionGroup.getWorkingSet();
        String wsstr = CBrowsingMessages.getFormattedString("CBrowsingPart.toolTip", new String[]{ws.getName()});
        if (result.length() == 0) {
            return wsstr;
        }
        return CBrowsingMessages.getFormattedString("CBrowsingPart.toolTip2", new String[]{result, ws.getName()});
    }

    public String getTitleToolTip() {
        if (this.fViewer == null) {
            return super.getTitleToolTip();
        }
        return this.getToolTipText(this.fViewer.getInput());
    }

    protected final StructuredViewer getViewer() {
        return this.fViewer;
    }

    protected final void setViewer(StructuredViewer viewer) {
        this.fViewer = viewer;
    }

    protected abstract LabelProvider createLabelProvider();

    protected ILabelProvider createTitleProvider() {
        return new CElementLabelProvider(256);
    }

    protected final ILabelProvider getLabelProvider() {
        return this.fLabelProvider;
    }

    protected final ILabelProvider getTitleProvider() {
        return this.fTitleProvider;
    }

    protected StructuredViewer createViewer(Composite parent) {
        return new ProblemTableViewer(parent, 2);
    }

    protected int getLabelProviderFlags() {
        return 274;
    }

    protected void addFilters() {
    }

    protected abstract IContentProvider createContentProvider();

    protected void setInitialInput() {
        ISelection selection = this.getSite().getPage().getSelection();
        Object input = this.getSingleElementFromSelection(selection);
        if (!(input instanceof ICElement) && !(input instanceof ITypeInfo) && !((input = this.getSite().getPage().getInput()) instanceof ICElement) && input instanceof IAdaptable) {
            IAdaptable iAdaptable = (IAdaptable)input;
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.cdt.core.model.ICElement");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            input = iAdaptable.getAdapter((Class)clazz);
        }
        this.setInput(this.findInputForElement(input));
    }

    protected void setInitialSelection() {
        IWorkbenchPart part;
        IWorkbenchPage page = this.getSite().getPage();
        ISelection selection = null;
        if (page != null) {
            selection = page.getSelection();
        }
        if (selection instanceof ITextSelection && (part = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart()) instanceof IEditorPart) {
            this.setSelectionFromEditor((IWorkbenchPart)((IEditorPart)part));
            if (this.fViewer.getSelection() != null) {
                return;
            }
        }
        if (selection == null || selection.isEmpty()) {
            selection = this.restoreSelectionState(this.fMemento);
        }
        if (selection == null || selection.isEmpty()) {
            Object input = this.getSite().getPage().getInput();
            if (!(input instanceof ICElement)) {
                if (input instanceof IAdaptable) {
                    Class<?> clazz = class$1;
                    if (clazz == null) {
                        try {
                            clazz = class$1 = Class.forName("org.eclipse.cdt.core.model.ICElement");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    input = input.getAdapter((Class)clazz);
                } else {
                    return;
                }
            }
            selection = new StructuredSelection(input);
        }
        this.selectionChanged(null, selection);
    }

    protected final void setHelp() {
    }

    protected abstract String getHelpContextId();

    protected abstract String getLinkToEditorKey();

    protected void hookViewerListeners() {
        this.fViewer.addPostSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (!CBrowsingPart.this.fProcessSelectionEvents) {
                    return;
                }
                CBrowsingPart.this.fPreviousSelectedElement = CBrowsingPart.this.getSingleElementFromSelection(event.getSelection());
                IWorkbenchPage page = CBrowsingPart.this.getSite().getPage();
                if (page == null) {
                    return;
                }
                if (page.equals(CUIPlugin.getActivePage()) && CBrowsingPart.this.equals(page.getActivePart())) {
                    CBrowsingPart.this.linkToEditor((IStructuredSelection)event.getSelection());
                }
            }
        });
        this.fViewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                ISelection selection = event.getSelection();
                if (selection != null) {
                    Object element = CBrowsingPart.this.getSingleElementFromSelection(selection);
                    if (element instanceof ICElement) {
                        CBrowsingPart.this.openInEditor((ICElement)element);
                    } else if (element instanceof ITypeInfo) {
                        CBrowsingPart.this.openTypeInEditor((ITypeInfo)element);
                    }
                }
            }
        });
    }

    protected void openTypeInEditor(ITypeInfo info) {
        String message;
        String title;
        if (info == info.getCache().getGlobalNamespace()) {
            return;
        }
        ITypeReference location = info.getResolvedReference();
        if (location == null) {
            final ITypeInfo[] typesToResolve = new ITypeInfo[]{info};
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    AllTypesCache.resolveTypeLocation((ITypeInfo)typesToResolve[0], (IProgressMonitor)monitor);
                    if (monitor.isCanceled()) {
                        throw new InterruptedException();
                    }
                }
            };
            IProgressService service = PlatformUI.getWorkbench().getProgressService();
            try {
                service.busyCursorWhile(runnable);
            }
            catch (InvocationTargetException e) {
                String title2 = OpenTypeMessages.getString("OpenTypeAction.exception.title");
                String message2 = OpenTypeMessages.getString("OpenTypeAction.exception.message");
                ExceptionHandler.handle(e, title2, message2);
                return;
            }
            catch (InterruptedException interruptedException) {
                return;
            }
            location = info.getResolvedReference();
        }
        if (location == null) {
            title = OpenTypeMessages.getString("OpenTypeAction.errorTitle");
            message = OpenTypeMessages.getFormattedString("OpenTypeAction.errorTypeNotFound", info.getQualifiedTypeName().toString());
            MessageDialog.openError((Shell)this.getShell(), (String)title, (String)message);
        } else if (!this.openInEditor(location)) {
            title = OpenTypeMessages.getString("OpenTypeAction.errorTitle");
            message = OpenTypeMessages.getFormattedString("OpenTypeAction.errorOpenEditor", location.getPath().toString());
            MessageDialog.openError((Shell)this.getShell(), (String)title, (String)message);
        }
    }

    private boolean openInEditor(ITypeReference location) {
        ITranslationUnit unit = location.getTranslationUnit();
        IEditorPart editorPart = null;
        try {
            IPath path;
            if (unit != null) {
                editorPart = EditorUtility.openInEditor(unit);
            }
            if (editorPart == null && (path = location.getLocation()) != null) {
                FileStorage storage = new FileStorage(path);
                editorPart = EditorUtility.openInEditor(storage);
            }
            if (editorPart != null && editorPart instanceof ITextEditor) {
                ITextEditor editor = (ITextEditor)editorPart;
                editor.selectAndReveal(location.getOffset(), location.getLength());
                return true;
            }
        }
        catch (CModelException ex) {
            ex.printStackTrace();
            return false;
        }
        catch (PartInitException ex) {
            ex.printStackTrace();
            return false;
        }
        return false;
    }

    protected boolean openInEditor(ICElement cElement) {
        IEditorPart editorPart = null;
        try {
            if (cElement != null) {
                editorPart = EditorUtility.openInEditor(cElement);
            }
            if (editorPart == null) {
                return false;
            }
        }
        catch (CModelException ex) {
            ex.printStackTrace();
            return false;
        }
        catch (PartInitException ex) {
            ex.printStackTrace();
            return false;
        }
        if (cElement != null && editorPart instanceof CEditor) {
            CEditor editor = (CEditor)editorPart;
            editor.setSelection(cElement);
            return true;
        }
        return false;
    }

    void restoreSelection() {
    }

    void adjustInputAndSetSelection(Object o) {
        if (!(o instanceof ICElement) && !(o instanceof ITypeInfo)) {
            this.setSelection((ISelection)StructuredSelection.EMPTY, true);
            return;
        }
        Object elementToSelect = this.getSuitableElement(this.findElementToSelect(o));
        Object newInput = this.findInputForElement(o);
        Object oldInput = null;
        if (this.getInput() instanceof ICElement || this.getInput() instanceof ITypeInfo) {
            oldInput = this.getInput();
        }
        if (elementToSelect == null && !this.isValidInput(newInput) && newInput == null && !this.isAncestorOf(o, oldInput)) {
            this.setInput(null);
        } else if (this.mustSetNewInput(elementToSelect, oldInput, newInput)) {
            this.setInput(newInput);
            elementToSelect = this.getSuitableElement(elementToSelect);
        }
        if (elementToSelect != null) {
            this.setSelection((ISelection)new StructuredSelection(elementToSelect), true);
        } else {
            this.setSelection((ISelection)StructuredSelection.EMPTY, true);
        }
    }

    private boolean mustSetNewInput(Object elementToSelect, Object oldInput, Object newInput) {
        return !(newInput != null && newInput.equals(oldInput) || elementToSelect != null && oldInput != null);
    }

    protected abstract Object findInputForElement(Object var1);

    protected abstract Object findElementToSelect(Object var1);

    Object getSuitableElement(Object obj) {
        if (!(obj instanceof ICElement) && !(obj instanceof ITypeInfo)) {
            return null;
        }
        if (this.fTypeComparator.compare(obj, 60) > 0) {
            return obj;
        }
        return obj;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final Object getSingleElementFromSelection(ISelection selection) {
        Object element;
        if (!(selection instanceof StructuredSelection)) return null;
        if (selection.isEmpty()) {
            return null;
        }
        Iterator iter = ((StructuredSelection)selection).iterator();
        Object firstElement = iter.next();
        if (!(firstElement instanceof ICElement) && !(firstElement instanceof ITypeInfo)) {
            Class<?> clazz;
            ICElement je;
            if (!(firstElement instanceof IAdaptable)) return firstElement;
            IAdaptable iAdaptable = (IAdaptable)firstElement;
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                Class<?> clazz3;
                try {
                    clazz3 = Class.forName("org.eclipse.cdt.core.model.ICElement");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                clazz2 = class$1 = clazz3;
            }
            if ((je = (ICElement)iAdaptable.getAdapter((Class)clazz2)) != null) return je;
            if (!(firstElement instanceof IFile)) return je;
            IContainer parent = ((IFile)firstElement).getParent();
            if (parent == null) return null;
            Class<?> clazz4 = class$1;
            Class<?> clazz5 = clazz4;
            if (clazz4 != null) return (ICElement)parent.getAdapter((Class)clazz5);
            try {
                clazz = Class.forName("org.eclipse.cdt.core.model.ICElement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            clazz5 = class$1 = clazz;
            return (ICElement)parent.getAdapter((Class)clazz5);
        }
        Object currentInput = this.getViewer().getInput();
        if (currentInput == null || !currentInput.equals(this.findInputForElement(firstElement))) {
            if (!iter.hasNext()) return firstElement;
            return null;
        }
        do {
            if (!iter.hasNext()) {
                return firstElement;
            }
            element = iter.next();
            if (element instanceof ICElement || element instanceof ITypeInfo) continue;
            return null;
        } while (currentInput.equals(this.findInputForElement(element)));
        return null;
    }

    protected Comparator getTypeComparator() {
        return this.fTypeComparator;
    }

    private void linkToEditor(IStructuredSelection selection) {
        IEditorPart part;
        Object obj = selection.getFirstElement();
        if (selection.size() == 1 && (part = EditorUtility.isOpenInEditor(obj)) != null) {
            IWorkbenchPage page = this.getSite().getPage();
            page.bringToTop((IWorkbenchPart)part);
            if (obj instanceof ICElement) {
                EditorUtility.revealInEditor(part, (ICElement)obj);
            }
        }
    }

    private void setSelectionFromEditor(IWorkbenchPartReference ref) {
        IWorkbenchPart part = ref.getPart(false);
        this.setSelectionFromEditor(part);
    }

    void setSelectionFromEditor(IWorkbenchPart part) {
        if (!this.linkBrowsingViewSelectionToEditor()) {
            return;
        }
        if (part == null) {
            return;
        }
        IWorkbenchPartSite site = part.getSite();
        if (site == null) {
            return;
        }
        ISelectionProvider provider = site.getSelectionProvider();
        if (provider != null) {
            this.setSelectionFromEditor(part, provider.getSelection());
        }
    }

    private void setSelectionFromEditor(IWorkbenchPart part, ISelection selection) {
        if (part instanceof IEditorPart) {
            Object obj;
            ICElement element = null;
            if (selection instanceof IStructuredSelection && (obj = this.getSingleElementFromSelection(selection)) instanceof ICElement) {
                element = (ICElement)obj;
            }
            IEditorInput ei = ((IEditorPart)part).getEditorInput();
            if (selection instanceof ITextSelection) {
                int offset = ((ITextSelection)selection).getOffset();
                element = this.getElementAt(ei, offset);
            }
            if (element != null) {
                this.adjustInputAndSetSelection(element);
                return;
            }
            if (ei instanceof IFileEditorInput) {
                IContainer container;
                ICElement je;
                IFile file = ((IFileEditorInput)ei).getFile();
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("org.eclipse.cdt.core.model.ICElement");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((je = (ICElement)file.getAdapter((Class)clazz)) == null && (container = ((IFileEditorInput)ei).getFile().getParent()) != null) {
                    Class<?> clazz2 = class$1;
                    if (clazz2 == null) {
                        try {
                            clazz2 = class$1 = Class.forName("org.eclipse.cdt.core.model.ICElement");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    je = (ICElement)container.getAdapter((Class)clazz2);
                }
                if (je == null) {
                    this.setSelection(null, false);
                    return;
                }
                this.adjustInputAndSetSelection(je);
            }
        }
    }

    Object getElementOfInput(IEditorInput input) {
        if (input instanceof IFileEditorInput) {
            return ((IFileEditorInput)input).getFile();
        }
        return null;
    }

    protected void setSelection(ISelection selection, boolean reveal) {
        if (selection != null && selection.equals(this.fViewer.getSelection())) {
            return;
        }
        this.fProcessSelectionEvents = false;
        this.fViewer.setSelection(selection, reveal);
        this.fProcessSelectionEvents = true;
    }

    protected static ICElement getWorkingCopy(ICElement input) {
        return input;
    }

    protected ICElement getElementAt(IEditorInput input, int offset) {
        IWorkingCopyManager manager = CUIPlugin.getDefault().getWorkingCopyManager();
        IWorkingCopy unit = manager.getWorkingCopy(input);
        if (unit != null) {
            try {
                if (unit.isConsistent()) {
                    return unit.getElementAtOffset(offset);
                }
            }
            catch (CModelException cModelException) {}
        }
        return null;
    }

    void setProcessSelectionEvents(boolean state) {
        this.fProcessSelectionEvents = state;
    }

    public Object getViewPartInput() {
        if (this.fViewer != null) {
            return this.fViewer.getInput();
        }
        return null;
    }

    protected boolean hasCustomFilter() {
        return this.fHasCustomFilter;
    }

    protected boolean hasWorkingSetFilter() {
        return this.fHasWorkingSetFilter;
    }

    private boolean linkBrowsingViewSelectionToEditor() {
        return this.isLinkingEnabled();
    }

    public void setLinkingEnabled(boolean enabled) {
        IEditorPart editor;
        this.fLinkingEnabled = enabled;
        PreferenceConstants.getPreferenceStore().setValue(this.getLinkToEditorKey(), enabled);
        if (enabled && (editor = this.getSite().getPage().getActiveEditor()) != null) {
            this.setSelectionFromEditor((IWorkbenchPart)editor);
        }
    }
}

