/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.dialogs.cpaths;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.internal.ui.CPluginImages;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPElement;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPElementAttribute;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPElementLabelProvider;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPElementSorter;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPathBasePage;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPathEntryMessages;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.ExclusionPatternDialog;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.MultipleFolderSelectionDialog;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.NewSourceFolderDialog;
import org.eclipse.cdt.internal.ui.util.PixelConverter;
import org.eclipse.cdt.internal.ui.wizards.TypedViewerFilter;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.ITreeListAdapter;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.TreeListDialogField;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.NewFolderDialog;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class CPathOutputEntryPage
extends CPathBasePage {
    private ListDialogField fCPathList;
    private ICProject fCurrCProject;
    private IPath fProjPath;
    private IWorkspaceRoot fWorkspaceRoot;
    private TreeListDialogField fOutputList;
    private final int IDX_ADD = 0;
    private final int IDX_EDIT = 2;
    private final int IDX_REMOVE = 3;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public CPathOutputEntryPage(ListDialogField cPathList) {
        super(CPathEntryMessages.getString("OutputPathEntryPage.title"));
        this.setDescription(CPathEntryMessages.getString("OutputPathEntryPage.description"));
        this.fWorkspaceRoot = CUIPlugin.getWorkspace().getRoot();
        this.fCPathList = cPathList;
        OutputContainerAdapter adapter = new OutputContainerAdapter();
        String[] stringArray = new String[4];
        stringArray[0] = CPathEntryMessages.getString("OutputPathEntryPage.folders.add.button");
        stringArray[2] = CPathEntryMessages.getString("OutputPathEntryPage.folders.edit.button");
        stringArray[3] = CPathEntryMessages.getString("OutputPathEntryPage.folders.remove.button");
        String[] buttonLabels = stringArray;
        this.fOutputList = new TreeListDialogField(adapter, buttonLabels, (ILabelProvider)new CPElementLabelProvider());
        this.fOutputList.setDialogFieldListener(adapter);
        this.fOutputList.setLabelText(CPathEntryMessages.getString("OutputPathEntryPage.folders.label"));
        this.fOutputList.setViewerSorter(new CPElementSorter());
        this.fOutputList.enableButton(2, false);
        this.fOutputList.enableButton(3, false);
    }

    public Image getImage() {
        return CPluginImages.get("org.eclipse.cdt.ui.container_obj.gif");
    }

    public void init(ICProject cproject) {
        this.fCurrCProject = cproject;
        this.fProjPath = this.fCurrCProject.getProject().getFullPath();
        this.updateFoldersList();
    }

    private void updateFoldersList() {
        List folders = this.filterList(this.fCPathList.getElements());
        this.fOutputList.setElements(folders);
        int i = 0;
        while (i < folders.size()) {
            CPElement cpe = (CPElement)folders.get(i);
            IPath[] patterns = (IPath[])cpe.getAttribute("exclusion");
            if (patterns.length > 0) {
                this.fOutputList.expandElement(cpe, 3);
            }
            ++i;
        }
    }

    public void createControl(Composite parent) {
        PixelConverter converter = new PixelConverter((Control)parent);
        Composite composite = new Composite(parent, 0);
        LayoutUtil.doDefaultLayout(composite, new DialogField[]{this.fOutputList}, true);
        LayoutUtil.setHorizontalGrabbing(this.fOutputList.getTreeControl(null));
        int buttonBarWidth = converter.convertWidthInCharsToPixels(24);
        this.fOutputList.setButtonsMinWidth(buttonBarWidth);
        List elements = this.fOutputList.getElements();
        int i = 0;
        while (i < elements.size()) {
            CPElement elem = (CPElement)elements.get(i);
            IPath[] patterns = (IPath[])elem.getAttribute("exclusion");
            if (patterns.length > 0) {
                this.fOutputList.expandElement(elem, 3);
            }
            ++i;
        }
        this.setControl((Control)composite);
        WorkbenchHelp.setHelp((Control)composite, (String)"org.eclipse.cdt.ui.std_prop_output");
    }

    protected void outputPageKeyPressed(TreeListDialogField field, KeyEvent event) {
        List selection;
        if (field == this.fOutputList && event.character == '\u007f' && event.stateMask == 0 && this.canRemove(selection = field.getSelectedElements())) {
            this.removeEntry();
        }
    }

    protected void outputPageDoubleClicked(TreeListDialogField field) {
        List selection;
        if (field == this.fOutputList && this.canEdit(selection = field.getSelectedElements())) {
            this.editEntry();
        }
    }

    private boolean hasFolders(IContainer container) {
        try {
            IResource[] members = container.members();
            int i = 0;
            while (i < members.length) {
                if (members[i] instanceof IContainer) {
                    return true;
                }
                ++i;
            }
        }
        catch (CoreException coreException) {}
        return false;
    }

    protected void outputPageCustomButtonPressed(DialogField field, int index) {
        if (field == this.fOutputList) {
            if (index == 0) {
                CPElement entry;
                ArrayList<CPElement> elementsToAdd = new ArrayList<CPElement>(10);
                IProject project = this.fCurrCProject.getProject();
                if (project.exists()) {
                    if (this.hasFolders((IContainer)project)) {
                        CPElement[] srcentries = this.openOutputContainerDialog(null);
                        if (srcentries != null) {
                            int i = 0;
                            while (i < srcentries.length) {
                                elementsToAdd.add(srcentries[i]);
                                ++i;
                            }
                        }
                    } else {
                        entry = this.openNewOutputContainerDialog(null, true);
                        if (entry != null) {
                            elementsToAdd.add(entry);
                        }
                    }
                } else {
                    entry = this.openNewOutputContainerDialog(null, false);
                    if (entry != null) {
                        elementsToAdd.add(entry);
                    }
                }
                if (!elementsToAdd.isEmpty()) {
                    HashSet modifiedElements = new HashSet();
                    this.askForAddingExclusionPatternsDialog(elementsToAdd, modifiedElements);
                    this.fOutputList.addElements(elementsToAdd);
                    this.fOutputList.postSetSelection((ISelection)new StructuredSelection(elementsToAdd));
                    if (!modifiedElements.isEmpty()) {
                        Iterator iter = modifiedElements.iterator();
                        while (iter.hasNext()) {
                            Object elem = iter.next();
                            this.fOutputList.refresh(elem);
                            this.fOutputList.expandElement(elem, 3);
                        }
                    }
                }
            } else if (index == 2) {
                this.editEntry();
            } else if (index == 3) {
                this.removeEntry();
            }
        }
    }

    private void editEntry() {
        List selElements = this.fOutputList.getSelectedElements();
        if (selElements.size() != 1) {
            return;
        }
        Object elem = selElements.get(0);
        if (this.fOutputList.getIndexOfElement(elem) != -1) {
            this.editElementEntry((CPElement)elem);
        } else if (elem instanceof CPElementAttribute) {
            this.editAttributeEntry((CPElementAttribute)elem);
        }
    }

    private void editElementEntry(CPElement elem) {
        CPElement res = null;
        res = this.openNewOutputContainerDialog(elem, true);
        if (res != null) {
            this.fOutputList.replaceElement(elem, res);
        }
    }

    private void editAttributeEntry(CPElementAttribute elem) {
        String key = elem.getKey();
        if (key.equals("exclusion")) {
            CPElement selElement = elem.getParent();
            ExclusionPatternDialog dialog = new ExclusionPatternDialog(this.getShell(), selElement);
            if (dialog.open() == 0) {
                selElement.setAttribute("exclusion", dialog.getExclusionPattern());
                this.fOutputList.refresh();
                this.fCPathList.dialogFieldChanged();
            }
        }
    }

    protected void outputPageSelectionChanged(DialogField field) {
        List selected = this.fOutputList.getSelectedElements();
        this.fOutputList.enableButton(2, this.canEdit(selected));
        this.fOutputList.enableButton(3, this.canRemove(selected));
    }

    private void removeEntry() {
        List selElements = this.fOutputList.getSelectedElements();
        int i = selElements.size() - 1;
        while (i >= 0) {
            Object elem = selElements.get(i);
            if (elem instanceof CPElementAttribute) {
                CPElementAttribute attrib = (CPElementAttribute)elem;
                String key = attrib.getKey();
                Path[] value = key.equals("exclusion") ? new Path[]{} : null;
                attrib.getParent().setAttribute(key, value);
                selElements.remove(i);
            }
            --i;
        }
        if (selElements.isEmpty()) {
            this.fOutputList.refresh();
            this.fCPathList.dialogFieldChanged();
        } else {
            this.fOutputList.removeElements(selElements);
        }
    }

    private boolean canRemove(List selElements) {
        if (selElements.size() == 0) {
            return false;
        }
        int i = 0;
        while (i < selElements.size()) {
            CPElement curr;
            CPElementAttribute attrib;
            Object elem = selElements.get(i);
            if (elem instanceof CPElementAttribute ? ((attrib = (CPElementAttribute)elem).getKey().equals("exclusion") ? ((IPath[])attrib.getValue()).length == 0 : attrib.getValue() == null) : elem instanceof CPElement && (curr = (CPElement)elem).getParentContainer() != null) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean canEdit(List selElements) {
        if (selElements.size() != 1) {
            return false;
        }
        Object elem = selElements.get(0);
        if (elem instanceof CPElement) {
            return false;
        }
        return elem instanceof CPElementAttribute;
    }

    private void outputPageDialogFieldChanged(DialogField field) {
        if (this.fCurrCProject == null) {
            return;
        }
        if (field == this.fOutputList) {
            this.updateCPathList();
        }
    }

    private void updateCPathList() {
        int nEntries;
        List srcelements = this.fOutputList.getElements();
        List cpelements = this.fCPathList.getElements();
        int lastRemovePos = nEntries = cpelements.size();
        int afterLastSourcePos = 0;
        int i = nEntries - 1;
        while (i >= 0) {
            CPElement cpe = (CPElement)cpelements.get(i);
            int kind = cpe.getEntryKind();
            if (this.isEntryKind(kind)) {
                if (!srcelements.remove(cpe)) {
                    cpelements.remove(i);
                    lastRemovePos = i;
                } else if (lastRemovePos == nEntries) {
                    afterLastSourcePos = i + 1;
                }
            }
            --i;
        }
        if (!srcelements.isEmpty()) {
            int insertPos = Math.min(afterLastSourcePos, lastRemovePos);
            cpelements.addAll(insertPos, srcelements);
        }
        if (lastRemovePos != nEntries || !srcelements.isEmpty()) {
            this.fCPathList.setElements(cpelements);
        }
    }

    private CPElement openNewOutputContainerDialog(CPElement existing, boolean includeLinked) {
        if (includeLinked) {
            NewFolderDialog dialog = new NewFolderDialog(this.getShell(), (IContainer)this.fCurrCProject.getProject());
            if (dialog.open() == 0) {
                IResource createdFolder = (IResource)dialog.getResult()[0];
                return this.newCPOutputElement(createdFolder);
            }
            return null;
        }
        String title = existing == null ? CPathEntryMessages.getString("SourcePathEntryPage.NewSourceFolderDialog.new.title") : CPathEntryMessages.getString("SourcePathEntryPage.NewSourceFolderDialog.edit.title");
        IProject proj = this.fCurrCProject.getProject();
        NewSourceFolderDialog dialog = new NewSourceFolderDialog(this.getShell(), title, proj, this.getExistingContainers(existing), existing);
        dialog.setMessage(CPathEntryMessages.getFormattedString("SourcePathEntryPage.NewSourceFolderDialog.description", this.fProjPath.toString()));
        if (dialog.open() == 0) {
            IContainer folder = dialog.getSourceFolder();
            return this.newCPOutputElement((IResource)folder);
        }
        return null;
    }

    private void askForAddingExclusionPatternsDialog(List newEntries, Set modifiedEntries) {
        this.fixNestingConflicts(newEntries, this.fOutputList.getElements(), modifiedEntries);
        if (!modifiedEntries.isEmpty()) {
            String title = CPathEntryMessages.getString("OutputPathEntryPage.exclusion_added.title");
            String message = CPathEntryMessages.getString("OutputPathEntryPage.exclusion_added.message");
            MessageDialog.openInformation((Shell)this.getShell(), (String)title, (String)message);
        }
    }

    private CPElement[] openOutputContainerDialog(CPElement existing) {
        Class[] classArray = new Class[2];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IProject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.core.resources.IFolder");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz2;
        Class[] acceptedClasses = classArray;
        List existingContainers = this.getExistingContainers(null);
        IProject[] allProjects = this.fWorkspaceRoot.getProjects();
        ArrayList<IProject> rejectedElements = new ArrayList<IProject>(allProjects.length);
        IProject currProject = this.fCurrCProject.getProject();
        int i = 0;
        while (i < allProjects.length) {
            if (!allProjects[i].equals((Object)currProject)) {
                rejectedElements.add(allProjects[i]);
            }
            ++i;
        }
        TypedViewerFilter filter = new TypedViewerFilter(acceptedClasses, rejectedElements.toArray());
        WorkbenchLabelProvider lp = new WorkbenchLabelProvider();
        BaseWorkbenchContentProvider cp = new BaseWorkbenchContentProvider();
        String title = existing == null ? CPathEntryMessages.getString("OutputPathEntryPage.ExistingOutputFolderDialog.new.title") : CPathEntryMessages.getString("OutputPathEntryPage.ExistingOutputFolderDialog.edit.title");
        String message = existing == null ? CPathEntryMessages.getString("OutputPathEntryPage.ExistingOutputFolderDialog.new.description") : CPathEntryMessages.getString("OutputPathEntryPage.ExistingOutputFolderDialog.edit.description");
        MultipleFolderSelectionDialog dialog = new MultipleFolderSelectionDialog(this.getShell(), (ILabelProvider)lp, (ITreeContentProvider)cp);
        dialog.setExisting(existingContainers.toArray());
        dialog.setTitle(title);
        dialog.setMessage(message);
        dialog.addFilter(filter);
        dialog.setInput(this.fCurrCProject.getProject().getParent());
        if (existing == null) {
            dialog.setInitialFocus(this.fCurrCProject.getProject());
        } else {
            dialog.setInitialFocus(existing.getResource());
        }
        if (dialog.open() == 0) {
            Object[] elements = dialog.getResult();
            CPElement[] res = new CPElement[elements.length];
            int i2 = 0;
            while (i2 < res.length) {
                IResource elem = (IResource)elements[i2];
                res[i2] = this.newCPOutputElement(elem);
                ++i2;
            }
            return res;
        }
        return null;
    }

    private List getExistingContainers(CPElement existing) {
        ArrayList<IResource> res = new ArrayList<IResource>();
        List cplist = this.fOutputList.getElements();
        int i = 0;
        while (i < cplist.size()) {
            IResource resource;
            CPElement elem = (CPElement)cplist.get(i);
            if (elem != existing && (resource = elem.getResource()) instanceof IContainer) {
                res.add(resource);
            }
            ++i;
        }
        return res;
    }

    private CPElement newCPOutputElement(IResource res) {
        Assert.isNotNull((Object)res);
        return new CPElement(this.fCurrCProject, 7, res.getFullPath(), res);
    }

    public List getSelection() {
        return this.fOutputList.getSelectedElements();
    }

    public void setSelection(List selElements) {
        this.fOutputList.selectElements((ISelection)new StructuredSelection(selElements));
    }

    public boolean isEntryKind(int kind) {
        return kind == 7;
    }

    public void performApply(IProgressMonitor monitor) throws CoreException {
    }

    public void performDefaults() {
    }

    private class OutputContainerAdapter
    implements ITreeListAdapter,
    IDialogFieldListener {
        private final Object[] EMPTY_ARR = new Object[0];

        OutputContainerAdapter() {
        }

        public void customButtonPressed(TreeListDialogField field, int index) {
            CPathOutputEntryPage.this.outputPageCustomButtonPressed(field, index);
        }

        public void selectionChanged(TreeListDialogField field) {
            CPathOutputEntryPage.this.outputPageSelectionChanged(field);
        }

        public void doubleClicked(TreeListDialogField field) {
            CPathOutputEntryPage.this.outputPageDoubleClicked(field);
        }

        public void keyPressed(TreeListDialogField field, KeyEvent event) {
            CPathOutputEntryPage.this.outputPageKeyPressed(field, event);
        }

        public Object[] getChildren(TreeListDialogField field, Object element) {
            if (element instanceof CPElement) {
                return ((CPElement)element).getChildren();
            }
            return this.EMPTY_ARR;
        }

        public Object getParent(TreeListDialogField field, Object element) {
            if (element instanceof CPElementAttribute) {
                return ((CPElementAttribute)element).getParent();
            }
            return null;
        }

        public boolean hasChildren(TreeListDialogField field, Object element) {
            return element instanceof CPElement;
        }

        public void dialogFieldChanged(DialogField field) {
            CPathOutputEntryPage.this.outputPageDialogFieldChanged(field);
        }
    }
}

