/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui;

import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.IArchive;
import org.eclipse.cdt.core.model.IArchiveContainer;
import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.cdt.core.model.IBinaryContainer;
import org.eclipse.cdt.core.model.ICContainer;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IFunction;
import org.eclipse.cdt.core.model.IFunctionDeclaration;
import org.eclipse.cdt.core.model.IInclude;
import org.eclipse.cdt.core.model.IIncludeReference;
import org.eclipse.cdt.core.model.ILibraryReference;
import org.eclipse.cdt.core.model.IMacro;
import org.eclipse.cdt.core.model.IMethod;
import org.eclipse.cdt.core.model.IMethodDeclaration;
import org.eclipse.cdt.core.model.INamespace;
import org.eclipse.cdt.core.model.ISourceRoot;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IUsing;
import org.eclipse.cdt.core.model.IVariable;
import org.eclipse.cdt.core.model.IVariableDeclaration;
import org.eclipse.cdt.internal.ui.cview.IncludeRefContainer;
import org.eclipse.cdt.internal.ui.cview.LibraryRefContainer;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class CElementSorter
extends ViewerSorter {
    private static final int CMODEL = 0;
    private static final int PROJECTS = 10;
    private static final int BINARYCONTAINER = 12;
    private static final int ARCHIVECONTAINER = 13;
    private static final int INCLUDEREFCONTAINER = 14;
    private static final int LIBRARYREFCONTAINER = 15;
    private static final int SOURCEROOTS = 16;
    private static final int CCONTAINERS = 17;
    private static final int LIBRARYREFERENCES = 18;
    private static final int INCLUDEREFERENCES = 19;
    private static final int TRANSLATIONUNIT_HEADERS = 20;
    private static final int TRANSLATIONUNIT_SOURCE = 21;
    private static final int TRANSLATIONUNITS = 22;
    private static final int BINARIES = 23;
    private static final int ARCHIVES = 24;
    private static final int INCLUDES = 30;
    private static final int MACROS = 31;
    private static final int NAMESPACES = 32;
    private static final int USINGS = 33;
    private static final int VARIABLEDECLARATIONS = 34;
    private static final int FUNCTIONDECLARATIONS = 35;
    private static final int VARIABLES = 36;
    private static final int VARIABLES_RESERVED = 37;
    private static final int VARIABLES_SYSTEM = 38;
    private static final int FUNCTIONS = 39;
    private static final int FUNCTIONS_RESERVED = 40;
    private static final int FUNCTIONS_SYSTEM = 41;
    private static final int METHODDECLARATIONS = 42;
    private static final int CELEMENTS = 100;
    private static final int CELEMENTS_RESERVED = 101;
    private static final int CELEMENTS_SYSTEM = 102;
    private static final int RESOURCEFOLDERS = 200;
    private static final int RESOURCES = 201;
    private static final int STORAGE = 202;
    private static final int OTHERS = 500;
    static /* synthetic */ Class class$0;

    public int category(Object element) {
        if (element instanceof ICModel) {
            return 0;
        }
        if (element instanceof ICProject) {
            return 10;
        }
        if (element instanceof ISourceRoot) {
            return 16;
        }
        if (element instanceof IBinaryContainer) {
            return 12;
        }
        if (element instanceof IArchiveContainer) {
            return 13;
        }
        if (element instanceof ICContainer) {
            return 17;
        }
        if (element instanceof ITranslationUnit) {
            ITranslationUnit tu = (ITranslationUnit)element;
            if (CoreModel.isValidHeaderUnitName((IProject)tu.getCProject().getProject(), (String)tu.getElementName())) {
                return 20;
            }
            if (CoreModel.isValidSourceUnitName((IProject)tu.getCProject().getProject(), (String)tu.getElementName())) {
                return 21;
            }
            return 22;
        }
        if (element instanceof IInclude) {
            return 30;
        }
        if (element instanceof IMacro) {
            return 31;
        }
        if (element instanceof INamespace) {
            return 32;
        }
        if (element instanceof IUsing) {
            return 33;
        }
        if (element instanceof IFunctionDeclaration && !(element instanceof IFunction)) {
            return 35;
        }
        if (element instanceof IMethodDeclaration && !(element instanceof IMethod)) {
            return 42;
        }
        if (element instanceof IVariableDeclaration) {
            return 34;
        }
        if (element instanceof IVariable) {
            String name = ((ICElement)element).getElementName();
            if (name.startsWith("__")) {
                return 38;
            }
            if (name.charAt(0) == '_') {
                return 37;
            }
            return 36;
        }
        if (element instanceof IFunction) {
            String name = ((ICElement)element).getElementName();
            if (name.startsWith("__")) {
                return 41;
            }
            if (name.charAt(0) == '_') {
                return 40;
            }
            return 39;
        }
        if (element instanceof IArchive) {
            return 24;
        }
        if (element instanceof IBinary) {
            return 23;
        }
        if (element instanceof ILibraryReference) {
            return 18;
        }
        if (element instanceof IIncludeReference) {
            return 19;
        }
        if (element instanceof ICElement) {
            String name = ((ICElement)element).getElementName();
            if (name.startsWith("__")) {
                return 102;
            }
            if (name.charAt(0) == '_') {
                return 101;
            }
            return 100;
        }
        if (element instanceof IFile) {
            return 201;
        }
        if (element instanceof IProject) {
            return 10;
        }
        if (element instanceof IContainer) {
            return 200;
        }
        if (element instanceof IStorage) {
            return 202;
        }
        if (element instanceof LibraryRefContainer) {
            return 15;
        }
        if (element instanceof IncludeRefContainer) {
            return 14;
        }
        return 500;
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        int cat2;
        int cat1 = this.category(e1);
        if (cat1 != (cat2 = this.category(e2))) {
            return cat1 - cat2;
        }
        if (cat1 == 10) {
            IAdaptable iAdaptable = (IAdaptable)e1;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ui.model.IWorkbenchAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            IWorkbenchAdapter a1 = (IWorkbenchAdapter)iAdaptable.getAdapter((Class)clazz);
            IAdaptable iAdaptable2 = (IAdaptable)e2;
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("org.eclipse.ui.model.IWorkbenchAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            IWorkbenchAdapter a2 = (IWorkbenchAdapter)iAdaptable2.getAdapter((Class)clazz2);
            return this.getCollator().compare(a1.getLabel(e1), a2.getLabel(e2));
        }
        if (cat1 == 16) {
            int p2;
            int p1;
            ISourceRoot root1 = this.getSourceRoot(e1);
            ISourceRoot root2 = this.getSourceRoot(e2);
            if (root1 == null) {
                if (root2 == null) {
                    return 0;
                }
                return 1;
            }
            if (root2 == null) {
                return -1;
            }
            if (!root1.getPath().equals((Object)root2.getPath()) && (p1 = this.getPathEntryIndex(root1)) != (p2 = this.getPathEntryIndex(root2))) {
                return p1 - p2;
            }
        }
        if (cat1 == 201 || cat1 == 200 || cat1 == 202 || cat1 == 500) {
            return this.compareWithLabelProvider(viewer, e1, e2);
        }
        String name1 = e1 instanceof ICElement ? ((ICElement)e1).getElementName() : e1.toString();
        String name2 = e2 instanceof ICElement ? ((ICElement)e2).getElementName() : e2.toString();
        return this.getCollator().compare(name1, name2);
    }

    private ISourceRoot getSourceRoot(Object element) {
        ICElement celement = (ICElement)element;
        while (!(celement instanceof ISourceRoot) && celement != null) {
            celement = celement.getParent();
        }
        return (ISourceRoot)celement;
    }

    private int compareWithLabelProvider(Viewer viewer, Object e1, Object e2) {
        IBaseLabelProvider prov;
        if ((viewer == null || !(viewer instanceof ContentViewer)) && (prov = ((ContentViewer)viewer).getLabelProvider()) instanceof ILabelProvider) {
            ILabelProvider lprov = (ILabelProvider)prov;
            String name1 = lprov.getText(e1);
            String name2 = lprov.getText(e2);
            if (name1 != null && name2 != null) {
                return this.getCollator().compare(name1, name2);
            }
        }
        return 0;
    }

    private int getPathEntryIndex(ISourceRoot root) {
        try {
            IPath rootPath = root.getPath();
            ISourceRoot[] roots = root.getCProject().getSourceRoots();
            int i = 0;
            while (i < roots.length) {
                if (roots[i].getPath().equals((Object)rootPath)) {
                    return i;
                }
                ++i;
            }
        }
        catch (CModelException cModelException) {}
        return Integer.MAX_VALUE;
    }
}

