/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.dialogs;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.ICDescriptor;
import org.eclipse.cdt.internal.core.search.indexing.IndexManager;
import org.eclipse.cdt.ui.dialogs.IndexerOptionDialogPage;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.help.WorkbenchHelp;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class IndexerOptionPropertyPage
extends PropertyPage {
    private IndexerOptionDialogPage optionPage = new IndexerOptionDialogPage();
    private boolean oldIndexerValue;
    private int oldIndexerProblemsValue;

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new FillLayout());
        this.optionPage.createControl(composite);
        WorkbenchHelp.setHelp((Control)composite, (String)"org.eclipse.cdt.ui.std_prop_indexer");
        this.initialize();
        return composite;
    }

    protected void performDefaults() {
        this.initialize();
        super.performDefaults();
    }

    private void initialize() {
        IProject project = this.getProject();
        try {
            this.oldIndexerValue = this.getIndexerEnabled(project);
            this.oldIndexerProblemsValue = this.getIndexerProblemsEnabled(project);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        this.optionPage.setIndexerValue(this.oldIndexerValue);
        this.optionPage.setIndexerProblemValues(this.oldIndexerProblemsValue);
    }

    public boolean performOk() {
        boolean problemsChanged;
        boolean newIndexerValue = this.optionPage.getIndexerValue();
        int newIndexerProblemsValue = this.optionPage.getIndexerProblemsValues();
        boolean indexChanged = this.oldIndexerValue != newIndexerValue;
        boolean bl = problemsChanged = this.oldIndexerProblemsValue != newIndexerProblemsValue;
        if (indexChanged || problemsChanged) {
            IProject tempProject = this.getProject();
            this.optionPage.persistIndexerValues(tempProject);
            if (problemsChanged && newIndexerProblemsValue == 0) {
                CCorePlugin.getDefault().getCoreModel().getIndexManager().removeIndexerProblems((IResource)tempProject);
            }
            if (indexChanged && newIndexerValue) {
                CCorePlugin.getDefault().getCoreModel().getIndexManager().indexAll(tempProject);
            } else if (indexChanged && !newIndexerValue) {
                CCorePlugin.getDefault().getCoreModel().getIndexManager().discardJobs(tempProject.getName());
            }
        }
        return true;
    }

    public IProject getProject() {
        IAdaptable tempElement = this.getElement();
        IProject project = null;
        if (tempElement != null && tempElement instanceof IProject) {
            project = (IProject)tempElement;
        }
        return project;
    }

    public boolean getIndexerEnabled(IProject project) throws CoreException {
        Boolean indexValue = (Boolean)project.getSessionProperty(IndexManager.activationKey);
        if (indexValue == null) {
            indexValue = this.loadIndexerEnabledFromCDescriptor(project);
        }
        if (indexValue != null) {
            project.setSessionProperty(IndexManager.activationKey, (Object)indexValue);
        } else {
            indexValue = new Boolean(true);
            this.optionPage.setIndexerValue(true);
            this.optionPage.persistIndexerValues(project);
        }
        return indexValue;
    }

    public int getIndexerProblemsEnabled(IProject project) throws CoreException {
        Integer value = (Integer)project.getSessionProperty(IndexManager.problemsActivationKey);
        if (value == null) {
            value = this.loadIndexerProblemsEnabledFromCDescriptor(project);
        }
        if (value != null) {
            project.setSessionProperty(IndexManager.problemsActivationKey, (Object)value);
        } else {
            value = new Integer(0);
            this.optionPage.setIndexerProblemValues(0);
            this.optionPage.persistIndexerValues(project);
        }
        return value;
    }

    private Boolean loadIndexerEnabledFromCDescriptor(IProject project) throws CoreException {
        ICDescriptor descriptor = CCorePlugin.getDefault().getCProjectDescription(project, true);
        Node child = descriptor.getProjectData("cdt_indexer").getFirstChild();
        Boolean strBool = null;
        while (child != null) {
            if (child.getNodeName().equals("indexEnabled")) {
                strBool = Boolean.valueOf(((Element)child).getAttribute("indexValue"));
            }
            child = child.getNextSibling();
        }
        return strBool;
    }

    private Integer loadIndexerProblemsEnabledFromCDescriptor(IProject project) throws CoreException {
        ICDescriptor descriptor = CCorePlugin.getDefault().getCProjectDescription(project, true);
        Node child = descriptor.getProjectData("cdt_indexer").getFirstChild();
        Integer strInt = null;
        while (child != null) {
            if (child.getNodeName().equals("indexerProblemsEnabled")) {
                String val = ((Element)child).getAttribute("indexProblemsValue");
                try {
                    strInt = Integer.valueOf(val);
                }
                catch (NumberFormatException numberFormatException) {
                    Boolean bool = Boolean.valueOf(val);
                    if (bool.booleanValue()) {
                        strInt = new Integer(1);
                        break;
                    }
                    strInt = new Integer(0);
                }
                break;
            }
            child = child.getNextSibling();
        }
        return strInt;
    }
}

