/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.actions;

import org.eclipse.cdt.debug.core.model.IRunToAddress;
import org.eclipse.cdt.debug.core.model.IRunToLine;
import org.eclipse.cdt.debug.internal.ui.actions.AbstractEditorActionDelegate;
import org.eclipse.cdt.debug.internal.ui.actions.ActionMessages;
import org.eclipse.cdt.debug.internal.ui.actions.RunToLineAdapter;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.ISuspendResume;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.actions.IRunToLineTarget;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.ITextEditor;

public class RunToLineActionDelegate
extends AbstractEditorActionDelegate {
    IRunToLineTarget fRunToLineTarget;

    public void run(IAction action) {
        if (this.getTargetPart() instanceof ITextEditor) {
            ITextSelection selection = (ITextSelection)((ITextEditor)this.getTargetPart()).getSelectionProvider().getSelection();
            if (this.getRunToLineTarget() != null) {
                try {
                    this.getRunToLineTarget().runToLine(this.getTargetPart(), (ISelection)selection, (ISuspendResume)this.getDebugTarget());
                }
                catch (CoreException e) {
                    DebugUIPlugin.errorDialog((Shell)this.getTargetPart().getSite().getShell(), (String)ActionMessages.getString("RunToLineActionDelegate.Error_1"), (String)ActionMessages.getString("RunToLineActionDelegate.Operation_failed_1"), (IStatus)e.getStatus());
                }
            }
        }
    }

    protected void initializeDebugTarget() {
        IDebugTarget target;
        this.setDebugTarget(null);
        IAdaptable context = DebugUITools.getDebugContext();
        if (context != null && context instanceof IDebugElement && (target = ((IDebugElement)context).getDebugTarget()) != null && (target instanceof IRunToLine || target instanceof IRunToAddress)) {
            this.setDebugTarget(target);
        }
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        IDebugTarget target = null;
        if (part != null && part.getSite().getId().equals("org.eclipse.debug.ui.DebugView")) {
            IDebugTarget target1;
            Object element;
            if (selection instanceof IStructuredSelection && (element = ((IStructuredSelection)selection).getFirstElement()) != null && element instanceof IDebugElement && (target1 = ((IDebugElement)element).getDebugTarget()) != null && (target1 instanceof IRunToLine || target1 instanceof IRunToAddress)) {
                target = target1;
            }
            this.setDebugTarget(target);
            this.update();
        }
    }

    private IRunToLineTarget getRunToLineTarget() {
        if (this.fRunToLineTarget == null) {
            this.fRunToLineTarget = new RunToLineAdapter();
        }
        return this.fRunToLineTarget;
    }
}

