/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.browser.cbrowsing;

import java.util.Collection;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ElementChangedEvent;
import org.eclipse.cdt.core.model.IArchive;
import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICElementDelta;
import org.eclipse.cdt.core.model.IElementChangedListener;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.internal.ui.BaseCElementContentProvider;
import org.eclipse.cdt.internal.ui.browser.cbrowsing.CBrowsingPart;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public abstract class CBrowsingContentProvider
extends BaseCElementContentProvider
implements ITreeContentProvider,
IElementChangedListener {
    protected StructuredViewer fViewer;
    protected Object fInput;
    protected CBrowsingPart fBrowsingPart;
    protected int fReadsInDisplayThread;
    protected static final Object[] NO_CHILDREN = new Object[0];

    public CBrowsingContentProvider(CBrowsingPart browsingPart) {
        this.fBrowsingPart = browsingPart;
        this.fViewer = this.fBrowsingPart.getViewer();
        CoreModel.getDefault().addElementChangedListener((IElementChangedListener)this);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (newInput instanceof Collection) {
            Collection col = (Collection)newInput;
            newInput = !col.isEmpty() ? col.iterator().next() : null;
        }
        this.fInput = newInput;
    }

    public void dispose() {
        CoreModel.getDefault().removeElementChangedListener((IElementChangedListener)this);
    }

    public void elementChanged(ElementChangedEvent event) {
        try {
            this.processDelta(event.getDelta());
        }
        catch (CModelException e) {
            CUIPlugin.getDefault().log(e.getStatus());
        }
    }

    protected boolean isPathEntryChange(ICElementDelta delta) {
        int flags = delta.getFlags();
        return delta.getKind() == 4 && ((flags & 0x800000) != 0 || (flags & 0x1000) != 0 || (flags & 0x100) != 0 || (flags & 0x2000) != 0 || (flags & 0x40000) != 0 || (flags & 0x200) != 0 || (flags & 0x800) != 0);
    }

    protected void processDelta(ICElementDelta delta) throws CModelException {
        int kind = delta.getKind();
        int flags = delta.getFlags();
        ICElement element = delta.getElement();
        if ((flags & 0x80) != 0 || (flags & 0x40) != 0) {
            this.postRefresh(element);
        }
        if (kind == 2) {
            this.postRemove(element);
        }
        if (kind == 1) {
            Object parent = this.internalGetParent(element);
            this.postAdd(parent, element);
        }
        if (kind == 4 && (element instanceof ITranslationUnit || element instanceof IBinary || element instanceof IArchive)) {
            this.postRefresh(element);
            return;
        }
        if (this.isPathEntryChange(delta)) {
            this.postRefresh(element.getCProject());
        }
        ICElementDelta[] affectedChildren = delta.getAffectedChildren();
        int i = 0;
        while (i < affectedChildren.length) {
            this.processDelta(affectedChildren[i]);
            ++i;
        }
    }

    private void postRefresh(final Object element) {
        this.postRunnable(new Runnable(){

            public void run() {
                Control ctrl = CBrowsingContentProvider.this.fViewer.getControl();
                if (ctrl != null && !ctrl.isDisposed()) {
                    if (element instanceof IWorkingCopy) {
                        if (CBrowsingContentProvider.this.fViewer.testFindItem(element) != null) {
                            CBrowsingContentProvider.this.fViewer.refresh(element);
                        } else {
                            CBrowsingContentProvider.this.fViewer.refresh((Object)((IWorkingCopy)element).getOriginalElement());
                        }
                    } else {
                        CBrowsingContentProvider.this.fViewer.refresh(element);
                    }
                }
            }
        });
    }

    private void postAdd(final Object parent, Object element) {
        this.postRunnable(new Runnable(){

            public void run() {
                Control ctrl = CBrowsingContentProvider.this.fViewer.getControl();
                if (ctrl != null && !ctrl.isDisposed()) {
                    if (parent instanceof IWorkingCopy) {
                        if (CBrowsingContentProvider.this.fViewer.testFindItem(parent) != null) {
                            CBrowsingContentProvider.this.fViewer.refresh(parent);
                        } else {
                            CBrowsingContentProvider.this.fViewer.refresh((Object)((IWorkingCopy)parent).getOriginalElement());
                        }
                    } else {
                        CBrowsingContentProvider.this.fViewer.refresh(parent);
                    }
                }
            }
        });
    }

    private void postRemove(final Object element) {
        this.postRunnable(new Runnable(){

            public void run() {
                Control ctrl = CBrowsingContentProvider.this.fViewer.getControl();
                if (ctrl != null && !ctrl.isDisposed()) {
                    Object parent = CBrowsingContentProvider.this.internalGetParent(element);
                    if (parent instanceof IWorkingCopy) {
                        if (CBrowsingContentProvider.this.fViewer.testFindItem(parent) != null) {
                            CBrowsingContentProvider.this.fViewer.refresh(parent);
                        } else {
                            CBrowsingContentProvider.this.fViewer.refresh((Object)((IWorkingCopy)parent).getOriginalElement());
                        }
                    } else {
                        CBrowsingContentProvider.this.fViewer.refresh(parent);
                    }
                }
            }
        });
    }

    private void postRunnable(Runnable r) {
        Control ctrl = this.fViewer.getControl();
        if (ctrl != null && !ctrl.isDisposed()) {
            ctrl.getDisplay().asyncExec(r);
        }
    }

    protected void startReadInDisplayThread() {
        if (this.isDisplayThread()) {
            ++this.fReadsInDisplayThread;
        }
    }

    protected void finishedReadInDisplayThread() {
        if (this.isDisplayThread()) {
            --this.fReadsInDisplayThread;
        }
    }

    private boolean isDisplayThread() {
        Control ctrl = this.fViewer.getControl();
        if (ctrl == null) {
            return false;
        }
        Display currentDisplay = Display.getCurrent();
        return currentDisplay != null && currentDisplay.equals(ctrl.getDisplay());
    }
}

