/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.search;

import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.search.BasicSearchMatch;
import org.eclipse.cdt.internal.ui.search.ElementNameSorter;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.Viewer;

public class PathNameSorter
extends ElementNameSorter {
    public int compare(Viewer viewer, Object e1, Object e2) {
        IPath path1 = this.getPath(e1);
        IPath path2 = this.getPath(e2);
        return this.compare(path1, path2);
    }

    private IPath getPath(Object element) {
        if (element instanceof ICElement) {
            return ((ICElement)element).getPath();
        }
        if (element instanceof IResource) {
            return ((IResource)element).getFullPath();
        }
        if (element instanceof BasicSearchMatch) {
            return ((BasicSearchMatch)element).getLocation();
        }
        return new Path("");
    }

    protected int compare(IPath path1, IPath path2) {
        int segmentCount = Math.min(path1.segmentCount(), path2.segmentCount());
        int i = 0;
        while (i < segmentCount) {
            int value = this.collator.compare(path1.segment(i), path2.segment(i));
            if (value != 0) {
                return value;
            }
            ++i;
        }
        return path1.segmentCount() - path2.segmentCount();
    }
}

