/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.core.scannerconfig.gnu;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.cdt.make.core.scannerconfig.IScannerInfoCollector;
import org.eclipse.cdt.make.core.scannerconfig.IScannerInfoConsoleParser;
import org.eclipse.cdt.make.core.scannerconfig.IScannerInfoConsoleParserUtility;
import org.eclipse.cdt.make.internal.core.scannerconfig.util.TraceUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;

public class GCCSpecsConsoleParser
implements IScannerInfoConsoleParser {
    private final int STATE_BEGIN = 0;
    private final int STATE_SPECS_STARTED = 1;
    private final int STATE_INCLUDES_STARTED = 2;
    private IProject fProject = null;
    private IScannerInfoConsoleParserUtility fUtil = null;
    private IScannerInfoCollector fCollector = null;
    private int state = 0;
    private List symbols = new ArrayList();
    private List includes = new ArrayList();

    public void startup(IProject project, IScannerInfoConsoleParserUtility util, IScannerInfoCollector collector) {
        this.fProject = project;
        this.fUtil = util;
        this.fCollector = collector;
    }

    public boolean processLine(String line) {
        boolean rc = false;
        TraceUtil.outputTrace("GCCSpecsConsoleParser parsing line:", TraceUtil.EOL, line);
        switch (this.state) {
            case 0: {
                if (line.startsWith("Reading specs from")) {
                    this.state = 1;
                }
                return rc;
            }
            case 1: {
                if (line.indexOf("-D") != -1) {
                    StringTokenizer scanner = new StringTokenizer(line);
                    if (scanner.countTokens() <= 1) {
                        return rc;
                    }
                    String token = scanner.nextToken();
                    while (scanner.hasMoreTokens()) {
                        String symbol;
                        if (token.startsWith("-D") && !this.symbols.contains(symbol = token.substring(2))) {
                            this.symbols.add(symbol);
                        }
                        token = scanner.nextToken();
                    }
                }
                if (line.startsWith("#include") && line.endsWith("search starts here:")) {
                    this.state = 2;
                }
                return rc;
            }
            case 2: {
                if (line.startsWith("#include") && line.endsWith("search starts here:")) {
                    this.state = 2;
                } else {
                    if (line.startsWith("End of search list.")) {
                        this.state = 0;
                        break;
                    }
                    if (!this.includes.contains(line)) {
                        this.includes.add(line);
                    }
                }
                return rc;
            }
        }
        this.fCollector.contributeToScannerConfig((IResource)this.fProject, this.includes, this.symbols, new HashMap());
        TraceUtil.outputTrace("Scanner info from 'specs' file", "Include paths", this.includes, new ArrayList(), "Defined symbols", this.symbols);
        return rc;
    }

    public void shutdown() {
        if (this.fUtil != null) {
            this.fUtil.reportProblems();
        }
    }
}

