/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.internal.core.model.CElementInfo;
import org.eclipse.cdt.internal.core.model.CModelInfo;
import org.eclipse.cdt.internal.core.model.CModelManager;
import org.eclipse.cdt.internal.core.model.CModelStatus;
import org.eclipse.cdt.internal.core.model.CProject;
import org.eclipse.cdt.internal.core.model.CopyResourceElementsOperation;
import org.eclipse.cdt.internal.core.model.DeleteResourceElementsOperation;
import org.eclipse.cdt.internal.core.model.MoveResourceElementsOperation;
import org.eclipse.cdt.internal.core.model.MultiOperation;
import org.eclipse.cdt.internal.core.model.Openable;
import org.eclipse.cdt.internal.core.model.OpenableInfo;
import org.eclipse.cdt.internal.core.model.RenameResourceElementsOperation;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;

public class CModel
extends Openable
implements ICModel {
    public CModel() {
        this(ResourcesPlugin.getWorkspace().getRoot());
    }

    public CModel(IWorkspaceRoot root) {
        super(null, (IResource)root, 10);
    }

    public boolean equals(Object o) {
        if (!(o instanceof CModel)) {
            return false;
        }
        return super.equals(o);
    }

    public ICProject[] getCProjects() throws CModelException {
        List list = this.getChildrenOfType(11);
        ICProject[] array = new ICProject[list.size()];
        list.toArray(array);
        return array;
    }

    public ICProject getCProject(String name) {
        IProject project = ((IWorkspaceRoot)this.getResource()).getProject(name);
        return CModelManager.getDefault().create(project);
    }

    public ICProject getCProject(IResource resource) {
        switch (resource.getType()) {
            case 2: {
                return new CProject(this, ((IFolder)resource).getProject());
            }
            case 1: {
                return new CProject(this, ((IFile)resource).getProject());
            }
            case 4: {
                return new CProject(this, (IProject)resource);
            }
        }
        throw new IllegalArgumentException("element.invalidResourceForProject");
    }

    public ICProject findCProject(IProject project) {
        try {
            ICProject[] projects = this.getOldCProjectsList();
            int i = 0;
            int length = projects.length;
            while (i < length) {
                ICProject javaProject = projects[i];
                if (project.equals((Object)javaProject.getProject())) {
                    return javaProject;
                }
                ++i;
            }
        }
        catch (CModelException cModelException) {}
        return null;
    }

    public IWorkspace getWorkspace() {
        return this.getUnderlyingResource().getWorkspace();
    }

    public void copy(ICElement[] elements, ICElement[] containers, ICElement[] siblings, String[] renamings, boolean replace, IProgressMonitor monitor) throws CModelException {
        if (elements == null || elements[0] == null || elements[0].getElementType() > 60) {
            throw new CModelException(new CModelStatus());
        }
        this.runOperation(new CopyResourceElementsOperation(elements, containers, replace), elements, siblings, renamings, monitor);
    }

    public void delete(ICElement[] elements, boolean force, IProgressMonitor monitor) throws CModelException {
        if (elements == null || elements[0] == null || elements[0].getElementType() > 60) {
            throw new CModelException(new CModelStatus());
        }
        this.runOperation(new DeleteResourceElementsOperation(elements, force), monitor);
    }

    public void move(ICElement[] elements, ICElement[] containers, ICElement[] siblings, String[] renamings, boolean replace, IProgressMonitor monitor) throws CModelException {
        if (elements == null || elements[0] == null || elements[0].getElementType() > 60) {
            throw new CModelException(new CModelStatus());
        }
        this.runOperation(new MoveResourceElementsOperation(elements, containers, replace), elements, siblings, renamings, monitor);
    }

    public void rename(ICElement[] elements, ICElement[] destinations, String[] renamings, boolean force, IProgressMonitor monitor) throws CModelException {
        if (elements == null || elements[0] == null || elements[0].getElementType() > 60) {
            throw new CModelException(new CModelStatus());
        }
        this.runOperation(new RenameResourceElementsOperation(elements, destinations, renamings, force), monitor);
    }

    protected void runOperation(MultiOperation op, ICElement[] elements, ICElement[] siblings, String[] renamings, IProgressMonitor monitor) throws CModelException {
        op.setRenamings(renamings);
        if (siblings != null) {
            int i = 0;
            while (i < elements.length) {
                op.setInsertBefore(elements[i], siblings[i]);
                ++i;
            }
        }
        this.runOperation(op, monitor);
    }

    protected CElementInfo createElementInfo() {
        return new CModelInfo(this);
    }

    public int hashCode() {
        return this.resource.hashCode();
    }

    public ICProject[] getOldCProjectsList() throws CModelException {
        CModelManager manager = CModelManager.getDefault();
        return manager.cProjectsCache == null ? this.getCProjects() : manager.cProjectsCache;
    }

    /*
     * Exception decompiling
     */
    protected boolean buildStructure(OpenableInfo info, IProgressMonitor pm, Map newElements, IResource underlyingResource) throws CModelException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 73->76)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Object[] getNonCResources() throws CModelException {
        return ((CModelInfo)this.getElementInfo()).getNonCResources();
    }

    protected boolean computeChildren(OpenableInfo info, IResource res) throws CModelException {
        IWorkspaceRoot root = (IWorkspaceRoot)this.getResource();
        IProject[] projects = root.getProjects();
        int i = 0;
        int max = projects.length;
        while (i < max) {
            IProject project = projects[i];
            if (CoreModel.hasCNature(project) || CoreModel.hasCCNature(project)) {
                CProject cproject = new CProject(this, project);
                info.addChild(cproject);
            }
            ++i;
        }
        ((CModelInfo)this.getElementInfo()).setNonCResources(null);
        return true;
    }
}

