/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.views.disassembly;

import java.util.Arrays;
import org.eclipse.cdt.debug.core.model.IAsmInstruction;
import org.eclipse.cdt.debug.core.model.IAsmSourceLine;
import org.eclipse.cdt.debug.core.model.IBreakpointTarget;
import org.eclipse.cdt.debug.core.model.ICDebugTarget;
import org.eclipse.cdt.debug.core.model.ICLineBreakpoint;
import org.eclipse.cdt.debug.core.model.ICStackFrame;
import org.eclipse.cdt.debug.core.model.IDisassembly;
import org.eclipse.cdt.debug.core.model.IDisassemblyBlock;
import org.eclipse.cdt.debug.internal.ui.CDebugUIUtils;
import org.eclipse.cdt.debug.internal.ui.views.disassembly.DisassemblyMessages;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPersistableElement;

public class DisassemblyEditorInput
implements IEditorInput {
    public static final IEditorInput EMPTY_EDITOR_INPUT = new DisassemblyEditorInput();
    public static final IEditorInput PENDING_EDITOR_INPUT = new DisassemblyEditorInput(){

        public String getContents() {
            return DisassemblyMessages.getString("DisassemblyDocumentProvider.Pending_1");
        }
    };
    private IDisassemblyBlock fBlock;
    private String fContents = "";
    private IRegion[] fSourceRegions = new IRegion[0];
    static /* synthetic */ Class class$0;

    protected DisassemblyEditorInput() {
    }

    private DisassemblyEditorInput(IDisassemblyBlock block) {
        this.fBlock = block;
        this.createContents();
    }

    public boolean exists() {
        return true;
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public String getName() {
        return null;
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public String getToolTipText() {
        return null;
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public boolean contains(ICStackFrame frame) {
        if (this.fBlock != null) {
            return this.fBlock.contains(frame);
        }
        return false;
    }

    public String getContents() {
        return this.fContents;
    }

    public int getInstructionLine(long address) {
        if (this.fBlock != null) {
            IAsmSourceLine[] lines = this.fBlock.getSourceLines();
            int result = 0;
            int i = 0;
            while (i < lines.length) {
                IAsmInstruction[] instructions = lines[i].getInstructions();
                ++result;
                int j = 0;
                while (j < instructions.length) {
                    ++result;
                    if (instructions[j].getAdress() == address) {
                        return result;
                    }
                    ++j;
                }
                ++i;
            }
        }
        return 0;
    }

    public int getInstructionLine(ICLineBreakpoint breakpoint) {
        IDisassembly dis;
        if (this.fBlock != null && (dis = this.fBlock.getDisassembly()) != null) {
            IBreakpointTarget bt;
            IDebugTarget iDebugTarget = dis.getDebugTarget();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.cdt.debug.core.model.IBreakpointTarget");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((bt = (IBreakpointTarget)iDebugTarget.getAdapter((Class)clazz)) != null) {
                try {
                    long address = bt.getBreakpointAddress(breakpoint);
                    if (address != 0L) {
                        return this.getInstructionLine(address);
                    }
                }
                catch (DebugException debugException) {}
            }
        }
        return 0;
    }

    public long getAddress(int lineNumber) {
        if (this.fBlock != null) {
            IAsmSourceLine[] lines = this.fBlock.getSourceLines();
            int current = 0;
            int i = 0;
            while (i < lines.length) {
                IAsmInstruction[] instructions = lines[i].getInstructions();
                if (lineNumber == ++current) {
                    return instructions[0].getAdress();
                }
                if (lineNumber > current && lineNumber <= current + instructions.length) {
                    return instructions[lineNumber - current - 1].getAdress();
                }
                current += instructions.length;
                ++i;
            }
        }
        return 0L;
    }

    public String getModuleFile() {
        return this.fBlock != null ? this.fBlock.getModuleFile() : null;
    }

    public static DisassemblyEditorInput create(ICStackFrame frame) throws DebugException {
        DisassemblyEditorInput input = null;
        IDisassembly disassembly = ((ICDebugTarget)frame.getDebugTarget()).getDisassembly();
        if (disassembly != null) {
            IDisassemblyBlock block = disassembly.getDisassemblyBlock(frame);
            input = new DisassemblyEditorInput(block);
        }
        return input;
    }

    private void createContents() {
        this.fSourceRegions = new IRegion[0];
        StringBuffer lines = new StringBuffer();
        int maxFunctionName = 0;
        int maxOpcodeLength = 0;
        long maxOffset = 0L;
        if (this.fBlock != null) {
            IAsmSourceLine[] mi = this.fBlock.getSourceLines();
            int j = 0;
            while (j < mi.length) {
                IAsmInstruction[] instructions = mi[j].getInstructions();
                int i = 0;
                while (i < instructions.length) {
                    String opcode;
                    String functionName = instructions[i].getFunctionName();
                    if (functionName.length() > maxFunctionName) {
                        maxFunctionName = functionName.length();
                    }
                    if ((opcode = instructions[i].getOpcode()).length() > maxOpcodeLength) {
                        maxOpcodeLength = opcode.length();
                    }
                    if (instructions[i].getOffset() > maxOffset) {
                        maxOffset = instructions[i].getOffset();
                    }
                    ++i;
                }
                ++j;
            }
            int instrPos = this.calculateInstructionPosition(maxFunctionName, maxOffset);
            int argPosition = instrPos + maxOpcodeLength + 1;
            if (this.fBlock.isMixedMode()) {
                this.fSourceRegions = new IRegion[mi.length];
            }
            int j2 = 0;
            while (j2 < mi.length) {
                if (this.fBlock.isMixedMode()) {
                    String sl = this.getSourceLineString(mi[j2]);
                    this.fSourceRegions[j2] = new Region(lines.length(), sl.length());
                    lines.append(sl);
                }
                IAsmInstruction[] instructions = mi[j2].getInstructions();
                int i = 0;
                while (i < instructions.length) {
                    lines.append(this.getInstructionString(instructions[i], instrPos, argPosition));
                    ++i;
                }
                ++j2;
            }
        }
        this.fContents = lines.toString();
    }

    private String getInstructionString(IAsmInstruction instruction, int instrPosition, int argPosition) {
        int worstCaseSpace = Math.max(instrPosition, argPosition);
        char[] spaces = new char[worstCaseSpace];
        Arrays.fill(spaces, ' ');
        StringBuffer sb = new StringBuffer();
        if (instruction != null) {
            sb.append(CDebugUIUtils.toHexAddressString(instruction.getAdress()));
            sb.append(' ');
            String functionName = instruction.getFunctionName();
            if (functionName != null && functionName.length() > 0) {
                sb.append('<');
                sb.append(functionName);
                if (instruction.getOffset() != 0L) {
                    sb.append('+');
                    sb.append(instruction.getOffset());
                }
                sb.append(">:");
                sb.append(spaces, 0, instrPosition - sb.length());
            }
            sb.append(instruction.getOpcode());
            sb.append(spaces, 0, argPosition - sb.length());
            sb.append(instruction.getArguments());
            sb.append('\n');
        }
        return sb.toString();
    }

    private int calculateInstructionPosition(int maxFunctionName, long maxOffset) {
        return 16 + maxFunctionName + Long.toString(maxOffset).length();
    }

    private String getSourceLineString(IAsmSourceLine line) {
        String text = line.toString();
        if (text == null) {
            text = String.valueOf(DisassemblyMessages.getString("DisassemblyEditorInput.source_line_is_not_available_1")) + '\n';
        }
        return text;
    }

    public IRegion[] getSourceRegions() {
        return this.fSourceRegions;
    }

    protected IDisassembly getDisassembly() {
        return this.fBlock != null ? this.fBlock.getDisassembly() : null;
    }
}

