/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.ast.complete.gcc;

import java.util.List;
import org.eclipse.cdt.core.parser.ITokenDuple;
import org.eclipse.cdt.core.parser.ParserMode;
import org.eclipse.cdt.core.parser.ast.ASTUtil;
import org.eclipse.cdt.core.parser.ast.IASTExpression;
import org.eclipse.cdt.core.parser.ast.IASTScope;
import org.eclipse.cdt.core.parser.ast.IASTTypeId;
import org.eclipse.cdt.core.parser.ast.gcc.IASTGCCExpression;
import org.eclipse.cdt.internal.core.parser.ast.GCCASTExtension;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTBinaryExpression;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTTypeIdExpression;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTUnaryExpression;
import org.eclipse.cdt.internal.core.parser.ast.complete.ExpressionFactory;

public class GCCASTCompleteExtension
extends GCCASTExtension {
    public GCCASTCompleteExtension(ParserMode mode) {
        super(mode);
    }

    public boolean overrideCreateExpressionMethod() {
        return this.mode == ParserMode.STRUCTURAL_PARSE || this.mode == ParserMode.COMPLETE_PARSE;
    }

    protected IASTExpression createExpression(IASTExpression.Kind kind, IASTExpression lhs, IASTExpression rhs, IASTExpression thirdExpression, IASTTypeId typeId, ITokenDuple idExpression, char[] literal, IASTExpression.IASTNewExpressionDescriptor newDescriptor, List references) {
        if (lhs != null && rhs != null && (kind == IASTGCCExpression.Kind.RELATIONAL_MAX || kind == IASTGCCExpression.Kind.RELATIONAL_MIN)) {
            return new ASTBinaryExpression(kind, references, lhs, rhs){

                public String toString() {
                    IASTExpression.Kind k = this.getExpressionKind();
                    StringBuffer buffer = new StringBuffer();
                    buffer.append(ASTUtil.getExpressionString(this.getLHSExpression()));
                    if (k == IASTGCCExpression.Kind.RELATIONAL_MAX) {
                        buffer.append(" >? ");
                    } else {
                        buffer.append(" <? ");
                    }
                    buffer.append(ASTUtil.getExpressionString(this.getRHSExpression()));
                    return buffer.toString();
                }
            };
        }
        if (lhs != null && (kind == IASTGCCExpression.Kind.UNARY_ALIGNOF_UNARYEXPRESSION || kind == IASTGCCExpression.Kind.UNARY_TYPEOF_UNARYEXPRESSION)) {
            return new ASTUnaryExpression(kind, references, lhs){

                public String toString() {
                    IASTExpression.Kind k = this.getExpressionKind();
                    StringBuffer buffer = new StringBuffer();
                    if (k == IASTGCCExpression.Kind.UNARY_ALIGNOF_UNARYEXPRESSION) {
                        buffer.append("__alignof__");
                    } else {
                        buffer.append("typeof");
                    }
                    buffer.append(' ');
                    buffer.append(ASTUtil.getExpressionString(this.getLHSExpression()));
                    return buffer.toString();
                }
            };
        }
        if (typeId != null && lhs == null && (kind == IASTGCCExpression.Kind.UNARY_ALIGNOF_TYPEID || kind == IASTGCCExpression.Kind.UNARY_TYPEOF_TYPEID)) {
            return new ASTTypeIdExpression(kind, references, typeId){

                public String toString() {
                    IASTExpression.Kind k = this.getExpressionKind();
                    StringBuffer buffer = new StringBuffer();
                    if (k == IASTGCCExpression.Kind.UNARY_ALIGNOF_TYPEID) {
                        buffer.append("__alignof__");
                    } else {
                        buffer.append("typeof");
                    }
                    buffer.append('(');
                    buffer.append(ASTUtil.getTypeId(this.getTypeId()));
                    buffer.append(')');
                    return buffer.toString();
                }
            };
        }
        return ExpressionFactory.createExpression(kind, lhs, rhs, thirdExpression, typeId, idExpression, literal, newDescriptor, references);
    }

    public IASTExpression createExpression(IASTScope scope, IASTExpression.Kind kind, IASTExpression lhs, IASTExpression rhs, IASTExpression thirdExpression, IASTTypeId typeId, ITokenDuple idExpression, char[] literal, IASTExpression.IASTNewExpressionDescriptor newDescriptor, List references) {
        if (this.canHandleExpressionKind(kind)) {
            return this.createExpression(kind, lhs, rhs, thirdExpression, typeId, idExpression, literal, newDescriptor, references);
        }
        return ExpressionFactory.createExpression(kind, lhs, rhs, thirdExpression, typeId, idExpression, literal, newDescriptor, references);
    }
}

