/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.scanner;

import org.eclipse.cdt.core.parser.CodeReader;
import org.eclipse.cdt.core.parser.ast.IASTInclusion;
import org.eclipse.cdt.internal.core.parser.scanner.IScannerContext;

public class ScannerContextInclusion
implements IScannerContext {
    public static final int UNDO_BUFFER_SIZE = 4;
    public CodeReader code;
    private IASTInclusion inc;
    private final int index;
    private int line;
    protected int offset = 0;

    public ScannerContextInclusion(CodeReader code, IASTInclusion i, int index) {
        this.code = code;
        this.line = 1;
        this.inc = i;
        this.index = index;
    }

    public boolean isFinal() {
        return false;
    }

    public final String getContextName() {
        return new String(this.code.filename);
    }

    public int getOffset() {
        return this.offset;
    }

    public void close() {
    }

    public int getChar() {
        char c;
        if (this.offset == this.code.buffer.length) {
            return -1;
        }
        if ((char)(c = this.code.buffer[this.offset++]) == '\n') {
            ++this.line;
        }
        return c;
    }

    public void ungetChar(int undo) {
        --this.offset;
        if (undo == 10) {
            --this.line;
        }
    }

    public int getKind() {
        return IScannerContext.ContextKind.INCLUSION;
    }

    public IASTInclusion getExtension() {
        return this.inc;
    }

    public int getFilenameIndex() {
        return this.index;
    }

    public final int getLine() {
        return this.line;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("file ");
        buffer.append(this.getContextName());
        buffer.append(":");
        buffer.append(this.getLine());
        return buffer.toString();
    }
}

