/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedConfigElement;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IOptionCategory;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolReference;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.core.BuildObject;
import org.eclipse.cdt.managedbuilder.internal.core.Option;
import org.eclipse.cdt.managedbuilder.internal.core.OptionCategory;
import org.eclipse.cdt.managedbuilder.internal.core.Target;

public class Tool
extends BuildObject
implements ITool,
IOptionCategory {
    private static final String DEFAULT_SEPARATOR = ",";
    private static final IOptionCategory[] EMPTY_CATEGORIES = new IOptionCategory[0];
    private static final IOption[] EMPTY_OPTIONS = new IOption[0];
    private Vector categoryIds;
    private Map categoryMap;
    private List childOptionCategories;
    private String command;
    private List inputExtensions;
    private List interfaceExtensions;
    private int natureFilter;
    private Vector optionList;
    private Map optionMap;
    private String outputExtensions;
    private String outputFlag;
    private String outputPrefix;
    private boolean resolved = true;

    public Tool(IManagedConfigElement element) {
        this.loadFromManifest(element);
        ManagedBuildManager.addExtensionTool(this);
    }

    public Tool(Target target, IManagedConfigElement element) {
        this.loadFromManifest(element);
        target.addTool(this);
    }

    public void addChildCategory(IOptionCategory category) {
        if (this.childOptionCategories == null) {
            this.childOptionCategories = new ArrayList();
        }
        this.childOptionCategories.add(category);
    }

    public void addOption(Option option) {
        this.getOptionList().add(option);
        this.getOptionMap().put(option.getId(), option);
    }

    protected void addOptionCategory(IOptionCategory category) {
        this.getCategoryIds().add(category.getId());
        this.getCategoryMap().put(category.getId(), category);
    }

    public boolean buildsFileType(String extension) {
        if (extension == null) {
            return false;
        }
        return this.getInputExtensions().contains(extension);
    }

    private Vector getCategoryIds() {
        if (this.categoryIds == null) {
            this.categoryIds = new Vector();
        }
        return this.categoryIds;
    }

    private Map getCategoryMap() {
        if (this.categoryMap == null) {
            this.categoryMap = new HashMap();
        }
        return this.categoryMap;
    }

    private Vector getOptionList() {
        if (this.optionList == null) {
            this.optionList = new Vector();
        }
        return this.optionList;
    }

    private Map getOptionMap() {
        if (this.optionMap == null) {
            this.optionMap = new HashMap();
        }
        return this.optionMap;
    }

    public IOption[] getOptions() {
        return this.getOptionList().toArray(new IOption[this.getOptionList().size()]);
    }

    public IOptionCategory getTopOptionCategory() {
        return this;
    }

    public IOptionCategory[] getChildCategories() {
        if (this.childOptionCategories != null) {
            return this.childOptionCategories.toArray(new IOptionCategory[this.childOptionCategories.size()]);
        }
        return EMPTY_CATEGORIES;
    }

    public List getInputExtensions() {
        if (this.inputExtensions == null) {
            this.inputExtensions = new ArrayList();
        }
        return this.inputExtensions;
    }

    private List getInterfaceExtensions() {
        if (this.interfaceExtensions == null) {
            this.interfaceExtensions = new ArrayList();
        }
        return this.interfaceExtensions;
    }

    public String getOutputFlag() {
        return this.outputFlag == null ? new String() : this.outputFlag.trim();
    }

    public String getOutputPrefix() {
        return this.outputPrefix == null ? new String() : this.outputPrefix.trim();
    }

    public IOptionCategory getOwner() {
        return null;
    }

    public ITool getTool() {
        return this;
    }

    public String getToolCommand() {
        return this.command.trim();
    }

    public String getToolFlags() throws BuildException {
        StringBuffer buf = new StringBuffer();
        IOption[] opts = this.getOptions();
        int index = 0;
        while (index < opts.length) {
            IOption option = opts[index];
            switch (option.getValueType()) {
                case 0: {
                    String boolCmd = option.getBooleanValue() ? option.getCommand() : option.getCommandFalse();
                    if (boolCmd == null || boolCmd.length() <= 0) break;
                    buf.append(String.valueOf(boolCmd) + " ");
                    break;
                }
                case 1: {
                    String string = option.getEnumCommand(option.getSelectedEnum());
                    if (string.length() <= 0) break;
                    buf.append(String.valueOf(string) + " ");
                    break;
                }
                case 2: {
                    String strCmd = option.getCommand();
                    String val = option.getStringValue();
                    if (val.length() <= 0) break;
                    if (strCmd != null) {
                        buf.append(strCmd);
                    }
                    buf.append(String.valueOf(val) + " ");
                    break;
                }
                case 3: {
                    String listCmd = option.getCommand();
                    String[] list = option.getStringListValue();
                    int j = 0;
                    while (j < list.length) {
                        String temp = list[j];
                        if (listCmd != null) {
                            buf.append(listCmd);
                        }
                        buf.append(String.valueOf(temp) + " ");
                        ++j;
                    }
                    break;
                }
                case 4: {
                    String incCmd = option.getCommand();
                    String[] paths = option.getIncludePaths();
                    int j = 0;
                    while (j < paths.length) {
                        String temp = paths[j];
                        buf.append(String.valueOf(incCmd) + temp + " ");
                        ++j;
                    }
                    break;
                }
                case 5: {
                    String defCmd = option.getCommand();
                    String[] symbols = option.getDefinedSymbols();
                    int j = 0;
                    while (j < symbols.length) {
                        String temp = symbols[j];
                        buf.append(String.valueOf(defCmd) + temp + " ");
                        ++j;
                    }
                    break;
                }
            }
            ++index;
        }
        return buf.toString().trim();
    }

    public IOption[] getOptions(IConfiguration configuration) {
        ITool tool = this;
        if (configuration != null) {
            ITool[] tools = configuration.getTools();
            int i = 0;
            while (i < tools.length) {
                if (tools[i] instanceof IToolReference) {
                    if (((IToolReference)tools[i]).references(tool)) {
                        tool = tools[i];
                        break;
                    }
                } else if (tools[i].equals(tool)) break;
                ++i;
            }
        }
        IOption[] allOptions = tool.getOptions();
        ArrayList<IOption> myOptions = new ArrayList<IOption>();
        int i = 0;
        while (i < allOptions.length) {
            IOption option = allOptions[i];
            if (option.getCategory().equals(this)) {
                myOptions.add(option);
            }
            ++i;
        }
        myOptions.trimToSize();
        return myOptions.toArray(new IOption[myOptions.size()]);
    }

    public int getNatureFilter() {
        return this.natureFilter;
    }

    public IOption getOption(String id) {
        return this.getOptionById(id);
    }

    public IOption getOptionById(String id) {
        return (IOption)this.getOptionMap().get(id);
    }

    public IOptionCategory getOptionCategory(String id) {
        return (IOptionCategory)this.getCategoryMap().get(id);
    }

    public String[] getOutputExtensions() {
        return this.outputExtensions.split(DEFAULT_SEPARATOR);
    }

    public String getOutputExtension(String inputExtension) {
        ListIterator iter = this.getInputExtensions().listIterator();
        while (iter.hasNext()) {
            if (!((String)iter.next()).equals(inputExtension)) continue;
            return this.outputExtensions;
        }
        return null;
    }

    public boolean isHeaderFile(String ext) {
        if (ext == null) {
            return false;
        }
        return this.getInterfaceExtensions().contains(ext);
    }

    protected void loadFromManifest(IManagedConfigElement element) {
        ManagedBuildManager.putConfigElement(this, element);
        this.resolved = false;
        this.setId(element.getAttribute("id"));
        this.setName(element.getAttribute("name"));
        String nature = element.getAttribute("natureFilter");
        this.natureFilter = nature == null || "both".equals(nature) ? 2 : ("cnature".equals(nature) ? 0 : ("ccnature".equals(nature) ? 1 : 2));
        String inputs = element.getAttribute("sources") == null ? new String() : element.getAttribute("sources");
        StringTokenizer tokenizer = new StringTokenizer(inputs, DEFAULT_SEPARATOR);
        while (tokenizer.hasMoreElements()) {
            this.getInputExtensions().add(tokenizer.nextElement());
        }
        String headers = element.getAttribute("headerExtensions");
        if (headers == null) {
            headers = new String();
        }
        tokenizer = new StringTokenizer(headers, DEFAULT_SEPARATOR);
        while (tokenizer.hasMoreElements()) {
            this.getInterfaceExtensions().add(tokenizer.nextElement());
        }
        this.outputExtensions = element.getAttribute("outputs") == null ? new String() : element.getAttribute("outputs");
        this.command = element.getAttribute("command") == null ? new String() : element.getAttribute("command");
        this.outputFlag = element.getAttribute("outputFlag") == null ? new String() : element.getAttribute("outputFlag");
        this.outputPrefix = element.getAttribute("outputPrefix") == null ? new String() : element.getAttribute("outputPrefix");
        this.addOptionCategory(this);
        IManagedConfigElement[] toolElements = element.getChildren();
        int l = 0;
        while (l < toolElements.length) {
            IManagedConfigElement toolElement = toolElements[l];
            if (toolElement.getName().equals("option")) {
                new Option(this, toolElement);
            } else if (toolElement.getName().equals("optionCategory")) {
                new OptionCategory(this, toolElement);
            }
            ++l;
        }
    }

    public boolean producesFileType(String outputExtension) {
        return this.outputExtensions.equals(outputExtension);
    }

    public void resolveReferences() {
        if (!this.resolved) {
            this.resolved = true;
            Iterator optionIter = this.getOptionList().iterator();
            while (optionIter.hasNext()) {
                Option current = (Option)optionIter.next();
                current.resolveReferences();
            }
            Iterator catIter = this.getCategoryIds().iterator();
            while (catIter.hasNext()) {
                String id = (String)catIter.next();
                IOptionCategory current = (IOptionCategory)this.getCategoryMap().get(id);
                if (current instanceof Tool) {
                    ((Tool)current).resolveReferences();
                    continue;
                }
                if (!(current instanceof OptionCategory)) continue;
                ((OptionCategory)current).resolveReferences();
            }
        }
    }
}

