/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.browser.cache;

import java.io.IOException;
import org.eclipse.cdt.core.browser.ITypeSearchScope;
import org.eclipse.cdt.internal.core.CharOperation;
import org.eclipse.cdt.internal.core.browser.cache.ITypeCache;
import org.eclipse.cdt.internal.core.browser.cache.IndexerJob;
import org.eclipse.cdt.internal.core.browser.util.PathUtil;
import org.eclipse.cdt.internal.core.index.IEntryResult;
import org.eclipse.cdt.internal.core.index.IIndex;
import org.eclipse.cdt.internal.core.index.impl.BlocksIndexInput;
import org.eclipse.cdt.internal.core.index.impl.IndexInput;
import org.eclipse.cdt.internal.core.index.impl.IndexedFile;
import org.eclipse.cdt.internal.core.search.indexing.IIndexConstants;
import org.eclipse.cdt.internal.core.search.indexing.IndexManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;

public class IndexerDependenciesJob
extends IndexerJob {
    private ITypeCache fTypeCache;
    private ITypeSearchScope fScope;

    public IndexerDependenciesJob(IndexManager indexManager, ITypeCache typeCache, ITypeSearchScope scope) {
        super(indexManager, typeCache.getProject());
        this.fTypeCache = typeCache;
        this.fScope = scope;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean processIndex(IIndex index, IProject project, IProgressMonitor progressMonitor) throws InterruptedException {
        BlocksIndexInput input = new BlocksIndexInput(index.getIndexFile());
        try {
            try {
                ((IndexInput)input).open();
                this.flushDependencies(input, progressMonitor);
                Object var5_5 = null;
            }
            catch (IOException iOException) {
                Object var5_6 = null;
                try {
                    ((IndexInput)input).close();
                    return false;
                }
                catch (IOException iOException2) {
                    return false;
                }
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            try {}
            catch (IOException iOException) {
                return false;
            }
            ((IndexInput)input).close();
            throw throwable;
        }
        try {}
        catch (IOException iOException) {
            return false;
        }
        ((IndexInput)input).close();
        return true;
    }

    private void flushDependencies(IndexInput input, IProgressMonitor progressMonitor) throws InterruptedException, IOException {
        if (progressMonitor.isCanceled()) {
            throw new InterruptedException();
        }
        IEntryResult[] includeEntries = input.queryEntriesPrefixedBy(IIndexConstants.INCLUDE_REF);
        if (includeEntries != null) {
            int i = 0;
            while (i < includeEntries.length) {
                int[] references;
                if (progressMonitor.isCanceled()) {
                    throw new InterruptedException();
                }
                IEntryResult entry = includeEntries[i];
                IPath includePath = this.getIncludePath(entry);
                if (this.fScope != null && this.fScope.encloses(includePath) && (references = entry.getFileReferences()) != null) {
                    int j = 0;
                    while (j < references.length) {
                        if (progressMonitor.isCanceled()) {
                            throw new InterruptedException();
                        }
                        IndexedFile file = input.getIndexedFile(references[j]);
                        if (file != null && file.getPath() != null) {
                            IPath path = PathUtil.getWorkspaceRelativePath(file.getPath());
                            this.fTypeCache.flush(path);
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
    }

    private IPath getIncludePath(IEntryResult entry) {
        char[] word = entry.getWord();
        int firstSlash = CharOperation.indexOf('/', word, 0);
        String include = String.valueOf(CharOperation.subarray(word, firstSlash + 1, -1));
        return PathUtil.getWorkspaceRelativePath(include);
    }
}

