/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.search.matching;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.cdt.core.parser.CodeReader;
import org.eclipse.cdt.core.parser.EndOfFileException;
import org.eclipse.cdt.core.parser.IParser;
import org.eclipse.cdt.core.parser.IParserLogService;
import org.eclipse.cdt.core.parser.IProblem;
import org.eclipse.cdt.core.parser.IQuickParseCallback;
import org.eclipse.cdt.core.parser.IScanner;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.IToken;
import org.eclipse.cdt.core.parser.NullLogService;
import org.eclipse.cdt.core.parser.NullSourceElementRequestor;
import org.eclipse.cdt.core.parser.ParserFactory;
import org.eclipse.cdt.core.parser.ParserFactoryError;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.core.parser.ParserMode;
import org.eclipse.cdt.core.parser.ParserUtil;
import org.eclipse.cdt.core.parser.ScannerException;
import org.eclipse.cdt.core.parser.ScannerInfo;
import org.eclipse.cdt.core.parser.ast.ASTNotImplementedException;
import org.eclipse.cdt.core.parser.ast.ASTUtil;
import org.eclipse.cdt.core.parser.ast.IASTCompilationUnit;
import org.eclipse.cdt.core.parser.ast.IASTDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTFunction;
import org.eclipse.cdt.core.search.ICSearchConstants;
import org.eclipse.cdt.core.search.ICSearchPattern;
import org.eclipse.cdt.core.search.ICSearchScope;
import org.eclipse.cdt.core.search.OrPattern;
import org.eclipse.cdt.internal.core.CharOperation;
import org.eclipse.cdt.internal.core.index.IEntryResult;
import org.eclipse.cdt.internal.core.index.IIndex;
import org.eclipse.cdt.internal.core.index.impl.BlocksIndexInput;
import org.eclipse.cdt.internal.core.index.impl.IndexInput;
import org.eclipse.cdt.internal.core.search.IIndexSearchRequestor;
import org.eclipse.cdt.internal.core.search.indexing.IIndexConstants;
import org.eclipse.cdt.internal.core.search.matching.ClassDeclarationPattern;
import org.eclipse.cdt.internal.core.search.matching.DerivedTypesPattern;
import org.eclipse.cdt.internal.core.search.matching.FieldDeclarationPattern;
import org.eclipse.cdt.internal.core.search.matching.FriendPattern;
import org.eclipse.cdt.internal.core.search.matching.IncludePattern;
import org.eclipse.cdt.internal.core.search.matching.MacroDeclarationPattern;
import org.eclipse.cdt.internal.core.search.matching.MethodDeclarationPattern;
import org.eclipse.cdt.internal.core.search.matching.NamespaceDeclarationPattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;

public abstract class CSearchPattern
implements ICSearchConstants,
ICSearchPattern,
IIndexConstants {
    public static final int IMPOSSIBLE_MATCH = 0;
    public static final int POSSIBLE_MATCH = 1;
    public static final int ACCURATE_MATCH = 2;
    public static final int INACCURATE_MATCH = 3;
    private static final IParserLogService nullLog = new NullLogService();
    protected int _matchMode;
    protected boolean _caseSensitive;
    protected ICSearchConstants.LimitTo _limitTo;

    public CSearchPattern(int matchMode, boolean caseSensitive, ICSearchConstants.LimitTo limitTo) {
        this._matchMode = matchMode;
        this._caseSensitive = caseSensitive;
        this._limitTo = limitTo;
    }

    public CSearchPattern() {
    }

    public ICSearchConstants.LimitTo getLimitTo() {
        return this._limitTo;
    }

    public boolean canAccept(ICSearchConstants.LimitTo limit) {
        return limit == this.getLimitTo();
    }

    public static CSearchPattern createPattern(String patternString, ICSearchConstants.SearchFor searchFor, ICSearchConstants.LimitTo limitTo, int matchMode, boolean caseSensitive) {
        if (patternString == null || patternString.length() == 0) {
            return null;
        }
        CSearchPattern pattern = null;
        if (searchFor == ICSearchConstants.TYPE || searchFor == ICSearchConstants.CLASS || searchFor == ICSearchConstants.STRUCT || searchFor == ICSearchConstants.FWD_CLASS || searchFor == ICSearchConstants.FWD_STRUCT || searchFor == ICSearchConstants.FWD_UNION || searchFor == ICSearchConstants.ENUM || searchFor == ICSearchConstants.UNION || searchFor == ICSearchConstants.CLASS_STRUCT || searchFor == ICSearchConstants.TYPEDEF) {
            pattern = CSearchPattern.createClassPattern(patternString, searchFor, limitTo, matchMode, caseSensitive);
        } else if (searchFor == ICSearchConstants.DERIVED) {
            pattern = CSearchPattern.createDerivedPattern(patternString, searchFor, limitTo, matchMode, caseSensitive);
        } else if (searchFor == ICSearchConstants.FRIEND) {
            pattern = CSearchPattern.createFriendPattern(patternString, searchFor, limitTo, matchMode, caseSensitive);
        } else if (searchFor == ICSearchConstants.METHOD || searchFor == ICSearchConstants.FUNCTION) {
            pattern = CSearchPattern.createMethodPattern(patternString, searchFor, limitTo, matchMode, caseSensitive);
        } else if (searchFor == ICSearchConstants.FIELD || searchFor == ICSearchConstants.VAR || searchFor == ICSearchConstants.ENUMTOR) {
            pattern = CSearchPattern.createFieldPattern(patternString, searchFor, limitTo, matchMode, caseSensitive);
        } else if (searchFor == ICSearchConstants.NAMESPACE) {
            pattern = CSearchPattern.createNamespacePattern(patternString, limitTo, matchMode, caseSensitive);
        } else if (searchFor == ICSearchConstants.MACRO) {
            pattern = CSearchPattern.createMacroPattern(patternString, limitTo, matchMode, caseSensitive);
        } else if (searchFor == ICSearchConstants.INCLUDE) {
            pattern = CSearchPattern.createIncludePattern(patternString, limitTo, matchMode, caseSensitive);
        }
        return pattern;
    }

    private static CSearchPattern createIncludePattern(String patternString, ICSearchConstants.LimitTo limitTo, int matchMode, boolean caseSensitive) {
        if (limitTo != ICSearchConstants.REFERENCES) {
            return null;
        }
        return new IncludePattern(patternString.toCharArray(), matchMode, limitTo, caseSensitive);
    }

    private static CSearchPattern createMacroPattern(String patternString, ICSearchConstants.LimitTo limitTo, int matchMode, boolean caseSensitive) {
        if (limitTo != ICSearchConstants.DECLARATIONS && limitTo != ICSearchConstants.ALL_OCCURRENCES) {
            return null;
        }
        return new MacroDeclarationPattern(patternString.toCharArray(), matchMode, ICSearchConstants.DECLARATIONS, caseSensitive);
    }

    private static CSearchPattern createNamespacePattern(String patternString, ICSearchConstants.LimitTo limitTo, int matchMode, boolean caseSensitive) {
        if (limitTo == ICSearchConstants.ALL_OCCURRENCES) {
            OrPattern orPattern = new OrPattern();
            orPattern.addPattern(CSearchPattern.createNamespacePattern(patternString, ICSearchConstants.DECLARATIONS, matchMode, caseSensitive));
            orPattern.addPattern(CSearchPattern.createNamespacePattern(patternString, ICSearchConstants.DEFINITIONS, matchMode, caseSensitive));
            orPattern.addPattern(CSearchPattern.createNamespacePattern(patternString, ICSearchConstants.REFERENCES, matchMode, caseSensitive));
            return orPattern;
        }
        char[] patternArray = patternString.toCharArray();
        IScanner scanner = null;
        Requestor callback = new Requestor(ParserMode.COMPLETE_PARSE);
        try {
            scanner = ParserFactory.createScanner((CodeReader)new CodeReader(patternArray), (IScannerInfo)new ScannerInfo(), (ParserMode)ParserMode.QUICK_PARSE, (ParserLanguage)ParserLanguage.CPP, (ISourceElementRequestor)callback, (IParserLogService)nullLog, null);
        }
        catch (ParserFactoryError parserFactoryError) {}
        LinkedList list = CSearchPattern.scanForNames(scanner, callback, null, patternArray);
        char[] name = (char[])list.removeLast();
        char[][] qualifications = new char[][]{};
        return new NamespaceDeclarationPattern(name, (char[][])list.toArray((T[])qualifications), matchMode, limitTo, caseSensitive);
    }

    private static CSearchPattern createFieldPattern(String patternString, ICSearchConstants.SearchFor searchFor, ICSearchConstants.LimitTo limitTo, int matchMode, boolean caseSensitive) {
        if (limitTo == ICSearchConstants.ALL_OCCURRENCES) {
            OrPattern orPattern = new OrPattern();
            orPattern.addPattern(CSearchPattern.createFieldPattern(patternString, searchFor, ICSearchConstants.DECLARATIONS, matchMode, caseSensitive));
            orPattern.addPattern(CSearchPattern.createFieldPattern(patternString, searchFor, ICSearchConstants.REFERENCES, matchMode, caseSensitive));
            orPattern.addPattern(CSearchPattern.createFieldPattern(patternString, searchFor, ICSearchConstants.DEFINITIONS, matchMode, caseSensitive));
            return orPattern;
        }
        char[] patternArray = patternString.toCharArray();
        Requestor callback = new Requestor(ParserMode.COMPLETE_PARSE);
        IScanner scanner = null;
        try {
            scanner = ParserFactory.createScanner((CodeReader)new CodeReader(patternArray), (IScannerInfo)new ScannerInfo(), (ParserMode)ParserMode.QUICK_PARSE, (ParserLanguage)ParserLanguage.CPP, (ISourceElementRequestor)callback, (IParserLogService)nullLog, null);
        }
        catch (ParserFactoryError parserFactoryError) {}
        LinkedList list = CSearchPattern.scanForNames(scanner, callback, null, patternArray);
        char[] name = (char[])list.removeLast();
        char[][] qualifications = new char[][]{};
        return new FieldDeclarationPattern(name, (char[][])list.toArray((T[])qualifications), matchMode, searchFor, limitTo, caseSensitive);
    }

    private static CSearchPattern createMethodPattern(String patternString, ICSearchConstants.SearchFor searchFor, ICSearchConstants.LimitTo limitTo, int matchMode, boolean caseSensitive) {
        if (limitTo == ICSearchConstants.ALL_OCCURRENCES) {
            OrPattern orPattern = new OrPattern();
            orPattern.addPattern(CSearchPattern.createMethodPattern(patternString, searchFor, ICSearchConstants.DECLARATIONS, matchMode, caseSensitive));
            orPattern.addPattern(CSearchPattern.createMethodPattern(patternString, searchFor, ICSearchConstants.REFERENCES, matchMode, caseSensitive));
            orPattern.addPattern(CSearchPattern.createMethodPattern(patternString, searchFor, ICSearchConstants.DEFINITIONS, matchMode, caseSensitive));
            return orPattern;
        }
        int index = patternString.indexOf(40);
        String paramString = index == -1 ? "" : patternString.substring(index);
        String nameString = index == -1 ? patternString : patternString.substring(0, index);
        char[] nameArray = nameString.toCharArray();
        IScanner scanner = null;
        Requestor callback = new Requestor(ParserMode.COMPLETE_PARSE);
        try {
            scanner = ParserFactory.createScanner((CodeReader)new CodeReader(nameArray), (IScannerInfo)new ScannerInfo(), (ParserMode)ParserMode.QUICK_PARSE, (ParserLanguage)ParserLanguage.CPP, (ISourceElementRequestor)callback, (IParserLogService)nullLog, null);
        }
        catch (ParserFactoryError parserFactoryError) {}
        LinkedList names = CSearchPattern.scanForNames(scanner, callback, null, nameArray);
        LinkedList params = CSearchPattern.scanForParameters(paramString);
        char[] name = (char[])names.removeLast();
        char[][] qualifications = new char[][]{};
        qualifications = (char[][])names.toArray((T[])qualifications);
        char[][] parameters = new char[][]{};
        parameters = (char[][])params.toArray((T[])parameters);
        return new MethodDeclarationPattern(name, qualifications, parameters, matchMode, searchFor, limitTo, caseSensitive);
    }

    private static CSearchPattern createClassPattern(String patternString, ICSearchConstants.SearchFor searchFor, ICSearchConstants.LimitTo limitTo, int matchMode, boolean caseSensitive) {
        if (limitTo == ICSearchConstants.ALL_OCCURRENCES) {
            OrPattern orPattern = new OrPattern();
            orPattern.addPattern(CSearchPattern.createClassPattern(patternString, searchFor, ICSearchConstants.DECLARATIONS, matchMode, caseSensitive));
            orPattern.addPattern(CSearchPattern.createClassPattern(patternString, searchFor, ICSearchConstants.REFERENCES, matchMode, caseSensitive));
            return orPattern;
        }
        if (searchFor == ICSearchConstants.CLASS_STRUCT) {
            OrPattern orPattern = new OrPattern();
            orPattern.addPattern(CSearchPattern.createClassPattern(patternString, ICSearchConstants.CLASS, limitTo, matchMode, caseSensitive));
            orPattern.addPattern(CSearchPattern.createClassPattern(patternString, ICSearchConstants.STRUCT, limitTo, matchMode, caseSensitive));
            return orPattern;
        }
        boolean isForward = false;
        if (searchFor == ICSearchConstants.FWD_CLASS || searchFor == ICSearchConstants.FWD_STRUCT || searchFor == ICSearchConstants.FWD_UNION) {
            isForward = true;
        }
        char[] patternArray = patternString.toCharArray();
        IScanner scanner = null;
        Requestor callback = new Requestor(ParserMode.COMPLETE_PARSE);
        try {
            scanner = ParserFactory.createScanner((CodeReader)new CodeReader(patternArray), (IScannerInfo)new ScannerInfo(), (ParserMode)ParserMode.QUICK_PARSE, (ParserLanguage)ParserLanguage.CPP, (ISourceElementRequestor)callback, (IParserLogService)nullLog, null);
        }
        catch (ParserFactoryError parserFactoryError) {}
        IToken token = null;
        try {
            token = scanner.nextToken();
        }
        catch (EndOfFileException endOfFileException) {
        }
        catch (ScannerException scannerException) {}
        if (token != null) {
            boolean nullifyToken = true;
            if (token.getType() == 65) {
                searchFor = ICSearchConstants.CLASS;
            } else if (token.getType() == 109) {
                searchFor = ICSearchConstants.STRUCT;
            } else if (token.getType() == 119) {
                searchFor = ICSearchConstants.UNION;
            } else if (token.getType() == 77) {
                searchFor = ICSearchConstants.ENUM;
            } else if (token.getType() == 116) {
                searchFor = ICSearchConstants.TYPEDEF;
            } else {
                nullifyToken = false;
            }
            if (nullifyToken) {
                patternArray = CharOperation.subarray(patternArray, token.getLength() + 1, -1);
                token = null;
            }
        }
        LinkedList list = CSearchPattern.scanForNames(scanner, callback, token, patternArray);
        char[] name = (char[])list.removeLast();
        char[][] qualifications = new char[][]{};
        return new ClassDeclarationPattern(name, (char[][])list.toArray((T[])qualifications), searchFor, limitTo, matchMode, caseSensitive, isForward);
    }

    private static CSearchPattern createDerivedPattern(String patternString, ICSearchConstants.SearchFor searchFor, ICSearchConstants.LimitTo limitTo, int matchMode, boolean caseSensitive) {
        char[] patternArray = patternString.toCharArray();
        IScanner scanner = null;
        Requestor callback = new Requestor(ParserMode.COMPLETE_PARSE);
        try {
            scanner = ParserFactory.createScanner((CodeReader)new CodeReader(patternArray), (IScannerInfo)new ScannerInfo(), (ParserMode)ParserMode.QUICK_PARSE, (ParserLanguage)ParserLanguage.CPP, (ISourceElementRequestor)callback, (IParserLogService)nullLog, null);
        }
        catch (ParserFactoryError parserFactoryError) {}
        searchFor = ICSearchConstants.DERIVED;
        LinkedList list = CSearchPattern.scanForNames(scanner, callback, null, patternArray);
        char[] name = (char[])list.removeLast();
        char[][] qualifications = new char[][]{};
        return new DerivedTypesPattern(name, (char[][])list.toArray((T[])qualifications), searchFor, limitTo, matchMode, caseSensitive);
    }

    private static CSearchPattern createFriendPattern(String patternString, ICSearchConstants.SearchFor searchFor, ICSearchConstants.LimitTo limitTo, int matchMode, boolean caseSensitive) {
        char[] patternArray = patternString.toCharArray();
        IScanner scanner = null;
        Requestor callback = new Requestor(ParserMode.COMPLETE_PARSE);
        try {
            scanner = ParserFactory.createScanner((CodeReader)new CodeReader(patternArray), (IScannerInfo)new ScannerInfo(), (ParserMode)ParserMode.QUICK_PARSE, (ParserLanguage)ParserLanguage.CPP, (ISourceElementRequestor)callback, (IParserLogService)nullLog, null);
        }
        catch (ParserFactoryError parserFactoryError) {}
        searchFor = ICSearchConstants.FRIEND;
        LinkedList list = CSearchPattern.scanForNames(scanner, callback, null, patternArray);
        char[] name = (char[])list.removeLast();
        char[][] qualifications = new char[][]{};
        return new FriendPattern(name, (char[][])list.toArray((T[])qualifications), searchFor, limitTo, matchMode, caseSensitive);
    }

    private static LinkedList scanForParameters(String paramString) {
        LinkedList<char[]> list = new LinkedList<char[]>();
        if (paramString == null || paramString.equals("")) {
            return list;
        }
        String functionString = "void f " + paramString + ";";
        IScanner scanner = null;
        IQuickParseCallback callback = ParserFactory.createQuickParseCallback();
        try {
            scanner = ParserFactory.createScanner((CodeReader)new CodeReader(functionString.toCharArray()), (IScannerInfo)new ScannerInfo(), (ParserMode)ParserMode.QUICK_PARSE, (ParserLanguage)ParserLanguage.CPP, (ISourceElementRequestor)callback, (IParserLogService)new NullLogService(), null);
        }
        catch (ParserFactoryError parserFactoryError) {}
        IParser parser = null;
        try {
            parser = ParserFactory.createParser(scanner, (ISourceElementRequestor)callback, (ParserMode)ParserMode.QUICK_PARSE, (ParserLanguage)ParserLanguage.CPP, (IParserLogService)ParserUtil.getParserLogService());
        }
        catch (ParserFactoryError parserFactoryError) {}
        if (parser.parse()) {
            IASTCompilationUnit compUnit = callback.getCompilationUnit();
            Iterator declarations = null;
            try {
                declarations = compUnit.getDeclarations();
            }
            catch (ASTNotImplementedException aSTNotImplementedException) {}
            if (declarations == null || !declarations.hasNext()) {
                return null;
            }
            IASTDeclaration decl = (IASTDeclaration)declarations.next();
            if (!(decl instanceof IASTFunction)) {
                return list;
            }
            IASTFunction function = (IASTFunction)decl;
            String[] paramTypes = ASTUtil.getFunctionParameterTypes((IASTFunction)function);
            if (paramTypes.length == 0) {
                list.add("void".toCharArray());
            } else {
                int i = 0;
                while (i < paramTypes.length) {
                    list.add(paramTypes[i].toCharArray());
                    ++i;
                }
            }
        }
        return list;
    }

    private static LinkedList scanForNames(IScanner scanner, Requestor callback, IToken unusedToken, char[] pattern) {
        LinkedList<char[]> list = new LinkedList<char[]>();
        String name = new String("");
        int idx = 0;
        try {
            IToken token = unusedToken != null ? unusedToken : scanner.nextToken();
            IToken prev = null;
            boolean encounteredWild = false;
            boolean lastTokenWasOperator = false;
            block7: while (true) {
                switch (token.getType()) {
                    case 3: {
                        list.addLast(name.toCharArray());
                        name = new String("");
                        lastTokenWasOperator = false;
                        idx += token.getLength();
                        while (idx < pattern.length && CharOperation.isWhitespace(pattern[idx])) {
                            ++idx;
                        }
                        break;
                    }
                    case 95: {
                        name = String.valueOf(name) + token.getImage();
                        name = String.valueOf(name) + ' ';
                        lastTokenWasOperator = true;
                        idx += token.getLength();
                        while (idx < pattern.length && CharOperation.isWhitespace(pattern[idx])) {
                            ++idx;
                        }
                        break;
                    }
                    default: {
                        if (token.getType() == 23 || token.getType() == 7) {
                            if (idx > 0 && idx < pattern.length && CharOperation.isWhitespace(pattern[idx - 1]) && !lastTokenWasOperator) {
                                name = String.valueOf(name) + ' ';
                            }
                            encounteredWild = true;
                        } else if (!encounteredWild && !lastTokenWasOperator && name.length() > 0 && prev.getType() != 1 && prev.getType() != 42 && prev.getType() != 34 && prev.getType() != 20 && prev.getType() != 10 && token.getType() != 11 && token.getType() != 46) {
                            name = String.valueOf(name) + ' ';
                        } else {
                            encounteredWild = false;
                        }
                        name = String.valueOf(name) + token.getImage();
                        if (encounteredWild && idx < pattern.length - 1 && CharOperation.isWhitespace(pattern[idx + 1])) {
                            name = String.valueOf(name) + ' ';
                        }
                        idx += token.getLength();
                        while (idx < pattern.length && CharOperation.isWhitespace(pattern[idx])) {
                            ++idx;
                        }
                        lastTokenWasOperator = false;
                    }
                }
                prev = token;
                token = null;
                while (true) {
                    if (token != null) continue block7;
                    token = scanner.nextToken();
                    if (callback.badCharacterOffset == -1 || token.getOffset() <= callback.badCharacterOffset) continue;
                    if (!encounteredWild && !lastTokenWasOperator && prev.getType() != 20) {
                        name = String.valueOf(name) + " ";
                    }
                    name = String.valueOf(name) + "\\";
                    ++idx;
                    encounteredWild = true;
                    lastTokenWasOperator = false;
                    prev = null;
                    callback.badCharacterOffset = -1;
                }
                break;
            }
        }
        catch (EndOfFileException endOfFileException) {
            list.addLast(name.toCharArray());
        }
        catch (ScannerException scannerException) {}
        return list;
    }

    protected boolean matchesName(char[] pattern, char[] name) {
        if (pattern == null) {
            return true;
        }
        if (name != null) {
            switch (this._matchMode) {
                case 0: {
                    return CharOperation.equals(pattern, name, this._caseSensitive);
                }
                case 1: {
                    return CharOperation.prefixEquals(pattern, name, this._caseSensitive);
                }
                case 2: {
                    if (!this._caseSensitive) {
                        pattern = CharOperation.toLowerCase(pattern);
                    }
                    return CharOperation.match(pattern, name, this._caseSensitive);
                }
            }
        }
        return false;
    }

    protected boolean matchQualifications(char[][] qualifications, char[][] candidate) {
        return this.matchQualifications(qualifications, candidate, false);
    }

    protected boolean matchQualifications(char[][] qualifications, char[][] candidate, boolean skipLastName) {
        int root;
        int candidateLength;
        int qualLength;
        int n = qualLength = qualifications != null ? qualifications.length : 0;
        int n2 = candidate != null ? candidate.length - (skipLastName ? 1 : 0) : (candidateLength = 0);
        if (qualLength == 0) {
            return true;
        }
        int n3 = root = qualifications[0].length == 0 ? 1 : 0;
        if (root == 1 && candidateLength != qualLength - 1 || root == 0 && candidateLength < qualLength) {
            return false;
        }
        int i = 1;
        while (i <= qualLength - root) {
            if (!this.matchesName(qualifications[qualLength - i], candidate[candidateLength - i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void findIndexMatches(IIndex index, IIndexSearchRequestor requestor, int detailLevel, IProgressMonitor progressMonitor, ICSearchScope scope) throws IOException {
        if (progressMonitor != null && progressMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        BlocksIndexInput input = new BlocksIndexInput(index.getIndexFile());
        try {
            ((IndexInput)input).open();
            this.findIndexMatches(input, requestor, detailLevel, progressMonitor, scope);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            ((IndexInput)input).close();
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        ((IndexInput)input).close();
    }

    public void findIndexMatches(IndexInput input, IIndexSearchRequestor requestor, int detailLevel, IProgressMonitor progressMonitor, ICSearchScope scope) throws IOException {
        if (progressMonitor != null && progressMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        char[] prefix = this.indexEntryPrefix();
        if (prefix == null) {
            return;
        }
        IEntryResult[] entries = input.queryEntriesPrefixedBy(prefix);
        if (entries == null) {
            return;
        }
        int i = 0;
        int max = entries.length;
        while (i < max) {
            if (progressMonitor != null && progressMonitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            IEntryResult entry = entries[i];
            this.resetIndexInfo();
            this.decodeIndexEntry(entry);
            if (this.matchIndexEntry()) {
                this.feedIndexRequestor(requestor, detailLevel, entry.getFileReferences(), input, scope);
            }
            ++i;
        }
    }

    public abstract void feedIndexRequestor(IIndexSearchRequestor var1, int var2, int[] var3, IndexInput var4, ICSearchScope var5) throws IOException;

    protected abstract void resetIndexInfo();

    protected abstract void decodeIndexEntry(IEntryResult var1);

    public abstract char[] indexEntryPrefix();

    protected abstract boolean matchIndexEntry();

    protected static class Requestor
    extends NullSourceElementRequestor {
        public int badCharacterOffset = -1;

        public Requestor(ParserMode mode) {
            super(mode);
        }

        public boolean acceptProblem(IProblem problem) {
            if (problem.getID() == 0x1000001) {
                this.badCharacterOffset = problem.getSourceStart();
                return false;
            }
            return super.acceptProblem(problem);
        }
    }
}

