/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.core.scannerconfig;

import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IPathEntryContainer;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.make.core.scannerconfig.IDiscoveredPathManager;
import org.eclipse.cdt.make.core.scannerconfig.ScannerConfigUtil;
import org.eclipse.cdt.make.internal.core.MakeMessages;
import org.eclipse.cdt.make.internal.core.scannerconfig.DiscoveredPathContainer;
import org.eclipse.cdt.make.internal.core.scannerconfig.DiscoveredPathInfo;
import org.eclipse.cdt.make.internal.core.scannerconfig.util.SymbolEntry;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class DiscoveredPathManager
implements IDiscoveredPathManager,
IResourceChangeListener {
    private static final String CDESCRIPTOR_ID = String.valueOf(MakeCorePlugin.getUniqueIdentifier()) + ".discoveredScannerInfo";
    public static final String INCLUDE_PATH = "includePath";
    public static final String PATH = "path";
    public static final String DEFINED_SYMBOL = "definedSymbol";
    public static final String SYMBOL = "symbol";
    public static final String REMOVED = "removed";
    private Map fDiscoveredMap = new HashMap();
    private List listeners = Collections.synchronizedList(new ArrayList());
    private static final int INFO_CHANGED = 1;
    private static final int INFO_REMOVED = 2;

    public void startup() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    public void shutdown() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (event.getSource() instanceof IWorkspace) {
            IResource resource = event.getResource();
            switch (event.getType()) {
                case 2: 
                case 4: {
                    if (resource.getType() != 4) break;
                    this.fDiscoveredMap.remove(resource);
                }
            }
        }
    }

    public IDiscoveredPathManager.IDiscoveredPathInfo getDiscoveredInfo(IProject project) throws CoreException {
        DiscoveredPathInfo info = (DiscoveredPathInfo)this.fDiscoveredMap.get(project);
        if (info == null) {
            info = this.loadPathInfo(project);
            this.fDiscoveredMap.put(project, info);
        }
        return info;
    }

    private DiscoveredPathInfo loadPathInfo(IProject project) throws CoreException {
        LinkedHashMap includes = new LinkedHashMap();
        LinkedHashMap symbols = new LinkedHashMap();
        this.loadDiscoveredScannerInfoFromState(project, includes, symbols);
        DiscoveredPathInfo info = new DiscoveredPathInfo(project);
        info.setIncludeMap(includes);
        info.setSymbolMap(symbols);
        return info;
    }

    public void removeDiscoveredInfo(IProject project) {
        ScannerConfigUtil.getDiscoveredScannerConfigStore(project, true);
        DiscoveredPathInfo info = (DiscoveredPathInfo)this.fDiscoveredMap.remove(project);
        if (info != null) {
            this.fireUpdate(2, info);
        }
    }

    public void updateDiscoveredInfo(IDiscoveredPathManager.IDiscoveredPathInfo info) throws CoreException {
        if (this.fDiscoveredMap.get(info.getProject()) != null) {
            DiscoveredPathManager.saveDiscoveredScannerInfoToState((DiscoveredPathInfo)info);
            this.fireUpdate(1, info);
            ICProject cProject = CoreModel.getDefault().create(info.getProject());
            if (cProject != null) {
                CoreModel.getDefault().setPathEntryContainer(new ICProject[]{cProject}, (IPathEntryContainer)new DiscoveredPathContainer(info.getProject()), null);
            }
        }
    }

    private void loadDiscoveredScannerInfoFromState(IProject project, LinkedHashMap includes, LinkedHashMap symbols) throws CoreException {
        IPath path = ScannerConfigUtil.getDiscoveredScannerConfigStore(project, false);
        if (path.toFile().exists()) {
            try {
                FileInputStream file = new FileInputStream(path.toFile());
                DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                Document document = parser.parse(file);
                Node rootElement = document.getFirstChild();
                if (rootElement.getNodeName().equals("scannerInfo")) {
                    Node child = rootElement.getFirstChild();
                    this.loadDiscoveredScannerInfo(includes, symbols, child);
                }
            }
            catch (IOException e) {
                throw new CoreException((IStatus)new Status(4, MakeCorePlugin.getUniqueIdentifier(), -1, MakeMessages.getString("DiscoveredPathManager.File_Error_Message"), (Throwable)e));
            }
            catch (ParserConfigurationException e) {
                MakeCorePlugin.log(e);
                throw new CoreException((IStatus)new Status(4, MakeCorePlugin.getUniqueIdentifier(), -1, MakeMessages.getString("DiscoveredPathManager.File_Error_Message"), (Throwable)e));
            }
            catch (SAXException e) {
                MakeCorePlugin.log(e);
                throw new CoreException((IStatus)new Status(4, MakeCorePlugin.getUniqueIdentifier(), -1, MakeMessages.getString("DiscoveredPathManager.File_Error_Message"), (Throwable)e));
            }
        }
    }

    private void loadDiscoveredScannerInfo(LinkedHashMap includes, LinkedHashMap symbols, Node child) {
        while (child != null) {
            if (child.getNodeName().equals(INCLUDE_PATH)) {
                includes.put(((Element)child).getAttribute(PATH), Boolean.valueOf(((Element)child).getAttribute(REMOVED)));
            } else if (child.getNodeName().equals(DEFINED_SYMBOL)) {
                String symbol = ((Element)child).getAttribute(SYMBOL);
                String removed = ((Element)child).getAttribute(REMOVED);
                boolean bRemoved = removed != null && removed.equals("true");
                ScannerConfigUtil.scAddSymbolString2SymbolEntryMap(symbols, symbol, !bRemoved);
            }
            child = child.getNextSibling();
        }
    }

    private static void saveDiscoveredScannerInfo(DiscoveredPathInfo info, Element rootElement, Document doc) {
        if (info != null) {
            LinkedHashMap discoveredIncludes = info.getIncludeMap();
            Iterator iter = discoveredIncludes.keySet().iterator();
            while (iter.hasNext()) {
                Element pathElement = doc.createElement(INCLUDE_PATH);
                String include = (String)iter.next();
                pathElement.setAttribute(PATH, include);
                Boolean removed = (Boolean)discoveredIncludes.get(include);
                if (removed != null && removed.booleanValue()) {
                    pathElement.setAttribute(REMOVED, "true");
                }
                rootElement.appendChild(pathElement);
            }
            LinkedHashMap discoveredSymbols = info.getSymbolMap();
            iter = discoveredSymbols.keySet().iterator();
            while (iter.hasNext()) {
                Element symbolElement;
                String value;
                String symbol = (String)iter.next();
                SymbolEntry se = (SymbolEntry)discoveredSymbols.get(symbol);
                Iterator i = se.getActiveRaw().iterator();
                while (i.hasNext()) {
                    value = (String)i.next();
                    symbolElement = doc.createElement(DEFINED_SYMBOL);
                    symbolElement.setAttribute(SYMBOL, value);
                    rootElement.appendChild(symbolElement);
                }
                i = se.getRemovedRaw().iterator();
                while (i.hasNext()) {
                    value = (String)i.next();
                    symbolElement = doc.createElement(DEFINED_SYMBOL);
                    symbolElement.setAttribute(SYMBOL, value);
                    symbolElement.setAttribute(REMOVED, "true");
                    rootElement.appendChild(symbolElement);
                }
            }
        }
    }

    private static void saveDiscoveredScannerInfoToState(DiscoveredPathInfo info) throws CoreException {
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = builder.newDocument();
            Element rootElement = doc.createElement("scannerInfo");
            rootElement.setAttribute("id", CDESCRIPTOR_ID);
            doc.appendChild(rootElement);
            DiscoveredPathManager.saveDiscoveredScannerInfo(info, rootElement, doc);
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("indent", "yes");
            DOMSource source = new DOMSource(doc);
            StreamResult result = new StreamResult(stream);
            transformer.transform(source, result);
            try {
                IPath path = ScannerConfigUtil.getDiscoveredScannerConfigStore(info.getProject(), false);
                FileOutputStream file = new FileOutputStream(path.toFile());
                file.write(stream.toByteArray());
                file.close();
            }
            catch (IOException e) {
                throw new CoreException((IStatus)new Status(4, MakeCorePlugin.getUniqueIdentifier(), -1, MakeMessages.getString("DiscoveredPathManager.File_Error_Message"), (Throwable)e));
            }
            stream.close();
        }
        catch (TransformerException e) {
            MakeCorePlugin.log(e);
            throw new CoreException((IStatus)new Status(4, MakeCorePlugin.getUniqueIdentifier(), -1, MakeMessages.getString("DiscoveredPathManager.File_Error_Message"), (Throwable)e));
        }
        catch (IOException e) {
            MakeCorePlugin.log(e);
            throw new CoreException((IStatus)new Status(4, MakeCorePlugin.getUniqueIdentifier(), -1, MakeMessages.getString("DiscoveredPathManager.File_Error_Message"), (Throwable)e));
        }
        catch (ParserConfigurationException e) {
            MakeCorePlugin.log(e);
            throw new CoreException((IStatus)new Status(4, MakeCorePlugin.getUniqueIdentifier(), -1, MakeMessages.getString("DiscoveredPathManager.File_Error_Message"), (Throwable)e));
        }
    }

    private void fireUpdate(final int type, final IDiscoveredPathManager.IDiscoveredPathInfo info) {
        Object[] list = this.listeners.toArray();
        int i = 0;
        while (i < list.length) {
            final IDiscoveredPathManager.IDiscoveredInfoListener listener = (IDiscoveredPathManager.IDiscoveredInfoListener)list[i];
            if (listener != null) {
                Platform.run((ISafeRunnable)new ISafeRunnable(){

                    public void handleException(Throwable exception) {
                        Status status = new Status(4, "org.eclipse.cdt.core", -1, CCorePlugin.getResourceString((String)"CDescriptorManager.exception.listenerError"), exception);
                        CCorePlugin.log((IStatus)status);
                    }

                    public void run() throws Exception {
                        switch (type) {
                            case 1: {
                                listener.infoChanged(info);
                                break;
                            }
                            case 2: {
                                listener.infoRemoved(info.getProject());
                            }
                        }
                    }
                });
            }
            ++i;
        }
    }

    public void addDiscoveredInfoListener(IDiscoveredPathManager.IDiscoveredInfoListener listener) {
        this.listeners.add(listener);
    }

    public void removeDiscoveredInfoListener(IDiscoveredPathManager.IDiscoveredInfoListener listener) {
        this.listeners.remove(listener);
    }
}

