/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.actions;

import org.eclipse.cdt.debug.internal.ui.actions.ActionMessages;
import org.eclipse.cdt.debug.internal.ui.actions.ToggleBreakpointAdapter;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionDelegate;

public class ManageFunctionBreakpointActionDelegate
extends ActionDelegate
implements IObjectActionDelegate {
    private ToggleBreakpointAdapter fBreakpointAdapter = new ToggleBreakpointAdapter();
    private IWorkbenchPart fTargetPart;
    private ISelection fSelection;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.fTargetPart = targetPart;
    }

    public void run(IAction action) {
        try {
            this.getBreakpointAdapter().toggleMethodBreakpoints(this.getTargetPart(), this.getSelection());
        }
        catch (CoreException e) {
            DebugUIPlugin.errorDialog((Shell)this.getTargetPart().getSite().getShell(), (String)ActionMessages.getString("ManageFunctionBreakpointActionDelegate.Error_1"), (String)ActionMessages.getString("ManageFunctionBreakpointActionDelegate.Operation_failed_1"), (IStatus)e.getStatus());
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.setSelection(selection);
        action.setEnabled(this.getBreakpointAdapter().canToggleMethodBreakpoints(this.getTargetPart(), this.getSelection()));
    }

    private IWorkbenchPart getTargetPart() {
        return this.fTargetPart;
    }

    private ISelection getSelection() {
        return this.fSelection;
    }

    private ToggleBreakpointAdapter getBreakpointAdapter() {
        return this.fBreakpointAdapter;
    }

    private void setSelection(ISelection selection) {
        this.fSelection = selection;
    }
}

