/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.ast.complete;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.ast.IASTScope;
import org.eclipse.cdt.core.parser.ast.IASTUsingDeclaration;
import org.eclipse.cdt.core.parser.ast.IReferenceManager;
import org.eclipse.cdt.internal.core.parser.ast.SymbolIterator;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTNode;

public class ASTUsingDeclaration
extends ASTNode
implements IASTUsingDeclaration {
    private final IASTScope ownerScope;
    private final boolean isTypeName;
    private final List declarations = new ArrayList();
    private List references;
    private char[] name;
    private final char[] fn;
    private int startingLineNumber;
    private int startingOffset;
    private int endingLineNumber;
    private int endingOffset;

    public char[] getFilename() {
        return this.fn;
    }

    public ASTUsingDeclaration(IASTScope ownerScope, char[] name, List declarations, boolean isTypeName, int startingOffset, int startingLine, int endingOffset, int endingLine, List references, char[] filename) {
        this.ownerScope = ownerScope;
        this.isTypeName = isTypeName;
        this.name = name;
        this.declarations.addAll(declarations);
        this.setStartingOffsetAndLineNumber(startingOffset, startingLine);
        this.setEndingOffsetAndLineNumber(endingOffset, endingLine);
        this.references = references;
        this.fn = filename;
    }

    public boolean isTypename() {
        return this.isTypeName;
    }

    public String usingTypeName() {
        return String.valueOf(this.name);
    }

    public char[] usingTypeNameCharArray() {
        return this.name;
    }

    public IASTScope getOwnerScope() {
        return this.ownerScope;
    }

    public void acceptElement(ISourceElementRequestor requestor, IReferenceManager manager) {
        try {
            requestor.acceptUsingDeclaration(this);
        }
        catch (Exception exception) {}
        manager.processReferences(this.references, requestor);
        this.references = null;
    }

    public void enterScope(ISourceElementRequestor requestor, IReferenceManager manager) {
    }

    public void exitScope(ISourceElementRequestor requestor, IReferenceManager manager) {
    }

    public Iterator getUsingTypes() {
        return new SymbolIterator(this.declarations.iterator());
    }

    public final int getStartingLine() {
        return this.startingLineNumber;
    }

    public final int getEndingLine() {
        return this.endingLineNumber;
    }

    public final void setStartingOffsetAndLineNumber(int offset, int lineNumber) {
        this.startingOffset = offset;
        this.startingLineNumber = lineNumber;
    }

    public final void setEndingOffsetAndLineNumber(int offset, int lineNumber) {
        this.endingOffset = offset;
        this.endingLineNumber = lineNumber;
    }

    public final int getStartingOffset() {
        return this.startingOffset;
    }

    public final int getEndingOffset() {
        return this.endingOffset;
    }
}

