/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.scanner;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.cdt.core.parser.BacktrackException;
import org.eclipse.cdt.core.parser.CodeReader;
import org.eclipse.cdt.core.parser.EndOfFileException;
import org.eclipse.cdt.core.parser.IMacroDescriptor;
import org.eclipse.cdt.core.parser.IParserLogService;
import org.eclipse.cdt.core.parser.IProblem;
import org.eclipse.cdt.core.parser.IScanner;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.ISourceElementCallbackDelegate;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.IToken;
import org.eclipse.cdt.core.parser.KeywordSetKey;
import org.eclipse.cdt.core.parser.NullLogService;
import org.eclipse.cdt.core.parser.NullSourceElementRequestor;
import org.eclipse.cdt.core.parser.OffsetLimitReachedException;
import org.eclipse.cdt.core.parser.ParserFactory;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.core.parser.ParserMode;
import org.eclipse.cdt.core.parser.ScannerException;
import org.eclipse.cdt.core.parser.ScannerInfo;
import org.eclipse.cdt.core.parser.ast.ASTExpressionEvaluationException;
import org.eclipse.cdt.core.parser.ast.IASTCompletionNode;
import org.eclipse.cdt.core.parser.ast.IASTExpression;
import org.eclipse.cdt.core.parser.ast.IASTFactory;
import org.eclipse.cdt.core.parser.ast.IASTInclusion;
import org.eclipse.cdt.core.parser.extension.IScannerExtension;
import org.eclipse.cdt.internal.core.parser.IExpressionParser;
import org.eclipse.cdt.internal.core.parser.InternalParserUtil;
import org.eclipse.cdt.internal.core.parser.ast.ASTCompletionNode;
import org.eclipse.cdt.internal.core.parser.ast.EmptyIterator;
import org.eclipse.cdt.internal.core.parser.problem.IProblemFactory;
import org.eclipse.cdt.internal.core.parser.scanner.BranchTracker;
import org.eclipse.cdt.internal.core.parser.scanner.ContextException;
import org.eclipse.cdt.internal.core.parser.scanner.ContextStack;
import org.eclipse.cdt.internal.core.parser.scanner.DynamicMacroDescriptor;
import org.eclipse.cdt.internal.core.parser.scanner.DynamicMacroEvaluator;
import org.eclipse.cdt.internal.core.parser.scanner.FunctionMacroDescriptor;
import org.eclipse.cdt.internal.core.parser.scanner.IScannerContext;
import org.eclipse.cdt.internal.core.parser.scanner.IScannerData;
import org.eclipse.cdt.internal.core.parser.scanner.LimitedScannerContext;
import org.eclipse.cdt.internal.core.parser.scanner.ObjectMacroDescriptor;
import org.eclipse.cdt.internal.core.parser.scanner.ScannerContextInclusion;
import org.eclipse.cdt.internal.core.parser.scanner.ScannerContextTop;
import org.eclipse.cdt.internal.core.parser.scanner.ScannerContextTopString;
import org.eclipse.cdt.internal.core.parser.scanner.ScannerProblemFactory;
import org.eclipse.cdt.internal.core.parser.scanner.ScannerStringBuffer;
import org.eclipse.cdt.internal.core.parser.scanner.ScannerUtility;
import org.eclipse.cdt.internal.core.parser.token.KeywordSets;
import org.eclipse.cdt.internal.core.parser.token.SimpleToken;
import org.eclipse.cdt.internal.core.parser.token.TokenFactory;
import org.eclipse.cdt.internal.core.parser.util.TraceUtil;

public final class Scanner
implements IScanner,
IScannerData {
    protected static final EndOfFileException EOF = new EndOfFileException();
    private ScannerStringBuffer strbuff = new ScannerStringBuffer(100);
    protected static final String HEX_PREFIX = "0x";
    private static final ObjectMacroDescriptor CPLUSPLUS_MACRO = new ObjectMacroDescriptor("__cplusplus", "199711L");
    private static final ObjectMacroDescriptor STDC_VERSION_MACRO = new ObjectMacroDescriptor("__STDC_VERSION__", "199001L");
    protected static final ObjectMacroDescriptor STDC_HOSTED_MACRO = new ObjectMacroDescriptor("__STDC_HOSTED__", "0");
    protected static final ObjectMacroDescriptor STDC_MACRO = new ObjectMacroDescriptor("__STDC__", "1");
    private static final NullSourceElementRequestor NULL_REQUESTOR = new NullSourceElementRequestor();
    private static final String SCRATCH = "<scratch>";
    private final List workingCopies;
    protected final ContextStack contextStack;
    private IASTFactory astFactory = null;
    private ISourceElementRequestor requestor;
    private ParserMode parserMode;
    private final CodeReader reader;
    private final ParserLanguage language;
    protected IParserLogService log;
    private final IProblemFactory problemFactory = new ScannerProblemFactory();
    private Map definitions = new Hashtable();
    private BranchTracker branches = new BranchTracker();
    private final IScannerInfo originalConfig;
    private List includePathNames = new ArrayList();
    private final Map privateDefinitions = new Hashtable();
    private boolean initialContextInitialized = false;
    protected IToken finalToken;
    private final IScannerExtension scannerExtension;
    private static final int NO_OFFSET_LIMIT = -1;
    private int offsetLimit = -1;
    private boolean limitReached = false;
    private IScannerContext currentContext;
    private final Map fileCache = new HashMap(100);
    private static final int NOCHAR = -1;
    private static final String TEXT = "<text>";
    private static final String EXPRESSION = "<expression>";
    private static final String PASTING = "<pasting>";
    private static final String DEFINED = "defined";
    private static final String POUND_DEFINE = "#define ";
    private IScannerContext lastContext = null;
    private StringBuffer storageBuffer = null;
    private int count = 0;
    private static HashMap cppKeywords = new HashMap();
    private static HashMap cKeywords = new HashMap();
    private static HashMap ppDirectives = new HashMap();
    private IToken currentToken = null;
    private IToken cachedToken = null;
    private boolean passOnToClient = true;
    private boolean throwExceptionOnBadCharacterRead = false;
    private boolean tokenizingMacroReplacementList = false;
    protected static final String EMPTY_STRING = "";
    protected static final char[] EMPTY_STRING_CHAR_ARRAY = "".toCharArray();
    private Map tempMap = new HashMap();
    protected static endOfMacroTokenException endOfMacroToken = new endOfMacroTokenException();
    private static final ScannerUtility.InclusionParseException INCLUSION_PARSE_EXCEPTION;
    protected Map definitionsBackupMap = null;
    protected boolean forInclusion = false;
    private static final IParserLogService NULL_LOG_SERVICE;
    private static final String[] STRING_ARRAY;
    private static final IToken[] EMPTY_TOKEN_ARRAY;
    private static final int START_BUFFER_SIZE = 8;
    private IToken[] tokenArrayBuffer = new IToken[8];
    public boolean disableMacroExpansion = false;

    static {
        cppKeywords.put("and", new Integer(54));
        cppKeywords.put("and_eq", new Integer(55));
        cppKeywords.put("asm", new Integer(56));
        cppKeywords.put("auto", new Integer(57));
        cppKeywords.put("bitand", new Integer(58));
        cppKeywords.put("bitor", new Integer(59));
        cppKeywords.put("bool", new Integer(60));
        cppKeywords.put("break", new Integer(61));
        cppKeywords.put("case", new Integer(62));
        cppKeywords.put("catch", new Integer(63));
        cppKeywords.put("char", new Integer(64));
        cppKeywords.put("class", new Integer(65));
        cppKeywords.put("compl", new Integer(66));
        cppKeywords.put("const", new Integer(67));
        cppKeywords.put("const_cast", new Integer(69));
        cppKeywords.put("continue", new Integer(70));
        cppKeywords.put("default", new Integer(71));
        cppKeywords.put("delete", new Integer(72));
        cppKeywords.put("do", new Integer(73));
        cppKeywords.put("double", new Integer(74));
        cppKeywords.put("dynamic_cast", new Integer(75));
        cppKeywords.put("else", new Integer(76));
        cppKeywords.put("enum", new Integer(77));
        cppKeywords.put("explicit", new Integer(78));
        cppKeywords.put("export", new Integer(79));
        cppKeywords.put("extern", new Integer(80));
        cppKeywords.put("false", new Integer(81));
        cppKeywords.put("float", new Integer(82));
        cppKeywords.put("for", new Integer(83));
        cppKeywords.put("friend", new Integer(84));
        cppKeywords.put("goto", new Integer(85));
        cppKeywords.put("if", new Integer(86));
        cppKeywords.put("inline", new Integer(87));
        cppKeywords.put("int", new Integer(88));
        cppKeywords.put("long", new Integer(89));
        cppKeywords.put("mutable", new Integer(90));
        cppKeywords.put("namespace", new Integer(91));
        cppKeywords.put("new", new Integer(92));
        cppKeywords.put("not", new Integer(93));
        cppKeywords.put("not_eq", new Integer(94));
        cppKeywords.put("operator", new Integer(95));
        cppKeywords.put("or", new Integer(96));
        cppKeywords.put("or_eq", new Integer(97));
        cppKeywords.put("private", new Integer(98));
        cppKeywords.put("protected", new Integer(99));
        cppKeywords.put("public", new Integer(100));
        cppKeywords.put("register", new Integer(101));
        cppKeywords.put("reinterpret_cast", new Integer(102));
        cppKeywords.put("return", new Integer(103));
        cppKeywords.put("short", new Integer(104));
        cppKeywords.put("signed", new Integer(108));
        cppKeywords.put("sizeof", new Integer(105));
        cppKeywords.put("static", new Integer(106));
        cppKeywords.put("static_cast", new Integer(107));
        cppKeywords.put("struct", new Integer(109));
        cppKeywords.put("switch", new Integer(110));
        cppKeywords.put("template", new Integer(111));
        cppKeywords.put("this", new Integer(112));
        cppKeywords.put("throw", new Integer(113));
        cppKeywords.put("true", new Integer(114));
        cppKeywords.put("try", new Integer(115));
        cppKeywords.put("typedef", new Integer(116));
        cppKeywords.put("typeid", new Integer(117));
        cppKeywords.put("typename", new Integer(118));
        cppKeywords.put("union", new Integer(119));
        cppKeywords.put("unsigned", new Integer(120));
        cppKeywords.put("using", new Integer(121));
        cppKeywords.put("virtual", new Integer(122));
        cppKeywords.put("void", new Integer(123));
        cppKeywords.put("volatile", new Integer(124));
        cppKeywords.put("wchar_t", new Integer(125));
        cppKeywords.put("while", new Integer(126));
        cppKeywords.put("xor", new Integer(127));
        cppKeywords.put("xor_eq", new Integer(128));
        ppDirectives.put("#define", new Integer(0));
        ppDirectives.put("#undef", new Integer(1));
        ppDirectives.put("#if", new Integer(2));
        ppDirectives.put("#ifdef", new Integer(3));
        ppDirectives.put("#ifndef", new Integer(4));
        ppDirectives.put("#else", new Integer(5));
        ppDirectives.put("#endif", new Integer(6));
        ppDirectives.put("#include", new Integer(7));
        ppDirectives.put("#line", new Integer(8));
        ppDirectives.put("#error", new Integer(9));
        ppDirectives.put("#pragma", new Integer(10));
        ppDirectives.put("#elif", new Integer(12));
        ppDirectives.put("#", new Integer(11));
        cKeywords.put("auto", new Integer(57));
        cKeywords.put("break", new Integer(61));
        cKeywords.put("case", new Integer(62));
        cKeywords.put("char", new Integer(64));
        cKeywords.put("const", new Integer(67));
        cKeywords.put("continue", new Integer(70));
        cKeywords.put("default", new Integer(71));
        cKeywords.put("delete", new Integer(72));
        cKeywords.put("do", new Integer(73));
        cKeywords.put("double", new Integer(74));
        cKeywords.put("else", new Integer(76));
        cKeywords.put("enum", new Integer(77));
        cKeywords.put("extern", new Integer(80));
        cKeywords.put("float", new Integer(82));
        cKeywords.put("for", new Integer(83));
        cKeywords.put("goto", new Integer(85));
        cKeywords.put("if", new Integer(86));
        cKeywords.put("inline", new Integer(87));
        cKeywords.put("int", new Integer(88));
        cKeywords.put("long", new Integer(89));
        cKeywords.put("register", new Integer(101));
        cKeywords.put("restrict", new Integer(137));
        cKeywords.put("return", new Integer(103));
        cKeywords.put("short", new Integer(104));
        cKeywords.put("signed", new Integer(108));
        cKeywords.put("sizeof", new Integer(105));
        cKeywords.put("static", new Integer(106));
        cKeywords.put("struct", new Integer(109));
        cKeywords.put("switch", new Integer(110));
        cKeywords.put("typedef", new Integer(116));
        cKeywords.put("union", new Integer(119));
        cKeywords.put("unsigned", new Integer(120));
        cKeywords.put("void", new Integer(123));
        cKeywords.put("volatile", new Integer(124));
        cKeywords.put("while", new Integer(126));
        cKeywords.put("_Bool", new Integer(134));
        cKeywords.put("_Complex", new Integer(135));
        cKeywords.put("_Imaginary", new Integer(136));
        INCLUSION_PARSE_EXCEPTION = new ScannerUtility.InclusionParseException();
        NULL_LOG_SERVICE = new NullLogService();
        STRING_ARRAY = new String[0];
        EMPTY_TOKEN_ARRAY = new IToken[0];
    }

    public void setScannerContext(IScannerContext context) {
        this.currentContext = context;
    }

    protected void handleProblem(int problemID, String argument, int beginningOffset, boolean warning, boolean error) throws ScannerException {
        this.handleProblem(problemID, argument, beginningOffset, warning, error, true);
    }

    protected void handleProblem(int problemID, String argument, int beginningOffset, boolean warning, boolean error, boolean extra) throws ScannerException {
        IProblem problem = this.problemFactory.createProblem(problemID, beginningOffset, this.getCurrentOffset(), this.contextStack.getCurrentLineNumber(), this.getCurrentFile().toCharArray(), argument != null ? argument.toCharArray() : EMPTY_STRING_CHAR_ARRAY, warning, error);
        TraceUtil.outputTrace(this.log, "Scanner problem encountered: ", problem);
        if (!this.requestor.acceptProblem(problem) && extra) {
            throw new ScannerException(problem);
        }
    }

    Scanner(CodeReader reader, Map definitions, List includePaths, ISourceElementRequestor requestor, ParserMode mode, ParserLanguage language, IParserLogService log, IScannerExtension extension) {
        String[] incs = includePaths.toArray(STRING_ARRAY);
        this.log = log;
        this.requestor = requestor;
        this.parserMode = mode;
        this.reader = reader;
        this.language = language;
        this.originalConfig = new ScannerInfo(definitions, incs);
        this.contextStack = new ContextStack(this, log);
        this.workingCopies = null;
        this.scannerExtension = extension;
        this.definitions = definitions;
        this.includePathNames = includePaths;
        if (reader.isFile()) {
            this.fileCache.put(reader.filename, reader);
        }
        this.setupBuiltInMacros();
    }

    public Scanner(CodeReader reader, IScannerInfo info, ISourceElementRequestor requestor, ParserMode parserMode, ParserLanguage language, IParserLogService log, IScannerExtension extension, List workingCopies) {
        this.log = log;
        this.requestor = requestor;
        this.parserMode = parserMode;
        this.reader = reader;
        this.language = language;
        this.originalConfig = info;
        this.contextStack = new ContextStack(this, log);
        this.workingCopies = workingCopies;
        this.scannerExtension = extension;
        this.astFactory = ParserFactory.createASTFactory(parserMode, language);
        if (reader.isFile()) {
            this.fileCache.put(reader.filename, reader);
        }
        TraceUtil.outputTrace(log, "Scanner constructed with the following configuration:");
        TraceUtil.outputTrace(log, "\tPreprocessor definitions from IScannerInfo: ");
        if (info.getDefinedSymbols() != null) {
            Iterator i = info.getDefinedSymbols().keySet().iterator();
            Map m = info.getDefinedSymbols();
            int numberOfSymbolsLogged = 0;
            while (i.hasNext()) {
                String symbolName = (String)i.next();
                Object value = m.get(symbolName);
                if (value instanceof String) {
                    this.addDefinition(symbolName, this.scannerExtension.initializeMacroValue(this, (String)value));
                    TraceUtil.outputTrace(log, "\t\tNAME = ", symbolName, " VALUE = ", value.toString());
                    ++numberOfSymbolsLogged;
                    continue;
                }
                if (!(value instanceof IMacroDescriptor)) continue;
                this.addDefinition(symbolName, (IMacroDescriptor)value);
            }
            if (numberOfSymbolsLogged == 0) {
                TraceUtil.outputTrace(log, "\t\tNo definitions specified.");
            }
        } else {
            TraceUtil.outputTrace(log, "\t\tNo definitions specified.");
        }
        TraceUtil.outputTrace(log, "\tInclude paths from IScannerInfo: ");
        if (info.getIncludePaths() != null) {
            this.overwriteIncludePath(info.getIncludePaths());
            int i = 0;
            while (i < info.getIncludePaths().length) {
                TraceUtil.outputTrace(log, "\t\tPATH: ", info.getIncludePaths()[i], null, null);
                ++i;
            }
        } else {
            TraceUtil.outputTrace(log, "\t\tNo include paths specified.");
        }
        this.setupBuiltInMacros();
    }

    public final ParserLanguage getLanguage() {
        return this.language;
    }

    public final Map getPrivateDefinitions() {
        return this.privateDefinitions;
    }

    public final ContextStack getContextStack() {
        return this.contextStack;
    }

    public final IParserLogService getLogService() {
        return this.log;
    }

    public final List getIncludePathNames() {
        return this.includePathNames;
    }

    public final Map getPublicDefinitions() {
        return this.definitions;
    }

    public final ParserMode getParserMode() {
        return this.parserMode;
    }

    public final ISourceElementRequestor getClientRequestor() {
        return this.requestor;
    }

    public final Iterator getWorkingCopies() {
        return this.workingCopies != null ? this.workingCopies.iterator() : EmptyIterator.EMPTY_ITERATOR;
    }

    protected void setupBuiltInMacros() {
        this.scannerExtension.setupBuiltInMacros(this);
        if (this.getDefinition("__STDC__") == null) {
            this.addDefinition("__STDC__", STDC_MACRO);
        }
        if (this.language == ParserLanguage.C) {
            if (this.getDefinition("__STDC_HOSTED__") == null) {
                this.addDefinition("__STDC_HOSTED__", STDC_HOSTED_MACRO);
            }
            if (this.getDefinition("__STDC_VERSION__") == null) {
                this.addDefinition("__STDC_VERSION__", STDC_VERSION_MACRO);
            }
        } else if (this.getDefinition("__cplusplus") == null) {
            this.addDefinition("__cplusplus", CPLUSPLUS_MACRO);
        }
        if (this.getDefinition("__FILE__") == null) {
            this.addDefinition("__FILE__", new DynamicMacroDescriptor("__FILE__", new DynamicMacroEvaluator(){

                public String execute() {
                    String fName = Scanner.this.contextStack.getMostRelevantFileContext().getContextName();
                    StringBuffer buff = new StringBuffer(fName.length() + 2);
                    buff.append('\"');
                    buff.append(fName);
                    buff.append('\"');
                    return buff.toString();
                }
            }));
        }
        if (this.getDefinition("__LINE__") == null) {
            this.addDefinition("__LINE__", new DynamicMacroDescriptor("__LINE__", new DynamicMacroEvaluator(){

                public String execute() {
                    return new Integer(Scanner.this.contextStack.getCurrentLineNumber()).toString();
                }
            }));
        }
        if (this.getDefinition("__DATE__") == null) {
            this.addDefinition("__DATE__", new DynamicMacroDescriptor("__DATE__", new DynamicMacroEvaluator(){

                public String getMonth() {
                    return "Mar";
                }

                public String execute() {
                    StringBuffer result = new StringBuffer();
                    result.append(this.getMonth());
                    result.append(" ");
                    result.append(" ");
                    result.append(5);
                    result.append(" ");
                    result.append(1);
                    return result.toString();
                }
            }));
        }
        if (this.getDefinition("__TIME__") == null) {
            this.addDefinition("__TIME__", new DynamicMacroDescriptor("__TIME__", new DynamicMacroEvaluator(){

                public String execute() {
                    StringBuffer result = new StringBuffer();
                    result.append(10);
                    result.append(':');
                    result.append(12);
                    result.append(':');
                    result.append(13);
                    return result.toString();
                }
            }));
        }
    }

    private void setupInitialContext() {
        ScannerContextInclusion context = null;
        try {
            context = this.offsetLimit == -1 ? new ScannerContextTop(this.reader) : new LimitedScannerContext(this, this.reader, this.offsetLimit, 0);
            this.contextStack.pushInitialContext(context);
        }
        catch (ContextException contextException) {
            this.handleInternalError();
        }
        this.initialContextInitialized = true;
    }

    public void addIncludePath(String includePath) {
        this.includePathNames.add(includePath);
    }

    public void overwriteIncludePath(String[] newIncludePaths) {
        if (newIncludePaths == null) {
            return;
        }
        this.includePathNames = new ArrayList(newIncludePaths.length);
        int i = 0;
        while (i < newIncludePaths.length) {
            String path = newIncludePaths[i];
            File file = new File(path);
            if (!file.exists() && path.indexOf(34) != -1) {
                StringTokenizer tokenizer = new StringTokenizer(path, "\"");
                this.strbuff.startString();
                while (tokenizer.hasMoreTokens()) {
                    this.strbuff.append(tokenizer.nextToken());
                }
                file = new File(this.strbuff.toString());
            }
            if (file.exists() && file.isDirectory()) {
                this.includePathNames.add(path);
            }
            ++i;
        }
    }

    public void addDefinition(String key, IMacroDescriptor macro) {
        this.definitions.put(key, macro);
    }

    public void addDefinition(String key, String value) {
        this.addDefinition(key, new ObjectMacroDescriptor(key, value));
    }

    public final IMacroDescriptor getDefinition(String key) {
        IMacroDescriptor descriptor = (IMacroDescriptor)this.definitions.get(key);
        if (descriptor != null) {
            return descriptor;
        }
        return (IMacroDescriptor)this.privateDefinitions.get(key);
    }

    public final String[] getIncludePaths() {
        return (String[])this.includePathNames.toArray();
    }

    protected boolean skipOverWhitespace() throws ScannerException {
        int c = this.getChar(false);
        boolean result = false;
        while (c != -1 && (c == 32 || c == 9)) {
            c = this.getChar(false);
            result = true;
        }
        if (c != -1) {
            this.ungetChar(c);
        }
        return result;
    }

    protected String getRestOfPreprocessorLine() throws ScannerException, EndOfFileException {
        block11: {
            this.skipOverWhitespace();
            int c = this.getChar(false);
            if (c == 10) {
                return EMPTY_STRING;
            }
            this.strbuff.startString();
            boolean inString = false;
            boolean inChar = false;
            while (true) {
                if (c != 10 && c != 13 && c != 92 && c != 47 && (c != 34 || c == 34 && inChar) && (c != 39 || c == 39 && inString) && c != -1) {
                    this.strbuff.append(c);
                    c = this.getChar(true);
                    continue;
                }
                if (c == 47) {
                    if (inString || inChar) {
                        this.strbuff.append(c);
                        c = this.getChar(true);
                        continue;
                    }
                    int next = this.getChar(false);
                    if (next == 47) {
                        this.skipOverSinglelineComment();
                        break block11;
                    }
                    if (next == 42) {
                        this.skipOverMultilineComment();
                        c = this.getChar(true);
                        continue;
                    }
                    this.strbuff.append(c);
                    c = next;
                    continue;
                }
                if (c == 34) {
                    inString = !inString;
                    this.strbuff.append(c);
                    c = this.getChar(true);
                    continue;
                }
                if (c == 39) {
                    inChar = !inChar;
                    this.strbuff.append(c);
                    c = this.getChar(true);
                    continue;
                }
                if (c != 92) break;
                c = this.getChar(true);
                if (c == 13) {
                    c = this.getChar(true);
                    if (c != 10) continue;
                    c = this.getChar(true);
                    continue;
                }
                if (c == 10) {
                    c = this.getChar(true);
                    continue;
                }
                this.strbuff.append(92);
                if (c != 34 && c != 39) continue;
                this.strbuff.append(c);
                c = this.getChar(true);
            }
            this.ungetChar(c);
        }
        return this.strbuff.toString();
    }

    protected void skipOverTextUntilNewline() throws ScannerException {
        while (true) {
            switch (this.getChar(false)) {
                case -1: 
                case 10: {
                    return;
                }
                case 92: {
                    this.getChar(false);
                }
            }
        }
    }

    private void setCurrentToken(IToken t) {
        if (this.currentToken != null) {
            this.currentToken.setNext(t);
        }
        this.finalToken = t;
        this.currentToken = t;
    }

    protected void resetStorageBuffer() {
        if (this.storageBuffer != null) {
            this.storageBuffer = null;
        }
    }

    protected IToken newToken(int t, String i) {
        IToken token = TokenFactory.createUniquelyImagedToken(t, i, this);
        this.setCurrentToken(token);
        return this.currentToken;
    }

    protected IToken newConstantToken(int t) {
        this.setCurrentToken(TokenFactory.createToken(t, this));
        return this.currentToken;
    }

    protected String getNextIdentifier() throws ScannerException {
        this.strbuff.startString();
        this.skipOverWhitespace();
        int c = this.getChar(false);
        if (c >= 97 && c <= 122 || (c >= 65 && c <= 90) | c == 95) {
            this.strbuff.append(c);
            c = this.getChar(false);
            while (c >= 97 && c <= 122 || c >= 65 && c <= 90 || c >= 48 && c <= 57 || c == 95) {
                this.strbuff.append(c);
                c = this.getChar(false);
            }
        }
        this.ungetChar(c);
        return this.strbuff.toString();
    }

    protected void handleInclusion(String fileName, boolean useIncludePaths, int beginOffset, int startLine, int nameOffset, int nameLine, int endOffset, int endLine) throws ScannerException {
        CodeReader duple = null;
        int i = 0;
        block4: while (i < 2) {
            if (useIncludePaths) {
                Iterator iter = this.includePathNames.iterator();
                while (iter.hasNext()) {
                    String path = (String)iter.next();
                    String finalPath = ScannerUtility.createReconciledPath(path, fileName);
                    duple = (CodeReader)this.fileCache.get(finalPath);
                    if (duple == null && (duple = ScannerUtility.createReaderDuple(finalPath, this.requestor, this.getWorkingCopies())) != null && duple.isFile()) {
                        this.fileCache.put(duple.filename, duple);
                    }
                    if (duple != null) break block4;
                }
                if (duple == null) {
                    this.handleProblem(0x2000002, fileName, beginOffset, false, true);
                }
            } else {
                String finalPath = ScannerUtility.createReconciledPath(new File(this.currentContext.getContextName()).getParentFile().getAbsolutePath(), fileName);
                duple = (CodeReader)this.fileCache.get(finalPath);
                if (duple == null && (duple = ScannerUtility.createReaderDuple(finalPath, this.requestor, this.getWorkingCopies())) != null && duple.isFile()) {
                    this.fileCache.put(duple.filename, duple);
                }
                if (duple != null) break;
                useIncludePaths = true;
            }
            ++i;
        }
        if (duple != null) {
            IASTInclusion inclusion = null;
            try {
                inclusion = this.getASTFactory().createInclusion(fileName.toCharArray(), duple.filename, !useIncludePaths, beginOffset, startLine, nameOffset, nameOffset + fileName.length(), nameLine, endOffset, endLine, this.getCurrentFilename());
            }
            catch (Exception exception) {}
            try {
                this.contextStack.updateInclusionContext(duple, inclusion, this.requestor);
            }
            catch (ContextException e1) {
                this.handleProblem(e1.getId(), fileName, beginOffset, false, true);
            }
        }
    }

    public void setTokenizingMacroReplacementList(boolean mr) {
        this.tokenizingMacroReplacementList = mr;
    }

    public final int getCharacter() throws ScannerException {
        if (!this.initialContextInitialized) {
            this.setupInitialContext();
        }
        return this.getChar(false);
    }

    final int getChar() throws ScannerException {
        return this.getChar(false);
    }

    /*
     * Unable to fully structure code
     */
    private final int getChar(boolean insideString) throws ScannerException {
        this.lastContext = this.currentContext;
        if (this.lastContext.getKind() == IScannerContext.ContextKind.SENTINEL) {
            return -1;
        }
        c = this.currentContext.getChar();
        if (c != -1) {
            return c;
        }
        if (!this.currentContext.isFinal()) ** GOTO lbl14
        return c;
lbl-1000:
        // 1 sources

        {
            c = this.currentContext.getChar();
            if (c != -1) {
                return c;
            }
            if (!this.currentContext.isFinal()) continue;
            return c;
lbl14:
            // 2 sources

            ** while (this.contextStack.rollbackContext((ISourceElementRequestor)this.requestor))
        }
lbl15:
        // 1 sources

        return -1;
    }

    final void ungetChar(int c) {
        this.currentContext.ungetChar(c);
        if (this.lastContext != this.currentContext) {
            this.contextStack.undoRollback(this.lastContext, this.requestor);
        }
    }

    protected boolean lookAheadForTokenPasting() throws ScannerException {
        int c = this.getChar(false);
        if (c == 35) {
            c = this.getChar(false);
            if (c == 35) {
                return true;
            }
            this.ungetChar(c);
        }
        this.ungetChar(c);
        return false;
    }

    protected void consumeUntilOutOfMacroExpansion() throws ScannerException {
        while (this.currentContext.getKind() == IScannerContext.ContextKind.MACROEXPANSION) {
            this.getChar(false);
        }
    }

    public IToken nextToken() throws ScannerException, EndOfFileException {
        return this.nextToken(true);
    }

    public boolean pasteIntoInputStream(String buff) throws ScannerException, EndOfFileException {
        if (this.lookAheadForTokenPasting()) {
            if (this.storageBuffer == null) {
                this.storageBuffer = new StringBuffer(buff);
            } else {
                this.storageBuffer.append(buff);
            }
            return true;
        }
        if (this.storageBuffer != null) {
            this.storageBuffer.append(buff.toString());
            try {
                this.contextStack.updateMacroContext(this.storageBuffer.toString(), PASTING, this.requestor, -1, -1);
            }
            catch (ContextException e) {
                this.handleProblem(e.getId(), this.currentContext.getContextName(), this.getCurrentOffset(), false, true);
            }
            this.storageBuffer = null;
            return true;
        }
        return false;
    }

    public int consumeNewlineAfterSlash() throws ScannerException {
        int c = this.getChar(false);
        if (c == 13) {
            c = this.getChar(false);
            if (c == 10) {
                return this.getChar(true);
            }
            return c;
        }
        if (c == 10) {
            return this.getChar(true);
        }
        this.ungetChar(c);
        return 92;
    }

    public IToken processStringLiteral(boolean wideLiteral) throws ScannerException, EndOfFileException {
        int beginOffset = this.getCurrentOffset();
        this.strbuff.startString();
        int beforePrevious = -1;
        int previous = 34;
        int c = this.getChar(true);
        while (true) {
            if (c == 92) {
                c = this.consumeNewlineAfterSlash();
            }
            if (c == 34 && (previous != 92 || beforePrevious == 92)) break;
            if (c == -1 || c == 10 && (previous != 92 || beforePrevious == 92)) {
                this.handleProblem(0x1000002, null, beginOffset, false, true);
                return null;
            }
            this.strbuff.append(c);
            beforePrevious = previous;
            previous = c;
            c = this.getChar(true);
        }
        int type = wideLiteral ? 131 : 130;
        String result = this.strbuff.toString();
        IToken returnToken = this.newToken(type, result);
        IToken next = null;
        try {
            next = this.nextToken(true);
            if (next != null && (next.getType() == 130 || next.getType() == 131)) {
                returnToken.setImage(String.valueOf(result) + next.getImage());
            } else {
                this.cachedToken = next;
            }
        }
        catch (EndOfFileException endOfFileException) {
            next = null;
        }
        this.currentToken = returnToken;
        returnToken.setNext(null);
        return returnToken;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    public IToken processNumber(int c, boolean pasting) throws ScannerException, EndOfFileException {
        block25: {
            block26: {
                block24: {
                    block23: {
                        beginOffset = this.getCurrentOffset();
                        this.strbuff.startString();
                        hex = false;
                        floatingPoint = c == 46;
                        firstCharZero = c == 48;
                        this.strbuff.append(c);
                        firstChar = c;
                        c = this.getChar(false);
                        if (!firstCharZero && floatingPoint && (c < 48 || c > 57)) {
                            if (firstChar == 46) {
                                if (c == 42) {
                                    return this.newConstantToken(49);
                                }
                                if (c != 46) {
                                    this.ungetChar(c);
                                    return this.newConstantToken(50);
                                }
                                if (this.getChar(false) == 46) {
                                    return this.newConstantToken(48);
                                }
                                this.handleProblem(0x1000004, null, beginOffset, false, true);
                            }
                        } else if (c == 120) {
                            if (!firstCharZero) {
                                this.handleProblem(0x1000005, null, beginOffset, false, true);
                                return null;
                            }
                            this.strbuff.append(c);
                            hex = true;
                            c = this.getChar(false);
                        }
                        while (c >= 48 && c <= 57 || hex && (c >= 97 && c <= 102 || c >= 65 && c <= 70)) {
                            this.strbuff.append(c);
                            c = this.getChar(false);
                        }
                        if (c == 46) {
                            this.strbuff.append(c);
                            floatingPoint = true;
                            c = this.getChar(false);
                            while (c >= 48 && c <= 57 || hex && (c >= 97 && c <= 102 || c >= 65 && c <= 70)) {
                                this.strbuff.append(c);
                                c = this.getChar(false);
                            }
                        }
                        if (c != 101 && c != 69 && (!hex || c != 112 && c != 80)) break block23;
                        if (!floatingPoint) {
                            floatingPoint = true;
                        }
                        this.strbuff.append(c);
                        c = this.getChar(false);
                        if (c != 43 && c != 45) ** GOTO lbl73
                        this.strbuff.append(c);
                        c = this.getChar(false);
                        if (true) ** GOTO lbl73
                    }
                    if (!floatingPoint) break block24;
                    if (c == 108 || c == 76 || c == 102 || c == 70) {
                        c = this.getChar(false);
                    }
                    break block25;
                }
                if (c != 117 && c != 85) break block26;
                c = this.getChar(false);
                if (c == 108 || c == 76) {
                    c = this.getChar(false);
                }
                if (c == 108 || c == 76) {
                    c = this.getChar(false);
                }
                break block25;
            }
            if (c == 108 || c == 76) {
                c = this.getChar(false);
                if (c == 108 || c == 76) {
                    c = this.getChar(false);
                }
                if (c == 117 || c == 85) {
                    c = this.getChar(false);
                }
            }
            break block25;
            do {
                this.strbuff.append(c);
                c = this.getChar(false);
lbl73:
                // 3 sources

            } while (c >= 48 && c <= 57);
            if (c == 108 || c == 76 || c == 102 || c == 70) {
                this.strbuff.append(c);
                c = this.getChar(false);
            }
        }
        this.ungetChar(c);
        result = this.strbuff.toString();
        if (pasting && this.pasteIntoInputStream(result)) {
            return null;
        }
        if (floatingPoint && result.equals(".")) {
            return this.newConstantToken(50);
        }
        v0 = tokenType = floatingPoint != false ? 129 : 2;
        if (tokenType == 2 && hex && result.equals("0x")) {
            this.handleProblem(0x1000005, "0x", beginOffset, false, true);
            return null;
        }
        return this.newToken(tokenType, result);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public IToken processPreprocessor() throws ScannerException, EndOfFileException {
        Object directive;
        int beginningOffset = this.currentContext.getOffset() - 1;
        int beginningLine = this.contextStack.getCurrentLineNumber();
        boolean skipped = this.skipOverWhitespace();
        int c = this.getChar(false);
        if (c == 35) {
            if (!skipped) return this.newConstantToken(-6);
            this.handleProblem(0x2000006, "#  #", beginningOffset, false, true);
        } else if (this.tokenizingMacroReplacementList) {
            this.ungetChar(c);
            return this.newConstantToken(-7);
        }
        this.strbuff.startString();
        this.strbuff.append(35);
        while (c >= 97 && c <= 122 || c >= 65 && c <= 90 || c == 95) {
            this.strbuff.append(c);
            c = this.getChar(false);
        }
        this.ungetChar(c);
        String token = this.strbuff.toString();
        if (this.isLimitReached()) {
            this.handleCompletionOnPreprocessorDirective(token);
        }
        if ((directive = ppDirectives.get(token)) == null) {
            if (this.scannerExtension.canHandlePreprocessorDirective(token)) {
                this.scannerExtension.handlePreprocessorDirective(this, token, this.getRestOfPreprocessorLine());
                return null;
            } else {
                if (!this.passOnToClient) return null;
                this.handleProblem(0x2000006, token, beginningOffset, false, true);
            }
            return null;
        }
        int type = (Integer)directive;
        switch (type) {
            case 0: {
                if (!this.passOnToClient) {
                    this.skipOverTextUntilNewline();
                    if (!this.isLimitReached()) return null;
                    this.handleInvalidCompletion();
                    return null;
                }
                this.poundDefine(beginningOffset, beginningLine);
                return null;
            }
            case 7: {
                if (!this.passOnToClient) {
                    this.skipOverTextUntilNewline();
                    if (!this.isLimitReached()) return null;
                    this.handleInvalidCompletion();
                    return null;
                }
                this.poundInclude(beginningOffset, beginningLine);
                return null;
            }
            case 1: {
                if (!this.passOnToClient) {
                    this.skipOverTextUntilNewline();
                    if (!this.isLimitReached()) return null;
                    this.handleInvalidCompletion();
                    return null;
                }
                this.removeSymbol(this.getNextIdentifier());
                this.skipOverTextUntilNewline();
                return null;
            }
            case 2: {
                int currentOffset = this.getCurrentOffset();
                String expression = this.getRestOfPreprocessorLine();
                if (this.isLimitReached()) {
                    this.handleCompletionOnExpression(expression);
                }
                if (expression.trim().equals(EMPTY_STRING)) {
                    this.handleProblem(0x2000006, "#if", beginningOffset, false, true);
                }
                boolean expressionEvalResult = false;
                if (this.branches.queryCurrentBranchForIf()) {
                    expressionEvalResult = this.evaluateExpression(expression, currentOffset);
                }
                this.passOnToClient = this.branches.poundIf(expressionEvalResult);
                return null;
            }
            case 3: {
                String definition = this.getNextIdentifier();
                if (this.isLimitReached()) {
                    this.handleCompletionOnDefinition(definition);
                }
                if (this.getDefinition(definition) == null) {
                    this.passOnToClient = this.branches.poundIf(false);
                    this.skipOverTextUntilNewline();
                    return null;
                } else {
                    this.passOnToClient = this.branches.poundIf(true);
                }
                return null;
            }
            case 6: {
                String restOfLine = this.getRestOfPreprocessorLine().trim();
                if (this.isLimitReached()) {
                    this.handleInvalidCompletion();
                }
                if (!restOfLine.equals(EMPTY_STRING)) {
                    this.strbuff.startString();
                    this.strbuff.append("#endif ");
                    this.strbuff.append(restOfLine);
                    this.handleProblem(0x2000006, this.strbuff.toString(), beginningOffset, false, true);
                }
                try {
                    this.passOnToClient = this.branches.poundEndif();
                    return null;
                }
                catch (EmptyStackException emptyStackException) {
                    this.handleProblem(0x2000004, token, beginningOffset, false, true);
                }
                return null;
            }
            case 4: {
                String definition2 = this.getNextIdentifier();
                if (this.isLimitReached()) {
                    this.handleCompletionOnDefinition(definition2);
                }
                if (this.getDefinition(definition2) != null) {
                    this.skipOverTextUntilNewline();
                    this.passOnToClient = this.branches.poundIf(false);
                    if (!this.isLimitReached()) return null;
                    this.handleInvalidCompletion();
                    return null;
                } else {
                    this.passOnToClient = this.branches.poundIf(true);
                }
                return null;
            }
            case 5: {
                try {
                    this.passOnToClient = this.branches.poundElse();
                }
                catch (EmptyStackException emptyStackException) {
                    this.handleProblem(0x2000004, token, beginningOffset, false, true);
                }
                this.skipOverTextUntilNewline();
                if (!this.isLimitReached()) return null;
                this.handleInvalidCompletion();
                return null;
            }
            case 12: {
                int co = this.getCurrentOffset();
                String elifExpression = this.getRestOfPreprocessorLine();
                if (this.isLimitReached()) {
                    this.handleCompletionOnExpression(elifExpression);
                }
                if (elifExpression.equals(EMPTY_STRING)) {
                    this.handleProblem(0x2000006, "#elif", beginningOffset, false, true);
                }
                boolean elsifResult = false;
                if (this.branches.queryCurrentBranchForElif()) {
                    elsifResult = this.evaluateExpression(elifExpression, co);
                }
                try {
                    this.passOnToClient = this.branches.poundElif(elsifResult);
                    return null;
                }
                catch (EmptyStackException emptyStackException) {
                    this.strbuff.startString();
                    this.strbuff.append(token);
                    this.strbuff.append(32);
                    this.strbuff.append(elifExpression);
                    this.handleProblem(0x2000004, this.strbuff.toString(), beginningOffset, false, true);
                }
                return null;
            }
            case 8: {
                this.skipOverTextUntilNewline();
                if (!this.isLimitReached()) return null;
                this.handleInvalidCompletion();
                return null;
            }
            case 9: {
                if (!this.passOnToClient) {
                    this.skipOverTextUntilNewline();
                    if (!this.isLimitReached()) return null;
                    this.handleInvalidCompletion();
                    return null;
                }
                String restOfErrorLine = this.getRestOfPreprocessorLine();
                if (this.isLimitReached()) {
                    this.handleInvalidCompletion();
                }
                this.handleProblem(0x2000001, restOfErrorLine, beginningOffset, false, true);
                return null;
            }
            case 10: {
                this.skipOverTextUntilNewline();
                if (!this.isLimitReached()) return null;
                this.handleInvalidCompletion();
                return null;
            }
            case 11: {
                String remainderOfLine = this.getRestOfPreprocessorLine().trim();
                if (remainderOfLine.equals(EMPTY_STRING)) return null;
                this.strbuff.startString();
                this.strbuff.append("# ");
                this.strbuff.append(remainderOfLine);
                this.handleProblem(0x2000006, this.strbuff.toString(), beginningOffset, false, true);
                return null;
            }
        }
        this.strbuff.startString();
        this.strbuff.append("# ");
        this.strbuff.append(token);
        this.handleProblem(0x2000006, this.strbuff.toString(), beginningOffset, false, true);
        return null;
    }

    protected boolean processUniversalCharacterName() throws ScannerException {
        int i = 0;
        while (i < 4) {
            int c = this.getChar(false);
            if (!this.isHex(c)) {
                return false;
            }
            this.strbuff.append(c);
            ++i;
        }
        Vector<Character> v = new Vector<Character>();
        int i2 = 0;
        while (i2 < 4) {
            int c = this.getChar(false);
            if (!this.isHex(c)) {
                this.ungetChar(c);
                break;
            }
            v.add(new Character((char)c));
            ++i2;
        }
        if (v.size() == 4) {
            i2 = 0;
            while (i2 < 4) {
                this.strbuff.append(((Character)v.get(i2)).charValue());
                ++i2;
            }
        } else {
            i2 = v.size() - 1;
            while (i2 >= 0) {
                this.ungetChar(((Character)v.get(i2)).charValue());
                --i2;
            }
        }
        return true;
    }

    private boolean isHex(int c) {
        switch (c) {
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: {
                return true;
            }
        }
        return false;
    }

    protected IToken processKeywordOrIdentifier(boolean pasting) throws ScannerException, EndOfFileException {
        IMacroDescriptor mapping;
        int c;
        int baseOffset;
        block9: {
            int next;
            baseOffset = this.lastContext.getOffset() - 1;
            c = this.getChar(false);
            while (true) {
                if (this.scannerExtension.offersDifferentIdentifierCharacters() && this.scannerExtension.isValidIdentifierCharacter(c) || this.isValidIdentifierCharacter(c)) {
                    this.strbuff.append(c);
                    c = this.getChar(false);
                    if (c != 92) continue;
                    c = this.consumeNewlineAfterSlash();
                    continue;
                }
                if (c != 92) break block9;
                next = this.getChar(false);
                if (next != 117 && next != 85) break;
                this.strbuff.append(92);
                this.strbuff.append(next);
                if (!this.processUniversalCharacterName()) {
                    return null;
                }
                c = this.getChar(false);
            }
            this.ungetChar(next);
        }
        this.ungetChar(c);
        String ident = this.strbuff.toString();
        if (ident.equals(DEFINED)) {
            return this.newToken(2, this.handleDefinedMacro());
        }
        if (ident.equals("_Pragma") && this.language == ParserLanguage.C) {
            this.handlePragmaOperator();
            return null;
        }
        if (!this.disableMacroExpansion && (mapping = this.getDefinition(ident)) != null && !this.isLimitReached() && !mapping.isCircular() && this.contextStack.shouldExpandDefinition(ident)) {
            this.expandDefinition(ident, mapping, baseOffset);
            return null;
        }
        if (pasting && this.pasteIntoInputStream(ident)) {
            return null;
        }
        Object tokenTypeObject = this.language == ParserLanguage.CPP ? cppKeywords.get(ident) : cKeywords.get(ident);
        if (tokenTypeObject != null) {
            return this.newConstantToken((Integer)tokenTypeObject);
        }
        if (this.scannerExtension.isExtensionKeyword(this.language, ident)) {
            return this.newExtensionToken(this.scannerExtension.createExtensionToken(this, ident));
        }
        return this.newToken(1, ident);
    }

    protected IToken newExtensionToken(IToken token) {
        this.setCurrentToken(token);
        return this.currentToken;
    }

    protected boolean isValidIdentifierCharacter(int c) {
        return c >= 97 && c <= 122 || c >= 65 && c <= 90 || c >= 48 && c <= 57 || c == 95 || Character.isUnicodeIdentifierPart((char)c);
    }

    public IToken nextToken(boolean pasting) throws ScannerException, EndOfFileException {
        if (!this.initialContextInitialized) {
            this.setupInitialContext();
        }
        if (this.cachedToken != null) {
            this.setCurrentToken(this.cachedToken);
            this.cachedToken = null;
            return this.currentToken;
        }
        ++this.count;
        int c = this.getChar(false);
        while (c != -1) {
            if (!this.passOnToClient) {
                while (c != -1 && c != 35) {
                    c = this.getChar(false);
                    if (c != 47) continue;
                    c = this.getChar(false);
                    if (c == 47) {
                        this.skipOverSinglelineComment();
                        continue;
                    }
                    if (c != 42) continue;
                    this.skipOverMultilineComment();
                }
                if (c == -1) {
                    if (!this.isLimitReached()) continue;
                    this.handleInvalidCompletion();
                    continue;
                }
            }
            block0 : switch (c) {
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    c = this.getChar(false);
                    break;
                }
                case 58: {
                    c = this.getChar(false);
                    switch (c) {
                        case 58: {
                            return this.newConstantToken(3);
                        }
                        case 62: {
                            return this.newConstantToken(11);
                        }
                    }
                    this.ungetChar(c);
                    return this.newConstantToken(4);
                }
                case 59: {
                    return this.newConstantToken(5);
                }
                case 44: {
                    return this.newConstantToken(6);
                }
                case 63: {
                    IToken token;
                    c = this.getChar(false);
                    if (c == 63) {
                        c = this.getChar(false);
                        switch (c) {
                            case 61: {
                                token = this.processPreprocessor();
                                if (token == null) {
                                    c = this.getChar(false);
                                    break block0;
                                }
                                return token;
                            }
                        }
                        this.ungetChar(c);
                        this.ungetChar(63);
                        return this.newConstantToken(7);
                    }
                    this.ungetChar(c);
                    return this.newConstantToken(7);
                }
                case 40: {
                    return this.newConstantToken(8);
                }
                case 41: {
                    return this.newConstantToken(9);
                }
                case 91: {
                    return this.newConstantToken(10);
                }
                case 93: {
                    return this.newConstantToken(11);
                }
                case 123: {
                    return this.newConstantToken(12);
                }
                case 125: {
                    return this.newConstantToken(13);
                }
                case 43: {
                    c = this.getChar(false);
                    switch (c) {
                        case 61: {
                            return this.newConstantToken(14);
                        }
                        case 43: {
                            return this.newConstantToken(15);
                        }
                    }
                    this.ungetChar(c);
                    return this.newConstantToken(16);
                }
                case 45: {
                    c = this.getChar(false);
                    switch (c) {
                        case 61: {
                            return this.newConstantToken(17);
                        }
                        case 45: {
                            return this.newConstantToken(18);
                        }
                        case 62: {
                            c = this.getChar(false);
                            switch (c) {
                                case 42: {
                                    return this.newConstantToken(19);
                                }
                            }
                            this.ungetChar(c);
                            return this.newConstantToken(20);
                        }
                    }
                    this.ungetChar(c);
                    return this.newConstantToken(21);
                }
                case 42: {
                    c = this.getChar(false);
                    switch (c) {
                        case 61: {
                            return this.newConstantToken(22);
                        }
                    }
                    this.ungetChar(c);
                    return this.newConstantToken(23);
                }
                case 37: {
                    IToken token;
                    c = this.getChar(false);
                    switch (c) {
                        case 61: {
                            return this.newConstantToken(24);
                        }
                        case 62: {
                            return this.newConstantToken(13);
                        }
                        case 58: {
                            token = this.processPreprocessor();
                            if (token == null) {
                                c = this.getChar(false);
                                break block0;
                            }
                            return token;
                        }
                    }
                    this.ungetChar(c);
                    return this.newConstantToken(25);
                }
                case 94: {
                    c = this.getChar(false);
                    switch (c) {
                        case 61: {
                            return this.newConstantToken(26);
                        }
                    }
                    this.ungetChar(c);
                    return this.newConstantToken(27);
                }
                case 38: {
                    c = this.getChar(false);
                    switch (c) {
                        case 61: {
                            return this.newConstantToken(28);
                        }
                        case 38: {
                            return this.newConstantToken(29);
                        }
                    }
                    this.ungetChar(c);
                    return this.newConstantToken(30);
                }
                case 124: {
                    c = this.getChar(false);
                    switch (c) {
                        case 61: {
                            return this.newConstantToken(31);
                        }
                        case 124: {
                            return this.newConstantToken(32);
                        }
                    }
                    this.ungetChar(c);
                    return this.newConstantToken(33);
                }
                case 126: {
                    return this.newConstantToken(34);
                }
                case 33: {
                    c = this.getChar(false);
                    switch (c) {
                        case 61: {
                            return this.newConstantToken(35);
                        }
                    }
                    this.ungetChar(c);
                    return this.newConstantToken(36);
                }
                case 61: {
                    c = this.getChar(false);
                    switch (c) {
                        case 61: {
                            return this.newConstantToken(37);
                        }
                    }
                    this.ungetChar(c);
                    return this.newConstantToken(38);
                }
                case 60: {
                    c = this.getChar(false);
                    switch (c) {
                        case 60: {
                            c = this.getChar(false);
                            switch (c) {
                                case 61: {
                                    return this.newConstantToken(47);
                                }
                            }
                            this.ungetChar(c);
                            return this.newConstantToken(40);
                        }
                        case 61: {
                            return this.newConstantToken(41);
                        }
                        case 37: {
                            return this.newConstantToken(12);
                        }
                        case 58: {
                            return this.newConstantToken(10);
                        }
                    }
                    this.strbuff.startString();
                    this.strbuff.append(60);
                    this.strbuff.append(c);
                    String query = this.strbuff.toString();
                    if (this.scannerExtension.isExtensionOperator(this.language, query)) {
                        return this.newExtensionToken(this.scannerExtension.createExtensionToken(this, query));
                    }
                    this.ungetChar(c);
                    if (this.forInclusion) {
                        this.temporarilyReplaceDefinitionsMap();
                    }
                    return this.newConstantToken(42);
                }
                case 62: {
                    c = this.getChar(false);
                    switch (c) {
                        case 62: {
                            c = this.getChar(false);
                            switch (c) {
                                case 61: {
                                    return this.newConstantToken(43);
                                }
                            }
                            this.ungetChar(c);
                            return this.newConstantToken(44);
                        }
                        case 61: {
                            return this.newConstantToken(45);
                        }
                    }
                    this.strbuff.startString();
                    this.strbuff.append(62);
                    this.strbuff.append((char)c);
                    String query = this.strbuff.toString();
                    if (this.scannerExtension.isExtensionOperator(this.language, query)) {
                        return this.newExtensionToken(this.scannerExtension.createExtensionToken(this, query));
                    }
                    this.ungetChar(c);
                    if (this.forInclusion) {
                        this.temporarilyReplaceDefinitionsMap();
                    }
                    return this.newConstantToken(46);
                }
                case 46: {
                    c = this.getChar(false);
                    switch (c) {
                        case 46: {
                            c = this.getChar(false);
                            switch (c) {
                                case 46: {
                                    return this.newConstantToken(48);
                                }
                            }
                            break block0;
                        }
                        case 42: {
                            return this.newConstantToken(49);
                        }
                        case 48: 
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: {
                            this.ungetChar(c);
                            return this.processNumber(46, pasting);
                        }
                    }
                    this.ungetChar(c);
                    return this.newConstantToken(50);
                }
                case 47: {
                    c = this.getChar(false);
                    switch (c) {
                        case 47: {
                            this.skipOverSinglelineComment();
                            c = this.getChar(false);
                            break block0;
                        }
                        case 42: {
                            this.skipOverMultilineComment();
                            c = this.getChar(false);
                            break block0;
                        }
                        case 61: {
                            return this.newConstantToken(51);
                        }
                    }
                    this.ungetChar(c);
                    return this.newConstantToken(52);
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    IToken token = this.processNumber(c, pasting);
                    if (token == null) {
                        c = this.getChar(false);
                        break;
                    }
                    return token;
                }
                case 76: {
                    IToken token;
                    c = this.getChar(false);
                    if (c == 34) {
                        token = this.processStringLiteral(true);
                    } else {
                        if (c == 39) {
                            return this.processCharacterLiteral(c, true);
                        }
                        this.ungetChar(c);
                        this.strbuff.startString();
                        this.strbuff.append(76);
                        token = this.processKeywordOrIdentifier(pasting);
                    }
                    if (token == null) {
                        c = this.getChar(false);
                        break;
                    }
                    return token;
                }
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 77: 
                case 78: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 87: 
                case 88: 
                case 89: 
                case 90: 
                case 95: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: 
                case 114: 
                case 115: 
                case 116: 
                case 117: 
                case 118: 
                case 119: 
                case 120: 
                case 121: 
                case 122: {
                    this.strbuff.startString();
                    this.strbuff.append(c);
                    IToken token = this.processKeywordOrIdentifier(pasting);
                    if (token == null) {
                        c = this.getChar(false);
                        break;
                    }
                    return token;
                }
                case 34: {
                    IToken token = this.processStringLiteral(false);
                    if (token == null) {
                        c = this.getChar(false);
                        break;
                    }
                    return token;
                }
                case 39: {
                    return this.processCharacterLiteral(c, false);
                }
                case 35: {
                    IToken token = this.processPreprocessor();
                    if (token == null) {
                        c = this.getChar(false);
                        break;
                    }
                    return token;
                }
                default: {
                    IToken token;
                    if (this.scannerExtension.offersDifferentIdentifierCharacters() && this.scannerExtension.isValidIdentifierStartCharacter(c) || this.isValidIdentifierStartCharacter(c)) {
                        this.strbuff.startString();
                        this.strbuff.append(c);
                        token = this.processKeywordOrIdentifier(pasting);
                        if (token == null) {
                            c = this.getChar(false);
                            break;
                        }
                        return token;
                    }
                    if (c == 92) {
                        int next = this.getChar(false);
                        this.strbuff.startString();
                        this.strbuff.append(92);
                        this.strbuff.append(next);
                        if (next == 117 || next == 85) {
                            if (!this.processUniversalCharacterName()) {
                                this.handleProblem(0x1000001, this.strbuff.toString(), this.getCurrentOffset(), false, true, this.throwExceptionOnBadCharacterRead);
                                c = this.getChar(false);
                                break;
                            }
                            token = this.processKeywordOrIdentifier(pasting);
                            if (token == null) {
                                c = this.getChar(false);
                                break;
                            }
                            return token;
                        }
                        this.ungetChar(next);
                        this.handleProblem(0x1000001, this.strbuff.toString(), this.getCurrentOffset(), false, true, this.throwExceptionOnBadCharacterRead);
                    }
                    this.handleProblem(0x1000001, new Character((char)c).toString(), this.getCurrentOffset(), false, true, this.throwExceptionOnBadCharacterRead);
                    c = this.getChar(false);
                }
            }
        }
        this.throwEOF(null);
        return null;
    }

    protected boolean isValidIdentifierStartCharacter(int c) {
        return Character.isLetter((char)c) || c == 95;
    }

    protected void handleCompletionOnDefinition(String definition) throws EndOfFileException {
        ASTCompletionNode node = new ASTCompletionNode(IASTCompletionNode.CompletionKind.MACRO_REFERENCE, null, null, definition, KeywordSets.getKeywords(KeywordSetKey.EMPTY, this.language), EMPTY_STRING, null);
        this.throwEOF(node);
    }

    protected void handleCompletionOnExpression(String expression) throws EndOfFileException {
        int completionPoint = expression.length() + 2;
        IASTCompletionNode.CompletionKind kind = IASTCompletionNode.CompletionKind.MACRO_REFERENCE;
        String prefix = EMPTY_STRING;
        if (!expression.trim().equals(EMPTY_STRING)) {
            Scanner subScanner = new Scanner(new CodeReader(expression.toCharArray()), this.getTemporaryHashtable(), Collections.EMPTY_LIST, NULL_REQUESTOR, ParserMode.QUICK_PARSE, this.language, NULL_LOG_SERVICE, this.scannerExtension);
            IToken lastToken = null;
            while (true) {
                try {
                    lastToken = subScanner.nextToken();
                }
                catch (EndOfFileException endOfFileException) {
                    break;
                }
                catch (ScannerException scannerException) {
                    this.handleInternalError();
                    break;
                }
            }
            if (lastToken != null) {
                if (lastToken.getType() == 1 && lastToken.getEndOffset() == completionPoint) {
                    prefix = lastToken.getImage();
                } else if (lastToken.getEndOffset() == completionPoint && lastToken.getType() != 1) {
                    kind = IASTCompletionNode.CompletionKind.NO_SUCH_KIND;
                }
            }
        }
        ASTCompletionNode node = new ASTCompletionNode(kind, null, null, prefix, KeywordSets.getKeywords(kind == IASTCompletionNode.CompletionKind.NO_SUCH_KIND ? KeywordSetKey.EMPTY : KeywordSetKey.MACRO, this.language), EMPTY_STRING, null);
        this.throwEOF(node);
    }

    private Map getTemporaryHashtable() {
        this.tempMap.clear();
        this.tempMap = new HashMap();
        return this.tempMap;
    }

    protected void handleInvalidCompletion() throws EndOfFileException {
        this.throwEOF(new ASTCompletionNode(IASTCompletionNode.CompletionKind.UNREACHABLE_CODE, null, null, EMPTY_STRING, KeywordSets.getKeywords(KeywordSetKey.EMPTY, this.language), EMPTY_STRING, null));
    }

    protected void handleCompletionOnPreprocessorDirective(String prefix) throws EndOfFileException {
        this.throwEOF(new ASTCompletionNode(IASTCompletionNode.CompletionKind.NO_SUCH_KIND, null, null, prefix, KeywordSets.getKeywords(KeywordSetKey.PP_DIRECTIVE, this.language), EMPTY_STRING, null));
    }

    protected void removeSymbol(String key) {
        this.definitions.remove(key);
    }

    protected void handlePragmaOperator() throws ScannerException, EndOfFileException {
        this.getRestOfPreprocessorLine();
    }

    protected IToken processCharacterLiteral(int c, boolean wideLiteral) throws ScannerException {
        int beginOffset = this.getCurrentOffset();
        int type = wideLiteral ? 133 : 132;
        this.strbuff.startString();
        int prev = c;
        int prevPrev = c;
        c = this.getChar(true);
        while (true) {
            if (c == 10 || (c == 92 || c == 39) && prev == 92 || c == -1) {
                this.handleProblem(0x1000001, new Character((char)c).toString(), beginOffset, false, true, this.throwExceptionOnBadCharacterRead);
                c = 39;
            }
            if (c == 39 && (prev != 92 || prevPrev == 92)) break;
            this.strbuff.append(c);
            prevPrev = prev;
            prev = c;
            c = this.getChar(true);
        }
        return this.newToken(type, this.strbuff.toString());
    }

    protected String getCurrentFile() {
        return this.contextStack.getMostRelevantFileContext() != null ? this.contextStack.getMostRelevantFileContext().getContextName() : EMPTY_STRING;
    }

    protected int getCurrentOffset() {
        return this.contextStack.getMostRelevantFileContext() != null ? this.contextStack.getMostRelevantFileContext().getOffset() : -1;
    }

    public IToken nextTokenForStringizing() throws ScannerException, EndOfFileException {
        int beginOffset = this.getCurrentOffset();
        int c = this.getChar(false);
        this.strbuff.startString();
        try {
            while (c != -1) {
                block1 : switch (c) {
                    case 9: 
                    case 10: 
                    case 13: 
                    case 32: {
                        if (this.strbuff.length() > 0) {
                            throw endOfMacroToken;
                        }
                        c = this.getChar(false);
                        break;
                    }
                    case 34: {
                        if (this.strbuff.length() > 0) {
                            throw endOfMacroToken;
                        }
                        this.strbuff.startString();
                        c = this.getChar(true);
                        while (c != 34 && c != -1) {
                            this.strbuff.append(c);
                            c = this.getChar(true);
                        }
                        if (c != -1) {
                            return this.newToken(130, this.strbuff.toString());
                        }
                        this.handleProblem(0x1000002, null, beginOffset, false, true);
                        c = this.getChar(false);
                        break;
                    }
                    case 39: {
                        if (this.strbuff.length() > 0) {
                            throw endOfMacroToken;
                        }
                        return this.processCharacterLiteral(c, false);
                    }
                    case 44: {
                        if (this.strbuff.length() > 0) {
                            throw endOfMacroToken;
                        }
                        return this.newToken(6, ",");
                    }
                    case 40: {
                        if (this.strbuff.length() > 0) {
                            throw endOfMacroToken;
                        }
                        return this.newToken(8, "(");
                    }
                    case 41: {
                        if (this.strbuff.length() > 0) {
                            throw endOfMacroToken;
                        }
                        return this.newToken(9, ")");
                    }
                    case 47: {
                        if (this.strbuff.length() > 0) {
                            throw endOfMacroToken;
                        }
                        c = this.getChar(false);
                        switch (c) {
                            case 47: {
                                this.skipOverSinglelineComment();
                                c = this.getChar(false);
                                break block1;
                            }
                            case 42: {
                                this.skipOverMultilineComment();
                                c = this.getChar(false);
                                break block1;
                            }
                        }
                        this.strbuff.append(47);
                        break;
                    }
                    default: {
                        this.strbuff.append(c);
                        c = this.getChar(false);
                    }
                }
            }
        }
        catch (endOfMacroTokenException endOfMacroTokenException2) {
            this.ungetChar(c);
        }
        if (this.strbuff.length() > 0) {
            return this.newToken(1, this.strbuff.toString());
        }
        this.throwEOF(null);
        return null;
    }

    protected void throwEOF(IASTCompletionNode node) throws EndOfFileException, OffsetLimitReachedException {
        if (node == null) {
            if (this.offsetLimit == -1) {
                throw EOF;
            }
            if (this.finalToken != null && this.finalToken.getEndOffset() == this.offsetLimit) {
                throw new OffsetLimitReachedException(this.finalToken);
            }
            throw new OffsetLimitReachedException(null);
        }
        throw new OffsetLimitReachedException(node);
    }

    public final int getCount() {
        return this.count;
    }

    public final int getDepth() {
        return this.branches.getDepth();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean evaluateExpressionNew(String expression, int beginningOffset) throws ScannerException {
        boolean bl;
        ScannerContextTopString context = new ScannerContextTopString(expression, EXPRESSION, ';', true);
        this.contextStack.cs_push(context);
        IToken previousToken = this.currentToken;
        ISourceElementRequestor savedRequestor = this.requestor;
        IParserLogService savedLog = this.log;
        this.log = NULL_LOG_SERVICE;
        this.requestor = NULL_REQUESTOR;
        boolean savedPassOnToClient = this.passOnToClient;
        ParserMode savedParserMode = this.parserMode;
        IASTFactory savedFactory = this.astFactory;
        this.passOnToClient = true;
        this.parserMode = ParserMode.QUICK_PARSE;
        IExpressionParser parser = InternalParserUtil.createExpressionParser(this, this.language, NULL_LOG_SERVICE);
        try {
            try {
                IASTExpression exp = parser.expression(null, null, null);
                bl = exp.evaluateExpression() != 0L;
                Object var12_13 = null;
                this.currentToken = previousToken;
                if (this.currentToken != null) {
                    this.currentToken.setNext(null);
                }
                this.contextStack.cs_pop();
            }
            catch (BacktrackException backtrackException) {
                Object var12_14 = null;
                this.currentToken = previousToken;
                if (this.currentToken != null) {
                    this.currentToken.setNext(null);
                }
                this.contextStack.cs_pop();
                this.requestor = savedRequestor;
                this.passOnToClient = savedPassOnToClient;
                this.parserMode = savedParserMode;
                this.astFactory = savedFactory;
                this.log = savedLog;
                return false;
            }
            catch (ASTExpressionEvaluationException aSTExpressionEvaluationException) {
                Object var12_15 = null;
                this.currentToken = previousToken;
                if (this.currentToken != null) {
                    this.currentToken.setNext(null);
                }
                this.contextStack.cs_pop();
                this.requestor = savedRequestor;
                this.passOnToClient = savedPassOnToClient;
                this.parserMode = savedParserMode;
                this.astFactory = savedFactory;
                this.log = savedLog;
                return false;
            }
            catch (EndOfFileException endOfFileException) {
                Object var12_16 = null;
                this.currentToken = previousToken;
                if (this.currentToken != null) {
                    this.currentToken.setNext(null);
                }
                this.contextStack.cs_pop();
                this.requestor = savedRequestor;
                this.passOnToClient = savedPassOnToClient;
                this.parserMode = savedParserMode;
                this.astFactory = savedFactory;
                this.log = savedLog;
                return false;
            }
        }
        catch (Throwable throwable) {
            Object var12_17 = null;
            this.currentToken = previousToken;
            if (this.currentToken != null) {
                this.currentToken.setNext(null);
            }
            this.contextStack.cs_pop();
            this.requestor = savedRequestor;
            this.passOnToClient = savedPassOnToClient;
            this.parserMode = savedParserMode;
            this.astFactory = savedFactory;
            this.log = savedLog;
            throw throwable;
        }
        this.requestor = savedRequestor;
        this.passOnToClient = savedPassOnToClient;
        this.parserMode = savedParserMode;
        this.astFactory = savedFactory;
        this.log = savedLog;
        return bl;
    }

    protected boolean evaluateExpression(String expression, int beginningOffset) throws ScannerException {
        return this.evaluateExpressionNew(expression, beginningOffset);
    }

    protected void skipOverSinglelineComment() throws ScannerException, EndOfFileException {
        int c;
        block3: while (true) {
            c = this.getChar(false);
            switch (c) {
                case -1: 
                case 10: {
                    break block3;
                }
                default: {
                    continue block3;
                }
            }
            break;
        }
        if (c == -1 && this.isLimitReached()) {
            this.handleInvalidCompletion();
        }
    }

    protected boolean skipOverMultilineComment() throws ScannerException, EndOfFileException {
        int state = 0;
        boolean encounteredNewline = false;
        int c = this.getChar(false);
        while (state != 2 && c != -1) {
            if (c == 10) {
                encounteredNewline = true;
            }
            switch (state) {
                case 0: {
                    if (c != 42) break;
                    state = 1;
                    break;
                }
                case 1: {
                    if (c == 47) {
                        state = 2;
                        break;
                    }
                    if (c == 42) break;
                    state = 0;
                }
            }
            c = this.getChar(false);
        }
        if (state != 2) {
            if (c == -1 && !this.isLimitReached()) {
                this.handleProblem(0x1000006, null, this.getCurrentOffset(), false, true);
            } else if (c == -1) {
                this.handleInvalidCompletion();
            }
        }
        this.ungetChar(c);
        return encounteredNewline;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ScannerUtility.InclusionDirective parseInclusionDirective(String includeLine, int baseOffset) throws ScannerUtility.InclusionParseException {
        if (includeLine.equals(EMPTY_STRING)) {
            throw INCLUSION_PARSE_EXCEPTION;
        }
        ISourceElementRequestor savedRequestor = this.requestor;
        IToken previousToken = this.currentToken;
        try {
            try {
                ScannerContextTopString context = new ScannerContextTopString(includeLine, "INCLUDE", true);
                this.contextStack.cs_push(context);
                this.requestor = NULL_REQUESTOR;
                boolean useIncludePath = true;
                StringBuffer localStringBuff = new StringBuffer(100);
                int startOffset = baseOffset;
                int endOffset = baseOffset;
                IToken t = null;
                try {
                    t = this.nextToken(false);
                }
                catch (EndOfFileException endOfFileException) {
                    throw INCLUSION_PARSE_EXCEPTION;
                }
                try {
                    if (t.getType() == 130) {
                        localStringBuff.append(t.getImage());
                        startOffset = baseOffset + t.getOffset();
                        endOffset = baseOffset + t.getEndOffset();
                        useIncludePath = false;
                        t = this.nextToken(false);
                        this.contextStack.cs_pop();
                        this.requestor = savedRequestor;
                        throw INCLUSION_PARSE_EXCEPTION;
                    }
                    if (t.getType() != 42) throw INCLUSION_PARSE_EXCEPTION;
                    this.disableMacroExpansion = true;
                    try {
                        t = this.nextToken(false);
                        startOffset = baseOffset + t.getOffset();
                        while (true) {
                            if (t.getType() == 46) {
                                endOffset = baseOffset + t.getEndOffset();
                                break;
                            }
                            localStringBuff.append(t.getImage());
                            this.skipOverWhitespace();
                            int c = this.getChar();
                            if (c == 92) {
                                localStringBuff.append('\\');
                            } else {
                                this.ungetChar(c);
                            }
                            t = this.nextToken(false);
                        }
                    }
                    catch (EndOfFileException endOfFileException) {
                        throw INCLUSION_PARSE_EXCEPTION;
                    }
                    t = this.nextToken(false);
                    throw INCLUSION_PARSE_EXCEPTION;
                }
                catch (EndOfFileException endOfFileException) {
                    ScannerUtility.InclusionDirective inclusionDirective = new ScannerUtility.InclusionDirective(localStringBuff.toString(), useIncludePath, startOffset, endOffset);
                    Object var12_13 = null;
                    this.currentToken = previousToken;
                    if (this.currentToken != null) {
                        this.currentToken.setNext(null);
                    }
                    this.contextStack.cs_pop();
                    this.requestor = savedRequestor;
                    this.disableMacroExpansion = false;
                    return inclusionDirective;
                }
            }
            catch (ScannerException scannerException) {
                throw INCLUSION_PARSE_EXCEPTION;
            }
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            this.currentToken = previousToken;
            if (this.currentToken != null) {
                this.currentToken.setNext(null);
            }
            this.contextStack.cs_pop();
            this.requestor = savedRequestor;
            this.disableMacroExpansion = false;
            throw throwable;
        }
    }

    protected void poundInclude(int beginningOffset, int startLine) throws ScannerException, EndOfFileException {
        this.skipOverWhitespace();
        int baseOffset = this.lastContext.getOffset();
        int nameLine = this.contextStack.getCurrentLineNumber();
        String includeLine = this.getRestOfPreprocessorLine();
        if (this.isLimitReached()) {
            this.handleInvalidCompletion();
        }
        int endLine = this.contextStack.getCurrentLineNumber();
        ScannerUtility.InclusionDirective directive = null;
        try {
            directive = this.parseInclusionDirective(includeLine, baseOffset);
        }
        catch (ScannerUtility.InclusionParseException inclusionParseException) {
            this.strbuff.startString();
            this.strbuff.append("#include ");
            this.strbuff.append(includeLine);
            this.handleProblem(0x2000006, this.strbuff.toString(), beginningOffset, false, true);
            return;
        }
        if (this.parserMode == ParserMode.QUICK_PARSE) {
            if (this.requestor != null) {
                ISourceElementCallbackDelegate i = null;
                try {
                    i = this.getASTFactory().createInclusion(directive.getFilename().toCharArray(), EMPTY_STRING_CHAR_ARRAY, !directive.useIncludePaths(), beginningOffset, startLine, directive.getStartOffset(), directive.getStartOffset() + directive.getFilename().length(), nameLine, directive.getEndOffset(), endLine, this.getCurrentFilename());
                }
                catch (Exception exception) {}
                if (i != null) {
                    i.enterScope(this.requestor, null);
                    i.exitScope(this.requestor, null);
                }
            }
        } else {
            this.handleInclusion(directive.getFilename().trim(), directive.useIncludePaths(), beginningOffset, startLine, directive.getStartOffset(), nameLine, directive.getEndOffset(), endLine);
        }
    }

    protected void temporarilyReplaceDefinitionsMap() {
        this.definitionsBackupMap = this.definitions;
        this.definitions = Collections.EMPTY_MAP;
    }

    protected void restoreDefinitionsMap() {
        this.definitions = this.definitionsBackupMap;
        this.definitionsBackupMap = null;
    }

    protected void setForInclusion(boolean b) {
        this.forInclusion = b;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected IToken[] tokenizeReplacementString(int beginning, String key, String replacementString, String[] parameterIdentifiers) {
        IToken[] iTokenArray;
        IParserLogService savedLog;
        ISourceElementRequestor savedRequestor;
        block20: {
            IToken[] iTokenArray2;
            if (replacementString.trim().equals(EMPTY_STRING)) {
                return EMPTY_TOKEN_ARRAY;
            }
            IToken[] macroReplacementTokens = this.getTokenBuffer();
            int currentIndex = 0;
            ScannerContextTopString context = new ScannerContextTopString(replacementString, SCRATCH, true);
            this.contextStack.cs_push(context);
            savedRequestor = this.requestor;
            savedLog = this.log;
            IToken previousToken = this.currentToken;
            this.setTokenizingMacroReplacementList(true);
            this.disableMacroExpansion = true;
            this.requestor = NULL_REQUESTOR;
            this.log = NULL_LOG_SERVICE;
            try {
                IToken t = null;
                try {
                    t = this.nextToken(false);
                }
                catch (ScannerException scannerException) {
                }
                catch (EndOfFileException endOfFileException) {}
                if (t == null) {
                    iTokenArray = EMPTY_TOKEN_ARRAY;
                    Object var13_15 = null;
                    this.currentToken = previousToken;
                    if (this.currentToken != null) {
                        this.currentToken.setNext(null);
                    }
                    this.contextStack.cs_pop();
                    break block20;
                }
                try {
                    while (true) {
                        IToken[] doubled;
                        if (t.getType() == -7) {
                            int index;
                            if (currentIndex == macroReplacementTokens.length) {
                                doubled = new IToken[macroReplacementTokens.length * 2];
                                System.arraycopy(macroReplacementTokens, 0, doubled, 0, macroReplacementTokens.length);
                                macroReplacementTokens = doubled;
                            }
                            macroReplacementTokens[currentIndex++] = t;
                            t = this.nextToken(false);
                            if (parameterIdentifiers != null && (index = this.findIndex(parameterIdentifiers, t.getImage())) == -1 && beginning != -1) {
                                this.strbuff.startString();
                                this.strbuff.append(POUND_DEFINE);
                                this.strbuff.append(key);
                                this.strbuff.append(32);
                                this.strbuff.append(replacementString);
                                this.handleProblem(0x200000A, this.strbuff.toString(), beginning, false, true);
                                IToken[] iTokenArray3 = EMPTY_TOKEN_ARRAY;
                                Object var13_16 = null;
                                this.currentToken = previousToken;
                                if (this.currentToken != null) {
                                    this.currentToken.setNext(null);
                                }
                                this.contextStack.cs_pop();
                                this.setTokenizingMacroReplacementList(false);
                                this.requestor = savedRequestor;
                                this.log = savedLog;
                                this.disableMacroExpansion = false;
                                return iTokenArray3;
                            }
                        }
                        if (currentIndex == macroReplacementTokens.length) {
                            doubled = new IToken[macroReplacementTokens.length * 2];
                            System.arraycopy(macroReplacementTokens, 0, doubled, 0, macroReplacementTokens.length);
                            macroReplacementTokens = doubled;
                        }
                        macroReplacementTokens[currentIndex++] = t;
                        t = this.nextToken(false);
                    }
                }
                catch (EndOfFileException endOfFileException) {
                }
                catch (ScannerException scannerException) {}
                IToken[] result = new IToken[currentIndex];
                System.arraycopy(macroReplacementTokens, 0, result, 0, currentIndex);
                iTokenArray2 = result;
                Object var13_17 = null;
                this.currentToken = previousToken;
                if (this.currentToken != null) {
                    this.currentToken.setNext(null);
                }
                this.contextStack.cs_pop();
            }
            catch (Throwable throwable) {
                Object var13_18 = null;
                this.currentToken = previousToken;
                if (this.currentToken != null) {
                    this.currentToken.setNext(null);
                }
                this.contextStack.cs_pop();
                this.setTokenizingMacroReplacementList(false);
                this.requestor = savedRequestor;
                this.log = savedLog;
                this.disableMacroExpansion = false;
                throw throwable;
            }
            this.setTokenizingMacroReplacementList(false);
            this.requestor = savedRequestor;
            this.log = savedLog;
            this.disableMacroExpansion = false;
            return iTokenArray2;
        }
        this.setTokenizingMacroReplacementList(false);
        this.requestor = savedRequestor;
        this.log = savedLog;
        this.disableMacroExpansion = false;
        return iTokenArray;
    }

    IToken[] getTokenBuffer() {
        Arrays.fill(this.tokenArrayBuffer, null);
        return this.tokenArrayBuffer;
    }

    protected IMacroDescriptor createObjectMacroDescriptor(String key, String value) {
        IToken t = null;
        if (!value.trim().equals(EMPTY_STRING)) {
            t = TokenFactory.createUniquelyImagedToken(1, value, this);
        }
        return new ObjectMacroDescriptor(key, t, value);
    }

    /*
     * Unable to fully structure code
     */
    protected void poundDefine(int beginning, int beginningLine) throws ScannerException, EndOfFileException {
        block15: {
            block17: {
                block16: {
                    block14: {
                        key = this.getNextIdentifier();
                        offset = this.currentContext.getOffset() - key.length();
                        nameLine = this.contextStack.getCurrentLineNumber();
                        previousDefinition = this.getDefinition(key);
                        descriptor = null;
                        c = this.getChar(false);
                        if (c != 40) break block14;
                        this.strbuff.startString();
                        c = this.getChar(true);
                        while (c != 41) {
                            if (c == 92) {
                                c = this.getChar(false);
                                if (c == 13) {
                                    c = this.getChar(false);
                                }
                                if (c == 10) {
                                    c = this.getChar(false);
                                    continue;
                                }
                                this.ungetChar(c);
                                line = this.strbuff.toString();
                                this.strbuff.startString();
                                this.strbuff.append("#define ");
                                this.strbuff.append(line);
                                this.strbuff.append(92);
                                this.strbuff.append(c);
                                this.handleProblem(0x2000005, this.strbuff.toString(), beginning, false, true);
                                return;
                            }
                            if (c == 13 || c == 10 || c == -1) {
                                line = this.strbuff.toString();
                                this.strbuff.startString();
                                this.strbuff.append("#define ");
                                this.strbuff.append(line);
                                this.strbuff.append(92);
                                this.strbuff.append(c);
                                this.handleProblem(0x2000005, this.strbuff.toString(), beginning, false, true);
                                return;
                            }
                            this.strbuff.append(c);
                            c = this.getChar(true);
                        }
                        parameters = this.strbuff.toString();
                        tokenizer = new StringTokenizer(parameters, ",");
                        parameterIdentifiers = new String[tokenizer.countTokens()];
                        ct = 0;
                        while (tokenizer.hasMoreTokens()) {
                            parameterIdentifiers[ct++] = tokenizer.nextToken().trim();
                        }
                        this.skipOverWhitespace();
                        macroReplacementTokens = null;
                        replacementString = this.getRestOfPreprocessorLine();
                        macroReplacementTokens = replacementString.equals("") == false ? this.tokenizeReplacementString(beginning, key, replacementString, parameterIdentifiers) : Scanner.EMPTY_TOKEN_ARRAY;
                        descriptor = new FunctionMacroDescriptor(key, parameterIdentifiers, macroReplacementTokens, replacementString);
                        this.checkValidMacroRedefinition(key, previousDefinition, descriptor, beginning);
                        this.addDefinition(key, descriptor);
                        break block15;
                    }
                    if (c != 10 && c != 13) break block16;
                    descriptor = this.createObjectMacroDescriptor(key, "");
                    this.checkValidMacroRedefinition(key, previousDefinition, descriptor, beginning);
                    this.addDefinition(key, descriptor);
                    break block15;
                }
                if (c != 32 && c != 9) break block17;
                this.skipOverWhitespace();
                value = this.getRestOfPreprocessorLine();
                descriptor = this.createObjectMacroDescriptor(key, value);
                this.checkValidMacroRedefinition(key, previousDefinition, descriptor, beginning);
                this.addDefinition(key, descriptor);
                break block15;
            }
            if (c != 47) ** GOTO lbl99
            c = this.getChar(false);
            if (c == 47) {
                this.skipOverSinglelineComment();
                descriptor = this.createObjectMacroDescriptor(key, "");
                this.checkValidMacroRedefinition(key, previousDefinition, descriptor, beginning);
                this.addDefinition(key, descriptor);
            } else if (c == 42) {
                if (this.skipOverMultilineComment()) {
                    descriptor = this.createObjectMacroDescriptor(key, "");
                    this.checkValidMacroRedefinition(key, previousDefinition, descriptor, beginning);
                    this.addDefinition(key, descriptor);
                } else {
                    value = this.getRestOfPreprocessorLine();
                    descriptor = this.createObjectMacroDescriptor(key, value);
                    this.checkValidMacroRedefinition(key, previousDefinition, descriptor, beginning);
                    this.addDefinition(key, descriptor);
                }
            } else {
                potentialErrorMessage = new StringBuffer("#define ");
                potentialErrorMessage.append(key);
                potentialErrorMessage.append(" /");
                potentialErrorMessage.append(this.getRestOfPreprocessorLine());
                this.handleProblem(0x2000005, potentialErrorMessage.toString(), beginning, false, true);
                return;
lbl99:
                // 1 sources

                potentialErrorMessage = new StringBuffer("#define ");
                potentialErrorMessage.append(key);
                potentialErrorMessage.append((char)c);
                potentialErrorMessage.append(this.getRestOfPreprocessorLine());
                this.handleProblem(0x2000005, potentialErrorMessage.toString(), beginning, false, true);
                return;
            }
        }
        try {
            this.getASTFactory().createMacro(key.toCharArray(), beginning, beginningLine, offset, offset + key.length(), nameLine, this.currentContext.getOffset(), this.contextStack.getCurrentLineNumber(), descriptor, this.getCurrentFilename()).acceptElement(this.requestor, null);
        }
        catch (Exception v0) {}
    }

    protected void checkValidMacroRedefinition(String key, IMacroDescriptor previousDefinition, IMacroDescriptor newDefinition, int beginningOffset) throws ScannerException {
        if (this.parserMode != ParserMode.QUICK_PARSE && previousDefinition != null) {
            if (previousDefinition.compatible(newDefinition)) {
                return;
            }
            this.handleProblem(0x2000007, key, beginningOffset, false, true);
        }
    }

    protected void handleInternalError() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Vector getMacroParameters(String params, boolean forStringizing) throws ScannerException {
        int nParen = 0;
        Vector<String> parameters = new Vector<String>();
        this.strbuff.startString();
        int i = 0;
        while (i < params.length()) {
            block19: {
                char c = params.charAt(i);
                switch (c) {
                    case '(': {
                        ++nParen;
                        break;
                    }
                    case ')': {
                        --nParen;
                        break;
                    }
                    case ',': {
                        if (nParen != 0) break;
                        parameters.add(this.strbuff.toString());
                        this.strbuff.startString();
                        break block19;
                    }
                }
                this.strbuff.append(c);
            }
            ++i;
        }
        parameters.add(this.strbuff.toString());
        this.setThrowExceptionOnBadCharacterRead(false);
        ISourceElementRequestor savedRequestor = this.requestor;
        IParserLogService savedLog = this.log;
        this.log = NULL_LOG_SERVICE;
        this.requestor = NULL_REQUESTOR;
        IToken previousToken = this.currentToken;
        Vector<String> parameterValues = new Vector<String>();
        int i2 = 0;
        while (i2 < parameters.size()) {
            ScannerContextTopString context = new ScannerContextTopString((String)parameters.elementAt(i2), TEXT, true);
            this.contextStack.cs_push(context);
            IToken t = null;
            StringBuffer strBuff2 = new StringBuffer();
            boolean space = false;
            try {
                while (true) {
                    int c;
                    if ((c = this.getCharacter()) != 32 && c != 9 && c != 13 && c != 10) {
                        space = false;
                    }
                    if (c != -1) {
                        this.ungetChar(c);
                    }
                    IToken iToken = t = forStringizing ? this.nextTokenForStringizing() : this.nextToken(false);
                    if (space) {
                        strBuff2.append(' ');
                    }
                    switch (t.getType()) {
                        case 130: {
                            strBuff2.append('\"');
                            strBuff2.append(t.getImage());
                            strBuff2.append('\"');
                            break;
                        }
                        case 131: {
                            strBuff2.append("L\"");
                            strBuff2.append(t.getImage());
                            strBuff2.append('\"');
                            break;
                        }
                        case 132: {
                            strBuff2.append('\'');
                            strBuff2.append(t.getImage());
                            strBuff2.append('\'');
                            break;
                        }
                        default: {
                            strBuff2.append(t.getImage());
                        }
                    }
                    space = true;
                }
            }
            catch (EndOfFileException endOfFileException) {
                this.contextStack.cs_pop();
                parameterValues.add(strBuff2.toString());
                ++i2;
            }
        }
        this.currentToken = previousToken;
        if (this.currentToken != null) {
            this.currentToken.setNext(null);
        }
        this.setThrowExceptionOnBadCharacterRead(true);
        this.requestor = savedRequestor;
        this.log = savedLog;
        return parameterValues;
    }

    protected void expandDefinition(String symbol, String expansion, int symbolOffset) throws ScannerException {
        this.expandDefinition(symbol, new ObjectMacroDescriptor(symbol, expansion), symbolOffset);
    }

    /*
     * Unable to fully structure code
     */
    protected void expandDefinition(String symbol, IMacroDescriptor expansion, int symbolOffset) throws ScannerException {
        if (expansion.getMacroType() == IMacroDescriptor.MacroType.OBJECT_LIKE || expansion.getMacroType() == IMacroDescriptor.MacroType.INTERNAL_LIKE) {
            replacementValue = expansion.getExpansionSignature();
            try {
                this.contextStack.updateMacroContext(replacementValue, symbol, this.requestor, symbolOffset, symbol.length());
            }
            catch (ContextException e) {
                this.handleProblem(e.getId(), this.currentContext.getContextName(), this.getCurrentOffset(), false, true);
                this.consumeUntilOutOfMacroExpansion();
                return;
            }
        }
        if (expansion.getMacroType() != IMacroDescriptor.MacroType.FUNCTION_LIKE) ** GOTO lbl125
        this.skipOverWhitespace();
        c = this.getChar(false);
        if (c == 40) {
            this.strbuff.startString();
            bracketCount = 1;
            c = this.getChar(false);
            while (true) {
                if (c == 40) {
                    ++bracketCount;
                } else if (c == 41) {
                    --bracketCount;
                }
                if (bracketCount == 0 || c == -1) break;
                this.strbuff.append(c);
                c = this.getChar(true);
            }
            betweenTheBrackets = this.strbuff.toString().trim();
            if (expansion.getExpansionSignature() == "") {
                return;
            }
            endMacroOffset = this.lastContext.getOffset() - 1;
            parameterValues = this.getMacroParameters(betweenTheBrackets, false);
            parameterValuesForStringizing = null;
            t = null;
            tokens = expansion.getTokenizedExpansion();
            parameterNames = expansion.getParameters();
            if (parameterNames.length != parameterValues.size()) {
                this.handleProblem(0x2000009, symbol, this.getCurrentOffset(), false, true);
                this.consumeUntilOutOfMacroExpansion();
                return;
            }
            this.strbuff.startString();
            numberOfTokens = tokens.length;
            i = 0;
            while (i < numberOfTokens) {
                t = (SimpleToken)tokens[i];
                if (t.getType() == 1) {
                    index = this.findIndex(parameterNames, t.getImage());
                    if (index == -1) {
                        this.strbuff.append(t.getImage());
                    } else {
                        this.strbuff.append((String)parameterValues.elementAt(index));
                    }
                } else if (t.getType() == -7) {
                    if (parameterValuesForStringizing == null) {
                        cache = this.strbuff.toString();
                        parameterValuesForStringizing = this.getMacroParameters(betweenTheBrackets, true);
                        this.strbuff.startString();
                        this.strbuff.append(cache);
                    }
                    if (tokens.length == ++i) {
                        this.handleProblem(0x2000009, expansion.getName(), this.getCurrentOffset(), false, true);
                        return;
                    }
                    t = (SimpleToken)tokens[i];
                    index = this.findIndex(parameterNames, t.getImage());
                    if (index == -1) {
                        this.handleProblem(0x2000009, expansion.getName(), this.getCurrentOffset(), false, true);
                        return;
                    }
                    this.strbuff.append(34);
                    value = (String)parameterValuesForStringizing.elementAt(index);
                    val = value.toCharArray();
                    length = value.length();
                    j = 0;
                    while (j < length) {
                        ch = val[j];
                        if (ch == ' ' || ch == '\t' || ch == '\r' || ch == '\n') {
                            while (ch == ' ' || ch == '\t' || ch == '\r' || ch == '\n') {
                                ch = val[++j];
                            }
                            this.strbuff.append(32);
                        }
                        if (ch == '\"' || ch == '\\') {
                            this.strbuff.append(92);
                            this.strbuff.append(ch);
                        } else {
                            this.strbuff.append(ch);
                        }
                        ++j;
                    }
                    this.strbuff.append(34);
                } else {
                    switch (t.getType()) {
                        case 130: {
                            this.strbuff.append(34);
                            this.strbuff.append(t.getImage());
                            this.strbuff.append(34);
                            break;
                        }
                        case 131: {
                            this.strbuff.append("L\"");
                            this.strbuff.append(t.getImage());
                            this.strbuff.append(34);
                            break;
                        }
                        case 132: {
                            this.strbuff.append(39);
                            this.strbuff.append(t.getImage());
                            this.strbuff.append(39);
                            break;
                        }
                        default: {
                            this.strbuff.append(t.getImage());
                        }
                    }
                }
                pastingNext = false;
                if (i != numberOfTokens - 1 && (t2 = tokens[i + 1]).getType() == -6) {
                    pastingNext = true;
                    ++i;
                }
                if (t.getType() != -6 && !pastingNext && i < numberOfTokens - 1) {
                    this.strbuff.append(32);
                }
                ++i;
            }
            finalString = this.strbuff.toString();
            try {
                this.contextStack.updateMacroContext(finalString, expansion.getName(), this.requestor, symbolOffset, endMacroOffset - symbolOffset + 1);
            }
            catch (ContextException e) {
                this.handleProblem(e.getId(), this.currentContext.getContextName(), this.getCurrentOffset(), false, true);
                this.consumeUntilOutOfMacroExpansion();
                return;
            }
        } else {
            this.handleProblem(0x2000009, symbol, this.getCurrentOffset(), false, true);
            this.consumeUntilOutOfMacroExpansion();
            return;
lbl125:
            // 1 sources

            TraceUtil.outputTrace(this.log, "Unexpected type of MacroDescriptor stored in definitions table: ", null, expansion.getMacroType().toString(), null, null);
        }
    }

    private int findIndex(String[] parameterNames, String image) {
        int i = 0;
        while (i < parameterNames.length) {
            if (parameterNames[i].equals(image)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected String handleDefinedMacro() throws ScannerException {
        int o = this.getCurrentOffset();
        this.skipOverWhitespace();
        int c = this.getChar(false);
        String definitionIdentifier = null;
        if (c == 40) {
            definitionIdentifier = this.getNextIdentifier();
            this.skipOverWhitespace();
            c = this.getChar(false);
            if (c != 41) {
                this.handleProblem(0x2000009, "defined()", o, false, true);
                return "0";
            }
        } else {
            this.ungetChar(c);
            definitionIdentifier = this.getNextIdentifier();
        }
        if (this.getDefinition(definitionIdentifier) != null) {
            return "1";
        }
        return "0";
    }

    public void setThrowExceptionOnBadCharacterRead(boolean throwOnBad) {
        this.throwExceptionOnBadCharacterRead = throwOnBad;
    }

    public void setASTFactory(IASTFactory f) {
        this.astFactory = f;
    }

    public void setOffsetBoundary(int offset) {
        this.offsetLimit = offset;
    }

    public Map getDefinitions() {
        return Collections.unmodifiableMap(this.definitions);
    }

    public void setOffsetLimitReached(boolean b) {
        this.limitReached = b;
    }

    protected boolean isLimitReached() {
        if (this.offsetLimit == -1) {
            return false;
        }
        return this.limitReached;
    }

    public boolean isOnTopContext() {
        return this.currentContext.getKind() == IScannerContext.ContextKind.TOP;
    }

    public char[] getCurrentFilename() {
        return this.getCurrentFile().toCharArray();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Scanner @");
        if (this.currentContext != null) {
            buffer.append(this.currentContext.toString());
        } else {
            buffer.append("EOF");
        }
        return buffer.toString();
    }

    public int getCurrentFileIndex() {
        return this.contextStack.getMostRelevantFileContextIndex();
    }

    public String getFilenameForIndex(int index) {
        if (index < 0) {
            return EMPTY_STRING;
        }
        return this.contextStack.getInclusionFilename(index);
    }

    public IASTFactory getASTFactory() {
        if (this.astFactory == null) {
            this.astFactory = ParserFactory.createASTFactory(this.parserMode, this.language);
        }
        return this.astFactory;
    }

    public BranchTracker getBranchTracker() {
        return this.branches;
    }

    public CodeReader getInitialReader() {
        return this.reader;
    }

    public IScannerInfo getOriginalConfig() {
        return this.originalConfig;
    }

    public IProblemFactory getProblemFactory() {
        return this.problemFactory;
    }

    public IScanner getScanner() {
        return this;
    }

    public void setDefinitions(Map map) {
        this.definitions = map;
    }

    public void setIncludePathNames(List includePathNames) {
        this.includePathNames = includePathNames;
    }

    public Map getFileCache() {
        return this.fileCache;
    }

    protected static class endOfMacroTokenException
    extends Exception {
        protected endOfMacroTokenException() {
        }
    }

    public static class PreprocessorDirectives {
        public static final int DEFINE = 0;
        public static final int UNDEFINE = 1;
        public static final int IF = 2;
        public static final int IFDEF = 3;
        public static final int IFNDEF = 4;
        public static final int ELSE = 5;
        public static final int ENDIF = 6;
        public static final int INCLUDE = 7;
        public static final int LINE = 8;
        public static final int ERROR = 9;
        public static final int PRAGMA = 10;
        public static final int BLANK = 11;
        public static final int ELIF = 12;
    }
}

