/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.ast.complete;

import java.util.List;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.ast.IASTConstructorMemberInitializer;
import org.eclipse.cdt.core.parser.ast.IASTExpression;
import org.eclipse.cdt.core.parser.ast.IReferenceManager;

public class ASTConstructorMemberInitializer
implements IASTConstructorMemberInitializer {
    private final int nameOffset;
    private final boolean requireNameResolution;
    private final char[] name;
    private final IASTExpression expression;
    private List references;

    public ASTConstructorMemberInitializer(IASTExpression expression, char[] name, int nameOffset, List references, boolean requireNameResolution) {
        this.expression = expression;
        this.name = name;
        this.nameOffset = nameOffset;
        this.references = references;
        this.requireNameResolution = requireNameResolution;
    }

    public IASTExpression getExpressionList() {
        return this.expression;
    }

    public String getName() {
        return String.valueOf(this.name);
    }

    public char[] getNameCharArray() {
        return this.name;
    }

    public void acceptElement(ISourceElementRequestor requestor, IReferenceManager manager) {
        manager.processReferences(this.references, requestor);
        this.references = null;
        if (this.expression != null) {
            this.expression.freeReferences(manager);
        }
    }

    public void enterScope(ISourceElementRequestor requestor, IReferenceManager manager) {
    }

    public void exitScope(ISourceElementRequestor requestor, IReferenceManager manager) {
    }

    public boolean requiresNameResolution() {
        return this.requireNameResolution;
    }

    public List getReferences() {
        return this.references;
    }

    public int getNameOffset() {
        return this.nameOffset;
    }
}

