/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.editor;

import java.util.ResourceBundle;
import org.eclipse.cdt.internal.ui.CPluginImages;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.internal.ui.editor.CEditorMessages;
import org.eclipse.cdt.internal.ui.editor.GotoErrorAction;
import org.eclipse.cdt.internal.ui.editor.TogglePresentationAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.editors.text.TextEditorActionContributor;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.RetargetTextEditorAction;
import org.eclipse.ui.texteditor.TextEditorAction;

public class CEditorActionContributor
extends TextEditorActionContributor {
    protected CEditor fCEditor;
    protected RetargetTextEditorAction fContentAssist;
    protected RetargetTextEditorAction fAddInclude;
    protected RetargetTextEditorAction fOpenOnSelection;
    protected SelectionAction fShiftLeft;
    protected SelectionAction fShiftRight;
    private TogglePresentationAction fTogglePresentation;
    private GotoErrorAction fPreviousError;
    private GotoErrorAction fNextError;

    public CEditorActionContributor() {
        ResourceBundle bundle = CEditorMessages.getResourceBundle();
        this.fShiftRight = new SelectionAction("ShiftRight.", 8);
        this.fShiftRight.setActionDefinitionId("org.eclipse.ui.edit.text.shiftRight");
        CPluginImages.setImageDescriptors((IAction)this.fShiftRight, "lcl16/", "org.eclipse.cdt.ui.shift_r_edit.gif");
        this.fShiftLeft = new SelectionAction("ShiftLeft.", 9);
        this.fShiftLeft.setActionDefinitionId("org.eclipse.ui.edit.text.shiftLeft");
        CPluginImages.setImageDescriptors((IAction)this.fShiftLeft, "lcl16/", "org.eclipse.cdt.ui.shift_l_edit.gif");
        this.fContentAssist = new RetargetTextEditorAction(bundle, "ContentAssistProposal.");
        this.fContentAssist.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.proposals");
        this.fAddInclude = new RetargetTextEditorAction(bundle, "AddIncludeOnSelection.");
        this.fAddInclude.setActionDefinitionId("org.eclipse.cdt.ui.edit.text.c.add.include");
        this.fOpenOnSelection = new RetargetTextEditorAction(bundle, "OpenOnSelection.");
        this.fTogglePresentation = new TogglePresentationAction();
        this.fTogglePresentation.setActionDefinitionId("org.eclipse.cdt.ui.edit.text.c.toggle.presentation");
        this.fPreviousError = new GotoErrorAction("PreviousError.", false);
        this.fPreviousError.setActionDefinitionId("org.eclipse.ui.navigate.previous");
        CPluginImages.setImageDescriptors((IAction)this.fPreviousError, "tool16/", "org.eclipse.cdt.ui.prev_error_nav.gif");
        this.fNextError = new GotoErrorAction("NextError.", true);
        this.fNextError.setActionDefinitionId("org.eclipse.ui.navigate.next");
        CPluginImages.setImageDescriptors((IAction)this.fNextError, "tool16/", "org.eclipse.cdt.ui.next_error_nav.gif");
    }

    public void contributeToMenu(IMenuManager menu) {
        super.contributeToMenu(menu);
        IMenuManager editMenu = menu.findMenuUsingPath("edit");
        if (editMenu != null) {
            editMenu.add((IAction)this.fShiftRight);
            editMenu.add((IAction)this.fShiftLeft);
            editMenu.add((IContributionItem)new Separator("group.open"));
            editMenu.add((IAction)this.fNextError);
            editMenu.add((IAction)this.fPreviousError);
            editMenu.add((IContributionItem)new Separator("group.generate"));
            editMenu.appendToGroup("group.generate", (IAction)this.fContentAssist);
            editMenu.appendToGroup("group.generate", (IAction)this.fAddInclude);
            editMenu.appendToGroup("group.generate", (IAction)this.fOpenOnSelection);
        }
    }

    public void init(IActionBars bars) {
        super.init(bars);
        bars.setGlobalActionHandler("org.eclipse.ui.edit.text.toggleShowSelectedElementOnly", (IAction)this.fTogglePresentation);
    }

    public void contributeToToolBar(IToolBarManager tbm) {
        super.contributeToToolBar(tbm);
        tbm.add((IContributionItem)new Separator());
        tbm.add((IAction)this.fTogglePresentation);
        tbm.add((IAction)this.fNextError);
        tbm.add((IAction)this.fPreviousError);
    }

    public void setActiveEditor(IEditorPart part) {
        super.setActiveEditor(part);
        ITextEditor textEditor = null;
        if (part instanceof ITextEditor) {
            textEditor = (ITextEditor)part;
        }
        this.fShiftRight.setEditor(textEditor);
        this.fShiftLeft.setEditor(textEditor);
        this.fNextError.setEditor(textEditor);
        this.fPreviousError.setEditor(textEditor);
        this.fTogglePresentation.setEditor(textEditor);
        this.fContentAssist.setAction(this.getAction(textEditor, "ContentAssistProposal"));
        this.fAddInclude.setAction(this.getAction(textEditor, "AddIncludeOnSelection"));
        this.fOpenOnSelection.setAction(this.getAction(textEditor, "OpenOnSelection"));
    }

    public void contributeeToStatusLine(IStatusLineManager statusLineManager) {
        super.contributeToStatusLine(statusLineManager);
    }

    public void dispose() {
        this.setActiveEditor(null);
        super.dispose();
    }

    protected static class SelectionAction
    extends TextEditorAction
    implements ISelectionChangedListener {
        protected int fOperationCode;
        protected ITextOperationTarget fOperationTarget = null;
        static /* synthetic */ Class class$0;

        public SelectionAction(String prefix, int operation) {
            super(CEditorMessages.getResourceBundle(), prefix, null);
            this.fOperationCode = operation;
            this.setEnabled(false);
        }

        public void setEditor(ITextEditor editor) {
            ISelectionProvider p;
            if (this.getTextEditor() != null && (p = this.getTextEditor().getSelectionProvider()) != null) {
                p.removeSelectionChangedListener((ISelectionChangedListener)this);
            }
            super.setEditor(editor);
            if (editor != null) {
                Class<?> clazz;
                p = editor.getSelectionProvider();
                if (p != null) {
                    p.addSelectionChangedListener((ISelectionChangedListener)this);
                }
                if ((clazz = class$0) == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.jface.text.ITextOperationTarget");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                this.fOperationTarget = (ITextOperationTarget)editor.getAdapter((Class)clazz);
            } else {
                this.fOperationTarget = null;
            }
            this.selectionChanged(null);
        }

        public void selectionChanged(SelectionChangedEvent event) {
            boolean isEnabled = this.fOperationTarget != null && this.fOperationTarget.canDoOperation(this.fOperationCode);
            this.setEnabled(isEnabled);
        }

        public void run() {
            if (this.fOperationCode != -1 && this.fOperationTarget != null) {
                this.fOperationTarget.doOperation(this.fOperationCode);
            }
        }
    }
}

