/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IParent;
import org.eclipse.cdt.core.model.ISourceRange;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.corext.refactoring.base.IChange;
import org.eclipse.cdt.internal.corext.refactoring.base.ICompositeChange;
import org.eclipse.cdt.internal.corext.refactoring.changes.TextChange;
import org.eclipse.cdt.internal.ui.refactoring.ChangeElement;
import org.eclipse.cdt.internal.ui.refactoring.DefaultChangeElement;
import org.eclipse.cdt.internal.ui.refactoring.PseudoCChangeElement;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

class ChangeElementContentProvider
implements ITreeContentProvider {
    private static final ChangeElement[] EMPTY_CHILDREN = new ChangeElement[0];

    ChangeElementContentProvider() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public Object[] getChildren(Object o) {
        ChangeElement element = (ChangeElement)o;
        Object[] children = element.getChildren();
        if (children == null) {
            children = this.createChildren(element);
        }
        return children;
    }

    public Object getParent(Object element) {
        return ((ChangeElement)element).getParent();
    }

    public boolean hasChildren(Object element) {
        Object[] children = this.getChildren(element);
        return children != null && children.length > 0;
    }

    public void dispose() {
    }

    public Object[] getElements(Object element) {
        return this.getChildren(element);
    }

    private ChangeElement[] createChildren(ChangeElement object) {
        ChangeElement[] result = EMPTY_CHILDREN;
        if (!(object instanceof DefaultChangeElement)) {
            return result;
        }
        DefaultChangeElement changeElement = (DefaultChangeElement)object;
        IChange change = changeElement.getChange();
        if (change instanceof ICompositeChange) {
            IChange[] children = ((ICompositeChange)change).getChildren();
            result = new ChangeElement[children.length];
            int i = 0;
            while (i < children.length) {
                result[i] = new DefaultChangeElement(changeElement, children[i]);
                ++i;
            }
        }
        changeElement.setChildren(result);
        return result;
    }

    private TextChange.EditChange[] getSortedTextEditChanges(TextChange change) {
        TextChange.EditChange[] edits = change.getTextEditChanges();
        ArrayList<TextChange.EditChange> result = new ArrayList<TextChange.EditChange>(edits.length);
        int i = 0;
        while (i < edits.length) {
            if (!edits[i].isEmpty()) {
                result.add(edits[i]);
            }
            ++i;
        }
        OffsetComparator comparator = new OffsetComparator();
        Collections.sort(result, comparator);
        return result.toArray(new TextChange.EditChange[result.size()]);
    }

    private PseudoCChangeElement getChangeElement(Map map, ICElement element, List children, ChangeElement cunitChange) {
        PseudoCChangeElement result = (PseudoCChangeElement)map.get(element);
        if (result != null) {
            return result;
        }
        ICElement parent = element.getParent();
        if (parent instanceof ITranslationUnit) {
            result = new PseudoCChangeElement(cunitChange, element);
            children.add(result);
            map.put(element, result);
        } else {
            PseudoCChangeElement parentChange = this.getChangeElement(map, parent, children, cunitChange);
            result = new PseudoCChangeElement(parentChange, element);
            parentChange.addChild(result);
            map.put(element, result);
        }
        return result;
    }

    private ICElement getModifiedCElement(TextChange.EditChange edit, ITranslationUnit cunit) throws CModelException {
        IRegion range = edit.getTextRange();
        if (range.getOffset() == 0 && range.getLength() == 0) {
            return cunit;
        }
        ICElement result = this.getElementAt((IParent)cunit, range.getOffset());
        if (result == null) {
            return cunit;
        }
        try {
            while (true) {
                ISourceReference ref = (ISourceReference)result;
                Region sRange = new Region(ref.getSourceRange().getStartPos(), ref.getSourceRange().getLength());
                if (result.getElementType() != 60 && result.getParent() != null && !edit.coveredBy((IRegion)sRange)) {
                    result = result.getParent();
                    continue;
                }
                break;
            }
        }
        catch (CModelException cModelException) {
        }
        catch (ClassCastException classCastException) {}
        return result;
    }

    protected ICElement getElementAt(IParent unit, int position) throws CModelException {
        if (unit instanceof ISourceReference) {
            ICElement[] children = unit.getChildren();
            int i = 0;
            while (i < children.length) {
                ISourceReference child;
                ISourceRange range;
                ICElement aChild = children[i];
                if (aChild instanceof ISourceReference && position < (range = (child = (ISourceReference)children[i]).getSourceRange()).getStartPos() + range.getLength() && position >= range.getStartPos()) {
                    if (child instanceof IParent) {
                        return this.getElementAt((IParent)child, position);
                    }
                    return (ICElement)child;
                }
                ++i;
            }
        }
        return null;
    }

    private static class OffsetComparator
    implements Comparator {
        OffsetComparator() {
        }

        public int compare(Object o1, Object o2) {
            int p2;
            TextChange.EditChange c1 = (TextChange.EditChange)o1;
            TextChange.EditChange c2 = (TextChange.EditChange)o2;
            int p1 = this.getOffset(c1);
            if (p1 < (p2 = this.getOffset(c2))) {
                return -1;
            }
            if (p1 > p2) {
                return 1;
            }
            return 0;
        }

        private int getOffset(TextChange.EditChange edit) {
            return edit.getTextRange().getOffset();
        }
    }
}

