/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.cdi;

import java.util.Iterator;
import java.util.Properties;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDIRuntimeOptions;
import org.eclipse.cdt.debug.mi.core.MIException;
import org.eclipse.cdt.debug.mi.core.MISession;
import org.eclipse.cdt.debug.mi.core.cdi.CdiResources;
import org.eclipse.cdt.debug.mi.core.cdi.Session;
import org.eclipse.cdt.debug.mi.core.command.CommandFactory;
import org.eclipse.cdt.debug.mi.core.command.MIEnvironmentCD;
import org.eclipse.cdt.debug.mi.core.command.MIExecArguments;
import org.eclipse.cdt.debug.mi.core.command.MIGDBSetEnvironment;
import org.eclipse.cdt.debug.mi.core.output.MIInfo;

public class RuntimeOptions
implements ICDIRuntimeOptions {
    Session session;

    public RuntimeOptions(Session s) {
        this.session = s;
    }

    public void setArguments(String[] args) throws CDIException {
        if (args == null || args.length == 0) {
            return;
        }
        MISession mi = this.session.getMISession();
        CommandFactory factory = mi.getCommandFactory();
        MIExecArguments arguments = factory.createMIExecArguments(args);
        try {
            mi.postCommand(arguments);
            MIInfo info = arguments.getMIInfo();
            if (info == null) {
                throw new CDIException(CdiResources.getString("cdi.RuntimeOptions.Unable_to_set_args_target_not_responding"));
            }
        }
        catch (MIException e) {
            throw new CDIException(String.valueOf(CdiResources.getString("cdi.RuntimeOptions.Unable_to_set_args")) + e.getMessage());
        }
    }

    public void setEnvironment(Properties props) throws CDIException {
        if (props == null) {
            return;
        }
        MISession mi = this.session.getMISession();
        CommandFactory factory = mi.getCommandFactory();
        Iterator<Object> iterator = props.keySet().iterator();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            String value = props.getProperty(key);
            String[] params = null;
            params = value == null || value.length() == 0 ? new String[]{key} : new String[]{key, value};
            MIGDBSetEnvironment set = factory.createMIGDBSetEnvironment(params);
            try {
                mi.postCommand(set);
                MIInfo info = set.getMIInfo();
                if (info != null) continue;
                throw new CDIException(CdiResources.getString("cdi.RuntimeOptions.Unable_to_set_args_target_not_responding"));
            }
            catch (MIException e) {
                throw new CDIException(String.valueOf(CdiResources.getString("cdi.RuntimeOptions.Unable_to_set_environment")) + e.getMessage());
            }
        }
    }

    public void setWorkingDirectory(String wd) throws CDIException {
        if (wd == null || wd.length() == 0) {
            return;
        }
        MISession mi = this.session.getMISession();
        CommandFactory factory = mi.getCommandFactory();
        MIEnvironmentCD cd = factory.createMIEnvironmentCD(wd);
        try {
            mi.postCommand(cd);
            MIInfo info = cd.getMIInfo();
            if (info == null) {
                throw new CDIException(CdiResources.getString("cdi.RuntimeOptions.Unable_to_set_args_target_not_responding"));
            }
        }
        catch (MIException e) {
            throw new CDIException(String.valueOf(CdiResources.getString("cdi.RuntimeOptions.Unable_to_set_working_dir")) + e.getMessage());
        }
    }
}

