/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.ast.quick;

import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.ast.ASTNotImplementedException;
import org.eclipse.cdt.core.parser.ast.IASTNamespaceDefinition;
import org.eclipse.cdt.core.parser.ast.IASTScope;
import org.eclipse.cdt.core.parser.ast.IASTUsingDirective;
import org.eclipse.cdt.core.parser.ast.IReferenceManager;
import org.eclipse.cdt.internal.core.parser.ast.quick.ASTDeclaration;

public class ASTUsingDirective
extends ASTDeclaration
implements IASTUsingDirective {
    private final char[] fn;
    private final String namespaceName;
    private int startingLineNumber;
    private int startingOffset;
    private int endingLineNumber;
    private int endingOffset;

    public char[] getFilename() {
        return this.fn;
    }

    public ASTUsingDirective(IASTScope scope, String name, int startingOffset, int startingLine, int endingOffset, int endingLine, char[] filename) {
        super(scope);
        this.namespaceName = name;
        this.setStartingOffsetAndLineNumber(startingOffset, startingLine);
        this.setEndingOffsetAndLineNumber(endingOffset, endingLine);
        this.fn = filename;
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public void acceptElement(ISourceElementRequestor requestor, IReferenceManager manager) {
        try {
            requestor.acceptUsingDirective(this);
        }
        catch (Exception exception) {}
    }

    public void enterScope(ISourceElementRequestor requestor, IReferenceManager manager) {
    }

    public void exitScope(ISourceElementRequestor requestor, IReferenceManager manager) {
    }

    public IASTNamespaceDefinition getNamespaceDefinition() throws ASTNotImplementedException {
        throw new ASTNotImplementedException();
    }

    public final int getStartingLine() {
        return this.startingLineNumber;
    }

    public final int getEndingLine() {
        return this.endingLineNumber;
    }

    public final void setStartingOffsetAndLineNumber(int offset, int lineNumber) {
        this.startingOffset = offset;
        this.startingLineNumber = lineNumber;
    }

    public final void setEndingOffsetAndLineNumber(int offset, int lineNumber) {
        this.endingOffset = offset;
        this.endingLineNumber = lineNumber;
    }

    public final int getStartingOffset() {
        return this.startingOffset;
    }

    public final int getEndingOffset() {
        return this.endingOffset;
    }
}

