/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.scanner;

import java.util.EmptyStackException;
import java.util.Stack;

public class BranchTracker {
    private static final int IGNORE_SENTINEL = -1;
    private Stack branches = new Stack();
    private int ignore = -1;
    private static final Boolean FALSE = new Boolean(false);
    private static final Boolean TRUE = new Boolean(true);

    public boolean poundIf(boolean taken) {
        if (this.ignore == -1) {
            this.branches.push(new Boolean(taken));
            if (!taken) {
                this.ignore = this.branches.size();
            }
            return taken;
        }
        this.branches.push(FALSE);
        return false;
    }

    public boolean queryCurrentBranchForElif() {
        if (this.ignore != -1 && this.ignore < this.branches.size()) {
            return true;
        }
        return (Boolean)this.branches.peek() == false;
    }

    public boolean queryCurrentBranchForIf() {
        if (this.branches.isEmpty()) {
            return true;
        }
        if (this.ignore != -1 & this.ignore < this.branches.size()) {
            return false;
        }
        return (Boolean)this.branches.peek();
    }

    public boolean poundElif(boolean taken) throws EmptyStackException {
        if (this.ignore != -1 && this.ignore < this.branches.size()) {
            this.branches.pop();
            this.branches.push(FALSE);
            return false;
        }
        Boolean branchAlreadyTaken = (Boolean)this.branches.peek();
        if (this.ignore == -1) {
            if (!branchAlreadyTaken.booleanValue()) {
                this.branches.pop();
                this.branches.push(new Boolean(taken));
                if (!taken) {
                    this.ignore = this.branches.size();
                }
                return taken;
            }
            this.ignore = this.branches.size();
            return false;
        }
        if (!branchAlreadyTaken.booleanValue()) {
            this.branches.pop();
            this.branches.push(new Boolean(taken));
            if (taken) {
                this.ignore = -1;
            }
            return taken;
        }
        this.ignore = this.branches.size();
        return false;
    }

    public boolean poundElse() throws EmptyStackException {
        if (this.ignore != -1 && this.ignore < this.branches.size()) {
            this.branches.pop();
            this.branches.push(FALSE);
            return false;
        }
        Boolean branchAlreadyTaken = (Boolean)this.branches.peek();
        if (this.ignore == -1) {
            if (branchAlreadyTaken.booleanValue()) {
                this.ignore = this.branches.size();
                return false;
            }
            this.branches.pop();
            this.branches.push(TRUE);
            return true;
        }
        if (branchAlreadyTaken.booleanValue()) {
            this.ignore = this.branches.size();
            return false;
        }
        this.branches.pop();
        this.branches.push(TRUE);
        this.ignore = -1;
        return true;
    }

    public boolean poundEndif() throws EmptyStackException {
        if (this.ignore == this.branches.size()) {
            this.ignore = -1;
        }
        this.branches.pop();
        return this.ignore == -1;
    }

    public int getDepth() {
        return this.branches.size();
    }
}

