/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.scanner2;

import org.eclipse.cdt.internal.core.parser.scanner2.CharTable;

public class CharArrayPool
extends CharTable {
    public CharArrayPool(int tableSize) {
        super(tableSize);
    }

    private final void remove() {
        int hash = this.hash(this.keyTable[this.currEntry], 0, this.keyTable[this.currEntry].length);
        int i = this.hashTable[hash] - 1;
        if (i == this.currEntry) {
            this.hashTable[hash] = this.nextTable[this.currEntry];
        } else {
            do {
                int last = i;
            } while ((i = this.nextTable[i] - 1) != this.currEntry);
            this.nextTable[last] = this.nextTable[this.currEntry];
        }
        this.keyTable[this.currEntry] = null;
        this.nextTable[this.currEntry] = 0;
    }

    private final void addHashed(char[] str, int hash) {
        if (++this.currEntry == this.keyTable.length) {
            this.currEntry = 0;
        }
        if (this.keyTable[this.currEntry] != null) {
            this.remove();
        }
        this.keyTable[this.currEntry] = str;
        if (this.hashTable[hash] != 0) {
            this.nextTable[this.currEntry] = this.hashTable[hash];
        }
        this.hashTable[hash] = this.currEntry + 1;
    }

    public final char[] add(char[] source, int start, int length) {
        int hash = this.hash(source, start, length);
        int result = this.lookup(source, start, length, hash);
        if (result >= 0) {
            return this.keyTable[result];
        }
        char[] res = new char[length];
        System.arraycopy(source, 0, res, 0, length);
        this.addHashed(res, hash);
        return res;
    }

    public final char[] add(char[] source) {
        return this.add(source, 0, source.length);
    }
}

