/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.actions;

import org.eclipse.cdt.debug.core.CDIDebugModel;
import org.eclipse.cdt.debug.core.model.IRunToAddress;
import org.eclipse.cdt.debug.core.model.IRunToLine;
import org.eclipse.cdt.debug.internal.ui.actions.ActionMessages;
import org.eclipse.cdt.debug.internal.ui.views.disassembly.DisassemblyEditorInput;
import org.eclipse.cdt.debug.internal.ui.views.disassembly.DisassemblyView;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.ISuspendResume;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.ui.IDebugUIConstants;
import org.eclipse.debug.ui.actions.IRunToLineTarget;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.ITextEditor;

public class RunToLineAdapter
implements IRunToLineTarget {
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void runToLine(IWorkbenchPart part, ISelection selection, ISuspendResume target) throws CoreException {
        String errorMessage = null;
        if (part instanceof IEditorPart) {
            IRunToLine runToLine;
            IEditorPart editorPart = (IEditorPart)part;
            IEditorInput input = editorPart.getEditorInput();
            if (input == null) {
                errorMessage = ActionMessages.getString("RunToLineAdapter.Empty_editor_1");
                throw new CoreException((IStatus)new Status(4, CDebugUIPlugin.getUniqueIdentifier(), 150, errorMessage, null));
            }
            ITextEditor textEditor = (ITextEditor)editorPart;
            IDocument document = textEditor.getDocumentProvider().getDocument((Object)input);
            if (document == null) {
                errorMessage = ActionMessages.getString("RunToLineAdapter.Missing_document_1");
                throw new CoreException((IStatus)new Status(4, CDebugUIPlugin.getUniqueIdentifier(), 150, errorMessage, null));
            }
            String fileName = this.getFileName(input);
            ITextSelection textSelection = (ITextSelection)selection;
            int lineNumber = textSelection.getStartLine() + 1;
            if (!(target instanceof IAdaptable)) return;
            IAdaptable iAdaptable = (IAdaptable)target;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.cdt.debug.core.model.IRunToLine");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((runToLine = (IRunToLine)iAdaptable.getAdapter((Class)clazz)) == null || !runToLine.canRunToLine(fileName, lineNumber)) return;
            runToLine.runToLine(fileName, lineNumber, DebugUIPlugin.getDefault().getPluginPreferences().getBoolean(IDebugUIConstants.PREF_SKIP_BREAKPOINTS_DURING_RUN_TO_LINE));
            return;
        }
        if (part instanceof DisassemblyView) {
            IRunToAddress runToAddress;
            IEditorInput input = ((DisassemblyView)part).getInput();
            if (!(input instanceof DisassemblyEditorInput)) {
                errorMessage = ActionMessages.getString("RunToLineAdapter.Empty_editor_1");
                throw new CoreException((IStatus)new Status(4, CDebugUIPlugin.getUniqueIdentifier(), 150, errorMessage, null));
            }
            ITextSelection textSelection = (ITextSelection)selection;
            int lineNumber = textSelection.getStartLine() + 1;
            long address = ((DisassemblyEditorInput)input).getAddress(lineNumber);
            if (!(target instanceof IAdaptable)) return;
            IAdaptable iAdaptable = (IAdaptable)target;
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.cdt.debug.core.model.IRunToAddress");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((runToAddress = (IRunToAddress)iAdaptable.getAdapter((Class)clazz)) == null || !runToAddress.canRunToAddress(address)) return;
            runToAddress.runToAddress(address, DebugUIPlugin.getDefault().getPluginPreferences().getBoolean(IDebugUIConstants.PREF_SKIP_BREAKPOINTS_DURING_RUN_TO_LINE));
            return;
        }
        errorMessage = ActionMessages.getString("RunToLineAdapter.Operation_is_not_supported_1");
        throw new CoreException((IStatus)new Status(4, CDebugUIPlugin.getUniqueIdentifier(), 150, errorMessage, null));
    }

    public boolean canRunToLine(IWorkbenchPart part, ISelection selection, ISuspendResume target) {
        return target instanceof IDebugElement && ((IDebugElement)target).getModelIdentifier().equals(CDIDebugModel.getPluginIdentifier());
    }

    private String getFileName(IEditorInput input) throws CoreException {
        if (input instanceof IFileEditorInput) {
            return ((IFileEditorInput)input).getFile().getName();
        }
        if (input instanceof IStorageEditorInput) {
            return ((IStorageEditorInput)input).getStorage().getName();
        }
        return null;
    }
}

