/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.ui.properties;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.SortedMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IOptionCategory;
import org.eclipse.cdt.managedbuilder.core.ITarget;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.ui.ManagedBuilderUIMessages;
import org.eclipse.cdt.managedbuilder.ui.properties.BuildOptionSettingsPage;
import org.eclipse.cdt.managedbuilder.ui.properties.BuildSettingsPage;
import org.eclipse.cdt.managedbuilder.ui.properties.BuildToolSettingsPage;
import org.eclipse.cdt.managedbuilder.ui.properties.BuildToolsSettingsStore;
import org.eclipse.cdt.managedbuilder.ui.properties.ManageConfigDialog;
import org.eclipse.cdt.managedbuilder.ui.properties.ToolListContentProvider;
import org.eclipse.cdt.managedbuilder.ui.properties.ToolListLabelProvider;
import org.eclipse.cdt.utils.ui.controls.ControlFactory;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.preference.IPreferencePageContainer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.help.WorkbenchHelp;

public class BuildPropertyPage
extends PropertyPage
implements IWorkbenchPropertyPage,
IPreferencePageContainer {
    private static final String PREFIX = "BuildPropertyPage";
    private static final String LABEL = "BuildPropertyPage.label";
    private static final String NAME_LABEL = "BuildPropertyPage.label.NameText";
    private static final String BUILD_TOOLS_LABEL = "BuildPropertyPage.label.BuildToolTree";
    private static final String PLATFORM_LABEL = "BuildPropertyPage.label.Platform";
    private static final String CONFIG_LABEL = "BuildPropertyPage.label.Configuration";
    private static final String ALL_CONFS = "BuildPropertyPage.selection.configuration.all";
    private static final String ACTIVE_LABEL = "BuildPropertyPage.label.Active";
    private static final String SETTINGS_LABEL = "BuildPropertyPage.label.Settings";
    private static final String TREE_LABEL = "BuildPropertyPage.label.ToolTree";
    private static final String OPTIONS_LABEL = "BuildPropertyPage.label.ToolOptions";
    private static final String ADD_CONF = "BuildPropertyPage.label.AddConfButton";
    private static final String TIP = "BuildPropertyPage.tip";
    private static final String PLAT_TIP = "BuildPropertyPage.tip.platform";
    private static final String CONF_TIP = "BuildPropertyPage.tip.config";
    private static final String ADD_TIP = "BuildPropertyPage.tip.addconf";
    private static final String MANAGE_TITLE = "BuildPropertyPage.manage.title";
    private static final int[] DEFAULT_SASH_WEIGHTS = new int[]{20, 30};
    private static final String ID_SEPARATOR = ".";
    private Combo targetSelector;
    private Combo configSelector;
    private Button manageConfigs;
    private TreeViewer optionList;
    private SashForm sashForm;
    private Group sashGroup;
    private Composite settingsPageContainer;
    private ScrolledComposite containerSC;
    private ITarget[] targets;
    private ITarget selectedTarget;
    private IConfiguration[] configurations;
    private IConfiguration selectedConfiguration;
    private BuildSettingsPage currentSettingsPage;
    private Map configToPageListMap;
    private BuildToolsSettingsStore settingsStore;
    private Map settingsStoreMap;
    private IOptionCategory selectedCategory;
    private Point lastShellSize;
    private ITool selectedTool;
    private Point minimumPageSize = new Point(200, 200);
    private ToolListContentProvider provider;

    public BuildPropertyPage() {
        this.configToPageListMap = new HashMap();
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        composite.setLayout((Layout)new GridLayout(1, true));
        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)this.getProject());
        if (info.getVersion() == null) {
            Label invalidInfo = new Label(composite, 16384);
            invalidInfo.setFont(composite.getFont());
            invalidInfo.setText(ManagedBuilderUIMessages.getResourceString("BuildPropertyPage.error.version_low"));
            invalidInfo.setLayoutData((Object)new GridData(32, 4, true, true));
            return composite;
        }
        this.targets = ManagedBuildManager.getTargets((IResource)this.getProject());
        ITarget defaultTarget = info.getDefaultTarget();
        Group configGroup = ControlFactory.createGroup((Composite)composite, (String)ManagedBuilderUIMessages.getResourceString(ACTIVE_LABEL), (int)1);
        GridData gd = new GridData(256);
        gd.grabExcessHorizontalSpace = true;
        configGroup.setLayoutData((Object)gd);
        FormLayout form = new FormLayout();
        form.marginHeight = 5;
        form.marginWidth = 5;
        configGroup.setLayout((Layout)form);
        Label platformLabel = ControlFactory.createLabel((Composite)configGroup, (String)ManagedBuilderUIMessages.getResourceString(PLATFORM_LABEL));
        this.targetSelector = ControlFactory.createSelectCombo((Composite)configGroup, (String[])this.getPlatformNames(), (String)defaultTarget.getName());
        this.targetSelector.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                BuildPropertyPage.this.handleTargetSelection();
            }
        });
        this.targetSelector.setToolTipText(ManagedBuilderUIMessages.getResourceString(PLAT_TIP));
        Label configLabel = ControlFactory.createLabel((Composite)configGroup, (String)ManagedBuilderUIMessages.getResourceString(CONFIG_LABEL));
        this.configSelector = new Combo((Composite)configGroup, 12);
        this.configSelector.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                BuildPropertyPage.this.handleConfigSelection();
            }
        });
        this.configSelector.setToolTipText(ManagedBuilderUIMessages.getResourceString(CONF_TIP));
        this.manageConfigs = ControlFactory.createPushButton((Composite)configGroup, (String)ManagedBuilderUIMessages.getResourceString(ADD_CONF));
        this.manageConfigs.setToolTipText(ManagedBuilderUIMessages.getResourceString(ADD_TIP));
        this.manageConfigs.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BuildPropertyPage.this.handleManageConfig();
            }
        });
        FormData fd = new FormData();
        fd.top = new FormAttachment((Control)this.targetSelector, 0, 0x1000000);
        platformLabel.setLayoutData((Object)fd);
        fd = new FormData();
        fd.top = new FormAttachment((Control)this.configSelector, 0, 0x1000000);
        configLabel.setLayoutData((Object)fd);
        fd = new FormData();
        fd.left = new FormAttachment((Control)this.configSelector, 0, 16384);
        fd.right = new FormAttachment(100, 0);
        this.targetSelector.setLayoutData((Object)fd);
        fd = new FormData();
        fd.top = new FormAttachment((Control)this.configSelector, 0, 0x1000000);
        fd.right = new FormAttachment(100, 0);
        this.manageConfigs.setLayoutData((Object)fd);
        Label longestLabel = platformLabel.getText().length() > configLabel.getText().length() ? platformLabel : configLabel;
        fd = new FormData();
        fd.left = new FormAttachment((Control)longestLabel, 5);
        fd.top = new FormAttachment(55, 0);
        fd.right = new FormAttachment((Control)this.manageConfigs, -5, 16384);
        this.configSelector.setLayoutData((Object)fd);
        this.sashGroup = ControlFactory.createGroup((Composite)composite, (String)ManagedBuilderUIMessages.getResourceString(SETTINGS_LABEL), (int)1);
        this.sashGroup.setLayoutData((Object)new GridData(1808));
        this.sashForm = new SashForm((Composite)this.sashGroup, 0);
        this.sashForm.setOrientation(256);
        this.sashForm.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        this.sashForm.setLayout((Layout)layout);
        this.createSelectionArea((Composite)this.sashForm);
        this.createEditArea((Composite)this.sashForm);
        this.initializeSashForm();
        this.handleTargetSelection();
        WorkbenchHelp.setHelp((Control)composite, (String)"org.eclipse.cdt.ui.man_prop_build");
        return composite;
    }

    protected void createEditArea(Composite parent) {
        this.containerSC = new ScrolledComposite(parent, 768);
        this.containerSC.setExpandHorizontal(true);
        this.containerSC.setExpandVertical(true);
        this.settingsPageContainer = new Composite((Composite)this.containerSC, 0);
        this.settingsPageContainer.setLayout((Layout)new PageLayout());
        this.containerSC.setContent((Control)this.settingsPageContainer);
        this.containerSC.setMinSize(this.settingsPageContainer.computeSize(-1, -1));
        this.settingsPageContainer.layout();
    }

    protected void createSelectionArea(Composite parent) {
        Composite composite = ControlFactory.createComposite((Composite)parent, (int)1);
        this.optionList = new TreeViewer(composite, 2820);
        this.optionList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                BuildPropertyPage.this.handleOptionSelection();
            }
        });
        this.optionList.getControl().setLayoutData((Object)new GridData(1808));
        this.optionList.setLabelProvider((IBaseLabelProvider)new ToolListLabelProvider());
    }

    private void displayOptionsForCategory(IOptionCategory category) {
        if (category == this.selectedCategory) {
            return;
        }
        this.selectedTool = null;
        this.selectedCategory = category;
        BuildSettingsPage oldPage = this.currentSettingsPage;
        this.currentSettingsPage = null;
        List pages = this.getPagesForConfig();
        ListIterator iter = pages.listIterator();
        while (iter.hasNext()) {
            BuildSettingsPage page = (BuildSettingsPage)((Object)iter.next());
            if (!(page instanceof BuildOptionSettingsPage) || !((BuildOptionSettingsPage)page).isForCategory(category)) continue;
            this.currentSettingsPage = page;
            break;
        }
        if (this.currentSettingsPage == null) {
            this.currentSettingsPage = new BuildOptionSettingsPage(this.selectedConfiguration, category);
            pages.add(this.currentSettingsPage);
            this.currentSettingsPage.setContainer(this);
            if (this.currentSettingsPage.getControl() == null) {
                this.currentSettingsPage.createControl(this.settingsPageContainer);
            }
        }
        Control[] children = this.settingsPageContainer.getChildren();
        Control currentControl = this.currentSettingsPage.getControl();
        int i = 0;
        while (i < children.length) {
            if (children[i] != currentControl) {
                children[i].setVisible(false);
            }
            ++i;
        }
        this.currentSettingsPage.setVisible(true);
        if (oldPage != null) {
            if (oldPage instanceof BuildOptionSettingsPage) {
                ((BuildOptionSettingsPage)oldPage).storeSettings();
            } else if (oldPage instanceof BuildToolSettingsPage) {
                ((BuildToolSettingsPage)oldPage).storeSettings();
                ((BuildToolSettingsPage)oldPage).parseAllOptions();
            }
        }
        if (this.currentSettingsPage instanceof BuildOptionSettingsPage) {
            ((BuildOptionSettingsPage)this.currentSettingsPage).updateFields();
        }
        if (oldPage != null) {
            oldPage.setVisible(false);
        }
        this.containerSC.setMinSize(this.currentSettingsPage.computeSize());
        this.settingsPageContainer.layout();
    }

    private void displayOptionsForTool(ITool tool) {
        if (tool == this.selectedTool) {
            return;
        }
        this.selectedCategory = null;
        this.selectedTool = tool;
        BuildSettingsPage oldPage = this.currentSettingsPage;
        this.currentSettingsPage = null;
        List pages = this.getPagesForConfig();
        ListIterator iter = pages.listIterator();
        while (iter.hasNext()) {
            BuildSettingsPage page = (BuildSettingsPage)((Object)iter.next());
            if (!(page instanceof BuildToolSettingsPage) || !((BuildToolSettingsPage)page).isForTool(tool)) continue;
            this.currentSettingsPage = page;
            break;
        }
        if (this.currentSettingsPage == null) {
            this.currentSettingsPage = new BuildToolSettingsPage(this.selectedConfiguration, tool);
            pages.add(this.currentSettingsPage);
            this.currentSettingsPage.setContainer(this);
            if (this.currentSettingsPage.getControl() == null) {
                this.currentSettingsPage.createControl(this.settingsPageContainer);
            }
        }
        Control[] children = this.settingsPageContainer.getChildren();
        Control currentControl = this.currentSettingsPage.getControl();
        int i = 0;
        while (i < children.length) {
            if (children[i] != currentControl) {
                children[i].setVisible(false);
            }
            ++i;
        }
        this.currentSettingsPage.setVisible(true);
        if (oldPage != null) {
            if (oldPage instanceof BuildOptionSettingsPage) {
                ((BuildOptionSettingsPage)oldPage).storeSettings();
            } else if (oldPage instanceof BuildToolSettingsPage) {
                ((BuildToolSettingsPage)oldPage).storeSettings();
                ((BuildToolSettingsPage)oldPage).parseAllOptions();
            }
        }
        if (this.currentSettingsPage instanceof BuildToolSettingsPage) {
            ((BuildToolSettingsPage)this.currentSettingsPage).updateAllOptionField();
        }
        if (oldPage != null) {
            oldPage.setVisible(false);
        }
        this.containerSC.setMinSize(this.currentSettingsPage.computeSize());
        this.settingsPageContainer.layout();
    }

    private String[] getConfigurationNames() {
        String[] names = new String[this.configurations.length];
        int index = 0;
        while (index < this.configurations.length) {
            names[index] = this.configurations[index].getName();
            ++index;
        }
        return names;
    }

    protected Point getLastShellSize() {
        Shell shell;
        if (this.lastShellSize == null && (shell = this.getShell()) != null) {
            this.lastShellSize = shell.getSize();
        }
        return this.lastShellSize;
    }

    private List getPagesForConfig() {
        if (this.selectedConfiguration == null) {
            return null;
        }
        ArrayList pages = (ArrayList)this.configToPageListMap.get(this.selectedConfiguration.getId());
        if (pages == null) {
            pages = new ArrayList();
            this.configToPageListMap.put(this.selectedConfiguration.getId(), pages);
        }
        return pages;
    }

    private String[] getPlatformNames() {
        String[] names = new String[this.targets.length];
        int index = 0;
        while (index < this.targets.length) {
            names[index] = this.targets[index].getName();
            ++index;
        }
        return names;
    }

    public IPreferenceStore getPreferenceStore() {
        return this.settingsStore;
    }

    private IProject getProject() {
        IAdaptable element = this.getElement();
        if (element != null && element instanceof IProject) {
            return (IProject)element;
        }
        return null;
    }

    public ITarget getSelectedTarget() {
        return this.selectedTarget;
    }

    protected IConfiguration getSelectedConfiguration() {
        return this.selectedConfiguration;
    }

    protected Map getSettingsStoreMap() {
        if (this.settingsStoreMap == null) {
            this.settingsStoreMap = new HashMap();
        }
        return this.settingsStoreMap;
    }

    private void handleConfigSelection() {
        Object primary;
        if (this.configSelector.getItemCount() == 0) {
            return;
        }
        int selectionIndex = this.configSelector.getSelectionIndex();
        if (selectionIndex == -1) {
            return;
        }
        String configName = this.configSelector.getItem(selectionIndex);
        if (configName.equals(ManagedBuilderUIMessages.getResourceString(ALL_CONFS))) {
            return;
        }
        this.selectedConfiguration = this.configurations[selectionIndex];
        if (this.provider == null) {
            this.provider = new ToolListContentProvider();
            this.optionList.setContentProvider((IContentProvider)this.provider);
        }
        this.optionList.setInput((Object)this.selectedConfiguration);
        this.optionList.expandAll();
        BuildToolsSettingsStore store = (BuildToolsSettingsStore)this.getSettingsStoreMap().get(this.selectedConfiguration.getId());
        if (store == null) {
            store = new BuildToolsSettingsStore(this.selectedConfiguration);
            this.getSettingsStoreMap().put(this.selectedConfiguration.getId(), store);
        }
        this.settingsStore = store;
        Object[] elements = this.provider.getElements(this.selectedConfiguration);
        Object object = primary = elements.length > 0 ? elements[0] : null;
        if (primary != null) {
            this.optionList.setSelection((ISelection)new StructuredSelection(primary));
        }
    }

    private void handleManageConfig() {
        ManageConfigDialog manageDialog = new ManageConfigDialog(this.getShell(), ManagedBuilderUIMessages.getResourceString(MANAGE_TITLE), this.selectedTarget);
        if (manageDialog.open() == 0) {
            boolean updateConfigs = false;
            String newBuildOutput = manageDialog.getBuildArtifactName();
            if (!this.selectedTarget.getArtifactName().equals(newBuildOutput)) {
                this.selectedTarget.setArtifactName(newBuildOutput);
            }
            String newBuildExt = manageDialog.getBuildArtifaceExtension();
            if (!this.selectedTarget.getArtifactExtension().equals(newBuildExt)) {
                this.selectedTarget.setArtifactExtension(newBuildExt);
            }
            if (manageDialog.useDefaultMakeCommand()) {
                this.selectedTarget.resetMakeCommand();
            } else {
                String rawCommand = manageDialog.getMakeCommand();
                String makeCommand = this.parseMakeCommand(rawCommand);
                this.selectedTarget.setMakeCommand(makeCommand);
                String makeArguments = this.parseMakeArgs(rawCommand);
                this.selectedTarget.setMakeArguments(makeArguments);
            }
            ArrayList deletedConfigs = manageDialog.getDeletedConfigIds();
            ListIterator iter = deletedConfigs.listIterator();
            while (iter.hasNext()) {
                String id = (String)iter.next();
                this.selectedTarget.removeConfiguration(id);
                this.getSettingsStoreMap().remove(id);
                this.configurations = this.selectedTarget.getConfigurations();
                this.configSelector.removeAll();
                this.configSelector.setItems(this.getConfigurationNames());
                this.configSelector.select(0);
                updateConfigs = true;
            }
            SortedMap newConfigs = manageDialog.getNewConfigs();
            Set keys = newConfigs.keySet();
            Iterator keyIter = keys.iterator();
            Random r = new Random();
            r.setSeed(System.currentTimeMillis());
            while (keyIter.hasNext()) {
                String lastComponent;
                String newId;
                int index;
                String name = (String)keyIter.next();
                IConfiguration parent = (IConfiguration)newConfigs.get(name);
                if (parent == null) continue;
                int id = r.nextInt();
                if (id < 0) {
                    id *= -1;
                }
                if ((index = (newId = parent.getId()).lastIndexOf(ID_SEPARATOR)) > 0 && Character.isDigit((lastComponent = newId.substring(index + 1, newId.length())).charAt(0))) {
                    newId = newId.substring(0, index);
                }
                newId = String.valueOf(newId) + ID_SEPARATOR + id;
                IConfiguration newConfig = this.selectedTarget.createConfiguration(parent, newId);
                newConfig.setName(name);
                this.configurations = this.selectedTarget.getConfigurations();
                this.configSelector.removeAll();
                this.configSelector.setItems(this.getConfigurationNames());
                this.configSelector.select(this.configSelector.indexOf(name));
                updateConfigs = true;
            }
            if (updateConfigs) {
                this.handleConfigSelection();
            }
        }
    }

    private void handleOptionSelection() {
        IStructuredSelection selection = (IStructuredSelection)this.optionList.getSelection();
        Object element = selection.getFirstElement();
        if (element instanceof ITool) {
            this.displayOptionsForTool((ITool)element);
        } else if (element instanceof IOptionCategory) {
            this.displayOptionsForCategory((IOptionCategory)element);
        }
    }

    private void handleTargetSelection() {
        if (this.targetSelector.getItemCount() == 0) {
            this.manageConfigs.setEnabled(false);
            return;
        }
        this.manageConfigs.setEnabled(true);
        this.selectedTarget = this.targets[this.targetSelector.getSelectionIndex()];
        ManagedBuildManager.setSelectedTarget((IProject)this.getProject(), (ITarget)this.selectedTarget);
        this.populateConfigurations();
    }

    protected void initializeSashForm() {
        this.sashForm.setWeights(DEFAULT_SASH_WEIGHTS);
    }

    private String parseMakeArgs(String rawCommand) {
        StringBuffer result = new StringBuffer();
        String actualCommand = this.parseMakeCommand(rawCommand);
        String arguments = rawCommand.substring(actualCommand.length());
        if (arguments.length() == 0) {
            return result.toString().trim();
        }
        String[] tokens = arguments.trim().split("\\s");
        Pattern flagPattern = Pattern.compile("C|f|I|j|l|O|W");
        Pattern mixedFlagWithArg = Pattern.compile("-[^CfIjloW]*[CfIjloW]{1}.+");
        int i = 0;
        while (i < tokens.length) {
            String currentToken = tokens[i];
            if (currentToken.startsWith("--")) {
                result.append(currentToken);
                result.append(" ");
            } else if (currentToken.startsWith("-")) {
                if (i + 1 >= tokens.length) {
                    result.append(currentToken);
                } else {
                    String nextToken = tokens[i + 1];
                    Matcher flagMatcher = flagPattern.matcher(currentToken);
                    if (!flagMatcher.find()) {
                        result.append(currentToken);
                        result.append(" ");
                    } else if (mixedFlagWithArg.matcher(currentToken).matches()) {
                        result.append(currentToken);
                        result.append(" ");
                    } else {
                        result.append(currentToken);
                        result.append(" ");
                        result.append(nextToken);
                        result.append(" ");
                        ++i;
                    }
                }
            }
            ++i;
        }
        return result.toString().trim();
    }

    private String parseMakeCommand(String rawCommand) {
        StringBuffer command = new StringBuffer();
        String[] result = rawCommand.split("\\s");
        int i = 0;
        while (i < result.length) {
            String cmdSegment = result[i];
            if (i + 1 >= result.length) {
                command.append(cmdSegment);
            } else {
                String nextSegment = result[i + 1];
                if (nextSegment.startsWith("-")) {
                    command.append(cmdSegment);
                    break;
                }
                command.append(cmdSegment);
                command.append(" ");
            }
            ++i;
        }
        return command.toString().trim();
    }

    protected void performDefaults() {
        List pages = this.getPagesForConfig();
        pages.clear();
        ManagedBuildManager.resetConfiguration((IProject)this.getProject(), (IConfiguration)this.getSelectedConfiguration());
        this.settingsStore = new BuildToolsSettingsStore(this.getSelectedConfiguration());
        ManagedBuildManager.setDefaultConfiguration((IProject)this.getProject(), (IConfiguration)this.getSelectedConfiguration());
        ManagedBuildManager.saveBuildInfo((IProject)this.getProject(), (boolean)false);
        this.selectedCategory = null;
        this.selectedTool = null;
        this.handleOptionSelection();
    }

    public boolean performOk() {
        List pages = this.getPagesForConfig();
        if (pages == null) {
            return true;
        }
        ListIterator iter = pages.listIterator();
        while (iter.hasNext()) {
            BuildSettingsPage page = (BuildSettingsPage)((Object)iter.next());
            if (page == null) continue;
            if (page instanceof BuildToolSettingsPage) {
                if (!(this.currentSettingsPage instanceof BuildToolSettingsPage)) {
                    ((BuildToolSettingsPage)page).updateAllOptionField();
                }
                ((BuildToolSettingsPage)page).performOk();
                continue;
            }
            if (!(page instanceof BuildOptionSettingsPage)) continue;
            ((BuildOptionSettingsPage)page).performOk();
        }
        ManagedBuildManager.setDefaultConfiguration((IProject)this.getProject(), (IConfiguration)this.getSelectedConfiguration());
        ManagedBuildManager.saveBuildInfo((IProject)this.getProject(), (boolean)false);
        return true;
    }

    private void populateConfigurations() {
        if (this.configSelector == null) {
            return;
        }
        this.configurations = this.selectedTarget.getConfigurations();
        if (this.configurations.length == 0) {
            return;
        }
        this.configSelector.removeAll();
        this.configSelector.setItems(this.getConfigurationNames());
        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)this.getProject());
        IConfiguration defaultConfig = info.getDefaultConfiguration(this.selectedTarget);
        int index = this.configSelector.indexOf(defaultConfig.getName());
        this.configSelector.select(index == -1 ? 0 : index);
        this.handleConfigSelection();
    }

    public void updateButtons() {
    }

    public void updateMessage() {
    }

    public void updateTitle() {
    }

    private class PageLayout
    extends Layout {
        PageLayout() {
        }

        public void layout(Composite composite, boolean force) {
            Rectangle rect = composite.getClientArea();
            Control[] children = composite.getChildren();
            int i = 0;
            while (i < children.length) {
                children[i].setSize(rect.width, rect.height);
                ++i;
            }
        }

        public Point computeSize(Composite composite, int wHint, int hHint, boolean force) {
            if (wHint != -1 && hHint != -1) {
                return new Point(wHint, hHint);
            }
            int x = ((BuildPropertyPage)BuildPropertyPage.this).minimumPageSize.x;
            int y = ((BuildPropertyPage)BuildPropertyPage.this).minimumPageSize.y;
            Control[] children = composite.getChildren();
            int i = 0;
            while (i < children.length) {
                Point size = children[i].computeSize(-1, -1, force);
                x = Math.max(x, size.x);
                y = Math.max(y, size.y);
                ++i;
            }
            if (wHint != -1) {
                x = wHint;
            }
            if (hHint != -1) {
                y = hHint;
            }
            return new Point(x, y);
        }
    }
}

