/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.ui.properties;

import java.util.ArrayList;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.ITarget;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.ui.ManagedBuilderUIMessages;
import org.eclipse.cdt.managedbuilder.ui.properties.NewConfigurationDialog;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ManageConfigDialog
extends Dialog {
    private static final String CMN_PREFIX = "BuildPropertyCommon";
    private static final String CMN_LABEL = "BuildPropertyCommon.label";
    private static final String NEW = "BuildPropertyCommon.label.new";
    private static final String REMOVE = "BuildPropertyCommon.label.remove";
    private static final String PREFIX = "ManageConfig";
    private static final String LABEL = "ManageConfig.label";
    private static final String RESTORE = "ManageConfig.label.restore";
    private static final String GROUP = "ManageConfig.label.makecmdgroup";
    private static final String DEF_BTN = "ManageConfig.label.makecmddef";
    private static final String OUTPUT_GROUP = "ManageConfig.label.output.group";
    private static final String OUTPUT_EXT = "ManageConfig.label.output.extension";
    private static final String OUTPUT_NAME = "ManageConfig.label.output.name";
    private static final String CONFIGS = "ManageConfig.label.configs";
    private static final String CURRENT_CONFIGS = "ManageConfig.label.configs.current";
    private static final String DELETED_CONFIGS = "ManageConfig.label.configs.deleted";
    private static final String CONF_DLG = "ManageConfig.label.new.config.dialog";
    private String artifactExt;
    private String artifactName;
    private SortedMap deletedConfigs;
    private SortedMap existingConfigs;
    private String makeCommand;
    private ITarget managedTarget;
    private SortedMap newConfigs;
    private String title = "";
    private boolean useDefaultMake;
    protected Text buildArtifactExt;
    protected Text buildArtifactName;
    protected List currentConfigList;
    protected List deletedConfigList;
    protected Button makeCommandDefault;
    protected Text makeCommandEntry;
    protected Button newBtn;
    protected Button okBtn;
    protected Button removeBtn;
    protected Button restoreBtn;

    protected ManageConfigDialog(Shell parentShell, String title, ITarget target) {
        super(parentShell);
        this.title = title;
        this.managedTarget = target;
        this.setMakeCommand();
        this.artifactExt = this.managedTarget.getArtifactExtension();
        this.artifactName = this.managedTarget.getArtifactName();
        this.getExistingConfigs().clear();
        IConfiguration[] configs = this.managedTarget.getConfigurations();
        int i = 0;
        while (i < configs.length) {
            IConfiguration configuration = configs[i];
            this.getExistingConfigs().put(configuration.getName(), configuration.getId());
            ++i;
        }
        this.getDeletedConfigs().clear();
        this.getNewConfigs().clear();
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.useDefaultMake = this.makeCommandDefault.getSelection();
            this.makeCommand = this.makeCommandEntry.getText().trim();
            this.artifactName = this.buildArtifactName.getText().trim();
            this.artifactExt = this.buildArtifactExt.getText().trim();
        } else {
            this.useDefaultMake = true;
            this.artifactName = this.managedTarget.getArtifactName();
        }
        super.buttonPressed(buttonId);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.title != null) {
            shell.setText(this.title);
        }
    }

    private void createBuildArtifactGroup(Composite parent) {
        Group outputGroup = new Group(parent, 0);
        outputGroup.setFont(parent.getFont());
        outputGroup.setText(ManagedBuilderUIMessages.getResourceString(OUTPUT_GROUP));
        outputGroup.setLayout((Layout)new GridLayout(3, false));
        outputGroup.setLayoutData((Object)new GridData(768));
        Label nameLabel = new Label((Composite)outputGroup, 16384);
        nameLabel.setFont(outputGroup.getFont());
        nameLabel.setText(ManagedBuilderUIMessages.getResourceString(OUTPUT_NAME));
        nameLabel.setLayoutData((Object)new GridData(768));
        Label placeHolder = new Label((Composite)outputGroup, 0x1000000);
        placeHolder.setText(new String());
        placeHolder.setLayoutData((Object)new GridData());
        Label extLabel = new Label((Composite)outputGroup, 16384);
        extLabel.setFont(outputGroup.getFont());
        extLabel.setText(ManagedBuilderUIMessages.getResourceString(OUTPUT_EXT));
        extLabel.setLayoutData((Object)new GridData(768));
        this.buildArtifactName = new Text((Composite)outputGroup, 2052);
        this.buildArtifactName.setFont(outputGroup.getFont());
        this.buildArtifactName.setText(this.artifactName);
        GridData data = new GridData(768);
        data.widthHint = 200;
        this.buildArtifactName.setLayoutData((Object)data);
        this.buildArtifactName.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                ManageConfigDialog.this.buildArtifactName = null;
            }
        });
        this.buildArtifactName.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = ManagedBuilderUIMessages.getResourceString(ManageConfigDialog.OUTPUT_NAME);
            }
        });
        Label dotLabel = new Label((Composite)outputGroup, 0x1000000);
        dotLabel.setFont(outputGroup.getFont());
        dotLabel.setText(new String("."));
        dotLabel.setLayoutData((Object)new GridData());
        this.buildArtifactExt = new Text((Composite)outputGroup, 2052);
        this.buildArtifactExt.setFont(outputGroup.getFont());
        this.buildArtifactExt.setText(this.artifactExt);
        data = new GridData(768);
        data.widthHint = 100;
        this.buildArtifactExt.setLayoutData((Object)data);
        this.buildArtifactExt.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ManageConfigDialog.this.buildArtifactExt = null;
            }
        });
        this.buildArtifactExt.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = ManagedBuilderUIMessages.getResourceString(ManageConfigDialog.OUTPUT_EXT);
            }
        });
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okBtn = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.updateButtons();
    }

    private void createConfigListGroup(Composite parent) {
        Group configListGroup = new Group(parent, 0);
        configListGroup.setFont(parent.getFont());
        configListGroup.setText(ManagedBuilderUIMessages.getResourceString(CONFIGS));
        configListGroup.setLayout((Layout)new GridLayout(3, false));
        configListGroup.setLayoutData((Object)new GridData(1808));
        Label currentConfigLabel = new Label((Composite)configListGroup, 16384);
        currentConfigLabel.setFont(configListGroup.getFont());
        currentConfigLabel.setText(ManagedBuilderUIMessages.getResourceString(CURRENT_CONFIGS));
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        currentConfigLabel.setLayoutData((Object)data);
        Label deletedConfigLabel = new Label((Composite)configListGroup, 16384);
        deletedConfigLabel.setFont(configListGroup.getFont());
        deletedConfigLabel.setText(ManagedBuilderUIMessages.getResourceString(DELETED_CONFIGS));
        deletedConfigLabel.setLayoutData((Object)new GridData());
        this.currentConfigList = new List((Composite)configListGroup, 2820);
        this.currentConfigList.setFont(configListGroup.getFont());
        data = new GridData(1808);
        data.widthHint = 100;
        this.currentConfigList.setLayoutData((Object)data);
        this.currentConfigList.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                ManageConfigDialog.this.currentConfigList = null;
            }
        });
        Composite buttonBar = new Composite((Composite)configListGroup, 0);
        buttonBar.setFont(configListGroup.getFont());
        buttonBar.setLayout((Layout)new GridLayout(1, true));
        buttonBar.setLayoutData((Object)new GridData(1040));
        this.newBtn = new Button(buttonBar, 8);
        this.newBtn.setFont(buttonBar.getFont());
        this.newBtn.setText(ManagedBuilderUIMessages.getResourceString(NEW));
        this.setButtonLayoutData(this.newBtn);
        this.newBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ManageConfigDialog.this.handleNewPressed();
            }
        });
        this.newBtn.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ManageConfigDialog.this.newBtn = null;
            }
        });
        this.removeBtn = new Button(buttonBar, 8);
        this.removeBtn.setFont(buttonBar.getFont());
        this.removeBtn.setText(ManagedBuilderUIMessages.getResourceString(REMOVE));
        this.setButtonLayoutData(this.removeBtn);
        this.removeBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ManageConfigDialog.this.handleRemovePressed();
            }
        });
        this.removeBtn.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ManageConfigDialog.this.removeBtn = null;
            }
        });
        this.restoreBtn = new Button(buttonBar, 8);
        this.restoreBtn.setFont(buttonBar.getFont());
        this.restoreBtn.setText(ManagedBuilderUIMessages.getResourceString(RESTORE));
        this.setButtonLayoutData(this.restoreBtn);
        this.restoreBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ManageConfigDialog.this.handleRestorePressed();
            }
        });
        this.restoreBtn.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ManageConfigDialog.this.restoreBtn = null;
            }
        });
        this.deletedConfigList = new List((Composite)configListGroup, 2820);
        this.deletedConfigList.setFont(configListGroup.getFont());
        data = new GridData(1808);
        data.widthHint = 100;
        this.deletedConfigList.setLayoutData((Object)data);
        this.deletedConfigList.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                ManageConfigDialog.this.deletedConfigList = null;
            }
        });
    }

    protected Control createDialogArea(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setFont(parent.getFont());
        comp.setLayout((Layout)new GridLayout(1, true));
        comp.setLayoutData((Object)new GridData(1808));
        this.createBuildArtifactGroup(comp);
        this.createMakeCommandGroup(comp);
        this.createConfigListGroup(comp);
        this.currentConfigList.setItems(this.getConfigurationNames());
        this.currentConfigList.select(0);
        this.newBtn.setFocus();
        return comp;
    }

    private void createMakeCommandGroup(Composite parent) {
        Group makeCommandGroup = new Group(parent, 0);
        makeCommandGroup.setFont(parent.getFont());
        makeCommandGroup.setText(ManagedBuilderUIMessages.getResourceString(GROUP));
        makeCommandGroup.setLayout((Layout)new GridLayout(1, true));
        makeCommandGroup.setLayoutData((Object)new GridData(768));
        this.makeCommandDefault = new Button((Composite)makeCommandGroup, 16416);
        this.makeCommandDefault.setFont(makeCommandGroup.getFont());
        this.makeCommandDefault.setText(ManagedBuilderUIMessages.getResourceString(DEF_BTN));
        this.setButtonLayoutData(this.makeCommandDefault);
        this.makeCommandDefault.setBackground(makeCommandGroup.getBackground());
        this.makeCommandDefault.setForeground(makeCommandGroup.getForeground());
        this.makeCommandDefault.setSelection(!this.managedTarget.hasOverridenMakeCommand());
        this.makeCommandDefault.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ManageConfigDialog.this.handleUseDefaultPressed();
            }
        });
        this.makeCommandDefault.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                ManageConfigDialog.this.makeCommandDefault = null;
            }
        });
        this.makeCommandEntry = new Text((Composite)makeCommandGroup, 2052);
        this.makeCommandEntry.setFont(makeCommandGroup.getFont());
        this.makeCommandEntry.setEditable(!this.makeCommandDefault.getSelection());
        this.makeCommandEntry.setText(this.makeCommand);
        this.makeCommandEntry.setLayoutData((Object)new GridData(768));
        this.makeCommandEntry.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                ManageConfigDialog.this.makeCommandEntry = null;
            }
        });
    }

    public String getBuildArtifaceExtension() {
        return this.artifactExt;
    }

    public String getBuildArtifactName() {
        return this.artifactName;
    }

    private String[] getConfigurationNames() {
        return this.getExistingConfigs().keySet().toArray(new String[this.getExistingConfigs().size()]);
    }

    protected SortedMap getDeletedConfigs() {
        if (this.deletedConfigs == null) {
            this.deletedConfigs = new TreeMap();
        }
        return this.deletedConfigs;
    }

    public ArrayList getDeletedConfigIds() {
        return new ArrayList(this.getDeletedConfigs().values());
    }

    protected SortedMap getExistingConfigs() {
        if (this.existingConfigs == null) {
            this.existingConfigs = new TreeMap();
        }
        return this.existingConfigs;
    }

    public String getMakeCommand() {
        return this.makeCommand;
    }

    public SortedMap getNewConfigs() {
        if (this.newConfigs == null) {
            this.newConfigs = new TreeMap();
        }
        return this.newConfigs;
    }

    private IProject getProject() {
        return this.managedTarget.getOwner().getProject();
    }

    protected void handleNewPressed() {
        ITarget[] targets = ManagedBuildManager.getDefinedTargets((IProject)this.getProject());
        int i = 0;
        while (i < targets.length) {
            ITarget target = targets[i];
            if (target.getId().equals(this.managedTarget.getParent().getId())) {
                break;
            }
            ++i;
        }
        NewConfigurationDialog dialog = new NewConfigurationDialog(this.getShell(), this.managedTarget, ManagedBuilderUIMessages.getResourceString(CONF_DLG));
        if (dialog.open() == 0) {
            String newConfigName = dialog.getNewName();
            this.getNewConfigs().put(newConfigName, dialog.getParentConfiguration());
            this.currentConfigList.add(newConfigName);
            this.currentConfigList.setSelection(this.currentConfigList.getItemCount() - 1);
        }
        this.updateButtons();
    }

    protected void handleRemovePressed() {
        int selectionIndex = this.currentConfigList.getSelectionIndex();
        if (selectionIndex != -1) {
            String selectedConfigName = this.currentConfigList.getItem(selectionIndex);
            String selectedConfigId = null;
            if (this.getNewConfigs().containsKey(selectedConfigName)) {
                IConfiguration selectedConfig = (IConfiguration)this.getNewConfigs().get(selectedConfigName);
                selectedConfigId = selectedConfig.getId();
                this.getNewConfigs().remove(selectedConfigName);
            } else {
                selectedConfigId = (String)this.getExistingConfigs().get(selectedConfigName);
            }
            this.getDeletedConfigs().put(selectedConfigName, selectedConfigId);
            this.currentConfigList.remove(selectionIndex);
            this.currentConfigList.setSelection(selectionIndex - 1);
            this.deletedConfigList.add(selectedConfigName);
            this.deletedConfigList.setSelection(this.deletedConfigList.getItemCount() - 1);
            this.updateButtons();
        }
    }

    protected void handleRestorePressed() {
        int selectionIndex = this.deletedConfigList.getSelectionIndex();
        if (selectionIndex != -1) {
            String selectedConfigName = this.deletedConfigList.getItem(selectionIndex);
            String selectedConfigId = (String)this.getDeletedConfigs().get(selectedConfigName);
            if (!this.getExistingConfigs().containsKey(selectedConfigName)) {
                IConfiguration restoredConfig = this.managedTarget.getConfiguration(selectedConfigId);
                this.getNewConfigs().put(selectedConfigName, restoredConfig);
            }
            this.getDeletedConfigs().remove(selectedConfigName);
            this.deletedConfigList.remove(selectionIndex);
            this.deletedConfigList.setSelection(selectionIndex - 1);
            this.currentConfigList.add(selectedConfigName);
            this.currentConfigList.setSelection(this.currentConfigList.getItemCount());
            this.updateButtons();
        }
    }

    protected void handleUseDefaultPressed() {
        boolean checked = this.makeCommandDefault.getSelection();
        if (checked) {
            this.managedTarget.resetMakeCommand();
            this.setMakeCommand();
            this.makeCommandEntry.setText(this.makeCommand);
            this.makeCommandEntry.setEditable(false);
        } else {
            this.makeCommandEntry.setEditable(true);
        }
    }

    private void setMakeCommand() {
        this.makeCommand = this.managedTarget.getMakeCommand();
        String makeArgs = this.managedTarget.getMakeArguments();
        if (makeArgs.length() > 0) {
            this.makeCommand = String.valueOf(this.makeCommand) + " " + makeArgs;
        }
    }

    private void updateButtons() {
        this.removeBtn.setEnabled(this.currentConfigList.getItemCount() > 1);
        this.restoreBtn.setEnabled(this.deletedConfigList.getItemCount() > 0);
    }

    public boolean useDefaultMakeCommand() {
        return this.useDefaultMake;
    }
}

