/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Item;

public class ProblemItemMapper {
    private static final int NUMBER_LIST_REUSE = 10;
    private HashMap fPathToItem = new HashMap();
    private Stack fReuseLists = new Stack();

    public void problemsChanged(Collection changedPaths, ILabelProvider lprovider) {
        if (changedPaths.size() <= this.fPathToItem.size()) {
            this.iterateChanges(changedPaths, lprovider);
        } else {
            this.iterateItems(changedPaths, lprovider);
        }
    }

    private void iterateChanges(Collection changedPaths, ILabelProvider lprovider) {
        Iterator elements = changedPaths.iterator();
        while (elements.hasNext()) {
            IPath curr = (IPath)elements.next();
            Object obj = this.fPathToItem.get(curr);
            if (obj == null) continue;
            if (obj instanceof Item) {
                this.refreshIcon(lprovider, (Item)obj);
                continue;
            }
            List list = (List)obj;
            int i = 0;
            while (i < list.size()) {
                this.refreshIcon(lprovider, (Item)list.get(i));
                ++i;
            }
        }
    }

    private void iterateItems(Collection changedPaths, ILabelProvider lprovider) {
        Iterator keys = this.fPathToItem.keySet().iterator();
        while (keys.hasNext()) {
            IPath curr = (IPath)keys.next();
            if (!changedPaths.contains(curr)) continue;
            Object obj = this.fPathToItem.get(curr);
            if (obj instanceof Item) {
                this.refreshIcon(lprovider, (Item)obj);
                continue;
            }
            List list = (List)obj;
            int i = 0;
            while (i < list.size()) {
                this.refreshIcon(lprovider, (Item)list.get(i));
                ++i;
            }
        }
    }

    private void refreshIcon(ILabelProvider lprovider, Item item) {
        if (!item.isDisposed()) {
            Object data = item.getData();
            if (data instanceof ICElement) {
                ((ICElement)data).exists();
            }
            Image old = item.getImage();
            Image image = lprovider.getImage(data);
            if (image != null && image != old) {
                item.setImage(image);
            }
        }
    }

    public void addToMap(Object element, Item item) {
        IPath path = ProblemItemMapper.getCorrespondingPath(element);
        if (path != null) {
            Object existingMapping = this.fPathToItem.get(path);
            if (existingMapping == null) {
                this.fPathToItem.put(path, item);
            } else if (existingMapping instanceof Item) {
                if (existingMapping != item) {
                    List list = this.newList();
                    list.add(existingMapping);
                    list.add(item);
                    this.fPathToItem.put(path, list);
                }
            } else {
                List list = (List)existingMapping;
                if (!list.contains(item)) {
                    list.add(item);
                }
            }
        }
    }

    public void removeFromMap(Object element, Item item) {
        IPath path = ProblemItemMapper.getCorrespondingPath(element);
        if (path != null) {
            Object existingMapping = this.fPathToItem.get(path);
            if (existingMapping == null) {
                return;
            }
            if (existingMapping instanceof Item) {
                this.fPathToItem.remove(path);
            } else {
                List list = (List)existingMapping;
                list.remove(item);
                if (list.isEmpty()) {
                    this.fPathToItem.remove(list);
                    this.releaseList(list);
                }
            }
        }
    }

    private List newList() {
        if (!this.fReuseLists.isEmpty()) {
            return (List)this.fReuseLists.pop();
        }
        return new ArrayList(2);
    }

    private void releaseList(List list) {
        if (this.fReuseLists.size() < 10) {
            this.fReuseLists.push(list);
        }
    }

    public void clearMap() {
        this.fPathToItem.clear();
    }

    private static IPath getCorrespondingPath(Object element) {
        if (element instanceof ICElement) {
            ICElement elem = (ICElement)element;
            return elem.getPath();
        }
        if (element instanceof IResource) {
            return ((IResource)element).getFullPath();
        }
        return null;
    }
}

