/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.launch.ui;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.eclipse.cdt.launch.internal.ui.LaunchImages;
import org.eclipse.cdt.launch.internal.ui.LaunchUIPlugin;
import org.eclipse.cdt.launch.ui.CLaunchConfigurationTab;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.help.WorkbenchHelp;

public class CEnvironmentTab
extends CLaunchConfigurationTab {
    protected Properties fElements;
    protected TableViewer fVariableList;
    protected Button fBtnNew;
    protected Button fBtnEdit;
    protected Button fBtnRemove;
    protected Button fBtnImport;

    public void createControl(Composite parent) {
        this.fElements = new Properties();
        Composite control = new Composite(parent, 0);
        this.setControl((Control)control);
        WorkbenchHelp.setHelp((Control)this.getControl(), (String)"org.eclipse.cdt.launch.launch_configuration_dialog_environment_tab");
        GridLayout gl = new GridLayout(2, false);
        this.createVerticalSpacer(control, 2);
        control.setLayout((Layout)gl);
        this.createVariableList(control);
        this.createButtons(control);
        this.fVariableList.setInput((Object)this.fElements);
        this.fVariableList.getTable().setFocus();
    }

    public void set(String env) {
        this.fElements.clear();
        ByteArrayInputStream input = new ByteArrayInputStream(env.getBytes());
        try {
            this.fElements.load(input);
        }
        catch (IOException iOException) {}
        this.fVariableList.refresh();
        this.fVariableList.getTable().setFocus();
        if (this.fVariableList.getTable().getItemCount() > 0) {
            this.fVariableList.getTable().setSelection(0);
        }
    }

    public String get() {
        String result = new String();
        Object[] entries = this.fElements.entrySet().toArray();
        int i = 0;
        while (i < entries.length) {
            result = String.valueOf(result) + entries[i].toString() + '\n';
            ++i;
        }
        return result;
    }

    public Properties getProperties() {
        return this.fElements;
    }

    public Object[] toArray() {
        return this.fElements.entrySet().toArray();
    }

    private void createVariableList(Composite parent) {
        this.fVariableList = new TableViewer(parent, 2818);
        this.fVariableList.setContentProvider((IContentProvider)new ElementsContentProvider());
        this.fVariableList.setLabelProvider((IBaseLabelProvider)new ElementsLabelProvider());
        this.fVariableList.setSorter((ViewerSorter)new SimpleSorter());
        Table table = this.fVariableList.getTable();
        TableLayout tableLayout = new TableLayout();
        table.setLayout((Layout)tableLayout);
        GridData gd = new GridData(272);
        gd.grabExcessVerticalSpace = true;
        gd.grabExcessHorizontalSpace = true;
        table.setLayoutData((Object)gd);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableColumn column1 = new TableColumn(table, 0);
        column1.setText(LaunchUIPlugin.getResourceString("CEnvironmentTab.Name"));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(30));
        TableColumn column2 = new TableColumn(table, 0);
        column2.setText(LaunchUIPlugin.getResourceString("CEnvironmentTab.Value"));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(30));
        this.fVariableList.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent e) {
                CEnvironmentTab.this.elementDoubleClicked((IStructuredSelection)e.getSelection());
            }
        });
        this.fVariableList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                CEnvironmentTab.this.updateButtons();
            }
        });
    }

    private void createButtons(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(2));
        composite.setLayout((Layout)new GridLayout(1, true));
        this.fBtnNew = new Button(composite, 0);
        this.fBtnNew.setText(LaunchUIPlugin.getResourceString("CEnvironmentTab.New..."));
        this.fBtnNew.setLayoutData((Object)new GridData(1808));
        this.fBtnNew.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CEnvironmentTab.this.newEntry();
            }
        });
        this.fBtnImport = new Button(composite, 0);
        this.fBtnImport.setText(LaunchUIPlugin.getResourceString("CEnvironmentTab.Import..."));
        this.fBtnImport.setLayoutData((Object)new GridData(1808));
        this.fBtnImport.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CEnvironmentTab.this.importEntries();
            }
        });
        this.fBtnEdit = new Button(composite, 0);
        this.fBtnEdit.setText(LaunchUIPlugin.getResourceString("CEnvironmentTab.Edit..."));
        this.fBtnEdit.setLayoutData((Object)new GridData(1808));
        this.fBtnEdit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CEnvironmentTab.this.edit();
            }
        });
        this.fBtnRemove = new Button(composite, 0);
        this.fBtnRemove.setText(LaunchUIPlugin.getResourceString("CEnvironmentTab.Remove"));
        this.fBtnRemove.setLayoutData((Object)new GridData(1808));
        this.fBtnRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CEnvironmentTab.this.remove();
            }
        });
    }

    protected void updateButtons() {
        IStructuredSelection selection = (IStructuredSelection)this.fVariableList.getSelection();
        this.fBtnEdit.setEnabled(selection.size() == 1);
        this.fBtnRemove.setEnabled(selection.size() > 0);
    }

    protected void elementDoubleClicked(IStructuredSelection selection) {
        if (selection.size() != 1) {
            return;
        }
        this.doEdit((Map.Entry)selection.getFirstElement());
    }

    protected void newEntry() {
        EntryDialog dialog = new EntryDialog(new String(), new String(), false);
        if (dialog.open() == 0) {
            this.fElements.setProperty(dialog.getName(), dialog.getValue());
            this.fVariableList.refresh();
        }
        this.updateButtons();
        this.updateLaunchConfigurationDialog();
    }

    protected void importEntries() {
        FileDialog fileDialog = new FileDialog(this.getShell(), 4096);
        String filename = fileDialog.open();
        if (filename == null) {
            return;
        }
        this.parseImportFile(filename);
        this.updateButtons();
        this.updateLaunchConfigurationDialog();
    }

    protected void parseImportFile(String filename) {
        File file = new File(filename);
        if (!file.exists()) {
            return;
        }
        try {
            String line;
            BufferedReader reader = new BufferedReader(new FileReader(file));
            while ((line = reader.readLine()) != null) {
                boolean overwrite;
                String value;
                String key;
                if ((line = line.trim()).length() == 0) continue;
                int demarcation = line.indexOf("=");
                if (demarcation == -1) {
                    key = line;
                    value = "";
                } else {
                    key = line.substring(0, demarcation);
                    value = line.substring(demarcation + 1, line.length());
                }
                if (this.fElements.getProperty(key) != null && !(overwrite = MessageDialog.openQuestion((Shell)this.getShell(), (String)LaunchUIPlugin.getResourceString("CEnvironmentTab.Existing_Environment_Variable"), (String)LaunchUIPlugin.getFormattedResourceString("CEnvironmentTab.Environment_variable_NAME_exists", key)))) continue;
                this.fElements.setProperty(key, value);
            }
        }
        catch (Exception exception) {}
        this.fVariableList.refresh();
    }

    protected void edit() {
        IStructuredSelection selection = (IStructuredSelection)this.fVariableList.getSelection();
        this.doEdit((Map.Entry)selection.getFirstElement());
    }

    protected void doEdit(Map.Entry entry) {
        EntryDialog dialog = new EntryDialog(entry.getKey().toString(), entry.getValue().toString(), true);
        if (dialog.open() == 0) {
            this.fElements.remove(entry.getKey());
            this.fElements.setProperty(dialog.getName(), dialog.getValue());
            this.fVariableList.refresh();
        }
        this.updateButtons();
        this.updateLaunchConfigurationDialog();
    }

    protected void remove() {
        IStructuredSelection selection = (IStructuredSelection)this.fVariableList.getSelection();
        Object[] elements = selection.toArray();
        int i = 0;
        while (i < elements.length) {
            this.fElements.remove(((Map.Entry)elements[i]).getKey());
            ++i;
        }
        this.fVariableList.refresh();
        this.updateButtons();
        this.updateLaunchConfigurationDialog();
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute("org.eclipse.cdt.launch.ENVIRONMENT_MAP", null);
        config.setAttribute("org.eclipse.cdt.launch.ENVIRONMENT_INHERIT", true);
    }

    public void initializeFrom(ILaunchConfiguration config) {
        try {
            Map env = config.getAttribute("org.eclipse.cdt.launch.ENVIRONMENT_MAP", null);
            if (env != null) {
                this.fElements.clear();
                this.fElements.putAll((Map<?, ?>)env);
                this.fVariableList.refresh();
                this.updateButtons();
            }
        }
        catch (CoreException coreException) {}
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute("org.eclipse.cdt.launch.ENVIRONMENT_MAP", (Map)this.fElements.clone());
        config.setAttribute("org.eclipse.cdt.launch.ENVIRONMENT_INHERIT", true);
    }

    public String getName() {
        return LaunchUIPlugin.getResourceString("CEnvironmentTab.Environment");
    }

    public Image getImage() {
        return LaunchImages.get(LaunchImages.IMG_VIEW_ENVIRONMENT_TAB);
    }

    class SimpleSorter
    extends ViewerSorter {
        SimpleSorter() {
        }

        public boolean isSorterProperty(Object element, Object property) {
            return true;
        }
    }

    class ElementsContentProvider
    implements IStructuredContentProvider {
        Object input = null;

        ElementsContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object parent) {
            return CEnvironmentTab.this.fElements.entrySet().toArray();
        }
    }

    class ElementsLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        ElementsLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element != null && element instanceof Map.Entry) {
                return columnIndex == 0 ? ((Map.Entry)element).getKey().toString() : ((Map.Entry)element).getValue().toString();
            }
            return null;
        }
    }

    class EntryDialog
    extends Dialog {
        private String fName;
        private String fValue;
        private boolean fEdit = false;
        private Button fBtnOk = null;
        private Text fTextName = null;
        private Text fTextValue = null;

        public EntryDialog(String name, String value, boolean edit) {
            super(CEnvironmentTab.this.getControl().getShell());
            this.fName = name;
            this.fValue = value;
            this.fEdit = edit;
        }

        protected Control createContents(Composite parent) {
            Control result = super.createContents(parent);
            this.updateButtonsState();
            return result;
        }

        protected void configureShell(Shell shell) {
            super.configureShell(shell);
            String title = this.fEdit ? LaunchUIPlugin.getResourceString("CEnvironmentTab.Edit_Variable") : LaunchUIPlugin.getResourceString("CEnvironmentTab.New_Variable");
            shell.setText(title);
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout(2, false);
            layout.marginWidth = 5;
            layout.numColumns = 2;
            composite.setLayout((Layout)layout);
            GC gc = new GC((Drawable)composite);
            gc.setFont(composite.getFont());
            FontMetrics metrics = gc.getFontMetrics();
            gc.dispose();
            int fieldWidthHint = Dialog.convertWidthInCharsToPixels((FontMetrics)metrics, (int)50);
            Label label = new Label(composite, 0);
            label.setText(LaunchUIPlugin.getResourceString("CEnvironmentTab.NameColon"));
            this.fTextName = new Text(composite, 2052);
            GridData gd = new GridData(1808);
            gd.grabExcessHorizontalSpace = true;
            gd.widthHint = fieldWidthHint;
            this.fTextName.setLayoutData((Object)gd);
            label = new Label(composite, 0);
            label.setText(LaunchUIPlugin.getResourceString("CEnvironmentTab.ValueColon"));
            this.fTextValue = new Text(composite, 2052);
            gd = new GridData(1808);
            gd.grabExcessHorizontalSpace = true;
            gd.widthHint = fieldWidthHint;
            this.fTextValue.setLayoutData((Object)gd);
            this.fTextName.addModifyListener(new ModifyListener(this){
                final /* synthetic */ EntryDialog this$1;
                {
                    this.this$1 = entryDialog;
                }

                public void modifyText(ModifyEvent e) {
                    this.this$1.updateButtonsState();
                }
            });
            this.fTextValue.addModifyListener(new ModifyListener(this){
                final /* synthetic */ EntryDialog this$1;
                {
                    this.this$1 = entryDialog;
                }

                public void modifyText(ModifyEvent e) {
                    this.this$1.updateButtonsState();
                }
            });
            this.fTextName.setText(this.fName);
            this.fTextValue.setText(this.fValue);
            return composite;
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.fBtnOk = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
            this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        }

        protected void updateButtonsState() {
            if (this.fBtnOk != null) {
                this.fBtnOk.setEnabled(this.fTextName.getText().trim().length() > 0);
            }
        }

        protected String getName() {
            return this.fName;
        }

        protected String getValue() {
            return this.fValue;
        }

        protected void okPressed() {
            this.fName = this.fTextName.getText().trim();
            this.fValue = this.fTextValue.getText().trim();
            this.setReturnCode(0);
            this.close();
        }
    }
}

