/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.cdt.core.model.IBinaryModule;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IParent;
import org.eclipse.cdt.core.model.IVariable;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.CDebugModel;
import org.eclipse.cdt.debug.core.CDebugUtils;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDIBreakpointHit;
import org.eclipse.cdt.debug.core.cdi.ICDIConfiguration;
import org.eclipse.cdt.debug.core.cdi.ICDIEndSteppingRange;
import org.eclipse.cdt.debug.core.cdi.ICDIErrorInfo;
import org.eclipse.cdt.debug.core.cdi.ICDIExpressionManager;
import org.eclipse.cdt.debug.core.cdi.ICDILocation;
import org.eclipse.cdt.debug.core.cdi.ICDISessionObject;
import org.eclipse.cdt.debug.core.cdi.ICDISharedLibraryEvent;
import org.eclipse.cdt.debug.core.cdi.ICDISignalReceived;
import org.eclipse.cdt.debug.core.cdi.ICDIWatchpointScope;
import org.eclipse.cdt.debug.core.cdi.ICDIWatchpointTrigger;
import org.eclipse.cdt.debug.core.cdi.event.ICDIChangedEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDICreatedEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDIDestroyedEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDIDisconnectedEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDIEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDIEventListener;
import org.eclipse.cdt.debug.core.cdi.event.ICDIExitedEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDIRestartedEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDIResumedEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDISuspendedEvent;
import org.eclipse.cdt.debug.core.cdi.model.ICDIBreakpoint;
import org.eclipse.cdt.debug.core.cdi.model.ICDIObject;
import org.eclipse.cdt.debug.core.cdi.model.ICDISharedLibrary;
import org.eclipse.cdt.debug.core.cdi.model.ICDISignal;
import org.eclipse.cdt.debug.core.cdi.model.ICDITarget;
import org.eclipse.cdt.debug.core.cdi.model.ICDIThread;
import org.eclipse.cdt.debug.core.model.ICAddressBreakpoint;
import org.eclipse.cdt.debug.core.model.ICBreakpoint;
import org.eclipse.cdt.debug.core.model.ICDebugTarget;
import org.eclipse.cdt.debug.core.model.ICLineBreakpoint;
import org.eclipse.cdt.debug.core.model.ICSharedLibrary;
import org.eclipse.cdt.debug.core.model.ICSignal;
import org.eclipse.cdt.debug.core.model.IDisassembly;
import org.eclipse.cdt.debug.core.model.IGlobalVariableDescriptor;
import org.eclipse.cdt.debug.core.sourcelookup.ICSourceLocator;
import org.eclipse.cdt.debug.internal.core.CBreakpointManager;
import org.eclipse.cdt.debug.internal.core.CExpressionTarget;
import org.eclipse.cdt.debug.internal.core.CGlobalVariableManager;
import org.eclipse.cdt.debug.internal.core.CMemoryManager;
import org.eclipse.cdt.debug.internal.core.CRegisterManager;
import org.eclipse.cdt.debug.internal.core.CSharedLibraryManager;
import org.eclipse.cdt.debug.internal.core.CSignalManager;
import org.eclipse.cdt.debug.internal.core.model.CDebugElement;
import org.eclipse.cdt.debug.internal.core.model.CExpression;
import org.eclipse.cdt.debug.internal.core.model.CThread;
import org.eclipse.cdt.debug.internal.core.model.CoreModelMessages;
import org.eclipse.cdt.debug.internal.core.model.Disassembly;
import org.eclipse.cdt.debug.internal.core.sourcelookup.CSourceManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointListener;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.IExpressionListener;
import org.eclipse.debug.core.IExpressionManager;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchListener;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IRegisterGroup;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.model.IThread;

public class CDebugTarget
extends CDebugElement
implements ICDebugTarget,
ICDIEventListener,
ILaunchListener,
IExpressionListener {
    private boolean fSuspending;
    private int fTargetType;
    private ArrayList fThreads;
    private IProcess fDebuggeeProcess = null;
    private ICDITarget fCDITarget;
    private String fName;
    private boolean fSuspended = true;
    private boolean fTerminated;
    private boolean fTerminating;
    private boolean fDisconnected;
    private ILaunch fLaunch;
    private ICDIConfiguration fConfig;
    private int fCurrentStateId = 0;
    private Object fCurrentStateInfo = null;
    private int fSuspendCount = 0;
    private CMemoryManager fMemoryManager;
    private Disassembly fDisassembly;
    private CSharedLibraryManager fSharedLibraryManager;
    private CSignalManager fSignalManager;
    private CRegisterManager fRegisterManager;
    private CBreakpointManager fBreakpointManager;
    private CExpressionTarget fExpressionTarget;
    private CGlobalVariableManager fGlobalVariableManager;
    private ICDIThread fSuspensionThread;
    private IFile fExecFile;
    private Boolean fIsLittleEndian = null;
    private RunningInfo fRunningInfo = null;
    private Preferences fPreferences = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;
    static /* synthetic */ Class class$9;
    static /* synthetic */ Class class$10;
    static /* synthetic */ Class class$11;
    static /* synthetic */ Class class$12;
    static /* synthetic */ Class class$13;
    static /* synthetic */ Class class$14;
    static /* synthetic */ Class class$15;
    static /* synthetic */ Class class$16;
    static /* synthetic */ Class class$17;
    static /* synthetic */ Class class$18;
    static /* synthetic */ Class class$19;
    static /* synthetic */ Class class$20;
    static /* synthetic */ Class class$21;
    static /* synthetic */ Class class$22;
    static /* synthetic */ Class class$23;
    static /* synthetic */ Class class$24;

    public CDebugTarget(ILaunch launch, int targetType, ICDITarget cdiTarget, String name, IProcess debuggeeProcess, IProcess debuggerProcess, IFile file, boolean allowsTerminate, boolean allowsDisconnect) {
        super(null);
        this.setLaunch(launch);
        this.setTargetType(targetType);
        this.setDebugTarget(this);
        this.setName(name);
        this.setProcess(debuggeeProcess);
        this.setCDITarget(cdiTarget);
        this.initializePreferences();
        this.setExecFile(file);
        this.setConfiguration(cdiTarget.getSession().getConfiguration());
        this.setThreadList(new ArrayList(5));
        this.createDisassembly();
        this.setSharedLibraryManager(new CSharedLibraryManager(this));
        this.setSignalManager(new CSignalManager(this));
        this.setRegisterManager(new CRegisterManager(this));
        this.setBreakpointManager(new CBreakpointManager(this));
        this.setGlobalVariableManager(new CGlobalVariableManager(this));
        this.initialize();
        DebugPlugin.getDefault().getLaunchManager().addLaunchListener((ILaunchListener)this);
        DebugPlugin.getDefault().getExpressionManager().addExpressionListener((IExpressionListener)this);
        this.getCDISession().getEventManager().addEventListener(this);
    }

    protected void initialize() {
        this.initializeState();
        this.initializeBreakpoints();
        this.initializeRegisters();
        this.initializeMemoryManager();
        this.initializeSourceManager();
        this.getLaunch().addDebugTarget((IDebugTarget)this);
        this.fireCreationEvent();
    }

    private void initializeBreakpoints() {
        DebugPlugin.getDefault().getBreakpointManager().addBreakpointListener((IBreakpointListener)this);
        this.setBreakpoints();
    }

    protected void initializeState() {
        ICDIThread[] threads = new ICDIThread[]{};
        try {
            threads = this.getCDITarget().getThreads();
        }
        catch (CDIException cDIException) {}
        int i = 0;
        while (i < threads.length) {
            this.createThread(threads[i]);
            ++i;
        }
        ArrayList list = this.getThreadList();
        ArrayList<DebugEvent> debugEvents = new ArrayList<DebugEvent>(list.size());
        Iterator it = list.iterator();
        while (it.hasNext()) {
            debugEvents.add(((CThread)it.next()).createCreateEvent());
        }
        this.fireEventSet(debugEvents.toArray(new DebugEvent[debugEvents.size()]));
    }

    public void setBreakpoints() {
        IBreakpointManager manager = DebugPlugin.getDefault().getBreakpointManager();
        IBreakpoint[] bps = manager.getBreakpoints(CDebugModel.getPluginIdentifier());
        int i = 0;
        while (i < bps.length) {
            if (bps[i] instanceof ICBreakpoint && this.getBreakpointManager().isTargetBreakpoint((ICBreakpoint)bps[i]) && !this.getBreakpointManager().isCDIRegistered((ICBreakpoint)bps[i])) {
                if (bps[i] instanceof ICAddressBreakpoint) {
                    try {
                        bps[i].setEnabled(false);
                    }
                    catch (CoreException coreException) {}
                }
                this.breakpointAdded0(bps[i]);
            }
            ++i;
        }
    }

    protected void initializeRegisters() {
        this.getRegisterManager().initialize();
    }

    protected void initializeMemoryManager() {
        this.fMemoryManager = new CMemoryManager(this);
    }

    protected void initializeSourceManager() {
        ISourceLocator locator = this.getLaunch().getSourceLocator();
        if (locator instanceof IAdaptable) {
            IResourceChangeListener listener;
            ICSourceLocator clocator;
            IAdaptable iAdaptable = (IAdaptable)locator;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.cdt.debug.core.sourcelookup.ICSourceLocator");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((clocator = (ICSourceLocator)iAdaptable.getAdapter((Class)clazz)) instanceof IAdaptable) {
                CSourceManager sm;
                IAdaptable iAdaptable2 = (IAdaptable)clocator;
                Class<?> clazz2 = class$1;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$1 = Class.forName("org.eclipse.cdt.debug.internal.core.sourcelookup.CSourceManager");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((sm = (CSourceManager)iAdaptable2.getAdapter((Class)clazz2)) != null) {
                    sm.setDebugTarget(this);
                }
            }
            IAdaptable iAdaptable3 = (IAdaptable)locator;
            Class<?> clazz3 = class$2;
            if (clazz3 == null) {
                try {
                    clazz3 = class$2 = Class.forName("org.eclipse.core.resources.IResourceChangeListener");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((listener = (IResourceChangeListener)iAdaptable3.getAdapter((Class)clazz3)) != null) {
                CCorePlugin.getWorkspace().addResourceChangeListener(listener);
            }
        }
    }

    public IProcess getProcess() {
        return this.fDebuggeeProcess;
    }

    protected void setProcess(IProcess debuggeeProcess) {
        this.fDebuggeeProcess = debuggeeProcess;
    }

    public IThread[] getThreads() {
        ArrayList threads = this.getThreadList();
        return threads.toArray(new IThread[threads.size()]);
    }

    public boolean hasThreads() throws DebugException {
        return this.getThreadList().size() > 0;
    }

    public String getName() throws DebugException {
        return this.fName;
    }

    protected void setName(String name) {
        this.fName = name;
    }

    public boolean supportsBreakpoint(IBreakpoint breakpoint) {
        if (!this.getConfiguration().supportsBreakpoints()) {
            return false;
        }
        return breakpoint instanceof ICBreakpoint && this.getBreakpointManager().isCDIRegistered((ICBreakpoint)breakpoint);
    }

    public void launchRemoved(ILaunch launch) {
        if (!this.isAvailable()) {
            return;
        }
        if (launch.equals(this.getLaunch())) {
            this.disconnected();
        }
    }

    public void launchAdded(ILaunch launch) {
    }

    public void launchChanged(ILaunch launch) {
    }

    public boolean canTerminate() {
        return this.supportsTerminate() && this.isAvailable();
    }

    public boolean isTerminated() {
        return this.fTerminated;
    }

    public void terminate() throws DebugException {
        if (this.isTerminating()) {
            return;
        }
        this.setTerminating(true);
        DebugPlugin.getDefault().asyncExec(new Runnable(){

            public void run() {
                try {
                    CDebugTarget.this.getCDITarget().terminate();
                }
                catch (CDIException e) {
                    CDebugTarget.this.setTerminating(false);
                    try {
                        CDebugTarget.this.targetRequestFailed(e.getMessage(), e);
                    }
                    catch (DebugException e1) {
                        CDebugUtils.error(e1.getStatus(), CDebugTarget.this);
                    }
                }
            }
        });
    }

    protected void setTerminated(boolean terminated) {
        this.fTerminated = terminated;
    }

    public boolean canResume() {
        return this.getConfiguration().supportsResume() && this.isSuspended() && this.isAvailable();
    }

    public boolean canSuspend() {
        if (!this.getConfiguration().supportsSuspend()) {
            return false;
        }
        if (!this.isSuspended() && this.isAvailable()) {
            IThread[] threads = this.getThreads();
            int i = 0;
            while (i < threads.length) {
                if (threads[i].isSuspended()) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public boolean isSuspended() {
        return this.fSuspended;
    }

    public void resume() throws DebugException {
        if (!this.isSuspended() && !this.isSuspending()) {
            return;
        }
        try {
            this.getCDITarget().resume();
        }
        catch (CDIException e) {
            this.targetRequestFailed(e.getMessage(), e);
        }
    }

    public void suspend() throws DebugException {
        if (this.isSuspended() || this.isSuspending()) {
            return;
        }
        this.setSuspending(true);
        DebugPlugin.getDefault().asyncExec(new Runnable(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                try {
                    try {
                        CDebugTarget.this.getCDITarget().suspend();
                    }
                    catch (CDIException e) {
                        try {
                            CDebugTarget.this.targetRequestFailed(e.getMessage(), e);
                        }
                        catch (DebugException e1) {
                            CDebugUtils.error(e1.getStatus(), CDebugTarget.this);
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    CDebugTarget.this.setSuspending(false);
                    throw throwable;
                }
                {
                    Object var3_5 = null;
                    CDebugTarget.this.setSuspending(false);
                    return;
                }
            }
        });
    }

    protected void setSuspending(boolean value) {
        this.fSuspending = value;
    }

    protected boolean isSuspending() {
        return this.fSuspending;
    }

    protected void suspendThreads(ICDISuspendedEvent event) {
        Iterator it = this.getThreadList().iterator();
        ICDIEvent[] events = new ICDIEvent[]{event};
        while (it.hasNext()) {
            ((CThread)it.next()).handleDebugEvents(events);
        }
    }

    protected synchronized List refreshThreads() {
        CThread thread;
        ArrayList<CThread> newThreads = new ArrayList<CThread>(5);
        ArrayList<CThread> list = new ArrayList<CThread>(5);
        ArrayList<DebugEvent> debugEvents = new ArrayList<DebugEvent>(5);
        List oldList = (List)this.getThreadList().clone();
        ICDIThread[] cdiThreads = new ICDIThread[]{};
        try {
            cdiThreads = this.getCDITarget().getThreads();
        }
        catch (CDIException e) {
            CDebugCorePlugin.log(e);
        }
        int i = 0;
        while (i < cdiThreads.length) {
            thread = this.findThread(oldList, cdiThreads[i]);
            if (thread == null) {
                thread = new CThread(this, cdiThreads[i]);
                newThreads.add(thread);
            } else {
                oldList.remove(thread);
            }
            list.add(thread);
            ++i;
        }
        Iterator it = oldList.iterator();
        while (it.hasNext()) {
            thread = (CThread)it.next();
            thread.terminated();
            debugEvents.add(thread.createTerminateEvent());
        }
        this.setThreadList(list);
        it = newThreads.iterator();
        while (it.hasNext()) {
            debugEvents.add(((CThread)it.next()).createCreateEvent());
        }
        if (debugEvents.size() > 0) {
            this.fireEventSet(debugEvents.toArray(new DebugEvent[debugEvents.size()]));
        }
        this.setCurrentThread();
        return newThreads;
    }

    protected synchronized void resumeThreads(List debugEvents, int detail) {
        Iterator it = this.getThreadList().iterator();
        while (it.hasNext()) {
            ((CThread)it.next()).resumed(detail, debugEvents);
        }
    }

    public void breakpointAdded(IBreakpoint breakpoint) {
        if (!(breakpoint instanceof ICBreakpoint && this.getBreakpointManager().isTargetBreakpoint((ICBreakpoint)breakpoint) && this.isAvailable())) {
            return;
        }
        this.breakpointAdded0(breakpoint);
    }

    private void breakpointAdded0(IBreakpoint breakpoint) {
        if (!this.isAvailable()) {
            return;
        }
        if (breakpoint instanceof ICAddressBreakpoint && !this.getBreakpointManager().supportsAddressBreakpoint((ICAddressBreakpoint)breakpoint)) {
            return;
        }
        if (this.getConfiguration().supportsBreakpoints()) {
            try {
                this.getBreakpointManager().setBreakpoint((ICBreakpoint)breakpoint);
            }
            catch (DebugException debugException) {}
        }
    }

    public void breakpointRemoved(IBreakpoint breakpoint, IMarkerDelta delta) {
        if (!(breakpoint instanceof ICBreakpoint && this.getBreakpointManager().isTargetBreakpoint((ICBreakpoint)breakpoint) && this.isAvailable())) {
            return;
        }
        try {
            this.getBreakpointManager().removeBreakpoint((ICBreakpoint)breakpoint);
        }
        catch (DebugException debugException) {}
    }

    public void breakpointChanged(IBreakpoint breakpoint, IMarkerDelta delta) {
        if (!(breakpoint instanceof ICBreakpoint && this.getBreakpointManager().isTargetBreakpoint((ICBreakpoint)breakpoint) && this.isAvailable() && delta != null)) {
            return;
        }
        try {
            this.getBreakpointManager().changeBreakpointProperties((ICBreakpoint)breakpoint, delta);
        }
        catch (DebugException debugException) {}
    }

    protected boolean supportsDisconnect() {
        return this.getConfiguration().supportsDisconnect();
    }

    protected boolean supportsTerminate() {
        return this.getConfiguration().supportsTerminate();
    }

    public boolean canDisconnect() {
        return this.supportsDisconnect() && this.isAvailable();
    }

    public void disconnect() throws DebugException {
        if (this.isDisconnected()) {
            return;
        }
        if (!this.canDisconnect()) {
            this.notSupported(CoreModelMessages.getString("CDebugTarget.0"));
        }
        try {
            this.getCDITarget().disconnect();
        }
        catch (CDIException e) {
            this.targetRequestFailed(e.getMessage(), e);
        }
    }

    public boolean isDisconnected() {
        return this.fDisconnected;
    }

    protected void setDisconnected(boolean disconnected) {
        this.fDisconnected = disconnected;
    }

    public boolean supportsStorageRetrieval() {
        return false;
    }

    public IMemoryBlock getMemoryBlock(long startAddress, long length) throws DebugException {
        return null;
    }

    public ILaunch getLaunch() {
        return this.fLaunch;
    }

    private void setLaunch(ILaunch launch) {
        this.fLaunch = launch;
    }

    protected ArrayList getThreadList() {
        return this.fThreads;
    }

    private void setThreadList(ArrayList threads) {
        this.fThreads = threads;
    }

    private void setCDITarget(ICDITarget cdiTarget) {
        this.fCDITarget = cdiTarget;
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("org.eclipse.debug.core.model.IDebugTarget");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter.equals(clazz)) {
            return this;
        }
        Class<?> clazz2 = class$4;
        if (clazz2 == null) {
            try {
                clazz2 = class$4 = Class.forName("org.eclipse.cdt.debug.core.model.ICDebugTarget");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter.equals(clazz2)) {
            return this;
        }
        Class<?> clazz3 = class$5;
        if (clazz3 == null) {
            try {
                clazz3 = class$5 = Class.forName("org.eclipse.cdt.debug.internal.core.model.CDebugTarget");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter.equals(clazz3)) {
            return this;
        }
        Class<?> clazz4 = class$6;
        if (clazz4 == null) {
            try {
                clazz4 = class$6 = Class.forName("org.eclipse.cdt.debug.core.cdi.model.ICDITarget");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter.equals(clazz4)) {
            return this.fCDITarget;
        }
        Class<?> clazz5 = class$7;
        if (clazz5 == null) {
            try {
                clazz5 = class$7 = Class.forName("org.eclipse.cdt.debug.core.model.IState");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter.equals(clazz5)) {
            return this;
        }
        Class<?> clazz6 = class$8;
        if (clazz6 == null) {
            try {
                clazz6 = class$8 = Class.forName("org.eclipse.cdt.debug.core.model.ICExpressionEvaluator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter.equals(clazz6)) {
            return this;
        }
        Class<?> clazz7 = class$9;
        if (clazz7 == null) {
            try {
                clazz7 = class$9 = Class.forName("org.eclipse.cdt.debug.core.model.ICDebugTargetType");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter.equals(clazz7)) {
            return this;
        }
        Class<?> clazz8 = class$10;
        if (clazz8 == null) {
            try {
                clazz8 = class$10 = Class.forName("org.eclipse.cdt.debug.core.ICMemoryManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter.equals(clazz8)) {
            return this.getMemoryManager();
        }
        Class<?> clazz9 = class$11;
        if (clazz9 == null) {
            try {
                clazz9 = class$11 = Class.forName("org.eclipse.cdt.debug.core.model.IDebuggerProcessSupport");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter.equals(clazz9)) {
            return this;
        }
        Class<?> clazz10 = class$12;
        if (clazz10 == null) {
            try {
                clazz10 = class$12 = Class.forName("org.eclipse.cdt.debug.core.model.IExecFileInfo");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter.equals(clazz10)) {
            return this;
        }
        Class<?> clazz11 = class$13;
        if (clazz11 == null) {
            try {
                clazz11 = class$13 = Class.forName("org.eclipse.cdt.debug.core.model.IRunToLine");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter.equals(clazz11)) {
            return this;
        }
        Class<?> clazz12 = class$14;
        if (clazz12 == null) {
            try {
                clazz12 = class$14 = Class.forName("org.eclipse.cdt.debug.core.model.IRunToAddress");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter.equals(clazz12)) {
            return this;
        }
        Class<?> clazz13 = class$15;
        if (clazz13 == null) {
            try {
                clazz13 = class$15 = Class.forName("org.eclipse.cdt.debug.core.model.IJumpToLine");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter.equals(clazz13)) {
            return this;
        }
        Class<?> clazz14 = class$16;
        if (clazz14 == null) {
            try {
                clazz14 = class$16 = Class.forName("org.eclipse.cdt.debug.core.model.IJumpToAddress");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter.equals(clazz14)) {
            return this;
        }
        Class<?> clazz15 = class$17;
        if (clazz15 == null) {
            try {
                clazz15 = class$17 = Class.forName("org.eclipse.cdt.debug.core.model.IBreakpointTarget");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter.equals(clazz15)) {
            return this;
        }
        Class<?> clazz16 = class$18;
        if (clazz16 == null) {
            try {
                clazz16 = class$18 = Class.forName("org.eclipse.cdt.debug.internal.core.CBreakpointManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter.equals(clazz16)) {
            return this.getBreakpointManager();
        }
        Class<?> clazz17 = class$19;
        if (clazz17 == null) {
            try {
                clazz17 = class$19 = Class.forName("org.eclipse.cdt.debug.core.ICSharedLibraryManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter.equals(clazz17)) {
            return this.getSharedLibraryManager();
        }
        Class<?> clazz18 = class$20;
        if (clazz18 == null) {
            try {
                clazz18 = class$20 = Class.forName("org.eclipse.cdt.debug.core.ICSignalManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter.equals(clazz18)) {
            return this.getSignalManager();
        }
        Class<?> clazz19 = class$21;
        if (clazz19 == null) {
            try {
                clazz19 = class$21 = Class.forName("org.eclipse.cdt.debug.core.ICRegisterManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter.equals(clazz19)) {
            return this.getRegisterManager();
        }
        Class<?> clazz20 = class$22;
        if (clazz20 == null) {
            try {
                clazz20 = class$22 = Class.forName("org.eclipse.cdt.debug.internal.core.CExpressionTarget");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter.equals(clazz20)) {
            return this.getExpressionTarget();
        }
        Class<?> clazz21 = class$23;
        if (clazz21 == null) {
            try {
                clazz21 = class$23 = Class.forName("org.eclipse.cdt.debug.core.ICGlobalVariableManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter.equals(clazz21)) {
            return this.getGlobalVariableManager();
        }
        Class<?> clazz22 = class$24;
        if (clazz22 == null) {
            try {
                clazz22 = class$24 = Class.forName("org.eclipse.cdt.debug.core.cdi.ICDISession");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter.equals(clazz22)) {
            return this.getCDISession();
        }
        return super.getAdapter(adapter);
    }

    public void handleDebugEvents(ICDIEvent[] events) {
        int i = 0;
        while (i < events.length) {
            ICDIEvent event = events[i];
            ICDIObject source = event.getSource();
            if (source == null && event instanceof ICDIDestroyedEvent) {
                this.handleTerminatedEvent((ICDIDestroyedEvent)event);
            } else if (source.getTarget().equals(this.getCDITarget())) {
                if (event instanceof ICDICreatedEvent) {
                    if (source instanceof ICDIThread) {
                        this.handleThreadCreatedEvent((ICDICreatedEvent)event);
                    }
                    if (source instanceof ICDISharedLibrary) {
                        this.getSharedLibraryManager().sharedLibraryLoaded((ICDISharedLibrary)source);
                    }
                } else if (event instanceof ICDISuspendedEvent) {
                    if (source instanceof ICDITarget || source instanceof ICDIThread) {
                        this.handleSuspendedEvent((ICDISuspendedEvent)event);
                    }
                } else if (event instanceof ICDIResumedEvent) {
                    if (source instanceof ICDITarget) {
                        this.handleResumedEvent((ICDIResumedEvent)event);
                    }
                } else if (event instanceof ICDIExitedEvent) {
                    if (source instanceof ICDITarget) {
                        this.handleExitedEvent((ICDIExitedEvent)event);
                    }
                } else if (event instanceof ICDIDestroyedEvent) {
                    if (source instanceof ICDIThread) {
                        this.handleThreadTerminatedEvent((ICDIDestroyedEvent)event);
                    }
                    if (source instanceof ICDISharedLibrary) {
                        this.getSharedLibraryManager().sharedLibraryUnloaded((ICDISharedLibrary)source);
                    }
                } else if (event instanceof ICDIDisconnectedEvent) {
                    if (source instanceof ICDITarget) {
                        this.handleDisconnectedEvent((ICDIDisconnectedEvent)event);
                    }
                } else if (event instanceof ICDIChangedEvent) {
                    if (source instanceof ICDITarget) {
                        this.handleChangedEvent((ICDIChangedEvent)event);
                    }
                    if (source instanceof ICDISharedLibrary) {
                        this.getSharedLibraryManager().symbolsLoaded((ICDISharedLibrary)source);
                    }
                    if (source instanceof ICDISignal) {
                        this.getSignalManager().signalChanged((ICDISignal)source);
                    }
                } else if (event instanceof ICDIRestartedEvent && source instanceof ICDITarget) {
                    this.handleRestartedEvent((ICDIRestartedEvent)event);
                }
            }
            ++i;
        }
    }

    public boolean canRestart() {
        return this.getConfiguration().supportsRestart() && this.isSuspended() && this.isAvailable();
    }

    public void restart() throws DebugException {
        if (!this.canRestart()) {
            return;
        }
        try {
            ICDILocation location = this.getCDISession().getBreakpointManager().createLocation("", "main", 0);
            this.setInternalTemporaryBreakpoint(location);
            this.getCDITarget().restart();
            this.restarted();
        }
        catch (CDIException e) {
            this.targetRequestFailed(e.getMessage(), e);
        }
    }

    protected void restarted() {
    }

    public int[] getSupportedFormats() throws DebugException {
        return null;
    }

    public boolean isAvailable() {
        return !this.isTerminated() && !this.isTerminating() && !this.isDisconnected();
    }

    private void setSuspended(boolean suspended) {
        this.fSuspended = suspended;
    }

    protected boolean isTerminating() {
        return this.fTerminating;
    }

    protected void setTerminating(boolean terminating) {
        this.fTerminating = terminating;
    }

    protected void terminated() {
        this.setTerminating(false);
        if (!this.isTerminated()) {
            if (!this.isDisconnected()) {
                this.setTerminated(true);
            }
            this.cleanup();
            this.fireTerminateEvent();
        }
    }

    protected void disconnected() {
        if (!this.isDisconnected()) {
            this.setDisconnected(true);
            this.cleanup();
            this.fireTerminateEvent();
        }
    }

    protected void cleanup() {
        this.resetStatus();
        this.removeAllThreads();
        this.getCDISession().getEventManager().removeEventListener(this);
        DebugPlugin.getDefault().getBreakpointManager().removeBreakpointListener((IBreakpointListener)this);
        DebugPlugin.getDefault().getExpressionManager().removeExpressionListener((IExpressionListener)this);
        DebugPlugin.getDefault().getLaunchManager().removeLaunchListener((ILaunchListener)this);
        this.disposeGlobalVariableManager();
        this.disposeMemoryManager();
        this.disposeSharedLibraryManager();
        this.disposeSignalManager();
        this.disposeRegisterManager();
        this.disposeDisassembly();
        this.disposeSourceManager();
        this.disposeBreakpointManager();
        this.disposeExpresionTarget();
        this.removeAllExpressions();
        this.disposePreferences();
    }

    protected void removeAllThreads() {
        ArrayList threads = this.getThreadList();
        this.setThreadList(new ArrayList(0));
        ArrayList<DebugEvent> debugEvents = new ArrayList<DebugEvent>(threads.size());
        Iterator it = threads.iterator();
        while (it.hasNext()) {
            CThread thread = (CThread)it.next();
            thread.terminated();
            debugEvents.add(thread.createTerminateEvent());
        }
        this.fireEventSet(debugEvents.toArray(new DebugEvent[debugEvents.size()]));
    }

    protected void removeAllExpressions() {
        IExpressionManager em = DebugPlugin.getDefault().getExpressionManager();
        IExpression[] expressions = em.getExpressions();
        int i = 0;
        while (i < expressions.length) {
            if (expressions[i] instanceof CExpression && expressions[i].getDebugTarget().equals(this)) {
                em.removeExpression(expressions[i]);
            }
            ++i;
        }
    }

    protected CThread createThread(ICDIThread cdiThread) {
        CThread thread = new CThread(this, cdiThread);
        this.getThreadList().add(thread);
        return thread;
    }

    protected CThread createRunningThread(ICDIThread cdiThread) {
        CThread thread = new CThread(this, cdiThread);
        thread.setRunning(true);
        this.getThreadList().add(thread);
        return thread;
    }

    private void handleSuspendedEvent(ICDISuspendedEvent event) {
        CThread thread;
        this.setSuspended(true);
        this.setCurrentStateId(7);
        ICDISessionObject reason = event.getReason();
        this.setCurrentStateInfo(reason);
        this.setRunningInfo(null);
        this.getRegisterManager().targetSuspended();
        this.setSuspensionThread();
        this.getBreakpointManager().skipBreakpoints(false);
        List newThreads = this.refreshThreads();
        if (event.getSource() instanceof ICDITarget) {
            this.suspendThreads(event);
        } else if (event.getSource() instanceof ICDIThread && (thread = this.findThread((ICDIThread)event.getSource())) != null && newThreads.contains(thread)) {
            ICDIEvent[] evts = new ICDIEvent[]{event};
            thread.handleDebugEvents(evts);
        }
        if (reason instanceof ICDIEndSteppingRange) {
            this.handleEndSteppingRange((ICDIEndSteppingRange)reason);
        } else if (reason instanceof ICDIBreakpointHit) {
            this.handleBreakpointHit((ICDIBreakpointHit)reason);
        } else if (reason instanceof ICDISignalReceived) {
            this.handleSuspendedBySignal((ICDISignalReceived)reason);
        } else if (reason instanceof ICDIWatchpointTrigger) {
            this.handleWatchpointTrigger((ICDIWatchpointTrigger)reason);
        } else if (reason instanceof ICDIWatchpointScope) {
            this.handleWatchpointScope((ICDIWatchpointScope)reason);
        } else if (reason instanceof ICDIErrorInfo) {
            this.handleErrorInfo((ICDIErrorInfo)reason);
        } else if (reason instanceof ICDISharedLibraryEvent) {
            this.handleSuspendedBySolibEvent((ICDISharedLibraryEvent)reason);
        }
    }

    private void handleResumedEvent(ICDIResumedEvent event) {
        this.setSuspended(false);
        this.setCurrentStateId(5);
        this.setCurrentStateInfo(null);
        this.resetStatus();
        ArrayList<DebugEvent> debugEvents = new ArrayList<DebugEvent>(10);
        int detail = 0;
        switch (event.getType()) {
            case 0: {
                detail = 32;
                break;
            }
            case 2: 
            case 4: {
                detail = 1;
                break;
            }
            case 1: 
            case 3: {
                detail = 2;
                break;
            }
            case 5: {
                detail = 4;
            }
        }
        this.resumeThreads(debugEvents, detail);
        if (this.getRunningInfo() == null) {
            this.setRunningInfo(event.getType());
        }
        debugEvents.add(this.createResumeEvent(detail));
        this.fireEventSet(debugEvents.toArray(new DebugEvent[debugEvents.size()]));
    }

    private void handleEndSteppingRange(ICDIEndSteppingRange endSteppingRange) {
        this.fireSuspendEvent(0);
    }

    private void handleBreakpointHit(ICDIBreakpointHit breakpointHit) {
        this.fireSuspendEvent(16);
    }

    private void handleWatchpointTrigger(ICDIWatchpointTrigger wt) {
        this.fireSuspendEvent(16);
    }

    private void handleWatchpointScope(ICDIWatchpointScope ws) {
        ICBreakpoint watchpoint = this.getBreakpointManager().getBreakpoint(ws.getWatchpoint());
        if (watchpoint != null) {
            try {
                this.getBreakpointManager().removeBreakpoint(watchpoint);
            }
            catch (DebugException e) {
                CDebugCorePlugin.log(e);
            }
            this.fireSuspendEvent(16);
        }
    }

    private void handleSuspendedBySignal(ICDISignalReceived signal) {
        this.fireSuspendEvent(0);
    }

    private void handleErrorInfo(ICDIErrorInfo info) {
        this.setStatus(2, info != null ? info.getMessage() : null);
        if (info != null) {
            MultiStatus status = new MultiStatus(CDebugCorePlugin.getUniqueIdentifier(), 10002, CoreModelMessages.getString("CDebugTarget.1"), null);
            StringTokenizer st = new StringTokenizer(info.getDetailMessage(), "\n\r");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if (token.length() > 200) {
                    token = token.substring(0, 200);
                }
                status.add((IStatus)new Status(4, status.getPlugin(), 10002, token, null));
            }
            CDebugUtils.error((IStatus)status, this);
        }
        this.fireSuspendEvent(0);
    }

    private void handleSuspendedBySolibEvent(ICDISharedLibraryEvent solibEvent) {
        this.fireSuspendEvent(0);
    }

    private void handleExitedEvent(ICDIExitedEvent event) {
        this.removeAllThreads();
        this.setCurrentStateId(8);
        this.setCurrentStateInfo(event.getReason());
        this.fireChangeEvent(512);
        if (this.getConfiguration().terminateSessionOnExit()) {
            this.terminated();
        }
    }

    private void handleTerminatedEvent(ICDIDestroyedEvent event) {
        this.terminated();
    }

    private void handleDisconnectedEvent(ICDIDisconnectedEvent event) {
        this.setCurrentStateId(9);
        this.setCurrentStateInfo(null);
        this.disconnected();
    }

    private void handleChangedEvent(ICDIChangedEvent event) {
    }

    private void handleRestartedEvent(ICDIRestartedEvent event) {
    }

    private void handleThreadCreatedEvent(ICDICreatedEvent event) {
        ICDIThread cdiThread = (ICDIThread)event.getSource();
        CThread thread = this.findThread(cdiThread);
        if (thread == null) {
            thread = this.createThread(cdiThread);
            thread.fireCreationEvent();
        }
    }

    private void handleThreadTerminatedEvent(ICDIDestroyedEvent event) {
        ICDIThread cdiThread = (ICDIThread)event.getSource();
        CThread thread = this.findThread(cdiThread);
        if (thread != null) {
            this.getThreadList().remove(thread);
            thread.terminated();
            thread.fireTerminateEvent();
        }
    }

    public CThread findThread(ICDIThread cdiThread) {
        ArrayList threads = this.getThreadList();
        int i = 0;
        while (i < threads.size()) {
            CThread t = (CThread)threads.get(i);
            if (t.getCDIThread().equals(cdiThread)) {
                return t;
            }
            ++i;
        }
        return null;
    }

    public CThread findThread(List threads, ICDIThread cdiThread) {
        int i = 0;
        while (i < threads.size()) {
            CThread t = (CThread)threads.get(i);
            if (t.getCDIThread().equals(cdiThread)) {
                return t;
            }
            ++i;
        }
        return null;
    }

    public int getCurrentStateId() {
        return this.fCurrentStateId;
    }

    private void setCurrentStateId(int id) {
        this.fCurrentStateId = id;
    }

    public Object getCurrentStateInfo() {
        return this.fCurrentStateInfo;
    }

    private void setCurrentStateInfo(Object info) {
        this.fCurrentStateInfo = info;
    }

    protected int getSuspendCount() {
        return this.fSuspendCount;
    }

    protected void incrementSuspendCount() {
        ++this.fSuspendCount;
    }

    public void fireSuspendEvent(int detail) {
        this.incrementSuspendCount();
        super.fireSuspendEvent(detail);
    }

    protected void setCurrentThread() {
        ICDIThread currentCDIThread = null;
        try {
            currentCDIThread = this.getCDITarget().getCurrentThread();
        }
        catch (CDIException e) {
            CDebugCorePlugin.log(e);
        }
        Iterator it = this.getThreadList().iterator();
        while (it.hasNext()) {
            CThread thread = (CThread)it.next();
            thread.setCurrent(currentCDIThread != null && thread.getCDIThread().equals(currentCDIThread));
        }
        if (currentCDIThread == null && !this.getThreadList().isEmpty()) {
            ((CThread)this.getThreadList().get(0)).setCurrent(true);
        }
    }

    protected ICDIConfiguration getConfiguration() {
        return this.fConfig;
    }

    private void setConfiguration(ICDIConfiguration config) {
        this.fConfig = config;
    }

    protected boolean supportsExpressionEvaluation() {
        return this.getConfiguration().supportsExpressionEvaluation();
    }

    public String evaluateExpressionToString(String expression) throws DebugException {
        try {
            return this.getCDITarget().evaluateExpressionToString(expression);
        }
        catch (CDIException e) {
            this.targetRequestFailed(e.getMessage(), null);
            return null;
        }
    }

    public boolean canEvaluate() {
        return this.supportsExpressionEvaluation() && this.isAvailable() && this.isSuspended();
    }

    public void expressionAdded(IExpression expression) {
    }

    public void expressionChanged(IExpression expression) {
    }

    public void expressionRemoved(IExpression expression) {
        if (expression != null && expression.getDebugTarget().equals(this) && expression instanceof CExpression) {
            ICDIExpressionManager em = this.getCDISession().getExpressionManager();
            try {
                em.destroyExpression(((CExpression)expression).getCDIExpression());
            }
            catch (CDIException cDIException) {}
        }
    }

    public void setInternalTemporaryBreakpoint(ICDILocation location) throws DebugException {
        try {
            this.getCDISession().getBreakpointManager().setLocationBreakpoint(1, location, null, null);
        }
        catch (CDIException e) {
            this.targetRequestFailed(e.getMessage(), null);
        }
    }

    public boolean canRunToLine(String fileName, int lineNumber) {
        return this.canResume();
    }

    public void runToLine(String fileName, int lineNumber, boolean skipBreakpoints) throws DebugException {
        if (!this.canRunToLine(fileName, lineNumber)) {
            return;
        }
        if (skipBreakpoints) {
            this.getBreakpointManager().skipBreakpoints(true);
        }
        ICDILocation location = this.getCDISession().getBreakpointManager().createLocation(fileName, null, lineNumber);
        try {
            this.getCDITarget().runUntil(location);
        }
        catch (CDIException e) {
            if (skipBreakpoints) {
                this.getBreakpointManager().skipBreakpoints(false);
            }
            this.targetRequestFailed(e.getMessage(), e);
        }
    }

    public boolean canRunToLine(IFile file, int lineNumber) {
        return this.canResume();
    }

    public void runToLine(IFile file, int lineNumber, boolean skipBreakpoints) throws DebugException {
        if (!this.canRunToLine(file, lineNumber)) {
            return;
        }
        this.runToLine(file.getLocation().lastSegment(), lineNumber, skipBreakpoints);
    }

    public void setCurrentThread(IThread thread) throws DebugException {
        if (!(this.isSuspended() && this.isAvailable() && thread instanceof CThread)) {
            return;
        }
        try {
            CThread oldThread = (CThread)this.getCurrentThread();
            if (!thread.equals(oldThread)) {
                this.getCDITarget().setCurrentThread(((CThread)thread).getCDIThread());
                if (oldThread != null) {
                    oldThread.setCurrent(false);
                }
                ((CThread)thread).setCurrent(true);
            }
        }
        catch (CDIException e) {
            this.targetRequestFailed(e.getMessage(), null);
        }
    }

    public IThread getCurrentThread() throws DebugException {
        IThread[] threads = this.getThreads();
        int i = 0;
        while (i < threads.length) {
            if (((CThread)threads[i]).isCurrent()) {
                return threads[i];
            }
            ++i;
        }
        return null;
    }

    protected ISourceLocator getSourceLocator() {
        return this.getLaunch().getSourceLocator();
    }

    protected void resetRegisters() {
        this.getRegisterManager().reset();
    }

    public int getTargetType() {
        return this.fTargetType;
    }

    private void setTargetType(int targetType) {
        this.fTargetType = targetType;
    }

    protected boolean isCoreDumpTarget() {
        return this.getTargetType() == 3;
    }

    protected CMemoryManager getMemoryManager() {
        return this.fMemoryManager;
    }

    protected void disposeMemoryManager() {
        this.getMemoryManager().dispose();
    }

    public boolean isLittleEndian() {
        if (this.fIsLittleEndian == null) {
            ICElement cFile;
            this.fIsLittleEndian = Boolean.TRUE;
            if (this.getExecFile() != null && CoreModel.getDefault().isBinary(this.getExecFile()) && (cFile = CCorePlugin.getDefault().getCoreModel().create(this.getExecFile())) instanceof IBinary) {
                this.fIsLittleEndian = new Boolean(((IBinary)cFile).isLittleEndian());
            }
        }
        return this.fIsLittleEndian;
    }

    public IFile getExecFile() {
        return this.fExecFile;
    }

    private void setExecFile(IFile file) {
        this.fExecFile = file;
    }

    public IGlobalVariableDescriptor[] getGlobals() throws DebugException {
        ICElement cFile;
        ArrayList list = new ArrayList();
        if (this.getExecFile() != null && CoreModel.getDefault().isBinary(this.getExecFile()) && (cFile = CCorePlugin.getDefault().getCoreModel().create(this.getExecFile())) instanceof IParent) {
            list.addAll(this.getCFileGlobals((IParent)cFile));
        }
        return list.toArray(new IGlobalVariableDescriptor[list.size()]);
    }

    private List getCFileGlobals(IParent file) throws DebugException {
        ArrayList<IGlobalVariableDescriptor> list = new ArrayList<IGlobalVariableDescriptor>();
        try {
            ICElement[] elements = file.getChildren();
            int i = 0;
            while (i < elements.length) {
                if (elements[i] instanceof IVariable) {
                    list.add(this.createGlobalVariable((IVariable)elements[i]));
                } else if (elements[i] instanceof IParent) {
                    list.addAll(this.getCFileGlobals((IParent)elements[i]));
                }
                ++i;
            }
        }
        catch (CModelException e) {
            this.requestFailed(String.valueOf(CoreModelMessages.getString("CDebugTarget.Unable_to_get_globals_1")) + e.getMessage(), (Exception)((Object)e));
        }
        return list;
    }

    private IGlobalVariableDescriptor createGlobalVariable(final IVariable var) {
        return new IGlobalVariableDescriptor(){

            public String getName() {
                return var.getElementName();
            }

            public IPath getPath() {
                Path path = new Path("");
                ICElement parent = var.getParent();
                if (parent instanceof IBinaryModule) {
                    path = ((IBinaryModule)parent).getPath();
                }
                return path;
            }
        };
    }

    protected void setSharedLibraryManager(CSharedLibraryManager libman) {
        this.fSharedLibraryManager = libman;
    }

    protected CSharedLibraryManager getSharedLibraryManager() {
        return this.fSharedLibraryManager;
    }

    protected void disposeSharedLibraryManager() {
        this.fSharedLibraryManager.dispose();
    }

    protected void setSignalManager(CSignalManager sm) {
        this.fSignalManager = sm;
    }

    protected CSignalManager getSignalManager() {
        return this.fSignalManager;
    }

    protected void disposeSignalManager() {
        this.fSignalManager.dispose();
    }

    protected void disposeRegisterManager() {
        this.fRegisterManager.dispose();
    }

    protected void disposeGlobalVariableManager() {
        this.fGlobalVariableManager.dispose();
    }

    public boolean canRunToAddress(long address) {
        return this.canResume();
    }

    public void runToAddress(long address, boolean skipBreakpoints) throws DebugException {
        if (!this.canRunToAddress(address)) {
            return;
        }
        if (skipBreakpoints) {
            this.getBreakpointManager().skipBreakpoints(true);
        }
        ICDILocation location = this.getCDISession().getBreakpointManager().createLocation(address);
        try {
            this.getCDITarget().runUntil(location);
        }
        catch (CDIException e) {
            if (skipBreakpoints) {
                this.getBreakpointManager().skipBreakpoints(false);
            }
            this.targetRequestFailed(e.getMessage(), e);
        }
    }

    public boolean canResumeWithoutSignal() {
        return this.isSuspended() && this.getCurrentStateInfo() instanceof ICDISignalReceived;
    }

    public void resumeWithoutSignal() throws DebugException {
        try {
            this.getCDITarget().signal();
        }
        catch (CDIException e) {
            this.targetRequestFailed(e.getMessage(), e);
        }
    }

    public boolean canJumpToLine(IFile file, int lineNumber) {
        return this.canResume();
    }

    public void jumpToLine(IFile file, int lineNumber) throws DebugException {
        if (!this.canJumpToLine(file, lineNumber)) {
            return;
        }
        this.jumpToLine(file.getLocation().lastSegment(), lineNumber);
    }

    public boolean canJumpToLine(String fileName, int lineNumber) {
        return this.canResume();
    }

    public void jumpToLine(String fileName, int lineNumber) throws DebugException {
        if (!this.canJumpToLine(fileName, lineNumber)) {
            return;
        }
        ICDILocation location = this.getCDISession().getBreakpointManager().createLocation(fileName, null, lineNumber);
        try {
            this.getCDITarget().jump(location);
        }
        catch (CDIException e) {
            this.targetRequestFailed(e.getMessage(), e);
        }
    }

    public boolean canJumpToAddress(long address) {
        return this.canResume();
    }

    public void jumpToAddress(long address) throws DebugException {
        if (!this.canJumpToAddress(address)) {
            return;
        }
        ICDILocation location = this.getCDISession().getBreakpointManager().createLocation(address);
        try {
            this.getCDITarget().jump(location);
        }
        catch (CDIException e) {
            this.targetRequestFailed(e.getMessage(), e);
        }
    }

    public CRegisterManager getRegisterManager() {
        return this.fRegisterManager;
    }

    protected void setRegisterManager(CRegisterManager registerManager) {
        this.fRegisterManager = registerManager;
    }

    public IRegisterGroup[] getRegisterGroups() throws DebugException {
        return this.getRegisterManager().getRegisterGroups();
    }

    protected void disposeSourceManager() {
        ISourceLocator locator = this.getSourceLocator();
        if (locator instanceof IAdaptable) {
            IResourceChangeListener listener;
            IAdaptable iAdaptable = (IAdaptable)locator;
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("org.eclipse.core.resources.IResourceChangeListener");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((listener = (IResourceChangeListener)iAdaptable.getAdapter((Class)clazz)) != null) {
                CCorePlugin.getWorkspace().removeResourceChangeListener(listener);
            }
        }
    }

    private void disposeExpresionTarget() {
        if (this.fExpressionTarget != null) {
            this.fExpressionTarget.dispose();
            this.fExpressionTarget = null;
        }
    }

    protected RunningInfo getRunningInfo() {
        return this.fRunningInfo;
    }

    public IFile getCurrentBreakpointFile() {
        ICDIBreakpoint cdiBreakpoint;
        Object info = this.getCurrentStateInfo();
        if (info instanceof ICDIBreakpointHit && (cdiBreakpoint = ((ICDIBreakpointHit)info).getBreakpoint()) != null) {
            return this.getBreakpointManager().getCDIBreakpointFile(cdiBreakpoint);
        }
        return null;
    }

    protected void setRunningInfo(RunningInfo info) {
        this.fRunningInfo = info;
    }

    protected void setRunningInfo(int type) {
        RunningInfo info = null;
        try {
            int depth;
            CThread thread = (CThread)this.getCurrentThread();
            if (thread != null && (depth = thread.getLastStackDepth()) > 0) {
                info = new RunningInfo(type, depth);
            }
        }
        catch (DebugException debugException) {}
        this.setRunningInfo(info);
    }

    protected CBreakpointManager getBreakpointManager() {
        return this.fBreakpointManager;
    }

    protected void setBreakpointManager(CBreakpointManager manager) {
        this.fBreakpointManager = manager;
    }

    protected void disposeBreakpointManager() {
        if (this.getBreakpointManager() != null) {
            this.getBreakpointManager().dispose();
        }
    }

    protected ICDIThread getSuspensionThread() {
        return this.fSuspensionThread;
    }

    private void setSuspensionThread() {
        this.fSuspensionThread = null;
        try {
            this.fSuspensionThread = this.getCDITarget().getCurrentThread();
        }
        catch (CDIException cDIException) {}
    }

    protected IBreakpoint[] getThreadBreakpoints(CThread thread) {
        ArrayList<ICBreakpoint> list = new ArrayList<ICBreakpoint>(1);
        if (this.isSuspended() && thread != null && this.getSuspensionThread() != null && this.getSuspensionThread().equals(thread.getCDIThread())) {
            ICBreakpoint bkpt = null;
            if (this.getCurrentStateInfo() instanceof ICDIBreakpointHit) {
                bkpt = this.getBreakpointManager().getBreakpoint(((ICDIBreakpointHit)this.getCurrentStateInfo()).getBreakpoint());
            } else if (this.getCurrentStateInfo() instanceof ICDIWatchpointTrigger) {
                bkpt = this.getBreakpointManager().getBreakpoint(((ICDIWatchpointTrigger)this.getCurrentStateInfo()).getWatchpoint());
            }
            if (bkpt != null) {
                list.add(bkpt);
            }
        }
        return list.toArray(new IBreakpoint[list.size()]);
    }

    public String toString() {
        String result = "";
        try {
            result = this.getName();
        }
        catch (DebugException debugException) {}
        return result;
    }

    public IDisassembly getDisassembly() throws DebugException {
        return this.fDisassembly;
    }

    public ICSharedLibrary[] getSharedLibraries() throws DebugException {
        CSharedLibraryManager slm = this.getSharedLibraryManager();
        if (slm != null) {
            return slm.getSharedLibraries();
        }
        return new ICSharedLibrary[0];
    }

    public ICSignal[] getSignals() throws DebugException {
        CSignalManager sm = this.getSignalManager();
        if (sm != null) {
            return sm.getSignals();
        }
        return new ICSignal[0];
    }

    public boolean hasSharedLibraries() throws DebugException {
        CSharedLibraryManager slm = this.getSharedLibraryManager();
        if (slm != null) {
            return slm.getSharedLibraries().length > 0;
        }
        return false;
    }

    public boolean hasSignals() throws DebugException {
        CSignalManager sm = this.getSignalManager();
        if (sm != null) {
            return sm.getSignals().length > 0;
        }
        return false;
    }

    public void loadSymbols() throws DebugException {
        CSharedLibraryManager slm = this.getSharedLibraryManager();
        if (slm != null) {
            slm.loadSymbolsForAll();
        }
    }

    private void createDisassembly() {
        this.fDisassembly = new Disassembly(this);
    }

    private void disposeDisassembly() {
        if (this.fDisassembly != null) {
            this.fDisassembly.dispose();
        }
        this.fDisassembly = null;
    }

    public long getBreakpointAddress(ICLineBreakpoint breakpoint) throws DebugException {
        return this.getBreakpointManager() != null ? this.getBreakpointManager().getBreakpointAddress(breakpoint) : 0L;
    }

    public boolean isTargetBreakpoint(ICBreakpoint breakpoint) {
        return this.getBreakpointManager() != null ? this.getBreakpointManager().isTargetBreakpoint(breakpoint) : false;
    }

    public void enableInstructionStepping(boolean enabled) {
        this.fPreferences.setValue("instruction_stepping_mode", enabled);
    }

    public boolean isInstructionSteppingEnabled() {
        return this.fPreferences.getBoolean("instruction_stepping_mode");
    }

    public boolean supportsInstructionStepping() {
        return this.getConfiguration().supportsInstructionStepping();
    }

    private void initializePreferences() {
        this.fPreferences = new Preferences();
        this.fPreferences.setDefault("instruction_stepping_mode", false);
    }

    private void disposePreferences() {
        this.fPreferences = null;
    }

    public void addPropertyChangeListener(Preferences.IPropertyChangeListener listener) {
        if (this.fPreferences != null) {
            this.fPreferences.addPropertyChangeListener(listener);
        }
    }

    public void removePropertyChangeListener(Preferences.IPropertyChangeListener listener) {
        if (this.fPreferences != null) {
            this.fPreferences.removePropertyChangeListener(listener);
        }
    }

    protected CExpressionTarget getExpressionTarget() {
        if (this.fExpressionTarget == null) {
            this.fExpressionTarget = new CExpressionTarget(this);
        }
        return this.fExpressionTarget;
    }

    protected CGlobalVariableManager getGlobalVariableManager() {
        return this.fGlobalVariableManager;
    }

    private void setGlobalVariableManager(CGlobalVariableManager globalVariableManager) {
        this.fGlobalVariableManager = globalVariableManager;
    }

    public class RunningInfo {
        private int fType = 0;
        private int fStackDepth;

        public RunningInfo(int type, int stackDepth) {
            this.fType = type;
            this.fStackDepth = stackDepth;
        }

        public int getType() {
            return this.fType;
        }

        public int getStackDepth() {
            return this.fStackDepth;
        }
    }
}

