/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.actions;

import java.text.MessageFormat;
import org.eclipse.cdt.debug.internal.ui.actions.ActionMessages;
import org.eclipse.cdt.debug.internal.ui.dialogfields.SelectionButtonDialogField;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class SignalPropertiesDialog
extends Dialog {
    private String fName;
    private String fDescription;
    private boolean fPass = false;
    private boolean fStop = false;
    private boolean fCanModify = false;
    private SelectionButtonDialogField fPassButton;
    private SelectionButtonDialogField fStopButton;

    public SignalPropertiesDialog(Shell parentShell, String name, String description, boolean pass, boolean stop, boolean canModify) {
        super(parentShell);
        this.fName = name;
        this.fDescription = description;
        this.fStop = stop;
        this.fPass = pass;
        this.fCanModify = canModify;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(MessageFormat.format(ActionMessages.getString("SignalPropertiesDialog.Title_1"), this.getName()));
    }

    protected String getDescription() {
        return this.fDescription;
    }

    protected String getName() {
        return this.fName;
    }

    protected boolean isPassEnabled() {
        return this.fPass;
    }

    protected void enablePass(boolean enable) {
        this.fPass = enable;
    }

    protected boolean isStopEnabled() {
        return this.fStop;
    }

    protected void enableStop(boolean enable) {
        this.fStop = enable;
    }

    protected Control createDialogArea(Composite parent) {
        Font font = parent.getFont();
        Composite composite = (Composite)super.createDialogArea(parent);
        Label label = new Label(composite, 64);
        label.setText(MessageFormat.format(ActionMessages.getString("SignalPropertiesDialog.Description_label_1"), this.getDescription()));
        GridData data = new GridData(772);
        data.widthHint = this.convertHorizontalDLUsToPixels(300);
        label.setLayoutData((Object)data);
        label.setFont(font);
        this.fPassButton = new SelectionButtonDialogField(32);
        this.fPassButton.setLabelText(ActionMessages.getString("SignalPropertiesDialog.Pass_label_1"));
        this.fPassButton.setSelection(this.fPass);
        this.fPassButton.setEnabled(this.fCanModify);
        this.fPassButton.doFillIntoGrid(composite, 1);
        this.fStopButton = new SelectionButtonDialogField(32);
        this.fStopButton.setLabelText(ActionMessages.getString("SignalPropertiesDialog.Stop_label_1"));
        this.fStopButton.setSelection(this.fStop);
        this.fStopButton.setEnabled(this.fCanModify);
        this.fStopButton.doFillIntoGrid(composite, 1);
        return composite;
    }

    protected void okPressed() {
        if (this.fPassButton != null) {
            this.fPass = this.fPassButton.isSelected();
        }
        if (this.fStopButton != null) {
            this.fStop = this.fStopButton.isSelected();
        }
        super.okPressed();
    }
}

