/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.browser.util;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IProgressMonitorWithBlocking;
import org.eclipse.core.runtime.IStatus;

public class DelegatedProgressMonitor
implements IProgressMonitor,
IProgressMonitorWithBlocking {
    private static int INITIAL_DELEGATE_COUNT = 2;
    private final ArrayList fDelegateList = new ArrayList(INITIAL_DELEGATE_COUNT);
    private String fTaskName;
    private String fSubTask;
    private int fTotalWork;
    private double fWorked;
    private boolean fIsBlocked;
    private boolean fIsCanceled;

    public DelegatedProgressMonitor() {
        this.init();
    }

    public DelegatedProgressMonitor(IProgressMonitor delegate) {
        this.init();
        this.addDelegate(delegate);
    }

    public synchronized void init() {
        this.fTaskName = null;
        this.fSubTask = null;
        this.fTotalWork = -1;
        this.fWorked = 0.0;
        this.fIsBlocked = false;
        this.fIsCanceled = false;
    }

    public synchronized void beginTask(String name, int totalWork) {
        this.fTaskName = name;
        this.fTotalWork = totalWork;
        this.visitDelegates(new IDelegateVisitor(){

            public void visit(IProgressMonitor delegate) {
                delegate.beginTask(DelegatedProgressMonitor.this.fTaskName, DelegatedProgressMonitor.this.fTotalWork);
            }
        });
    }

    public synchronized void done() {
        this.visitDelegates(new IDelegateVisitor(){

            public void visit(IProgressMonitor delegate) {
                delegate.done();
            }
        });
    }

    public synchronized void setTaskName(String name) {
        this.fTaskName = name;
        this.visitDelegates(new IDelegateVisitor(){

            public void visit(IProgressMonitor delegate) {
                delegate.setTaskName(DelegatedProgressMonitor.this.fTaskName);
            }
        });
    }

    public synchronized void subTask(String name) {
        this.fSubTask = name;
        this.visitDelegates(new IDelegateVisitor(){

            public void visit(IProgressMonitor delegate) {
                delegate.subTask(DelegatedProgressMonitor.this.fSubTask);
            }
        });
    }

    public void worked(int work) {
        this.internalWorked(work);
    }

    public synchronized void internalWorked(double internalWork) {
        this.fWorked += internalWork;
        final double fInternalWork = internalWork;
        this.visitDelegates(new IDelegateVisitor(){

            public void visit(IProgressMonitor delegate) {
                delegate.internalWorked(fInternalWork);
            }
        });
    }

    public synchronized boolean isCanceled() {
        this.visitDelegates(new IDelegateVisitor(){

            public void visit(IProgressMonitor delegate) {
                DelegatedProgressMonitor delegatedProgressMonitor = DelegatedProgressMonitor.this;
                delegatedProgressMonitor.fIsCanceled = delegatedProgressMonitor.fIsCanceled | delegate.isCanceled();
            }
        });
        return this.fIsCanceled;
    }

    public synchronized void setCanceled(boolean canceled) {
        this.fIsCanceled = canceled;
        this.visitDelegates(new IDelegateVisitor(){

            public void visit(IProgressMonitor delegate) {
                delegate.setCanceled(DelegatedProgressMonitor.this.fIsCanceled);
            }
        });
    }

    public synchronized void setBlocked(IStatus reason) {
        this.fIsBlocked = true;
        final IStatus fReason = reason;
        this.visitDelegates(new IDelegateVisitor(){

            public void visit(IProgressMonitor delegate) {
                if (delegate instanceof IProgressMonitorWithBlocking) {
                    ((IProgressMonitorWithBlocking)delegate).setBlocked(fReason);
                }
            }
        });
    }

    public synchronized void clearBlocked() {
        this.fIsBlocked = false;
        this.visitDelegates(new IDelegateVisitor(){

            public void visit(IProgressMonitor delegate) {
                if (delegate instanceof IProgressMonitorWithBlocking) {
                    ((IProgressMonitorWithBlocking)delegate).clearBlocked();
                }
            }
        });
    }

    public synchronized void addDelegate(IProgressMonitor delegate) {
        if (this.fDelegateList.indexOf(delegate) == -1) {
            if (this.fTaskName != null) {
                this.syncUp(delegate);
            }
            this.fDelegateList.add(delegate);
        }
    }

    private void syncUp(IProgressMonitor delegate) {
        delegate.beginTask(this.fTaskName, this.fTotalWork);
        delegate.internalWorked(this.fWorked);
        if (this.fSubTask != null && this.fSubTask.length() > 0) {
            delegate.subTask(this.fSubTask);
        }
        if (this.fIsBlocked && delegate instanceof IProgressMonitorWithBlocking) {
            ((IProgressMonitorWithBlocking)delegate).setBlocked(null);
        }
    }

    public synchronized void removeDelegate(IProgressMonitor delegate) {
        int index = this.fDelegateList.indexOf(delegate);
        if (index != -1) {
            this.fDelegateList.remove(index);
        }
    }

    public synchronized void removeAllDelegates() {
        this.fDelegateList.clear();
    }

    public synchronized IProgressMonitor[] getDelegates() {
        return (IProgressMonitor[])this.fDelegateList.toArray();
    }

    private void visitDelegates(IDelegateVisitor visitor) {
        ArrayList delegatesList = (ArrayList)this.fDelegateList.clone();
        Iterator i = delegatesList.iterator();
        while (i.hasNext()) {
            IProgressMonitor delegate = (IProgressMonitor)i.next();
            visitor.visit(delegate);
        }
    }

    private static interface IDelegateVisitor {
        public void visit(IProgressMonitor var1);
    }
}

