/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import org.eclipse.cdt.core.model.IPathEntry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class PathEntry
implements IPathEntry {
    protected int entryKind;
    protected boolean isExported;
    protected IPath path;

    public PathEntry(int entryKind, IPath path, boolean isExported) {
        this.path = path == null ? Path.EMPTY : path;
        this.entryKind = entryKind;
        this.isExported = isExported;
    }

    public IPath getPath() {
        return this.path;
    }

    public int getEntryKind() {
        return this.entryKind;
    }

    public boolean isExported() {
        return this.isExported;
    }

    public boolean equals(Object obj) {
        if (obj instanceof IPathEntry) {
            IPathEntry otherEntry = (IPathEntry)obj;
            if (!this.path.equals((Object)otherEntry.getPath())) {
                return false;
            }
            if (this.entryKind != otherEntry.getEntryKind()) {
                return false;
            }
            return this.isExported == otherEntry.isExported();
        }
        return super.equals(obj);
    }

    static int kindFromString(String kindStr) {
        if (kindStr.equalsIgnoreCase("prj")) {
            return 2;
        }
        if (kindStr.equalsIgnoreCase("src")) {
            return 3;
        }
        if (kindStr.equalsIgnoreCase("lib")) {
            return 1;
        }
        if (kindStr.equalsIgnoreCase("inc")) {
            return 4;
        }
        if (kindStr.equalsIgnoreCase("mac")) {
            return 6;
        }
        if (kindStr.equalsIgnoreCase("con")) {
            return 5;
        }
        if (kindStr.equalsIgnoreCase("out")) {
            return 7;
        }
        return -1;
    }

    static String kindToString(int kind) {
        switch (kind) {
            case 2: {
                return "prj";
            }
            case 3: {
                return "src";
            }
            case 1: {
                return "lib";
            }
            case 4: {
                return "inc";
            }
            case 6: {
                return "mac";
            }
            case 5: {
                return "con";
            }
            case 7: {
                return "out";
            }
        }
        return "unknown";
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        if (this.path != null && !this.path.isEmpty()) {
            buffer.append(this.path.toString()).append(' ');
        }
        buffer.append('[');
        switch (this.getEntryKind()) {
            case 1: {
                buffer.append("CDT_LIBRARY");
                break;
            }
            case 2: {
                buffer.append("CDT_PROJECT");
                break;
            }
            case 3: {
                buffer.append("CDT_SOURCE");
                break;
            }
            case 7: {
                buffer.append("CDT_OUTPUT");
                break;
            }
            case 4: {
                buffer.append("CDT_INCLUDE");
                break;
            }
            case 6: {
                buffer.append("CDT_MACRO");
                break;
            }
            case 5: {
                buffer.append("CDT_CONTAINER");
            }
        }
        buffer.append(']');
        return buffer.toString();
    }
}

