/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.actions;

import org.eclipse.cdt.debug.core.ICUpdateManager;
import org.eclipse.cdt.debug.internal.ui.actions.AbstractViewActionDelegate;
import org.eclipse.cdt.debug.internal.ui.actions.ActionMessages;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IStructuredSelection;

public abstract class AbstractRefreshActionDelegate
extends AbstractViewActionDelegate {
    protected String getErrorDialogTitle() {
        return ActionMessages.getString("AbstractRefreshActionDelegate.Error_1");
    }

    protected String getErrorDialogMessage() {
        return ActionMessages.getString("AbstractRefreshActionDelegate.Error(s)_occurred_refreshing_the_view_1");
    }

    protected void doAction() throws DebugException {
        ICUpdateManager um;
        if (this.getView() != null && (um = this.getUpdateManager(this.getView().getViewer().getInput())) != null) {
            um.update();
        }
    }

    protected void update() {
        IAction action = this.getAction();
        if (action != null) {
            ICUpdateManager um;
            boolean enabled = false;
            IStructuredSelection selection = this.getSelection();
            if (!selection.isEmpty() && (um = this.getUpdateManager(selection.getFirstElement())) != null && um.canUpdate()) {
                enabled = true;
            }
            action.setEnabled(enabled);
        }
    }

    protected void doHandleDebugEvent(DebugEvent event) {
        switch (event.getKind()) {
            case 8: {
                this.update();
                break;
            }
            case 1: {
                if (event.isEvaluation() && (event.getDetail() & 0x80) != 0) break;
                this.update();
                break;
            }
            case 2: {
                this.update();
            }
        }
    }

    protected abstract ICUpdateManager getUpdateManager(Object var1);
}

