/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.internal.filetype;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.ICDescriptor;
import org.eclipse.cdt.core.filetype.ICFileType;
import org.eclipse.cdt.core.filetype.ICFileTypeAssociation;
import org.eclipse.cdt.core.filetype.ICFileTypeResolver;
import org.eclipse.cdt.core.filetype.ICLanguage;
import org.eclipse.cdt.core.filetype.IResolverChangeListener;
import org.eclipse.cdt.core.filetype.IResolverModel;
import org.eclipse.cdt.core.filetype.ResolverChangeEvent;
import org.eclipse.cdt.core.filetype.ResolverDelta;
import org.eclipse.cdt.core.internal.filetype.CFileType;
import org.eclipse.cdt.core.internal.filetype.CFileTypeAssociation;
import org.eclipse.cdt.core.internal.filetype.CFileTypeResolver;
import org.eclipse.cdt.core.internal.filetype.CLanguage;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ResolverModel
implements IResolverModel {
    public static final String NAME_UNKNOWN = "Unknown";
    public static final ICLanguage DEFAULT_LANG_TYPE = new CLanguage("org.eclipse.cdt.core.language.unknown", "Unknown");
    public static final ICFileType DEFAULT_FILE_TYPE = new CFileType("org.eclipse.cdt.core.fileType.unknown", DEFAULT_LANG_TYPE, "Unknown", 0);
    private Map fLangMap = new HashMap();
    private Map fTypeMap = new HashMap();
    private ICFileTypeResolver fDefaultResolver = null;
    private ICFileTypeResolver fWkspResolver = null;
    private static final String EXTENSION_LANG = "CLanguage";
    private static final String EXTENSION_TYPE = "CFileType";
    private static final String EXTENSION_ASSOC = "CFileTypeAssociation";
    private static final String TAG_CUSTOM = "custom";
    private static final String TAG_ASSOC = "associations";
    private static final String TAG_ENTRY = "entry";
    private static final String ATTR_TYPE = "type";
    private static final String ATTR_PATTERN = "pattern";
    private static final String ATTR_FILE = "file";
    private static final String ATTR_ID = "id";
    private static final String ATTR_LANGUAGE = "language";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_VAL_SOURCE = "source";
    private static final String ATTR_VAL_HEADER = "header";
    private static final String ATTR_VALUE = "value";
    private static final String WKSP_STATE_FILE = "resolver.properties";
    private static final String CDT_RESOLVER = "cdt_resolver";
    public static boolean VERBOSE = false;
    private static ResolverModel fInstance = null;
    private static final String RESOLVER_MODEL_ID = "org.eclipse.cdt.core.resolver";
    private static final QualifiedName QN_CUSTOM_RESOLVER = new QualifiedName("org.eclipse.cdt.core.resolver", "custom");
    private List fListeners = Collections.synchronizedList(new Vector());

    private ResolverModel() {
        try {
            this.loadDeclaredLanguages();
            this.loadDeclaredTypes();
            this.fDefaultResolver = this.loadDefaultResolver();
            this.fWkspResolver = this.loadWorkspaceResolver();
            this.initRegistryChangeListener();
        }
        catch (Exception e) {
            CCorePlugin.log(e);
        }
    }

    public static synchronized ResolverModel getDefault() {
        if (fInstance == null) {
            fInstance = new ResolverModel();
        }
        return fInstance;
    }

    public ICLanguage[] getLanguages() {
        Collection values = this.fLangMap.values();
        return values.toArray(new ICLanguage[values.size()]);
    }

    public ICFileType[] getFileTypes() {
        Collection values = this.fTypeMap.values();
        return values.toArray(new ICFileType[values.size()]);
    }

    public ICLanguage getLanguageById(String languageId) {
        ICLanguage lang = (ICLanguage)this.fLangMap.get(languageId);
        return lang != null ? lang : DEFAULT_LANG_TYPE;
    }

    public ICFileType getFileTypeById(String typeId) {
        ICFileType type = (ICFileType)this.fTypeMap.get(typeId);
        return type != null ? type : DEFAULT_FILE_TYPE;
    }

    public void setResolver(ICFileTypeResolver newResolver) {
        ICFileTypeResolver oldResolver = this.getResolver();
        this.fWkspResolver = newResolver;
        this.saveWorkspaceResolver(newResolver);
        this.fireResolverChangeEvent(null, oldResolver);
    }

    public ICFileTypeResolver getResolver() {
        return this.fWkspResolver != null ? this.fWkspResolver : this.fDefaultResolver;
    }

    public void setResolver(IProject project, ICFileTypeResolver newResolver) {
        ICFileTypeResolver oldResolver = this.getResolver(project);
        try {
            project.setSessionProperty(QN_CUSTOM_RESOLVER, (Object)newResolver);
        }
        catch (CoreException coreException) {}
        this.saveProjectResolver(project, newResolver);
        this.fireResolverChangeEvent(project, oldResolver);
    }

    public ICFileTypeResolver getResolver(IProject project) {
        ICFileTypeResolver resolver = null;
        if (project != null) {
            try {
                Object obj = project.getSessionProperty(QN_CUSTOM_RESOLVER);
                if (obj instanceof ICFileTypeResolver) {
                    resolver = (ICFileTypeResolver)obj;
                }
            }
            catch (CoreException coreException) {}
            if (resolver == null && this.customProjectResolverExists(project)) {
                resolver = this.loadProjectResolver(project);
            }
        }
        if (resolver == null) {
            resolver = this.getResolver();
        }
        return resolver;
    }

    public ICFileTypeAssociation createAssocation(String pattern, ICFileType type) {
        return new CFileTypeAssociation(pattern, type);
    }

    public boolean addLanguage(ICLanguage lang) {
        ResolverChangeEvent event = new ResolverChangeEvent(null);
        boolean result = this.addLanguage(lang, event);
        if (result) {
            this.fireEvent(event);
        }
        return result;
    }

    public boolean addFileType(ICFileType type) {
        ResolverChangeEvent event = new ResolverChangeEvent(null);
        boolean result = this.addFileType(type, event);
        if (result) {
            this.fireEvent(event);
        }
        return result;
    }

    public boolean removeLanguage(ICLanguage lang) {
        ResolverChangeEvent event = new ResolverChangeEvent(null);
        boolean result = this.removeLanguage(lang, event);
        if (result) {
            this.fireEvent(event);
        }
        return result;
    }

    public boolean removeFileType(ICFileType type) {
        ResolverChangeEvent event = new ResolverChangeEvent(null);
        boolean result = this.removeFileType(type, event);
        if (result) {
            this.fireEvent(event);
        }
        return result;
    }

    public void addResolverChangeListener(IResolverChangeListener listener) {
        this.fListeners.add(listener);
    }

    public void removeResolverChangeListener(IResolverChangeListener listener) {
        this.fListeners.remove(listener);
    }

    private IExtensionPoint getExtensionPoint(String extensionPointId) {
        return Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.cdt.core", extensionPointId);
    }

    private static boolean isDebugging() {
        return VERBOSE;
    }

    private static void debugLog(String message) {
        System.out.println("CDT Resolver: " + message);
    }

    private boolean addLanguage(ICLanguage lang, ResolverChangeEvent event) {
        boolean added = false;
        if (!this.fLangMap.containsValue(lang)) {
            this.fLangMap.put(lang.getId(), lang);
            if (event != null) {
                event.addDelta(new ResolverDelta(lang, 16));
            }
            added = true;
        }
        return added;
    }

    private boolean addFileType(ICFileType type, ResolverChangeEvent event) {
        boolean added = false;
        if (!this.fTypeMap.containsValue(type)) {
            this.fTypeMap.put(type.getId(), type);
            if (event != null) {
                event.addDelta(new ResolverDelta(type, 16));
            }
            added = true;
        }
        return added;
    }

    private boolean removeLanguage(ICLanguage lang, ResolverChangeEvent event) {
        boolean removed;
        boolean bl = removed = this.fLangMap.remove(lang.getId()) != null;
        if (removed) {
            if (event != null) {
                event.addDelta(new ResolverDelta(lang, 32));
            }
            ArrayList<ICFileType> removeList = new ArrayList<ICFileType>();
            Iterator<Object> iter = this.fTypeMap.values().iterator();
            while (iter.hasNext()) {
                ICFileType type = (ICFileType)iter.next();
                if (!lang.equals(type.getLanguage())) continue;
                removeList.add(type);
            }
            iter = removeList.iterator();
            while (iter.hasNext()) {
                this.removeFileType((ICFileType)iter.next(), event);
            }
        }
        return removed;
    }

    private boolean removeFileType(ICFileType type, ResolverChangeEvent event) {
        boolean removed;
        boolean bl = removed = this.fTypeMap.remove(type.getId()) != null;
        if (removed && event != null) {
            event.addDelta(new ResolverDelta(type, 32));
        }
        return removed;
    }

    private void fireEvent(final ResolverChangeEvent event) {
        IResolverChangeListener[] listeners;
        List list = this.fListeners;
        synchronized (list) {
            if (ResolverModel.isDebugging()) {
                ResolverModel.debugLog(event.toString());
            }
            if (this.fListeners.isEmpty()) {
                return;
            }
            listeners = this.fListeners.toArray(new IResolverChangeListener[this.fListeners.size()]);
        }
        int i = 0;
        while (i < listeners.length) {
            final int index = i++;
            Platform.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable exception) {
                    Status status = new Status(4, "org.eclipse.cdt.core", -1, CCorePlugin.getResourceString("ResolverModel.exception.listenerError"), exception);
                    CCorePlugin.log((IStatus)status);
                }

                public void run() throws Exception {
                    listeners[index].resolverChanged(event);
                }
            });
        }
    }

    private void fireResolverChangeEvent(IProject project, ICFileTypeResolver oldResolver) {
        ICFileTypeResolver newResolver = this.getResolver(project);
        ResolverChangeEvent event = new ResolverChangeEvent(newResolver);
        int element = 15;
        if (project != null) {
            element = 8;
        }
        event.addDelta(new ResolverDelta(64, element, project));
        if (oldResolver != null && newResolver != null) {
            ICFileTypeAssociation[] oldAssoc = oldResolver.getFileTypeAssociations();
            ICFileTypeAssociation[] newAssoc = newResolver.getFileTypeAssociations();
            int i = 0;
            while (i < oldAssoc.length) {
                if (Arrays.binarySearch(newAssoc, oldAssoc[i], ICFileTypeAssociation.Comparator) < 0) {
                    event.addDelta(new ResolverDelta(oldAssoc[i], 32));
                }
                ++i;
            }
            i = 0;
            while (i < newAssoc.length) {
                if (Arrays.binarySearch(oldAssoc, newAssoc[i], ICFileTypeAssociation.Comparator) < 0) {
                    event.addDelta(new ResolverDelta(newAssoc[i], 16));
                }
                ++i;
            }
        }
        this.fireEvent(event);
    }

    private void initRegistryChangeListener() {
        Platform.getExtensionRegistry().addRegistryChangeListener(new IRegistryChangeListener(){

            public void registryChanged(IRegistryChangeEvent event) {
                ResolverModel.this.handleRegistryChanged(event);
            }
        }, "org.eclipse.cdt.core");
    }

    private void handleRegistryChanged(IRegistryChangeEvent event) {
        IExtensionDelta[] deltas = null;
        ResolverChangeEvent modelEvent = new ResolverChangeEvent(null);
        deltas = event.getExtensionDeltas("org.eclipse.cdt.core", EXTENSION_LANG);
        int i = 0;
        while (i < deltas.length) {
            this.processLanguageExtension(modelEvent, deltas[i].getExtension(), 1 == deltas[i].getKind());
            ++i;
        }
        deltas = event.getExtensionDeltas("org.eclipse.cdt.core", EXTENSION_TYPE);
        i = 0;
        while (i < deltas.length) {
            this.processTypeExtension(modelEvent, deltas[i].getExtension(), 1 == deltas[i].getKind());
            ++i;
        }
        deltas = event.getExtensionDeltas("org.eclipse.cdt.core", EXTENSION_ASSOC);
        if (deltas.length != 0) {
            this.fDefaultResolver = this.loadDefaultResolver();
            this.fWkspResolver = this.loadWorkspaceResolver();
        }
        this.fireEvent(modelEvent);
    }

    private void loadDeclaredLanguages() {
        IExtensionPoint point = this.getExtensionPoint(EXTENSION_LANG);
        IExtension[] extensions = point.getExtensions();
        ResolverChangeEvent event = new ResolverChangeEvent(null);
        int i = 0;
        while (i < extensions.length) {
            this.processLanguageExtension(event, extensions[i], true);
            ++i;
        }
        this.fireEvent(event);
    }

    private void loadDeclaredTypes() {
        IExtensionPoint point = this.getExtensionPoint(EXTENSION_TYPE);
        IExtension[] extensions = point.getExtensions();
        ResolverChangeEvent event = new ResolverChangeEvent(null);
        int i = 0;
        while (i < extensions.length) {
            this.processTypeExtension(event, extensions[i], true);
            ++i;
        }
        this.fireEvent(event);
    }

    private void processLanguageExtension(ResolverChangeEvent event, IExtension extension, boolean add) {
        IConfigurationElement[] elements = extension.getConfigurationElements();
        int i = 0;
        while (i < elements.length) {
            String id = elements[i].getAttribute(ATTR_ID);
            String name = elements[i].getAttribute(ATTR_NAME);
            try {
                CLanguage element = new CLanguage(id, name);
                if (add) {
                    this.addLanguage(element, event);
                } else {
                    this.removeLanguage(element, event);
                }
            }
            catch (IllegalArgumentException e) {
                CCorePlugin.log(e);
            }
            ++i;
        }
    }

    private void processTypeExtension(ResolverChangeEvent event, IExtension extension, boolean add) {
        IConfigurationElement[] elements = extension.getConfigurationElements();
        int i = 0;
        while (i < elements.length) {
            String id = elements[i].getAttribute(ATTR_ID);
            String lang = elements[i].getAttribute(ATTR_LANGUAGE);
            String name = elements[i].getAttribute(ATTR_NAME);
            String type = elements[i].getAttribute(ATTR_TYPE);
            try {
                CFileType element = new CFileType(id, this.getLanguageById(lang), name, this.parseType(type));
                if (add) {
                    this.addFileType(element, event);
                } else {
                    this.removeFileType(element, event);
                }
            }
            catch (IllegalArgumentException e) {
                CCorePlugin.log(e);
            }
            ++i;
        }
    }

    private int parseType(String typeString) {
        int type = 0;
        if (typeString.equals(ATTR_VAL_SOURCE)) {
            type = 1;
        } else if (typeString.equals(ATTR_VAL_HEADER)) {
            type = 2;
        }
        return type;
    }

    private ICFileTypeResolver loadDefaultResolver() {
        ArrayList assoc = new ArrayList();
        CFileTypeResolver resolver = new CFileTypeResolver();
        IExtensionPoint point = this.getExtensionPoint(EXTENSION_ASSOC);
        IExtension[] extensions = point.getExtensions();
        IConfigurationElement[] elements = null;
        int i = 0;
        while (i < extensions.length) {
            elements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < elements.length) {
                ICFileType typeRef = this.getFileTypeById(elements[j].getAttribute(ATTR_TYPE));
                if (typeRef != null) {
                    assoc.addAll(this.getAssocFromPattern(typeRef, elements[j]));
                    assoc.addAll(this.getAssocFromFile(typeRef, elements[j]));
                }
                ++j;
            }
            ++i;
        }
        resolver.addAssociations(assoc.toArray(new ICFileTypeAssociation[assoc.size()]));
        return resolver;
    }

    private List getAssocFromPattern(ICFileType typeRef, IConfigurationElement element) {
        ArrayList<ICFileTypeAssociation> assocs = new ArrayList<ICFileTypeAssociation>();
        String attr = element.getAttribute(ATTR_PATTERN);
        if (attr != null) {
            String[] item = attr.split(",");
            int i = 0;
            while (i < item.length) {
                try {
                    assocs.add(this.createAssocation(item[i].trim(), typeRef));
                }
                catch (IllegalArgumentException e) {
                    CCorePlugin.log(e);
                }
                ++i;
            }
        }
        return assocs;
    }

    private List getAssocFromFile(ICFileType typeRef, IConfigurationElement element) {
        ArrayList<ICFileTypeAssociation> assocs = new ArrayList<ICFileTypeAssociation>();
        String attr = element.getAttribute(ATTR_FILE);
        if (attr != null) {
            URL baseURL = null;
            URL fileURL = null;
            BufferedReader in = null;
            String line = null;
            try {
                baseURL = Platform.getBundle((String)element.getDeclaringExtension().getNamespace()).getEntry("/");
                fileURL = new URL(baseURL, attr);
                in = new BufferedReader(new InputStreamReader(fileURL.openStream()));
                line = in.readLine();
                while (line != null) {
                    try {
                        assocs.add(this.createAssocation(line.trim(), typeRef));
                    }
                    catch (IllegalArgumentException e) {
                        CCorePlugin.log(e);
                    }
                    line = in.readLine();
                }
                in.close();
            }
            catch (IOException e) {
                CCorePlugin.log(e);
            }
        }
        return assocs;
    }

    private boolean customWorkspaceResolverExists() {
        return this.getWorkspaceResolverStateFilePath().toFile().exists();
    }

    private IPath getWorkspaceResolverStateFilePath() {
        return CCorePlugin.getDefault().getStateLocation().append(WKSP_STATE_FILE);
    }

    private ICFileTypeResolver loadWorkspaceResolver() {
        ArrayList<ICFileTypeAssociation> assocs = new ArrayList<ICFileTypeAssociation>();
        CFileTypeResolver resolver = null;
        File file = this.getWorkspaceResolverStateFilePath().toFile();
        if (file.exists()) {
            Properties props = new Properties();
            FileInputStream in = null;
            resolver = new CFileTypeResolver();
            try {
                in = new FileInputStream(file);
                props.load(in);
                Iterator<Map.Entry<Object, Object>> iter = props.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry<Object, Object> element = iter.next();
                    ICFileType type = this.getFileTypeById(element.getValue().toString());
                    try {
                        assocs.add(this.createAssocation(element.getKey().toString(), type));
                    }
                    catch (IllegalArgumentException e) {
                        CCorePlugin.log(e);
                    }
                }
                in.close();
            }
            catch (IOException e) {
                CCorePlugin.log(e);
            }
            if (in != null) {
                in = null;
            }
            resolver.addAssociations(assocs.toArray(new ICFileTypeAssociation[assocs.size()]));
        }
        return resolver;
    }

    private void saveWorkspaceResolver(ICFileTypeResolver resolver) {
        File file = this.getWorkspaceResolverStateFilePath().toFile();
        BufferedWriter out = null;
        try {
            if (resolver == null) {
                file.delete();
            } else {
                out = new BufferedWriter(new FileWriter(file));
                ICFileTypeAssociation[] assoc = resolver.getFileTypeAssociations();
                int i = 0;
                while (i < assoc.length) {
                    out.write(String.valueOf(assoc[i].getPattern()) + '=' + assoc[i].getType().getId() + "\n");
                    ++i;
                }
                out.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (out != null) {
            out = null;
        }
    }

    private boolean customProjectResolverExists(IProject project) {
        Element data = this.getProjectData(project, false);
        Node child = data != null ? data.getFirstChild() : null;
        Boolean custom = new Boolean(false);
        while (child != null) {
            if (child.getNodeName().equals(TAG_CUSTOM)) {
                custom = Boolean.valueOf(((Element)child).getAttribute(ATTR_VALUE));
            }
            child = child.getNextSibling();
        }
        return custom;
    }

    private ICDescriptor getProjectDescriptor(IProject project, boolean create) throws CoreException {
        ICDescriptor descriptor = null;
        descriptor = CCorePlugin.getDefault().getCProjectDescription(project, create);
        return descriptor;
    }

    private Element getProjectData(IProject project, boolean create) {
        Element data = null;
        try {
            ICDescriptor desc = this.getProjectDescriptor(project, create);
            if (desc != null) {
                data = desc.getProjectData(CDT_RESOLVER);
            }
        }
        catch (CoreException coreException) {}
        return data;
    }

    private ICFileTypeResolver loadProjectResolver(IProject project) {
        ArrayList<ICFileTypeAssociation> assocs = new ArrayList<ICFileTypeAssociation>();
        CFileTypeResolver resolver = new CFileTypeResolver();
        Element data = this.getProjectData(project, false);
        Node child = data != null ? data.getFirstChild() : null;
        while (child != null) {
            if (child.getNodeName().equals(TAG_ASSOC)) {
                Node assoc = child.getFirstChild();
                while (assoc != null) {
                    if (assoc.getNodeName().equals(TAG_ENTRY)) {
                        Element element = (Element)assoc;
                        String pattern = element.getAttribute(ATTR_PATTERN);
                        String typeId = element.getAttribute(ATTR_TYPE);
                        try {
                            assocs.add(this.createAssocation(pattern, this.getFileTypeById(typeId)));
                        }
                        catch (IllegalArgumentException e) {
                            CCorePlugin.log(e);
                        }
                    }
                    assoc = assoc.getNextSibling();
                }
            }
            child = child.getNextSibling();
        }
        resolver.addAssociations(assocs.toArray(new ICFileTypeAssociation[assocs.size()]));
        return resolver;
    }

    private void saveProjectResolver(IProject project, ICFileTypeResolver resolver) {
        Element root = this.getProjectData(project, true);
        Document doc = root.getOwnerDocument();
        Node child = root.getFirstChild();
        Element element = null;
        while (child != null) {
            root.removeChild(child);
            child = root.getFirstChild();
        }
        element = doc.createElement(TAG_CUSTOM);
        element.setAttribute(ATTR_VALUE, new Boolean(resolver != null).toString());
        root.appendChild(element);
        if (resolver != null) {
            element = doc.createElement(TAG_ASSOC);
            root.appendChild(element);
            root = element;
            ICFileTypeAssociation[] assoc = resolver.getFileTypeAssociations();
            int i = 0;
            while (i < assoc.length) {
                element = doc.createElement(TAG_ENTRY);
                element.setAttribute(ATTR_PATTERN, assoc[i].getPattern());
                element.setAttribute(ATTR_TYPE, assoc[i].getType().getId());
                root.appendChild(element);
                ++i;
            }
        }
        try {
            this.getProjectDescriptor(project, true).saveProjectData();
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
        }
    }
}

