/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.browser.cache;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.browser.IWorkingCopyProvider;
import org.eclipse.cdt.core.browser.TypeSearchScope;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICElementDelta;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.core.browser.cache.ITypeCache;
import org.eclipse.cdt.internal.core.browser.cache.TypeCache;
import org.eclipse.cdt.internal.core.browser.cache.TypeCacheDelta;
import org.eclipse.cdt.internal.core.browser.cache.TypeCacherJob;
import org.eclipse.cdt.internal.core.browser.cache.TypeLocatorJob;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.IJobManager;

public class TypeCacheManager {
    private Map fCacheMap = new HashMap();
    private IWorkingCopyProvider fWorkingCopyProvider;
    private static final int PATH_ENTRY_FLAGS = 265984;

    public TypeCacheManager(IWorkingCopyProvider workingCopyProvider) {
        this.fWorkingCopyProvider = workingCopyProvider;
    }

    public synchronized void updateProject(IProject project) {
        TypeCacheDelta cacheDelta = new TypeCacheDelta(project);
        this.getCache(project).addDelta(cacheDelta);
    }

    public synchronized void processDelta(ICElementDelta delta) {
        ICElementDelta[] children;
        ICElement elem = delta.getElement();
        boolean added = delta.getKind() == 1;
        boolean removed = delta.getKind() == 2;
        boolean contentChanged = (delta.getFlags() & 1) != 0;
        boolean pathEntryChanged = (delta.getFlags() & 0x40F00) != 0;
        boolean hasChildren = (delta.getFlags() & 8) != 0;
        switch (elem.getElementType()) {
            case 11: 
            case 12: {
                ICProject cProject = elem.getCProject();
                IProject project = cProject.getProject();
                if (!added && !removed && !pathEntryChanged) break;
                TypeCacheDelta cacheDelta = new TypeCacheDelta(project, delta);
                this.getCache(project).addDelta(cacheDelta);
                break;
            }
            case 60: {
                ICProject cProject = elem.getCProject();
                IProject project = cProject.getProject();
                ITranslationUnit unit = (ITranslationUnit)elem;
                if (unit.isWorkingCopy()) {
                    this.processWorkingCopyDelta(delta);
                    return;
                }
                if (!added && !removed && !pathEntryChanged && !contentChanged) break;
                TypeCacheDelta cacheDelta = new TypeCacheDelta(project, delta);
                this.getCache(project).addDelta(cacheDelta);
                break;
            }
            case 61: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 72: 
            case 73: 
            case 78: {
                ICProject cProject = elem.getCProject();
                IProject project = cProject.getProject();
                if (!added && !removed) break;
                TypeCacheDelta cacheDelta = new TypeCacheDelta(project, delta);
                this.getCache(project).addDelta(cacheDelta);
            }
        }
        if (hasChildren && (children = delta.getAffectedChildren()) != null) {
            int i = 0;
            while (i < children.length) {
                this.processDelta(children[i]);
                ++i;
            }
        }
    }

    public synchronized void processWorkingCopyDelta(ICElementDelta delta) {
    }

    public synchronized ITypeCache getCache(IProject project) {
        Map map = this.fCacheMap;
        synchronized (map) {
            ITypeCache cache = (ITypeCache)this.fCacheMap.get(project);
            if (cache == null) {
                cache = new TypeCache(project, this.fWorkingCopyProvider);
                this.fCacheMap.put(project, cache);
            }
            return cache;
        }
    }

    public synchronized void reconcile(boolean enableIndexing, int priority, int delay) {
        TypeSearchScope workspaceScope = new TypeSearchScope(true);
        IProject[] projects = workspaceScope.getEnclosingProjects();
        int i = 0;
        while (i < projects.length) {
            ITypeCache cache = this.getCache(projects[i]);
            cache.reconcile(enableIndexing, priority, delay);
            ++i;
        }
    }

    public synchronized void reconcileAndWait(boolean enableIndexing, int priority, IProgressMonitor monitor) {
        TypeSearchScope workspaceScope = new TypeSearchScope(true);
        IProject[] projects = workspaceScope.getEnclosingProjects();
        int i = 0;
        while (i < projects.length) {
            ITypeCache cache = this.getCache(projects[i]);
            cache.reconcileAndWait(enableIndexing, priority, monitor);
            ++i;
        }
    }

    public void cancelJobs() {
        IJobManager jobManager = Platform.getJobManager();
        jobManager.cancel(TypeCacherJob.FAMILY);
        jobManager.cancel(TypeLocatorJob.FAMILY);
    }
}

