/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.corext.refactoring;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.search.BasicSearchMatch;
import org.eclipse.cdt.core.search.BasicSearchResultCollector;
import org.eclipse.cdt.core.search.ICSearchPattern;
import org.eclipse.cdt.core.search.ICSearchResultCollector;
import org.eclipse.cdt.core.search.ICSearchScope;
import org.eclipse.cdt.core.search.SearchEngine;
import org.eclipse.cdt.internal.corext.Assert;
import org.eclipse.cdt.internal.corext.refactoring.SearchResultGroup;
import org.eclipse.cdt.internal.corext.util.CModelUtil;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;

public class RefactoringSearchEngine {
    private RefactoringSearchEngine() {
    }

    public static ITranslationUnit[] findAffectedTranslationUnits(IProgressMonitor pm, ICSearchScope scope, ICSearchPattern pattern) throws CModelException {
        HashSet matches = new HashSet(5);
        BasicSearchResultCollector collector = new BasicSearchResultCollector();
        try {
            new SearchEngine().search(ResourcesPlugin.getWorkspace(), pattern, scope, (ICSearchResultCollector)collector, false);
        }
        catch (InterruptedException interruptedException) {}
        ArrayList<ITranslationUnit> result = new ArrayList<ITranslationUnit>(matches.size());
        Iterator iter = matches.iterator();
        while (iter.hasNext()) {
            IResource resource = (IResource)iter.next();
            ICElement element = CoreModel.getDefault().create(resource);
            if (!(element instanceof ITranslationUnit)) continue;
            ITranslationUnit original = (ITranslationUnit)element;
            result.add(CModelUtil.toWorkingCopy(original));
        }
        return result.toArray(new ITranslationUnit[result.size()]);
    }

    public static SearchResultGroup[] search(IProgressMonitor pm, ICSearchScope scope, ICSearchPattern pattern) throws CModelException {
        return RefactoringSearchEngine.search(scope, pattern, new BasicSearchResultCollector(pm));
    }

    public static SearchResultGroup[] search(ICSearchScope scope, ICSearchPattern pattern, BasicSearchResultCollector collector) throws CModelException {
        return RefactoringSearchEngine.search(scope, pattern, collector, null);
    }

    public static SearchResultGroup[] search(IProgressMonitor pm, ICSearchScope scope, ICSearchPattern pattern, ITranslationUnit[] workingCopies) throws CModelException {
        return RefactoringSearchEngine.search(scope, pattern, new BasicSearchResultCollector(pm), workingCopies);
    }

    public static SearchResultGroup[] search(ICSearchScope scope, ICSearchPattern pattern, BasicSearchResultCollector collector, ITranslationUnit[] workingCopies) throws CModelException {
        RefactoringSearchEngine.internalSearch(scope, pattern, (ICSearchResultCollector)collector, workingCopies);
        Set results = collector.getSearchResults();
        ArrayList resultList = new ArrayList(results);
        return RefactoringSearchEngine.groupByResource(RefactoringSearchEngine.createSearchResultArray(resultList));
    }

    public static SearchResultGroup[] groupByResource(BasicSearchMatch[] results) {
        Map grouped = RefactoringSearchEngine.groupByResource(Arrays.asList(results));
        SearchResultGroup[] result = new SearchResultGroup[grouped.keySet().size()];
        int i = 0;
        Iterator iter = grouped.keySet().iterator();
        while (iter.hasNext()) {
            IResource resource = (IResource)iter.next();
            List searchResults = (List)grouped.get(resource);
            result[i] = new SearchResultGroup(resource, RefactoringSearchEngine.createSearchResultArray(searchResults));
            ++i;
        }
        return result;
    }

    private static BasicSearchMatch[] createSearchResultArray(List searchResults) {
        return searchResults.toArray(new BasicSearchMatch[searchResults.size()]);
    }

    private static Map groupByResource(List searchResults) {
        HashMap grouped = new HashMap();
        Iterator iter = searchResults.iterator();
        while (iter.hasNext()) {
            BasicSearchMatch searchResult = (BasicSearchMatch)iter.next();
            if (!grouped.containsKey(searchResult.getResource())) {
                grouped.put(searchResult.getResource(), new ArrayList(1));
            }
            ((List)grouped.get(searchResult.getResource())).add(searchResult);
        }
        return grouped;
    }

    private static void internalSearch(ICSearchScope scope, ICSearchPattern pattern, ICSearchResultCollector collector, ITranslationUnit[] workingCopies) throws CModelException {
        if (pattern == null) {
            return;
        }
        Assert.isNotNull(scope, "scope");
        try {
            RefactoringSearchEngine.createSearchEngine(workingCopies).search(ResourcesPlugin.getWorkspace(), pattern, scope, collector, false);
        }
        catch (InterruptedException interruptedException) {}
    }

    private static SearchEngine createSearchEngine(ITranslationUnit[] workingCopies) {
        return new SearchEngine();
    }
}

