/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text.contentassist;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.cdt.core.parser.ast.ASTAccessVisibility;
import org.eclipse.cdt.internal.ui.CElementImageProvider;
import org.eclipse.cdt.internal.ui.text.contentassist.CCompletionProposal;
import org.eclipse.cdt.internal.ui.text.contentassist.CProposalContextInformation;
import org.eclipse.cdt.internal.ui.text.contentassist.CompletionRequestorAdaptor;
import org.eclipse.cdt.internal.ui.text.contentassist.IProblem;
import org.eclipse.cdt.internal.ui.util.ImageDescriptorRegistry;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.FunctionPrototypeSummary;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.swt.graphics.Image;

public class ResultCollector
extends CompletionRequestorAdaptor {
    private static final char[] METHOD_WITH_ARGUMENTS_TRIGGERS = new char[]{'(', '-', ' '};
    private static final char[] METHOD_TRIGGERS = new char[]{';', ',', '.', '\t', '[', ' '};
    private static final char[] TYPE_TRIGGERS = new char[]{'.', '\t', '[', '(', ' '};
    private static final char[] VAR_TRIGGERS = new char[]{'\t', ' ', '[', '(', '=', '-', ';', ',', '.'};
    private final String DEFINE = "#define ";
    private Set completions = new HashSet();
    private ImageDescriptorRegistry registry = CUIPlugin.getImageDescriptorRegistry();
    private IProblem fLastProblem;
    private ITextViewer fTextViewer;

    public ResultCollector() {
        this.completions.clear();
        this.fTextViewer = null;
    }

    public Set getCompletions() {
        return this.completions;
    }

    public void reset(ITextViewer viewer) {
        this.completions.clear();
        this.fTextViewer = viewer;
        this.fLastProblem = null;
    }

    public CCompletionProposal createProposal(String replaceString, String displayString, String infoString, String arguments, int contextInfoOffset, Image image, int offset, int length, int relevance) {
        CCompletionProposal proposal = new CCompletionProposal(replaceString, offset, length, image, displayString, relevance, this.fTextViewer);
        if (arguments != null && arguments.length() > 0) {
            CProposalContextInformation info = new CProposalContextInformation(replaceString, arguments);
            info.setContextInformationPosition(contextInfoOffset - 1);
            proposal.setContextInformation(info);
        }
        if (infoString != null && !displayString.equals(infoString)) {
            proposal.setAdditionalProposalInfo(infoString);
        }
        return proposal;
    }

    public void acceptField(String name, String returnType, ASTAccessVisibility visibility, int completionStart, int completionLength, int relevance) {
        String replaceString = "";
        String displayString = "";
        Image image = null;
        StringBuffer infoString = new StringBuffer();
        replaceString = name;
        displayString = name;
        if (returnType != null) {
            displayString = String.valueOf(displayString) + " : " + returnType;
        }
        ImageDescriptor imageDescriptor = CElementImageProvider.getFieldImageDescriptor(visibility);
        image = this.registry.get(imageDescriptor);
        CCompletionProposal proposal = this.createProposal(replaceString, displayString, infoString.toString(), null, 0, image, completionStart, completionLength, relevance);
        proposal.setTriggerCharacters(VAR_TRIGGERS);
        this.completions.add(proposal);
    }

    public void acceptClass(String name, int completionStart, int completionLength, int relevance) {
        String replaceString = "";
        String displayString = "";
        Image image = null;
        StringBuffer infoString = new StringBuffer();
        replaceString = name;
        displayString = name;
        ImageDescriptor imageDescriptor = CElementImageProvider.getClassImageDescriptor();
        image = this.registry.get(imageDescriptor);
        CCompletionProposal proposal = this.createProposal(replaceString, displayString, infoString.toString(), null, 0, image, completionStart, completionLength, relevance);
        proposal.setTriggerCharacters(TYPE_TRIGGERS);
        this.completions.add(proposal);
    }

    public void acceptFunction(String name, String parameterString, String returnType, int completionStart, int completionLength, int relevance, boolean insertFunctionName, int contextInfoOffset) {
        FunctionPrototypeSummary fproto;
        String replaceString = "";
        String displayString = "";
        String arguments = "";
        Image image = null;
        StringBuffer infoString = new StringBuffer();
        replaceString = name;
        displayString = name;
        String functionPrototype = String.valueOf(returnType) + " " + name;
        if (parameterString != null) {
            functionPrototype = parameterString.indexOf("(") == -1 && parameterString.indexOf(")") == -1 ? String.valueOf(functionPrototype) + "(" + parameterString + ")" : String.valueOf(functionPrototype) + parameterString;
        }
        if ((fproto = new FunctionPrototypeSummary(functionPrototype)) != null) {
            replaceString = String.valueOf(fproto.getName()) + "()";
            displayString = fproto.getPrototypeString(true);
            infoString.append(displayString);
            arguments = fproto.getArguments();
        }
        ImageDescriptor imageDescriptor = CElementImageProvider.getFunctionImageDescriptor();
        image = this.registry.get(imageDescriptor);
        if (!insertFunctionName) {
            replaceString = "";
        }
        CCompletionProposal proposal = this.createProposal(replaceString, displayString, infoString.toString(), arguments, contextInfoOffset, image, completionStart, completionLength, relevance);
        boolean userMustCompleteParameters = arguments != null && arguments.length() > 0 && insertFunctionName;
        char[] triggers = userMustCompleteParameters ? METHOD_WITH_ARGUMENTS_TRIGGERS : METHOD_TRIGGERS;
        proposal.setTriggerCharacters(triggers);
        if (userMustCompleteParameters) {
            proposal.setCursorPosition(replaceString.length() - 1);
        }
        this.completions.add(proposal);
    }

    public void acceptLocalVariable(String name, String returnType, int completionStart, int completionLength, int relevance) {
        String replaceString = "";
        String displayString = "";
        Image image = null;
        StringBuffer infoString = new StringBuffer();
        replaceString = name;
        displayString = name;
        if (returnType != null) {
            displayString = String.valueOf(displayString) + " : " + returnType;
        }
        ImageDescriptor imageDescriptor = CElementImageProvider.getLocalVariableImageDescriptor();
        image = this.registry.get(imageDescriptor);
        CCompletionProposal proposal = this.createProposal(replaceString, displayString, infoString.toString(), null, 0, image, completionStart, completionLength, relevance);
        proposal.setTriggerCharacters(VAR_TRIGGERS);
        this.completions.add(proposal);
    }

    public void acceptMacro(String name, int completionStart, int completionLength, int relevance, int contextInfoOffset) {
        boolean userMustCompleteParameters;
        String replaceString = "";
        String displayString = "";
        String arguments = "";
        Image image = null;
        StringBuffer infoString = new StringBuffer();
        String prototype = "";
        int bracket = name.indexOf(123);
        prototype = name.startsWith("#define ") ? name.substring("#define ".length(), bracket == -1 ? name.length() : bracket) : name;
        int leftbracket = prototype.indexOf(40);
        int rightbracket = prototype.lastIndexOf(41);
        if (leftbracket == -1 && rightbracket == -1) {
            replaceString = prototype;
            displayString = prototype;
        } else {
            FunctionPrototypeSummary fproto = new FunctionPrototypeSummary(prototype);
            if (fproto != null) {
                replaceString = String.valueOf(fproto.getName()) + "()";
                displayString = fproto.getPrototypeString(true, false);
                infoString.append(displayString);
                arguments = fproto.getArguments();
            } else {
                replaceString = prototype;
                displayString = prototype;
            }
        }
        ImageDescriptor imageDescriptor = CElementImageProvider.getMacroImageDescriptor();
        image = this.registry.get(imageDescriptor);
        CCompletionProposal proposal = this.createProposal(replaceString, displayString, infoString.toString(), arguments, contextInfoOffset, image, completionStart, completionLength, relevance);
        proposal.setTriggerCharacters(VAR_TRIGGERS);
        boolean bl = userMustCompleteParameters = arguments != null && arguments.length() > 0;
        if (userMustCompleteParameters) {
            proposal.setCursorPosition(replaceString.length() - 1);
        }
        this.completions.add(proposal);
    }

    public void acceptMethod(String name, String parameterString, String returnType, ASTAccessVisibility visibility, int completionStart, int completionLength, int relevance, boolean insertFunctionName, int contextInfoOffset) {
        FunctionPrototypeSummary fproto;
        String replaceString = "";
        String displayString = "";
        String arguments = "";
        Image image = null;
        StringBuffer infoString = new StringBuffer();
        replaceString = name;
        displayString = name;
        String functionPrototype = String.valueOf(returnType) + " " + name;
        if (parameterString != null) {
            functionPrototype = parameterString.indexOf("(") == -1 && parameterString.indexOf(")") == -1 ? String.valueOf(functionPrototype) + "(" + parameterString + ")" : String.valueOf(functionPrototype) + parameterString;
        }
        if ((fproto = new FunctionPrototypeSummary(functionPrototype)) != null) {
            replaceString = String.valueOf(fproto.getName()) + "()";
            displayString = fproto.getPrototypeString(true);
            infoString.append(displayString);
            arguments = fproto.getArguments();
        }
        ImageDescriptor imageDescriptor = CElementImageProvider.getMethodImageDescriptor(visibility);
        image = this.registry.get(imageDescriptor);
        if (!insertFunctionName) {
            replaceString = "";
        }
        CCompletionProposal proposal = this.createProposal(replaceString, displayString, infoString.toString(), arguments, contextInfoOffset, image, completionStart, completionLength, relevance);
        boolean userMustCompleteParameters = arguments != null && arguments.length() > 0 && insertFunctionName;
        char[] triggers = userMustCompleteParameters ? METHOD_WITH_ARGUMENTS_TRIGGERS : METHOD_TRIGGERS;
        proposal.setTriggerCharacters(triggers);
        if (userMustCompleteParameters) {
            proposal.setCursorPosition(replaceString.length() - 1);
        }
        this.completions.add(proposal);
    }

    public void acceptNamespace(String name, int completionStart, int completionLength, int relevance) {
        String replaceString = "";
        String displayString = "";
        Image image = null;
        StringBuffer infoString = new StringBuffer();
        replaceString = name;
        displayString = name;
        ImageDescriptor imageDescriptor = CElementImageProvider.getNamespaceImageDescriptor();
        image = this.registry.get(imageDescriptor);
        CCompletionProposal proposal = this.createProposal(replaceString, displayString, infoString.toString(), null, 0, image, completionStart, completionLength, relevance);
        proposal.setTriggerCharacters(TYPE_TRIGGERS);
        this.completions.add(proposal);
    }

    public void acceptStruct(String name, int completionStart, int completionLength, int relevance) {
        String replaceString = "";
        String displayString = "";
        Image image = null;
        StringBuffer infoString = new StringBuffer();
        replaceString = name;
        displayString = name;
        ImageDescriptor imageDescriptor = CElementImageProvider.getStructImageDescriptor();
        image = this.registry.get(imageDescriptor);
        CCompletionProposal proposal = this.createProposal(replaceString, displayString, infoString.toString(), null, 0, image, completionStart, completionLength, relevance);
        proposal.setTriggerCharacters(TYPE_TRIGGERS);
        this.completions.add(proposal);
    }

    public void acceptUnion(String name, int completionStart, int completionLength, int relevance) {
        String replaceString = "";
        String displayString = "";
        Image image = null;
        StringBuffer infoString = new StringBuffer();
        replaceString = name;
        displayString = name;
        ImageDescriptor imageDescriptor = CElementImageProvider.getUnionImageDescriptor();
        image = this.registry.get(imageDescriptor);
        CCompletionProposal proposal = this.createProposal(replaceString, displayString, infoString.toString(), null, 0, image, completionStart, completionLength, relevance);
        proposal.setTriggerCharacters(TYPE_TRIGGERS);
        this.completions.add(proposal);
    }

    public void acceptVariable(String name, String returnType, int completionStart, int completionLength, int relevance) {
        String replaceString = "";
        String displayString = "";
        Image image = null;
        StringBuffer infoString = new StringBuffer();
        replaceString = name;
        displayString = name;
        if (returnType != null) {
            displayString = String.valueOf(displayString) + " : " + returnType;
        }
        ImageDescriptor imageDescriptor = CElementImageProvider.getVariableImageDescriptor();
        image = this.registry.get(imageDescriptor);
        CCompletionProposal proposal = this.createProposal(replaceString, displayString, infoString.toString(), null, 0, image, completionStart, completionLength, relevance);
        proposal.setTriggerCharacters(VAR_TRIGGERS);
        this.completions.add(proposal);
    }

    public void acceptEnumeration(String name, int completionStart, int completionLength, int relevance) {
        String replaceString = "";
        String displayString = "";
        Image image = null;
        StringBuffer infoString = new StringBuffer();
        replaceString = name;
        displayString = name;
        ImageDescriptor imageDescriptor = CElementImageProvider.getEnumerationImageDescriptor();
        image = this.registry.get(imageDescriptor);
        CCompletionProposal proposal = this.createProposal(replaceString, displayString, infoString.toString(), null, 0, image, completionStart, completionLength, relevance);
        proposal.setTriggerCharacters(TYPE_TRIGGERS);
        this.completions.add(proposal);
    }

    public void acceptEnumerator(String name, int completionStart, int completionLength, int relevance) {
        String replaceString = "";
        String displayString = "";
        Image image = null;
        StringBuffer infoString = new StringBuffer();
        replaceString = name;
        displayString = name;
        ImageDescriptor imageDescriptor = CElementImageProvider.getEnumeratorImageDescriptor();
        image = this.registry.get(imageDescriptor);
        CCompletionProposal proposal = this.createProposal(replaceString, displayString, infoString.toString(), null, 0, image, completionStart, completionLength, relevance);
        proposal.setTriggerCharacters(VAR_TRIGGERS);
        this.completions.add(proposal);
    }

    public void acceptTypedef(String name, int completionStart, int completionLength, int relevance) {
        String replaceString = "";
        String displayString = "";
        Image image = null;
        StringBuffer infoString = new StringBuffer();
        replaceString = name;
        displayString = name;
        ImageDescriptor imageDescriptor = CElementImageProvider.getTypedefImageDescriptor();
        image = this.registry.get(imageDescriptor);
        CCompletionProposal proposal = this.createProposal(replaceString, displayString, infoString.toString(), null, 0, image, completionStart, completionLength, relevance);
        proposal.setTriggerCharacters(TYPE_TRIGGERS);
        this.completions.add(proposal);
    }

    public void acceptKeyword(String name, int completionStart, int completionLength, int relevance) {
        String replaceString = "";
        String displayString = "";
        Image image = null;
        StringBuffer infoString = new StringBuffer();
        replaceString = name;
        displayString = name;
        ImageDescriptor imageDescriptor = CElementImageProvider.getKeywordImageDescriptor();
        image = this.registry.get(imageDescriptor);
        CCompletionProposal proposal = this.createProposal(replaceString, displayString, infoString.toString(), null, 0, image, completionStart, completionLength, relevance);
        proposal.setTriggerCharacters(VAR_TRIGGERS);
        this.completions.add(proposal);
    }

    public void acceptError(IProblem error) {
        this.fLastProblem = error;
    }

    public String getErrorMessage() {
        if (this.fLastProblem != null) {
            return this.fLastProblem.getMessage();
        }
        return "";
    }
}

