/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.parser.BacktrackException;
import org.eclipse.cdt.core.parser.EndOfFileException;
import org.eclipse.cdt.core.parser.IParserLogService;
import org.eclipse.cdt.core.parser.IProblem;
import org.eclipse.cdt.core.parser.IScanner;
import org.eclipse.cdt.core.parser.IToken;
import org.eclipse.cdt.core.parser.ITokenDuple;
import org.eclipse.cdt.core.parser.KeywordSetKey;
import org.eclipse.cdt.core.parser.OffsetLimitReachedException;
import org.eclipse.cdt.core.parser.ParseError;
import org.eclipse.cdt.core.parser.ParserFactory;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.core.parser.ParserMode;
import org.eclipse.cdt.core.parser.ScannerException;
import org.eclipse.cdt.core.parser.ast.ASTPointerOperator;
import org.eclipse.cdt.core.parser.ast.ASTSemanticException;
import org.eclipse.cdt.core.parser.ast.IASTArrayModifier;
import org.eclipse.cdt.core.parser.ast.IASTCompletionNode;
import org.eclipse.cdt.core.parser.ast.IASTExpression;
import org.eclipse.cdt.core.parser.ast.IASTFactory;
import org.eclipse.cdt.core.parser.ast.IASTNode;
import org.eclipse.cdt.core.parser.ast.IASTScope;
import org.eclipse.cdt.core.parser.ast.IASTSimpleTypeSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTTypeId;
import org.eclipse.cdt.core.parser.extension.IParserExtension;
import org.eclipse.cdt.internal.core.parser.DeclarationWrapper;
import org.eclipse.cdt.internal.core.parser.Declarator;
import org.eclipse.cdt.internal.core.parser.IDeclarator;
import org.eclipse.cdt.internal.core.parser.IExpressionParser;
import org.eclipse.cdt.internal.core.parser.IParserData;
import org.eclipse.cdt.internal.core.parser.TemplateParameterManager;
import org.eclipse.cdt.internal.core.parser.TypeId;
import org.eclipse.cdt.internal.core.parser.scanner2.CharArrayUtils;
import org.eclipse.cdt.internal.core.parser.token.TokenFactory;
import org.eclipse.cdt.internal.core.parser.util.TraceUtil;

public class ExpressionParser
implements IExpressionParser,
IParserData {
    protected static final char[] EMPTY_STRING = "".toCharArray();
    private static int FIRST_ERROR_UNSET = -1;
    protected boolean parsePassed = true;
    protected int firstErrorOffset = FIRST_ERROR_UNSET;
    protected int firstErrorLine = FIRST_ERROR_UNSET;
    private BacktrackException backtrack = new BacktrackException();
    private int backtrackCount = 0;
    protected final IParserExtension extension;
    protected final IParserLogService log;
    protected ParserLanguage language = ParserLanguage.CPP;
    protected IASTFactory astFactory = null;
    protected IScanner scanner;
    protected IToken currToken;
    protected IToken lastToken;
    private boolean limitReached = false;
    private ScopeStack templateIdScopes = new ScopeStack();
    private TypeId typeIdInstance = new TypeId();
    protected boolean isCancelled = false;

    protected final void throwBacktrack(IProblem problem) throws BacktrackException {
        ++this.backtrackCount;
        this.backtrack.initialize(problem);
        throw this.backtrack;
    }

    protected final void throwBacktrack(int startingOffset, int endingOffset, int lineNumber, char[] f) throws BacktrackException {
        ++this.backtrackCount;
        this.backtrack.initialize(startingOffset, endingOffset == 0 ? startingOffset + 1 : endingOffset, lineNumber, f);
        throw this.backtrack;
    }

    public IASTFactory getAstFactory() {
        return this.astFactory;
    }

    public IParserLogService getLog() {
        return this.log;
    }

    public IToken LA(int i) throws EndOfFileException {
        if (this.isCancelled) {
            throw new ParseError(ParseError.ParseErrorKind.TIMEOUT_OR_CANCELLED);
        }
        if (i < 1) {
            return null;
        }
        if (this.currToken == null) {
            this.currToken = this.fetchToken();
        }
        IToken retToken = this.currToken;
        while (i > 1) {
            if ((retToken = retToken.getNext()) == null) {
                retToken = this.fetchToken();
            }
            --i;
        }
        return retToken;
    }

    public int LT(int i) throws EndOfFileException {
        return this.LA(i).getType();
    }

    public IToken consume() throws EndOfFileException {
        if (this.currToken == null) {
            this.currToken = this.fetchToken();
        }
        if (this.currToken != null) {
            this.lastToken = this.currToken;
        }
        this.currToken = this.currToken.getNext();
        this.handleNewToken(this.lastToken);
        return this.lastToken;
    }

    public IToken consume(int type) throws EndOfFileException, BacktrackException {
        if (this.LT(1) == type) {
            return this.consume();
        }
        IToken la = this.LA(1);
        this.throwBacktrack(la.getOffset(), la.getEndOffset(), la.getLineNumber(), la.getFilename());
        return null;
    }

    public IToken mark() throws EndOfFileException {
        if (this.currToken == null) {
            this.currToken = this.fetchToken();
        }
        return this.currToken;
    }

    public void backup(IToken mark) {
        this.currToken = mark;
        this.lastToken = null;
    }

    public ExpressionParser(IScanner scanner, ParserLanguage language, IParserLogService log, IParserExtension extension) {
        this.scanner = scanner;
        this.language = language;
        this.log = log;
        this.extension = extension;
        this.setupASTFactory(scanner, language);
    }

    protected void setupASTFactory(IScanner scanner, ParserLanguage language) {
        this.astFactory = ParserFactory.createASTFactory(ParserMode.EXPRESSION_PARSE, language);
        scanner.setASTFactory(this.astFactory);
        this.astFactory.setLogger(this.log);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void failParse() {
        try {
            try {
                if (this.firstErrorOffset == FIRST_ERROR_UNSET) {
                    this.firstErrorOffset = this.LA(1).getOffset();
                    this.firstErrorLine = this.LA(1).getLineNumber();
                }
            }
            catch (EndOfFileException endOfFileException) {}
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.parsePassed = false;
            throw throwable;
        }
        {
            Object var1_3 = null;
            this.parsePassed = false;
            return;
        }
    }

    protected IToken consumeTemplateParameters(IToken previousLast) throws EndOfFileException, BacktrackException {
        if (this.language != ParserLanguage.CPP) {
            return previousLast;
        }
        int startingOffset = previousLast == null ? this.lastToken.getOffset() : previousLast.getOffset();
        IToken last = previousLast;
        if (this.LT(1) == 42) {
            last = this.consume(42);
            ScopeStack scopes = new ScopeStack();
            scopes.push(42);
            while (scopes.size() > 0) {
                last = this.consume();
                switch (last.getType()) {
                    case 46: {
                        if (scopes.peek() != 42) break;
                        scopes.pop();
                        break;
                    }
                    case 11: {
                        int top;
                        do {
                            top = scopes.pop();
                        } while (scopes.size() > 0 && (top == 46 || top == 42));
                        if (top == 10) break;
                        this.throwBacktrack(startingOffset, last.getEndOffset(), last.getLineNumber(), last.getFilename());
                        break;
                    }
                    case 9: {
                        int top;
                        do {
                            top = scopes.pop();
                        } while (scopes.size() > 0 && (top == 46 || top == 42));
                        if (top == 8) break;
                        this.throwBacktrack(startingOffset, last.getEndOffset(), last.getLineNumber(), last.getFilename());
                        break;
                    }
                    case 8: 
                    case 10: 
                    case 42: {
                        scopes.push(last.getType());
                    }
                }
            }
        }
        return last;
    }

    protected List templateArgumentList(IASTScope scope, IASTCompletionNode.CompletionKind kind) throws EndOfFileException, BacktrackException {
        IToken start = this.LA(1);
        int startingOffset = start.getOffset();
        int startingLineNumber = start.getOffset();
        char[] fn = start.getFilename();
        start = null;
        IASTExpression expression = null;
        ArrayList<IASTExpression> list = new ArrayList<IASTExpression>();
        boolean completedArg = false;
        boolean failed = false;
        this.templateIdScopes.push(42);
        while (this.LT(1) != 46) {
            completedArg = false;
            IToken mark = this.mark();
            try {
                IASTTypeId typeId = this.typeId(scope, false, kind);
                expression = this.astFactory.createExpression(scope, IASTExpression.Kind.POSTFIX_TYPEID_TYPEID, null, null, null, typeId, null, EMPTY_STRING, null);
                list.add(expression);
                completedArg = true;
            }
            catch (BacktrackException backtrackException) {
                this.backup(mark);
            }
            catch (ASTSemanticException aSTSemanticException) {
                this.backup(mark);
            }
            if (!completedArg) {
                try {
                    IToken la = this.LA(1);
                    int so = la.getOffset();
                    int ln = la.getLineNumber();
                    expression = this.assignmentExpression(scope, IASTCompletionNode.CompletionKind.VARIABLE_TYPE, KeywordSetKey.EXPRESSION);
                    if (expression.getExpressionKind() == IASTExpression.Kind.PRIMARY_EMPTY) {
                        this.throwBacktrack(so, this.lastToken != null ? this.lastToken.getEndOffset() : 0, ln, fn);
                    }
                    list.add(expression);
                    completedArg = true;
                }
                catch (BacktrackException backtrackException) {
                    this.backup(mark);
                }
            }
            if (!completedArg) {
                try {
                    ITokenDuple nameDuple = this.name(scope, null, KeywordSetKey.EMPTY);
                    expression = this.astFactory.createExpression(scope, IASTExpression.Kind.ID_EXPRESSION, null, null, null, null, nameDuple, EMPTY_STRING, null);
                    list.add(expression);
                    continue;
                }
                catch (ASTSemanticException aSTSemanticException) {
                    failed = true;
                    break;
                }
                catch (BacktrackException backtrackException) {
                    failed = true;
                    break;
                }
                catch (Exception e) {
                    this.logException("templateArgumentList::createExpression()", e);
                    failed = true;
                    break;
                }
            }
            if (this.LT(1) == 6) {
                this.consume();
                continue;
            }
            if (this.LT(1) == 46) continue;
            failed = true;
            break;
        }
        this.templateIdScopes.pop();
        if (failed) {
            if (expression != null) {
                expression.freeReferences(this.astFactory.getReferenceManager());
            }
            this.throwBacktrack(startingOffset, 0, startingLineNumber, fn);
        }
        return list;
    }

    protected IToken templateId(IASTScope scope, IASTCompletionNode.CompletionKind kind) throws EndOfFileException, BacktrackException {
        ITokenDuple duple = this.name(scope, kind, KeywordSetKey.EMPTY);
        return duple.getLastToken();
    }

    protected ITokenDuple name(IASTScope scope, IASTCompletionNode.CompletionKind kind, KeywordSetKey key) throws BacktrackException, EndOfFileException {
        ITokenDuple iTokenDuple;
        TemplateParameterManager argumentList = TemplateParameterManager.getInstance();
        try {
            IToken l;
            IToken prev;
            IToken first = this.LA(1);
            IToken last = null;
            IToken mark = this.mark();
            boolean hasTemplateId = false;
            boolean startsWithColonColon = false;
            if (this.LT(1) == 3) {
                argumentList.addSegment(null);
                last = this.consume(3);
                this.setCompletionValues(scope, kind, KeywordSetKey.EMPTY, this.getCompliationUnit());
                startsWithColonColon = true;
            }
            if (this.LT(1) == 34) {
                this.consume();
            }
            switch (this.LT(1)) {
                case 1: {
                    prev = last;
                    last = this.consume(1);
                    if (startsWithColonColon) {
                        this.setCompletionValues(scope, kind, this.getCompliationUnit());
                    } else if (prev != null) {
                        this.setCompletionValues(scope, kind, first, prev, KeywordSetKey.EMPTY);
                    } else {
                        this.setCompletionValuesNoContext(scope, kind, key);
                    }
                    last = this.consumeTemplateArguments(scope, last, argumentList, kind);
                    if (last.getType() != 46) break;
                    hasTemplateId = true;
                    break;
                }
                default: {
                    l = this.LA(1);
                    this.backup(mark);
                    this.throwBacktrack(first.getOffset(), l.getEndOffset(), first.getLineNumber(), l.getFilename());
                    break;
                }
            }
            while (this.LT(1) == 3) {
                prev = last;
                last = this.consume(3);
                this.setCompletionValues(scope, kind, first, prev, KeywordSetKey.EMPTY);
                if (this.queryLookaheadCapability() && this.LT(1) == 111) {
                    this.consume();
                }
                if (this.queryLookaheadCapability() && this.LT(1) == 34) {
                    this.consume();
                }
                switch (this.LT(1)) {
                    case 95: {
                        l = this.LA(1);
                        this.backup(mark);
                        this.throwBacktrack(first.getOffset(), l.getEndOffset(), first.getLineNumber(), l.getFilename());
                    }
                    case 1: {
                        prev = last;
                        last = this.consume();
                        this.setCompletionValues(scope, kind, first, prev, KeywordSetKey.EMPTY);
                        last = this.consumeTemplateArguments(scope, last, argumentList, kind);
                        if (last.getType() != 46) break;
                        hasTemplateId = true;
                    }
                }
            }
            ITokenDuple tokenDuple = TokenFactory.createTokenDuple(first, last, hasTemplateId ? argumentList.getTemplateArgumentsList() : null);
            this.setGreaterNameContext(tokenDuple);
            iTokenDuple = tokenDuple;
            Object var12_13 = null;
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            TemplateParameterManager.returnInstance(argumentList);
            throw throwable;
        }
        TemplateParameterManager.returnInstance(argumentList);
        return iTokenDuple;
    }

    protected void setCompletionValuesNoContext(IASTScope scope, IASTCompletionNode.CompletionKind kind, KeywordSetKey key) throws EndOfFileException {
    }

    protected void setGreaterNameContext(ITokenDuple tokenDuple) {
    }

    protected void setCompletionValues(IASTScope scope, IASTCompletionNode.CompletionKind kind, IASTNode context) throws EndOfFileException {
    }

    protected void setCompletionValues(IASTScope scope, IASTCompletionNode.CompletionKind kind) throws EndOfFileException {
    }

    protected IASTNode getCompliationUnit() {
        return null;
    }

    protected void setCompletionValues(IASTScope scope, IASTCompletionNode.CompletionKind kind, KeywordSetKey key, IASTNode node) throws EndOfFileException {
    }

    protected IToken consumeTemplateArguments(IASTScope scope, IToken last, TemplateParameterManager argumentList, IASTCompletionNode.CompletionKind completionKind) throws EndOfFileException, BacktrackException {
        if (this.language != ParserLanguage.CPP) {
            return last;
        }
        if (this.LT(1) == 42) {
            IToken secondMark = this.mark();
            this.consume(42);
            try {
                List list = this.templateArgumentList(scope, completionKind);
                argumentList.addSegment(list);
                last = this.consume(46);
            }
            catch (BacktrackException backtrackException) {
                argumentList.addSegment(null);
                this.backup(secondMark);
            }
        } else {
            argumentList.addSegment(null);
        }
        return last;
    }

    protected IToken cvQualifier(IDeclarator declarator) throws EndOfFileException, BacktrackException {
        IToken result = null;
        int startingOffset = this.LA(1).getOffset();
        switch (this.LT(1)) {
            case 67: {
                result = this.consume(67);
                declarator.addPointerOperator(ASTPointerOperator.CONST_POINTER);
                break;
            }
            case 124: {
                result = this.consume(124);
                declarator.addPointerOperator(ASTPointerOperator.VOLATILE_POINTER);
                break;
            }
            case 137: {
                if (this.language == ParserLanguage.C) {
                    result = this.consume(137);
                    declarator.addPointerOperator(ASTPointerOperator.RESTRICT_POINTER);
                    break;
                }
                if (this.extension.isValidCVModifier(this.language, 137)) {
                    result = this.consume(137);
                    declarator.addPointerOperator(this.extension.getPointerOperator(this.language, 137));
                    break;
                }
                IToken la = this.LA(1);
                this.throwBacktrack(startingOffset, la.getEndOffset(), la.getLineNumber(), la.getFilename());
            }
            default: {
                if (!this.extension.isValidCVModifier(this.language, this.LT(1))) break;
                result = this.consume();
                declarator.addPointerOperator(this.extension.getPointerOperator(this.language, result.getType()));
            }
        }
        return result;
    }

    protected IToken consumeArrayModifiers(IDeclarator d, IASTScope scope) throws EndOfFileException, BacktrackException {
        int startingOffset = this.LA(1).getOffset();
        IToken last = null;
        while (this.LT(1) == 10) {
            this.consume(10);
            IASTExpression exp = null;
            if (this.LT(1) != 11) {
                exp = this.constantExpression(scope, IASTCompletionNode.CompletionKind.SINGLE_NAME_REFERENCE, KeywordSetKey.EXPRESSION);
            }
            last = this.consume(11);
            IASTArrayModifier arrayMod = null;
            try {
                arrayMod = this.astFactory.createArrayModifier(exp);
            }
            catch (Exception e) {
                this.logException("consumeArrayModifiers::createArrayModifier()", e);
                this.throwBacktrack(startingOffset, last.getEndOffset(), last.getLineNumber(), last.getFilename());
            }
            d.addArrayModifier(arrayMod);
        }
        return last;
    }

    /*
     * Exception decompiling
     */
    protected void operatorId(Declarator d, IToken originalToken, TemplateParameterManager templateArgs, IASTCompletionNode.CompletionKind completionKind) throws BacktrackException, EndOfFileException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 389->393)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected IToken consumePointerOperators(IDeclarator d) throws EndOfFileException, BacktrackException {
        ITokenDuple nameDuple;
        IToken mark;
        IToken result = null;
        while (true) {
            IToken newSuccess;
            if (this.LT(1) == 30) {
                result = this.consume(30);
                d.addPointerOperator(ASTPointerOperator.REFERENCE);
                return result;
            }
            mark = this.mark();
            nameDuple = null;
            if (this.LT(1) == 1 || this.LT(1) == 3) {
                try {
                    try {
                        nameDuple = this.name(d.getScope(), IASTCompletionNode.CompletionKind.SINGLE_NAME_REFERENCE, KeywordSetKey.EMPTY);
                    }
                    catch (OffsetLimitReachedException offsetLimitReachedException) {
                        this.backup(mark);
                        return null;
                    }
                }
                catch (BacktrackException backtrackException) {
                    this.backup(mark);
                    return null;
                }
            }
            if (this.LT(1) != 23) break;
            result = this.consume(23);
            d.setPointerOperatorName(nameDuple);
            IToken successful = null;
            while ((newSuccess = this.cvQualifier(d)) != null) {
                successful = newSuccess;
            }
            if (successful != null) continue;
            d.addPointerOperator(ASTPointerOperator.POINTER);
        }
        if (nameDuple != null) {
            nameDuple.freeReferences(this.astFactory.getReferenceManager());
        }
        this.backup(mark);
        return result;
    }

    protected IASTExpression constantExpression(IASTScope scope, IASTCompletionNode.CompletionKind kind, KeywordSetKey key) throws BacktrackException, EndOfFileException {
        return this.conditionalExpression(scope, kind, key);
    }

    public IASTExpression expression(IASTScope scope, IASTCompletionNode.CompletionKind kind, KeywordSetKey key) throws BacktrackException, EndOfFileException {
        IToken la = this.LA(1);
        int startingOffset = la.getOffset();
        int ln = la.getLineNumber();
        char[] fn = la.getFilename();
        IASTExpression assignmentExpression = this.assignmentExpression(scope, kind, key);
        while (this.LT(1) == 6) {
            this.consume(6);
            this.setParameterListExpression(assignmentExpression);
            IASTExpression secondExpression = this.assignmentExpression(scope, kind, key);
            this.setParameterListExpression(null);
            int endOffset = this.lastToken != null ? this.lastToken.getEndOffset() : 0;
            try {
                assignmentExpression = this.astFactory.createExpression(scope, IASTExpression.Kind.EXPRESSIONLIST, assignmentExpression, secondExpression, null, null, null, EMPTY_STRING, null);
            }
            catch (ASTSemanticException e) {
                this.throwBacktrack(e.getProblem());
            }
            catch (Exception e) {
                this.logException("expression::createExpression()", e);
                this.throwBacktrack(startingOffset, endOffset, ln, fn);
            }
        }
        return assignmentExpression;
    }

    protected void setParameterListExpression(IASTExpression assignmentExpression) {
    }

    protected IASTExpression assignmentExpression(IASTScope scope, IASTCompletionNode.CompletionKind kind, KeywordSetKey key) throws EndOfFileException, BacktrackException {
        this.setCompletionValues(scope, kind, key);
        if (this.LT(1) == 113) {
            return this.throwExpression(scope, key);
        }
        IASTExpression conditionalExpression = this.conditionalExpression(scope, kind, key);
        if (conditionalExpression != null && conditionalExpression.getExpressionKind() == IASTExpression.Kind.CONDITIONALEXPRESSION) {
            return conditionalExpression;
        }
        switch (this.LT(1)) {
            case 38: {
                return this.assignmentOperatorExpression(scope, IASTExpression.Kind.ASSIGNMENTEXPRESSION_NORMAL, conditionalExpression, kind, key);
            }
            case 22: {
                return this.assignmentOperatorExpression(scope, IASTExpression.Kind.ASSIGNMENTEXPRESSION_MULT, conditionalExpression, kind, key);
            }
            case 51: {
                return this.assignmentOperatorExpression(scope, IASTExpression.Kind.ASSIGNMENTEXPRESSION_DIV, conditionalExpression, kind, key);
            }
            case 24: {
                return this.assignmentOperatorExpression(scope, IASTExpression.Kind.ASSIGNMENTEXPRESSION_MOD, conditionalExpression, kind, key);
            }
            case 14: {
                return this.assignmentOperatorExpression(scope, IASTExpression.Kind.ASSIGNMENTEXPRESSION_PLUS, conditionalExpression, kind, key);
            }
            case 17: {
                return this.assignmentOperatorExpression(scope, IASTExpression.Kind.ASSIGNMENTEXPRESSION_MINUS, conditionalExpression, kind, key);
            }
            case 43: {
                return this.assignmentOperatorExpression(scope, IASTExpression.Kind.ASSIGNMENTEXPRESSION_RSHIFT, conditionalExpression, kind, key);
            }
            case 47: {
                return this.assignmentOperatorExpression(scope, IASTExpression.Kind.ASSIGNMENTEXPRESSION_LSHIFT, conditionalExpression, kind, key);
            }
            case 28: {
                return this.assignmentOperatorExpression(scope, IASTExpression.Kind.ASSIGNMENTEXPRESSION_AND, conditionalExpression, kind, key);
            }
            case 26: {
                return this.assignmentOperatorExpression(scope, IASTExpression.Kind.ASSIGNMENTEXPRESSION_XOR, conditionalExpression, kind, key);
            }
            case 31: {
                return this.assignmentOperatorExpression(scope, IASTExpression.Kind.ASSIGNMENTEXPRESSION_OR, conditionalExpression, kind, key);
            }
        }
        return conditionalExpression;
    }

    protected IASTExpression throwExpression(IASTScope scope, KeywordSetKey key) throws EndOfFileException, BacktrackException {
        IToken throwToken = this.consume(113);
        this.setCompletionValues(scope, IASTCompletionNode.CompletionKind.SINGLE_NAME_REFERENCE, KeywordSetKey.EXPRESSION);
        IASTExpression throwExpression = null;
        try {
            throwExpression = this.expression(scope, IASTCompletionNode.CompletionKind.SINGLE_NAME_REFERENCE, key);
        }
        catch (BacktrackException backtrackException) {}
        int endOffset = this.lastToken != null ? this.lastToken.getEndOffset() : 0;
        try {
            return this.astFactory.createExpression(scope, IASTExpression.Kind.THROWEXPRESSION, throwExpression, null, null, null, null, EMPTY_STRING, null);
        }
        catch (ASTSemanticException e) {
            this.throwBacktrack(e.getProblem());
        }
        catch (Exception e) {
            this.logException("throwExpression::createExpression()", e);
            this.throwBacktrack(throwToken.getOffset(), endOffset, throwToken.getLineNumber(), throwToken.getFilename());
        }
        return null;
    }

    protected IASTExpression conditionalExpression(IASTScope scope, IASTCompletionNode.CompletionKind kind, KeywordSetKey key) throws BacktrackException, EndOfFileException {
        IToken la = this.LA(1);
        int startingOffset = la.getOffset();
        int ln = la.getLineNumber();
        char[] fn = la.getFilename();
        la = null;
        IASTExpression firstExpression = this.logicalOrExpression(scope, kind, key);
        if (this.LT(1) == 7) {
            this.consume(7);
            IASTExpression secondExpression = this.expression(scope, kind, key);
            this.consume(4);
            IASTExpression thirdExpression = this.assignmentExpression(scope, kind, key);
            int endOffset = this.lastToken != null ? this.lastToken.getEndOffset() : 0;
            try {
                return this.astFactory.createExpression(scope, IASTExpression.Kind.CONDITIONALEXPRESSION, firstExpression, secondExpression, thirdExpression, null, null, EMPTY_STRING, null);
            }
            catch (ASTSemanticException e) {
                this.throwBacktrack(e.getProblem());
            }
            catch (Exception e) {
                this.logException("conditionalExpression::createExpression()", e);
                this.throwBacktrack(startingOffset, endOffset, ln, fn);
            }
        }
        return firstExpression;
    }

    protected IASTExpression logicalOrExpression(IASTScope scope, IASTCompletionNode.CompletionKind kind, KeywordSetKey key) throws BacktrackException, EndOfFileException {
        IToken la = this.LA(1);
        int startingOffset = la.getOffset();
        int line = la.getLineNumber();
        char[] fn = la.getFilename();
        IASTExpression firstExpression = this.logicalAndExpression(scope, kind, key);
        while (this.LT(1) == 32) {
            this.consume(32);
            IASTExpression secondExpression = this.logicalAndExpression(scope, kind, key);
            int endOffset = this.lastToken != null ? this.lastToken.getEndOffset() : 0;
            try {
                firstExpression = this.astFactory.createExpression(scope, IASTExpression.Kind.LOGICALOREXPRESSION, firstExpression, secondExpression, null, null, null, EMPTY_STRING, null);
            }
            catch (ASTSemanticException e) {
                this.throwBacktrack(e.getProblem());
            }
            catch (Exception e) {
                this.logException("logicalOrExpression::createExpression()", e);
                this.throwBacktrack(startingOffset, endOffset, line, fn);
            }
        }
        return firstExpression;
    }

    protected IASTExpression logicalAndExpression(IASTScope scope, IASTCompletionNode.CompletionKind kind, KeywordSetKey key) throws BacktrackException, EndOfFileException {
        IToken la = this.LA(1);
        int startingOffset = la.getOffset();
        int line = la.getLineNumber();
        char[] fn = la.getFilename();
        IASTExpression firstExpression = this.inclusiveOrExpression(scope, kind, key);
        while (this.LT(1) == 29) {
            this.consume(29);
            IASTExpression secondExpression = this.inclusiveOrExpression(scope, kind, key);
            int endOffset = this.lastToken != null ? this.lastToken.getEndOffset() : 0;
            try {
                firstExpression = this.astFactory.createExpression(scope, IASTExpression.Kind.LOGICALANDEXPRESSION, firstExpression, secondExpression, null, null, null, EMPTY_STRING, null);
            }
            catch (ASTSemanticException e) {
                this.throwBacktrack(e.getProblem());
            }
            catch (Exception e) {
                this.logException("logicalAndExpression::createExpression()", e);
                this.throwBacktrack(startingOffset, endOffset, line, fn);
            }
        }
        return firstExpression;
    }

    protected IASTExpression inclusiveOrExpression(IASTScope scope, IASTCompletionNode.CompletionKind kind, KeywordSetKey key) throws BacktrackException, EndOfFileException {
        IToken la = this.LA(1);
        int startingOffset = la.getOffset();
        int line = la.getLineNumber();
        char[] fn = la.getFilename();
        IASTExpression firstExpression = this.exclusiveOrExpression(scope, kind, key);
        while (this.LT(1) == 33) {
            this.consume();
            IASTExpression secondExpression = this.exclusiveOrExpression(scope, kind, key);
            int endOffset = this.lastToken != null ? this.lastToken.getEndOffset() : 0;
            try {
                firstExpression = this.astFactory.createExpression(scope, IASTExpression.Kind.INCLUSIVEOREXPRESSION, firstExpression, secondExpression, null, null, null, EMPTY_STRING, null);
            }
            catch (ASTSemanticException e) {
                this.throwBacktrack(e.getProblem());
            }
            catch (Exception e) {
                this.logException("inclusiveOrExpression::createExpression()", e);
                this.throwBacktrack(startingOffset, endOffset, line, fn);
            }
        }
        return firstExpression;
    }

    protected IASTExpression exclusiveOrExpression(IASTScope scope, IASTCompletionNode.CompletionKind kind, KeywordSetKey key) throws BacktrackException, EndOfFileException {
        IToken la = this.LA(1);
        int startingOffset = la.getOffset();
        int line = la.getLineNumber();
        char[] fn = la.getFilename();
        IASTExpression firstExpression = this.andExpression(scope, kind, key);
        while (this.LT(1) == 27) {
            this.consume();
            IASTExpression secondExpression = this.andExpression(scope, kind, key);
            int endOffset = this.lastToken != null ? this.lastToken.getEndOffset() : 0;
            try {
                firstExpression = this.astFactory.createExpression(scope, IASTExpression.Kind.EXCLUSIVEOREXPRESSION, firstExpression, secondExpression, null, null, null, EMPTY_STRING, null);
            }
            catch (ASTSemanticException e) {
                this.throwBacktrack(e.getProblem());
            }
            catch (Exception e) {
                this.logException("exclusiveORExpression::createExpression()", e);
                this.throwBacktrack(startingOffset, endOffset, line, fn);
            }
        }
        return firstExpression;
    }

    protected IASTExpression andExpression(IASTScope scope, IASTCompletionNode.CompletionKind kind, KeywordSetKey key) throws EndOfFileException, BacktrackException {
        IToken la = this.LA(1);
        int startingOffset = la.getOffset();
        int line = la.getLineNumber();
        char[] fn = la.getFilename();
        IASTExpression firstExpression = this.equalityExpression(scope, kind, key);
        while (this.LT(1) == 30) {
            this.consume();
            IASTExpression secondExpression = this.equalityExpression(scope, kind, key);
            int endOffset = this.lastToken != null ? this.lastToken.getEndOffset() : 0;
            try {
                firstExpression = this.astFactory.createExpression(scope, IASTExpression.Kind.ANDEXPRESSION, firstExpression, secondExpression, null, null, null, EMPTY_STRING, null);
            }
            catch (ASTSemanticException e) {
                this.throwBacktrack(e.getProblem());
            }
            catch (Exception e) {
                this.logException("andExpression::createExpression()", e);
                this.throwBacktrack(startingOffset, endOffset, line, fn);
            }
        }
        return firstExpression;
    }

    public void logException(String methodName, Exception e) {
        if (!(e instanceof EndOfFileException) && e != null && this.log.isTracing()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("Parser: Unexpected exception in ");
            buffer.append(methodName);
            buffer.append(":");
            buffer.append(e.getClass().getName());
            buffer.append("::");
            buffer.append(e.getMessage());
            buffer.append(". w/");
            buffer.append(this.scanner.toString());
            this.log.traceLog(buffer.toString());
        }
    }

    protected IASTExpression equalityExpression(IASTScope scope, IASTCompletionNode.CompletionKind kind, KeywordSetKey key) throws EndOfFileException, BacktrackException {
        IToken la = this.LA(1);
        int startingOffset = la.getOffset();
        int line = la.getLineNumber();
        char[] fn = la.getFilename();
        IASTExpression firstExpression = this.relationalExpression(scope, kind, key);
        block6: while (true) {
            switch (this.LT(1)) {
                case 35: 
                case 37: {
                    IToken t = this.consume();
                    IASTExpression secondExpression = this.relationalExpression(scope, kind, key);
                    int endOffset = this.lastToken != null ? this.lastToken.getEndOffset() : 0;
                    try {
                        firstExpression = this.astFactory.createExpression(scope, t.getType() == 37 ? IASTExpression.Kind.EQUALITY_EQUALS : IASTExpression.Kind.EQUALITY_NOTEQUALS, firstExpression, secondExpression, null, null, null, EMPTY_STRING, null);
                    }
                    catch (ASTSemanticException e) {
                        this.throwBacktrack(e.getProblem());
                    }
                    catch (Exception e) {
                        this.logException("equalityExpression::createExpression()", e);
                        this.throwBacktrack(startingOffset, endOffset, line, fn);
                    }
                    continue block6;
                }
            }
            break;
        }
        return firstExpression;
    }

    protected IASTExpression relationalExpression(IASTScope scope, IASTCompletionNode.CompletionKind kind, KeywordSetKey key) throws BacktrackException, EndOfFileException {
        IASTExpression extensionExpression;
        IToken la = this.LA(1);
        int startingOffset = la.getOffset();
        int line = la.getLineNumber();
        char[] fn = la.getFilename();
        IASTExpression firstExpression = this.shiftExpression(scope, kind, key);
        block13: while (true) {
            switch (this.LT(1)) {
                case 46: {
                    if (this.templateIdScopes.size() > 0 && this.templateIdScopes.peek() == 42) {
                        return firstExpression;
                    }
                }
                case 41: 
                case 42: 
                case 45: {
                    IToken mark = this.mark();
                    int t = this.consume().getType();
                    IASTExpression secondExpression = this.shiftExpression(scope, kind, key);
                    if (this.LA(1) == mark.getNext()) {
                        this.backup(mark);
                        return firstExpression;
                    }
                    IASTExpression.Kind expressionKind = null;
                    switch (t) {
                        case 46: {
                            expressionKind = IASTExpression.Kind.RELATIONAL_GREATERTHAN;
                            break;
                        }
                        case 42: {
                            expressionKind = IASTExpression.Kind.RELATIONAL_LESSTHAN;
                            break;
                        }
                        case 41: {
                            expressionKind = IASTExpression.Kind.RELATIONAL_LESSTHANEQUALTO;
                            break;
                        }
                        case 45: {
                            expressionKind = IASTExpression.Kind.RELATIONAL_GREATERTHANEQUALTO;
                        }
                    }
                    int endOffset = this.lastToken != null ? this.lastToken.getEndOffset() : 0;
                    try {
                        firstExpression = this.astFactory.createExpression(scope, expressionKind, firstExpression, secondExpression, null, null, null, EMPTY_STRING, null);
                    }
                    catch (ASTSemanticException e) {
                        this.throwBacktrack(e.getProblem());
                    }
                    catch (Exception e) {
                        this.logException("relationalExpression::createExpression()", e);
                        this.throwBacktrack(startingOffset, endOffset, line, fn);
                    }
                    continue block13;
                }
            }
            break;
        }
        if (this.extension.isValidRelationalExpressionStart(this.language, this.LT(1)) && (extensionExpression = this.extension.parseRelationalExpression(scope, this, kind, key, firstExpression)) != null) {
            return extensionExpression;
        }
        return firstExpression;
    }

    public IASTExpression shiftExpression(IASTScope scope, IASTCompletionNode.CompletionKind kind, KeywordSetKey key) throws BacktrackException, EndOfFileException {
        IToken la = this.LA(1);
        int startingOffset = la.getOffset();
        int line = la.getLineNumber();
        char[] fn = la.getFilename();
        IASTExpression firstExpression = this.additiveExpression(scope, kind, key);
        block6: while (true) {
            switch (this.LT(1)) {
                case 40: 
                case 44: {
                    IToken t = this.consume();
                    IASTExpression secondExpression = this.additiveExpression(scope, kind, key);
                    int endOffset = this.lastToken != null ? this.lastToken.getEndOffset() : 0;
                    try {
                        firstExpression = this.astFactory.createExpression(scope, t.getType() == 40 ? IASTExpression.Kind.SHIFT_LEFT : IASTExpression.Kind.SHIFT_RIGHT, firstExpression, secondExpression, null, null, null, EMPTY_STRING, null);
                    }
                    catch (ASTSemanticException e) {
                        this.throwBacktrack(e.getProblem());
                    }
                    catch (Exception e) {
                        this.logException("shiftExpression::createExpression()", e);
                        this.throwBacktrack(startingOffset, endOffset, line, fn);
                    }
                    continue block6;
                }
            }
            break;
        }
        return firstExpression;
    }

    protected IASTExpression additiveExpression(IASTScope scope, IASTCompletionNode.CompletionKind kind, KeywordSetKey key) throws BacktrackException, EndOfFileException {
        IToken la = this.LA(1);
        int startingOffset = la.getOffset();
        int line = la.getLineNumber();
        char[] fn = la.getFilename();
        IASTExpression firstExpression = this.multiplicativeExpression(scope, kind, key);
        block6: while (true) {
            switch (this.LT(1)) {
                case 16: 
                case 21: {
                    IToken t = this.consume();
                    IASTExpression secondExpression = this.multiplicativeExpression(scope, kind, key);
                    int endOffset = this.lastToken != null ? this.lastToken.getEndOffset() : 0;
                    try {
                        firstExpression = this.astFactory.createExpression(scope, t.getType() == 16 ? IASTExpression.Kind.ADDITIVE_PLUS : IASTExpression.Kind.ADDITIVE_MINUS, firstExpression, secondExpression, null, null, null, EMPTY_STRING, null);
                    }
                    catch (ASTSemanticException e) {
                        this.throwBacktrack(e.getProblem());
                    }
                    catch (Exception e) {
                        this.logException("additiveExpression::createExpression()", e);
                        this.throwBacktrack(startingOffset, endOffset, line, fn);
                    }
                    continue block6;
                }
            }
            break;
        }
        return firstExpression;
    }

    protected IASTExpression multiplicativeExpression(IASTScope scope, IASTCompletionNode.CompletionKind kind, KeywordSetKey key) throws BacktrackException, EndOfFileException {
        IToken la = this.LA(1);
        int startingOffset = la.getOffset();
        int line = la.getLineNumber();
        char[] fn = la.getFilename();
        IASTExpression firstExpression = this.pmExpression(scope, kind, key);
        block11: while (true) {
            switch (this.LT(1)) {
                case 23: 
                case 25: 
                case 52: {
                    IToken t = this.consume();
                    IASTExpression secondExpression = this.pmExpression(scope, kind, key);
                    IASTExpression.Kind expressionKind = null;
                    switch (t.getType()) {
                        case 23: {
                            expressionKind = IASTExpression.Kind.MULTIPLICATIVE_MULTIPLY;
                            break;
                        }
                        case 52: {
                            expressionKind = IASTExpression.Kind.MULTIPLICATIVE_DIVIDE;
                            break;
                        }
                        case 25: {
                            expressionKind = IASTExpression.Kind.MULTIPLICATIVE_MODULUS;
                        }
                    }
                    int endOffset = this.lastToken != null ? this.lastToken.getEndOffset() : 0;
                    try {
                        firstExpression = this.astFactory.createExpression(scope, expressionKind, firstExpression, secondExpression, null, null, null, EMPTY_STRING, null);
                    }
                    catch (ASTSemanticException e) {
                        firstExpression.freeReferences(this.astFactory.getReferenceManager());
                        this.throwBacktrack(e.getProblem());
                    }
                    catch (Exception e) {
                        this.logException("multiplicativeExpression::createExpression()", e);
                        this.throwBacktrack(startingOffset, endOffset, line, fn);
                    }
                    continue block11;
                }
            }
            break;
        }
        return firstExpression;
    }

    protected IASTExpression pmExpression(IASTScope scope, IASTCompletionNode.CompletionKind kind, KeywordSetKey key) throws EndOfFileException, BacktrackException {
        IToken la = this.LA(1);
        int startingOffset = la.getOffset();
        int line = la.getLineNumber();
        char[] fn = la.getFilename();
        IASTExpression firstExpression = this.castExpression(scope, kind, key);
        block6: while (true) {
            switch (this.LT(1)) {
                case 19: 
                case 49: {
                    IToken t = this.consume();
                    IASTExpression secondExpression = this.castExpression(scope, kind, key);
                    int endOffset = this.lastToken != null ? this.lastToken.getEndOffset() : 0;
                    try {
                        firstExpression = this.astFactory.createExpression(scope, t.getType() == 49 ? IASTExpression.Kind.PM_DOTSTAR : IASTExpression.Kind.PM_ARROWSTAR, firstExpression, secondExpression, null, null, null, EMPTY_STRING, null);
                    }
                    catch (ASTSemanticException e) {
                        this.throwBacktrack(e.getProblem());
                    }
                    catch (Exception e) {
                        this.logException("pmExpression::createExpression()", e);
                        this.throwBacktrack(startingOffset, endOffset, line, fn);
                    }
                    continue block6;
                }
            }
            break;
        }
        return firstExpression;
    }

    protected IASTExpression castExpression(IASTScope scope, IASTCompletionNode.CompletionKind kind, KeywordSetKey key) throws EndOfFileException, BacktrackException {
        block13: {
            if (this.LT(1) == 8) {
                IToken la = this.LA(1);
                int startingOffset = la.getOffset();
                int line = la.getLineNumber();
                char[] fn = la.getFilename();
                IToken mark = this.mark();
                this.consume();
                if (this.templateIdScopes.size() > 0) {
                    this.templateIdScopes.push(8);
                }
                boolean popped = false;
                IASTTypeId typeId = null;
                try {
                    IASTExpression castExpression;
                    try {
                        typeId = this.typeId(scope, false, this.getCastExpressionKind(kind));
                        this.consume(9);
                    }
                    catch (BacktrackException bte) {
                        this.backup(mark);
                        if (typeId != null) {
                            typeId.freeReferences(this.astFactory.getReferenceManager());
                        }
                        throw bte;
                    }
                    if (this.templateIdScopes.size() > 0) {
                        this.templateIdScopes.pop();
                        popped = true;
                    }
                    if ((castExpression = this.castExpression(scope, kind, key)) != null && castExpression.getExpressionKind() == IASTExpression.Kind.PRIMARY_EMPTY) {
                        this.backup(mark);
                        if (typeId != null) {
                            typeId.freeReferences(this.astFactory.getReferenceManager());
                        }
                        return this.unaryExpression(scope, kind, key);
                    }
                    int endOffset = this.lastToken != null ? this.lastToken.getEndOffset() : 0;
                    mark = null;
                    try {
                        return this.astFactory.createExpression(scope, IASTExpression.Kind.CASTEXPRESSION, castExpression, null, null, typeId, null, EMPTY_STRING, null);
                    }
                    catch (ASTSemanticException e) {
                        this.throwBacktrack(e.getProblem());
                    }
                    catch (Exception e) {
                        this.logException("castExpression::createExpression()", e);
                        this.throwBacktrack(startingOffset, endOffset, line, fn);
                    }
                }
                catch (BacktrackException backtrackException) {
                    if (this.templateIdScopes.size() <= 0 || popped) break block13;
                    this.templateIdScopes.pop();
                }
            }
        }
        return this.unaryExpression(scope, kind, key);
    }

    private IASTCompletionNode.CompletionKind getCastExpressionKind(IASTCompletionNode.CompletionKind kind) {
        return kind == IASTCompletionNode.CompletionKind.SINGLE_NAME_REFERENCE || kind == IASTCompletionNode.CompletionKind.FUNCTION_REFERENCE ? kind : IASTCompletionNode.CompletionKind.TYPE_REFERENCE;
    }

    public IASTTypeId typeId(IASTScope scope, boolean skipArrayModifiers, IASTCompletionNode.CompletionKind completionKind) throws EndOfFileException, BacktrackException {
        IToken last;
        int endOffset;
        IASTSimpleTypeSpecifier.Type kind;
        boolean isTypename;
        boolean isLong;
        boolean isShort;
        boolean isUnsigned;
        boolean isSigned;
        boolean isVolatile;
        boolean isConst;
        ITokenDuple name;
        IToken mark;
        block31: {
            mark = this.mark();
            name = null;
            isConst = false;
            isVolatile = false;
            isSigned = false;
            isUnsigned = false;
            isShort = false;
            isLong = false;
            isTypename = false;
            kind = null;
            try {
                name = this.name(scope, completionKind, KeywordSetKey.DECL_SPECIFIER_SEQUENCE);
                kind = IASTSimpleTypeSpecifier.Type.CLASS_OR_TYPENAME;
            }
            catch (BacktrackException backtrackException) {
                boolean encounteredType = false;
                block24: while (true) {
                    switch (this.LT(1)) {
                        case 108: {
                            this.consume();
                            isSigned = true;
                            continue block24;
                        }
                        case 120: {
                            this.consume();
                            isUnsigned = true;
                            continue block24;
                        }
                        case 104: {
                            this.consume();
                            isShort = true;
                            continue block24;
                        }
                        case 89: {
                            this.consume();
                            isLong = true;
                            continue block24;
                        }
                        case 67: {
                            this.consume();
                            isConst = true;
                            continue block24;
                        }
                        case 124: {
                            this.consume();
                            isVolatile = true;
                            continue block24;
                        }
                        case 1: {
                            if (encounteredType) break block24;
                            encounteredType = true;
                            name = this.name(scope, completionKind, KeywordSetKey.EMPTY);
                            kind = IASTSimpleTypeSpecifier.Type.CLASS_OR_TYPENAME;
                            continue block24;
                        }
                        case 88: {
                            if (encounteredType) break block24;
                            encounteredType = true;
                            kind = IASTSimpleTypeSpecifier.Type.INT;
                            this.consume();
                            continue block24;
                        }
                        case 64: {
                            if (encounteredType) break block24;
                            encounteredType = true;
                            kind = IASTSimpleTypeSpecifier.Type.CHAR;
                            this.consume();
                            continue block24;
                        }
                        case 60: {
                            if (encounteredType) break block24;
                            encounteredType = true;
                            kind = IASTSimpleTypeSpecifier.Type.BOOL;
                            this.consume();
                            continue block24;
                        }
                        case 74: {
                            if (encounteredType) break block24;
                            encounteredType = true;
                            kind = IASTSimpleTypeSpecifier.Type.DOUBLE;
                            this.consume();
                            continue block24;
                        }
                        case 82: {
                            if (encounteredType) break block24;
                            encounteredType = true;
                            kind = IASTSimpleTypeSpecifier.Type.FLOAT;
                            this.consume();
                            continue block24;
                        }
                        case 125: {
                            if (encounteredType) break block24;
                            encounteredType = true;
                            kind = IASTSimpleTypeSpecifier.Type.WCHAR_T;
                            this.consume();
                            continue block24;
                        }
                        case 123: {
                            if (encounteredType) break block24;
                            encounteredType = true;
                            kind = IASTSimpleTypeSpecifier.Type.VOID;
                            this.consume();
                            continue block24;
                        }
                        case 134: {
                            if (encounteredType) break block24;
                            encounteredType = true;
                            kind = IASTSimpleTypeSpecifier.Type._BOOL;
                            this.consume();
                            continue block24;
                        }
                    }
                    break;
                }
                if (kind != null) break block31;
                if (isShort || isLong || isUnsigned || isSigned) {
                    kind = IASTSimpleTypeSpecifier.Type.INT;
                }
                if (this.LT(1) != 118 && this.LT(1) != 109 && this.LT(1) != 65 && this.LT(1) != 77 && this.LT(1) != 119) break block31;
                this.consume();
                try {
                    name = this.name(scope, completionKind, KeywordSetKey.EMPTY);
                    kind = IASTSimpleTypeSpecifier.Type.CLASS_OR_TYPENAME;
                }
                catch (BacktrackException b) {
                    this.backup(mark);
                    this.throwBacktrack(b);
                }
            }
        }
        int n = endOffset = this.lastToken != null ? this.lastToken.getEndOffset() : 0;
        if (kind == null) {
            this.throwBacktrack(mark.getOffset(), endOffset, mark.getLineNumber(), mark.getFilename());
        }
        TypeId id = this.getTypeIdInstance(scope);
        IToken temp = last = this.lastToken;
        temp = this.consumePointerOperators(id);
        if (temp != null) {
            last = temp;
        }
        if (!skipArrayModifiers && (temp = this.consumeArrayModifiers(id, scope)) != null) {
            last = temp;
        }
        endOffset = this.lastToken != null ? this.lastToken.getEndOffset() : 0;
        try {
            char[] signature = EMPTY_STRING;
            if (last != null) {
                if (this.lastToken == null) {
                    this.lastToken = last;
                }
                signature = TokenFactory.createCharArrayRepresentation(mark, last);
            }
            return this.astFactory.createTypeId(scope, kind, isConst, isVolatile, isShort, isLong, isSigned, isUnsigned, isTypename, name, id.getPointerOperators(), id.getArrayModifiers(), signature);
        }
        catch (ASTSemanticException e) {
            this.backup(mark);
            this.throwBacktrack(e.getProblem());
        }
        catch (Exception e) {
            this.logException("typeId::createTypeId()", e);
            this.throwBacktrack(mark.getOffset(), endOffset, mark.getLineNumber(), mark.getFilename());
        }
        return null;
    }

    private TypeId getTypeIdInstance(IASTScope scope) {
        this.typeIdInstance.reset(scope);
        return this.typeIdInstance;
    }

    protected IASTExpression deleteExpression(IASTScope scope, IASTCompletionNode.CompletionKind kind, KeywordSetKey key) throws EndOfFileException, BacktrackException {
        IToken la = this.LA(1);
        int startingOffset = la.getOffset();
        int line = la.getLineNumber();
        char[] fn = la.getFilename();
        if (this.LT(1) == 3) {
            this.consume(3);
        }
        this.consume(72);
        boolean vectored = false;
        if (this.LT(1) == 10) {
            this.consume();
            this.consume(11);
            vectored = true;
        }
        IASTExpression castExpression = this.castExpression(scope, kind, key);
        int endOffset = this.lastToken != null ? this.lastToken.getEndOffset() : 0;
        try {
            return this.astFactory.createExpression(scope, vectored ? IASTExpression.Kind.DELETE_VECTORCASTEXPRESSION : IASTExpression.Kind.DELETE_CASTEXPRESSION, castExpression, null, null, null, null, EMPTY_STRING, null);
        }
        catch (ASTSemanticException e) {
            this.throwBacktrack(e.getProblem());
        }
        catch (Exception e) {
            this.logException("deleteExpression::createExpression()", e);
            this.throwBacktrack(startingOffset, endOffset, line, fn);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected IASTExpression newExpression(IASTScope scope, KeywordSetKey key) throws BacktrackException, EndOfFileException {
        int endOffset;
        ArrayList<IASTExpression> newInitializerExpressions;
        ArrayList<IASTExpression> newTypeIdExpressions;
        ArrayList<IASTExpression> newPlacementExpressions;
        IASTTypeId typeId;
        char[] fn;
        int line;
        int startingOffset;
        block28: {
            block29: {
                IToken backtrackMarker;
                IToken beforeSecondParen;
                boolean typeIdInParen;
                block30: {
                    this.setCompletionValues(scope, IASTCompletionNode.CompletionKind.NEW_TYPE_REFERENCE, KeywordSetKey.EMPTY);
                    IToken la = this.LA(1);
                    startingOffset = la.getOffset();
                    line = la.getLineNumber();
                    fn = la.getFilename();
                    if (this.LT(1) == 3) {
                        this.consume(3);
                    }
                    this.consume(92);
                    typeIdInParen = false;
                    boolean placementParseFailure = true;
                    beforeSecondParen = null;
                    backtrackMarker = null;
                    typeId = null;
                    newPlacementExpressions = new ArrayList<IASTExpression>();
                    newTypeIdExpressions = new ArrayList<IASTExpression>();
                    newInitializerExpressions = new ArrayList<IASTExpression>();
                    if (this.LT(1) != 8) break block29;
                    this.consume(8);
                    if (this.templateIdScopes.size() > 0) {
                        this.templateIdScopes.push(8);
                    }
                    try {
                        backtrackMarker = this.mark();
                        newPlacementExpressions.add(this.expression(scope, IASTCompletionNode.CompletionKind.SINGLE_NAME_REFERENCE, key));
                        this.consume(9);
                        if (this.templateIdScopes.size() > 0) {
                            this.templateIdScopes.pop();
                        }
                        placementParseFailure = false;
                        if (this.LT(1) == 8) {
                            beforeSecondParen = this.mark();
                            this.consume(8);
                            if (this.templateIdScopes.size() > 0) {
                                this.templateIdScopes.push(8);
                            }
                            typeIdInParen = true;
                        }
                    }
                    catch (BacktrackException backtrackException) {
                        this.backup(backtrackMarker);
                    }
                    if (!placementParseFailure) break block30;
                    typeId = this.typeId(scope, true, IASTCompletionNode.CompletionKind.NEW_TYPE_REFERENCE);
                    this.consume(9);
                    if (this.templateIdScopes.size() > 0) {
                        this.templateIdScopes.pop();
                    }
                    break block28;
                }
                if (!typeIdInParen) {
                    if (this.LT(1) != 10) {
                        try {
                            backtrackMarker = this.mark();
                            typeId = this.typeId(scope, true, IASTCompletionNode.CompletionKind.NEW_TYPE_REFERENCE);
                        }
                        catch (BacktrackException backtrackException) {
                            this.backup(backtrackMarker);
                            return null;
                        }
                    }
                    break block28;
                } else {
                    try {
                        typeId = this.typeId(scope, true, IASTCompletionNode.CompletionKind.NEW_TYPE_REFERENCE);
                        this.consume(9);
                        if (this.templateIdScopes.size() > 0) {
                            this.templateIdScopes.pop();
                        }
                        if (this.LT(1) == 8 || this.LT(1) == 10) break block28;
                        endOffset = this.lastToken != null ? this.lastToken.getEndOffset() : 0;
                        try {
                            this.setCompletionValues(scope, IASTCompletionNode.CompletionKind.NO_SUCH_KIND, KeywordSetKey.EMPTY);
                            return this.astFactory.createExpression(scope, IASTExpression.Kind.NEW_TYPEID, null, null, null, typeId, null, EMPTY_STRING, this.astFactory.createNewDescriptor(newPlacementExpressions, newTypeIdExpressions, newInitializerExpressions));
                        }
                        catch (ASTSemanticException e) {
                            this.throwBacktrack(e.getProblem());
                            break block28;
                        }
                        catch (Exception e) {
                            this.logException("newExpression_1::createExpression()", e);
                            this.throwBacktrack(startingOffset, endOffset, line, fn);
                        }
                    }
                    catch (BacktrackException backtrackException) {
                        this.backup(beforeSecondParen);
                        if (this.templateIdScopes.size() > 0) {
                            this.templateIdScopes.pop();
                        }
                        break block28;
                    }
                }
            }
            typeId = this.typeId(scope, true, IASTCompletionNode.CompletionKind.NEW_TYPE_REFERENCE);
        }
        while (this.LT(1) == 10) {
            this.consume();
            if (this.templateIdScopes.size() > 0) {
                this.templateIdScopes.push(10);
            }
            newTypeIdExpressions.add(this.assignmentExpression(scope, IASTCompletionNode.CompletionKind.SINGLE_NAME_REFERENCE, key));
            this.consume(11);
            if (this.templateIdScopes.size() <= 0) continue;
            this.templateIdScopes.pop();
        }
        if (this.LT(1) == 8) {
            this.consume(8);
            this.setCurrentFunctionName(typeId != null ? typeId.getFullSignatureCharArray() : EMPTY_STRING);
            this.setCompletionValues(scope, IASTCompletionNode.CompletionKind.CONSTRUCTOR_REFERENCE);
            if (this.templateIdScopes.size() > 0) {
                this.templateIdScopes.push(8);
            }
            newInitializerExpressions.add(this.expression(scope, IASTCompletionNode.CompletionKind.CONSTRUCTOR_REFERENCE, key));
            this.setCurrentFunctionName(EMPTY_STRING);
            this.consume(9);
            if (this.templateIdScopes.size() > 0) {
                this.templateIdScopes.pop();
            }
        }
        this.setCompletionValues(scope, IASTCompletionNode.CompletionKind.NO_SUCH_KIND, KeywordSetKey.EMPTY);
        endOffset = this.lastToken != null ? this.lastToken.getEndOffset() : 0;
        try {
            return this.astFactory.createExpression(scope, IASTExpression.Kind.NEW_TYPEID, null, null, null, typeId, null, EMPTY_STRING, this.astFactory.createNewDescriptor(newPlacementExpressions, newTypeIdExpressions, newInitializerExpressions));
        }
        catch (ASTSemanticException e) {
            this.throwBacktrack(e.getProblem());
            return null;
        }
        catch (Exception e) {
            this.logException("newExpression_2::createExpression()", e);
            this.throwBacktrack(startingOffset, endOffset, line, fn);
            return null;
        }
    }

    protected void setCurrentFunctionName(char[] functionName) {
    }

    public IASTExpression unaryExpression(IASTScope scope, IASTCompletionNode.CompletionKind kind, KeywordSetKey key) throws EndOfFileException, BacktrackException {
        IASTExpression extensionExpression;
        IToken la = this.LA(1);
        int startingOffset = la.getOffset();
        int line = la.getLineNumber();
        char[] fn = la.getFilename();
        switch (this.LT(1)) {
            case 23: {
                this.consume();
                return this.unaryOperatorCastExpression(scope, IASTExpression.Kind.UNARY_STAR_CASTEXPRESSION, kind, key);
            }
            case 30: {
                this.consume();
                return this.unaryOperatorCastExpression(scope, IASTExpression.Kind.UNARY_AMPSND_CASTEXPRESSION, kind, key);
            }
            case 16: {
                this.consume();
                return this.unaryOperatorCastExpression(scope, IASTExpression.Kind.UNARY_PLUS_CASTEXPRESSION, kind, key);
            }
            case 21: {
                this.consume();
                return this.unaryOperatorCastExpression(scope, IASTExpression.Kind.UNARY_MINUS_CASTEXPRESSION, kind, key);
            }
            case 36: {
                this.consume();
                return this.unaryOperatorCastExpression(scope, IASTExpression.Kind.UNARY_NOT_CASTEXPRESSION, kind, key);
            }
            case 34: {
                this.consume();
                return this.unaryOperatorCastExpression(scope, IASTExpression.Kind.UNARY_TILDE_CASTEXPRESSION, kind, key);
            }
            case 15: {
                this.consume();
                return this.unaryOperatorCastExpression(scope, IASTExpression.Kind.UNARY_INCREMENT, kind, key);
            }
            case 18: {
                this.consume();
                return this.unaryOperatorCastExpression(scope, IASTExpression.Kind.UNARY_DECREMENT, kind, key);
            }
            case 105: {
                int endOffset;
                this.consume(105);
                IToken mark = this.LA(1);
                IASTTypeId d = null;
                IASTExpression unaryExpression = null;
                if (this.LT(1) == 8) {
                    try {
                        this.consume(8);
                        d = this.typeId(scope, false, IASTCompletionNode.CompletionKind.SINGLE_NAME_REFERENCE);
                        this.consume(9);
                    }
                    catch (BacktrackException backtrackException) {
                        this.backup(mark);
                        unaryExpression = this.unaryExpression(scope, kind, key);
                    }
                } else {
                    unaryExpression = this.unaryExpression(scope, kind, key);
                }
                int n = endOffset = this.lastToken != null ? this.lastToken.getEndOffset() : 0;
                if (unaryExpression == null) {
                    try {
                        return this.astFactory.createExpression(scope, IASTExpression.Kind.UNARY_SIZEOF_TYPEID, null, null, null, d, null, EMPTY_STRING, null);
                    }
                    catch (ASTSemanticException e) {
                        this.throwBacktrack(e.getProblem());
                    }
                    catch (Exception e) {
                        this.logException("unaryExpression_1::createExpression()", e);
                        this.throwBacktrack(startingOffset, endOffset, line, fn);
                    }
                }
                try {
                    return this.astFactory.createExpression(scope, IASTExpression.Kind.UNARY_SIZEOF_UNARYEXPRESSION, unaryExpression, null, null, null, null, EMPTY_STRING, null);
                }
                catch (ASTSemanticException e1) {
                    this.throwBacktrack(e1.getProblem());
                }
                catch (Exception e) {
                    this.logException("unaryExpression_1::createExpression()", e);
                    this.throwBacktrack(startingOffset, endOffset, line, fn);
                }
            }
            case 92: {
                return this.newExpression(scope, key);
            }
            case 72: {
                return this.deleteExpression(scope, kind, key);
            }
            case 3: {
                if (!this.queryLookaheadCapability(2)) break;
                switch (this.LT(2)) {
                    case 92: {
                        return this.newExpression(scope, key);
                    }
                    case 72: {
                        return this.deleteExpression(scope, kind, key);
                    }
                }
                return this.postfixExpression(scope, kind, key);
            }
        }
        if (this.extension.isValidUnaryExpressionStart(this.LT(1)) && (extensionExpression = this.extension.parseUnaryExpression(scope, this, kind, key)) != null) {
            return extensionExpression;
        }
        return this.postfixExpression(scope, kind, key);
    }

    protected IASTExpression postfixExpression(IASTScope scope, IASTCompletionNode.CompletionKind kind, KeywordSetKey key) throws EndOfFileException, BacktrackException {
        IToken la = this.LA(1);
        int startingOffset = la.getOffset();
        int line = la.getLineNumber();
        char[] fn = la.getFilename();
        IASTExpression firstExpression = null;
        boolean isTemplate = false;
        this.setCompletionValues(scope, kind, key);
        switch (this.LT(1)) {
            case 118: {
                this.consume(118);
                boolean templateTokenConsumed = false;
                if (this.LT(1) == 111) {
                    this.consume(111);
                    templateTokenConsumed = true;
                }
                ITokenDuple nestedName = this.name(scope, IASTCompletionNode.CompletionKind.TYPE_REFERENCE, KeywordSetKey.EMPTY);
                this.consume(8);
                if (this.templateIdScopes.size() > 0) {
                    this.templateIdScopes.push(8);
                }
                IASTExpression expressionList = this.expression(scope, IASTCompletionNode.CompletionKind.TYPE_REFERENCE, key);
                int endOffset = this.consume(9).getEndOffset();
                if (this.templateIdScopes.size() > 0) {
                    this.templateIdScopes.pop();
                }
                try {
                    firstExpression = this.astFactory.createExpression(scope, templateTokenConsumed ? IASTExpression.Kind.POSTFIX_TYPENAME_TEMPLATEID : IASTExpression.Kind.POSTFIX_TYPENAME_IDENTIFIER, expressionList, null, null, null, nestedName, EMPTY_STRING, null);
                }
                catch (ASTSemanticException ase) {
                    this.throwBacktrack(ase.getProblem());
                }
                catch (Exception e) {
                    this.logException("postfixExpression_1::createExpression()", e);
                    this.throwBacktrack(startingOffset, endOffset, line, fn);
                }
                break;
            }
            case 64: {
                firstExpression = this.simpleTypeConstructorExpression(scope, IASTExpression.Kind.POSTFIX_SIMPLETYPE_CHAR, key);
                break;
            }
            case 125: {
                firstExpression = this.simpleTypeConstructorExpression(scope, IASTExpression.Kind.POSTFIX_SIMPLETYPE_WCHART, key);
                break;
            }
            case 60: {
                firstExpression = this.simpleTypeConstructorExpression(scope, IASTExpression.Kind.POSTFIX_SIMPLETYPE_BOOL, key);
                break;
            }
            case 104: {
                firstExpression = this.simpleTypeConstructorExpression(scope, IASTExpression.Kind.POSTFIX_SIMPLETYPE_SHORT, key);
                break;
            }
            case 88: {
                firstExpression = this.simpleTypeConstructorExpression(scope, IASTExpression.Kind.POSTFIX_SIMPLETYPE_INT, key);
                break;
            }
            case 89: {
                firstExpression = this.simpleTypeConstructorExpression(scope, IASTExpression.Kind.POSTFIX_SIMPLETYPE_LONG, key);
                break;
            }
            case 108: {
                firstExpression = this.simpleTypeConstructorExpression(scope, IASTExpression.Kind.POSTFIX_SIMPLETYPE_SIGNED, key);
                break;
            }
            case 120: {
                firstExpression = this.simpleTypeConstructorExpression(scope, IASTExpression.Kind.POSTFIX_SIMPLETYPE_UNSIGNED, key);
                break;
            }
            case 82: {
                firstExpression = this.simpleTypeConstructorExpression(scope, IASTExpression.Kind.POSTFIX_SIMPLETYPE_FLOAT, key);
                break;
            }
            case 74: {
                firstExpression = this.simpleTypeConstructorExpression(scope, IASTExpression.Kind.POSTFIX_SIMPLETYPE_DOUBLE, key);
                break;
            }
            case 75: {
                firstExpression = this.specialCastExpression(scope, IASTExpression.Kind.POSTFIX_DYNAMIC_CAST, key);
                break;
            }
            case 107: {
                firstExpression = this.specialCastExpression(scope, IASTExpression.Kind.POSTFIX_STATIC_CAST, key);
                break;
            }
            case 102: {
                firstExpression = this.specialCastExpression(scope, IASTExpression.Kind.POSTFIX_REINTERPRET_CAST, key);
                break;
            }
            case 69: {
                firstExpression = this.specialCastExpression(scope, IASTExpression.Kind.POSTFIX_CONST_CAST, key);
                break;
            }
            case 117: {
                this.consume();
                this.consume(8);
                if (this.templateIdScopes.size() > 0) {
                    this.templateIdScopes.push(8);
                }
                boolean isTypeId = true;
                IASTExpression lhs = null;
                IASTTypeId typeId = null;
                try {
                    typeId = this.typeId(scope, false, IASTCompletionNode.CompletionKind.TYPE_REFERENCE);
                }
                catch (BacktrackException backtrackException) {
                    isTypeId = false;
                    lhs = this.expression(scope, IASTCompletionNode.CompletionKind.TYPE_REFERENCE, key);
                }
                int endOffset = this.consume(9).getEndOffset();
                if (this.templateIdScopes.size() > 0) {
                    this.templateIdScopes.pop();
                }
                try {
                    firstExpression = this.astFactory.createExpression(scope, isTypeId ? IASTExpression.Kind.POSTFIX_TYPEID_TYPEID : IASTExpression.Kind.POSTFIX_TYPEID_EXPRESSION, lhs, null, null, typeId, null, EMPTY_STRING, null);
                }
                catch (ASTSemanticException e6) {
                    this.throwBacktrack(e6.getProblem());
                }
                catch (Exception e) {
                    this.logException("postfixExpression_2::createExpression()", e);
                    this.throwBacktrack(startingOffset, endOffset, line, fn);
                }
                break;
            }
            default: {
                firstExpression = this.primaryExpression(scope, kind, key);
            }
        }
        IASTExpression secondExpression = null;
        block52: while (true) {
            switch (this.LT(1)) {
                case 10: {
                    this.consume(10);
                    if (this.templateIdScopes.size() > 0) {
                        this.templateIdScopes.push(10);
                    }
                    secondExpression = this.expression(scope, IASTCompletionNode.CompletionKind.SINGLE_NAME_REFERENCE, key);
                    int endOffset = this.consume(11).getEndOffset();
                    if (this.templateIdScopes.size() > 0) {
                        this.templateIdScopes.pop();
                    }
                    try {
                        firstExpression = this.astFactory.createExpression(scope, IASTExpression.Kind.POSTFIX_SUBSCRIPT, firstExpression, secondExpression, null, null, null, EMPTY_STRING, null);
                    }
                    catch (ASTSemanticException e2) {
                        this.throwBacktrack(e2.getProblem());
                    }
                    catch (Exception e) {
                        this.logException("postfixExpression_3::createExpression()", e);
                        this.throwBacktrack(startingOffset, endOffset, line, fn);
                    }
                    continue block52;
                }
                case 8: {
                    this.consume(8);
                    IASTNode context = null;
                    if (firstExpression != null) {
                        if (firstExpression.getExpressionKind() == IASTExpression.Kind.ID_EXPRESSION) {
                            this.setCurrentFunctionName(firstExpression.getIdExpressionCharArray());
                        } else if (firstExpression.getRHSExpression() != null && firstExpression.getRHSExpression().getIdExpressionCharArray() != null) {
                            this.setCurrentFunctionName(firstExpression.getRHSExpression().getIdExpressionCharArray());
                            context = this.astFactory.expressionToMostPreciseASTNode(scope, firstExpression.getLHSExpression());
                        }
                    }
                    if (this.templateIdScopes.size() > 0) {
                        this.templateIdScopes.push(8);
                    }
                    this.setCompletionValues(scope, IASTCompletionNode.CompletionKind.FUNCTION_REFERENCE, context);
                    secondExpression = this.expression(scope, IASTCompletionNode.CompletionKind.FUNCTION_REFERENCE, key);
                    this.setCurrentFunctionName(EMPTY_STRING);
                    int endOffset = this.consume(9).getEndOffset();
                    if (this.templateIdScopes.size() > 0) {
                        this.templateIdScopes.pop();
                    }
                    try {
                        firstExpression = this.astFactory.createExpression(scope, IASTExpression.Kind.POSTFIX_FUNCTIONCALL, firstExpression, secondExpression, null, null, null, EMPTY_STRING, null);
                    }
                    catch (ASTSemanticException e3) {
                        this.throwBacktrack(e3.getProblem());
                    }
                    catch (Exception e) {
                        this.logException("postfixExpression_4::createExpression()", e);
                        this.throwBacktrack(startingOffset, endOffset, line, fn);
                    }
                    continue block52;
                }
                case 15: {
                    int endOffset = this.consume(15).getEndOffset();
                    try {
                        firstExpression = this.astFactory.createExpression(scope, IASTExpression.Kind.POSTFIX_INCREMENT, firstExpression, null, null, null, null, EMPTY_STRING, null);
                    }
                    catch (ASTSemanticException e1) {
                        this.throwBacktrack(e1.getProblem());
                    }
                    catch (Exception e) {
                        this.logException("postfixExpression_5::createExpression()", e);
                        this.throwBacktrack(startingOffset, endOffset, line, fn);
                    }
                    continue block52;
                }
                case 18: {
                    int endOffset = this.consume().getEndOffset();
                    try {
                        firstExpression = this.astFactory.createExpression(scope, IASTExpression.Kind.POSTFIX_DECREMENT, firstExpression, null, null, null, null, EMPTY_STRING, null);
                    }
                    catch (ASTSemanticException e4) {
                        this.throwBacktrack(e4.getProblem());
                    }
                    catch (Exception e) {
                        this.logException("postfixExpression_6::createExpression()", e);
                        this.throwBacktrack(startingOffset, endOffset, line, fn);
                    }
                    continue block52;
                }
                case 50: {
                    int endOffset;
                    this.consume(50);
                    if (this.queryLookaheadCapability() && this.LT(1) == 111) {
                        this.consume(111);
                        isTemplate = true;
                    }
                    IASTExpression.Kind memberCompletionKind = isTemplate ? IASTExpression.Kind.POSTFIX_DOT_TEMPL_IDEXPRESS : IASTExpression.Kind.POSTFIX_DOT_IDEXPRESSION;
                    this.setCompletionValues(scope, IASTCompletionNode.CompletionKind.MEMBER_REFERENCE, KeywordSetKey.EMPTY, firstExpression, memberCompletionKind);
                    secondExpression = this.primaryExpression(scope, IASTCompletionNode.CompletionKind.MEMBER_REFERENCE, key);
                    int n = endOffset = this.lastToken != null ? this.lastToken.getEndOffset() : 0;
                    if (secondExpression != null && secondExpression.getExpressionKind() == IASTExpression.Kind.ID_EXPRESSION && CharArrayUtils.indexOf('~', secondExpression.getIdExpressionCharArray()) != -1) {
                        memberCompletionKind = IASTExpression.Kind.POSTFIX_DOT_DESTRUCTOR;
                    }
                    try {
                        firstExpression = this.astFactory.createExpression(scope, memberCompletionKind, firstExpression, secondExpression, null, null, null, EMPTY_STRING, null);
                    }
                    catch (ASTSemanticException e5) {
                        this.throwBacktrack(e5.getProblem());
                    }
                    catch (Exception e) {
                        this.logException("postfixExpression_7::createExpression()", e);
                        this.throwBacktrack(startingOffset, endOffset, line, fn);
                    }
                    continue block52;
                }
                case 20: {
                    int endOffset;
                    this.consume(20);
                    if (this.queryLookaheadCapability() && this.LT(1) == 111) {
                        this.consume(111);
                        isTemplate = true;
                    }
                    IASTExpression.Kind arrowCompletionKind = isTemplate ? IASTExpression.Kind.POSTFIX_ARROW_TEMPL_IDEXP : IASTExpression.Kind.POSTFIX_ARROW_IDEXPRESSION;
                    this.setCompletionValues(scope, IASTCompletionNode.CompletionKind.MEMBER_REFERENCE, KeywordSetKey.EMPTY, firstExpression, arrowCompletionKind);
                    secondExpression = this.primaryExpression(scope, IASTCompletionNode.CompletionKind.MEMBER_REFERENCE, key);
                    int n = endOffset = this.lastToken != null ? this.lastToken.getEndOffset() : 0;
                    if (secondExpression != null && secondExpression.getExpressionKind() == IASTExpression.Kind.ID_EXPRESSION && CharArrayUtils.indexOf('~', secondExpression.getIdExpressionCharArray()) != -1) {
                        arrowCompletionKind = IASTExpression.Kind.POSTFIX_ARROW_DESTRUCTOR;
                    }
                    try {
                        firstExpression = this.astFactory.createExpression(scope, arrowCompletionKind, firstExpression, secondExpression, null, null, null, EMPTY_STRING, null);
                    }
                    catch (ASTSemanticException e) {
                        this.throwBacktrack(e.getProblem());
                    }
                    catch (Exception e) {
                        this.logException("postfixExpression_8::createExpression()", e);
                        this.throwBacktrack(startingOffset, endOffset, line, fn);
                    }
                    continue block52;
                }
            }
            break;
        }
        return firstExpression;
    }

    protected boolean queryLookaheadCapability(int count) throws EndOfFileException {
        boolean result = true;
        try {
            this.LA(count);
        }
        catch (EndOfFileException endOfFileException) {
            result = false;
        }
        return result;
    }

    protected boolean queryLookaheadCapability() throws EndOfFileException {
        return this.queryLookaheadCapability(1);
    }

    protected void checkEndOfFile() throws EndOfFileException {
        this.LA(1);
    }

    protected IASTExpression simpleTypeConstructorExpression(IASTScope scope, IASTExpression.Kind type, KeywordSetKey key) throws EndOfFileException, BacktrackException {
        IToken la = this.LA(1);
        int startingOffset = la.getOffset();
        int line = la.getLineNumber();
        char[] fn = la.getFilename();
        la = null;
        char[] typeName = this.consume().getCharImage();
        this.consume(8);
        this.setCurrentFunctionName(typeName);
        IASTExpression inside = this.expression(scope, IASTCompletionNode.CompletionKind.CONSTRUCTOR_REFERENCE, key);
        this.setCurrentFunctionName(EMPTY_STRING);
        int endOffset = this.consume(9).getEndOffset();
        try {
            return this.astFactory.createExpression(scope, type, inside, null, null, null, null, EMPTY_STRING, null);
        }
        catch (ASTSemanticException e) {
            this.throwBacktrack(e.getProblem());
        }
        catch (Exception e) {
            this.logException("simpleTypeConstructorExpression::createExpression()", e);
            this.throwBacktrack(startingOffset, endOffset, line, fn);
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    protected IASTExpression primaryExpression(IASTScope scope, IASTCompletionNode.CompletionKind kind, KeywordSetKey key) throws EndOfFileException, BacktrackException {
        t = null;
        switch (this.LT(1)) {
            case 2: {
                t = this.consume();
                try {
                    return this.astFactory.createExpression(scope, IASTExpression.Kind.PRIMARY_INTEGER_LITERAL, null, null, null, null, null, t.getCharImage(), null);
                }
                catch (ASTSemanticException e1) {
                    this.throwBacktrack(e1.getProblem());
                }
                catch (Exception e) {
                    this.logException("primaryExpression_1::createExpression()", e);
                    this.throwBacktrack(t.getOffset(), t.getEndOffset(), t.getLineNumber(), t.getFilename());
                }
            }
            case 129: {
                t = this.consume();
                try {
                    return this.astFactory.createExpression(scope, IASTExpression.Kind.PRIMARY_FLOAT_LITERAL, null, null, null, null, null, t.getCharImage(), null);
                }
                catch (ASTSemanticException e2) {
                    this.throwBacktrack(e2.getProblem());
                }
                catch (Exception e) {
                    this.logException("primaryExpression_2::createExpression()", e);
                    this.throwBacktrack(t.getOffset(), t.getEndOffset(), t.getLineNumber(), t.getFilename());
                }
            }
            case 130: 
            case 131: {
                t = this.consume();
                try {
                    return this.astFactory.createExpression(scope, IASTExpression.Kind.PRIMARY_STRING_LITERAL, null, null, null, null, null, t.getCharImage(), null);
                }
                catch (ASTSemanticException e5) {
                    this.throwBacktrack(e5.getProblem());
                }
                catch (Exception e) {
                    this.logException("primaryExpression_3::createExpression()", e);
                    this.throwBacktrack(t.getOffset(), t.getEndOffset(), t.getLineNumber(), t.getFilename());
                }
            }
            case 81: 
            case 114: {
                t = this.consume();
                try {
                    return this.astFactory.createExpression(scope, IASTExpression.Kind.PRIMARY_BOOLEAN_LITERAL, null, null, null, null, null, t.getCharImage(), null);
                }
                catch (ASTSemanticException e3) {
                    this.throwBacktrack(e3.getProblem());
                }
                catch (Exception e) {
                    this.logException("primaryExpression_4::createExpression()", e);
                    this.throwBacktrack(t.getOffset(), t.getEndOffset(), t.getLineNumber(), t.getFilename());
                }
            }
            case 132: 
            case 133: {
                t = this.consume();
                try {
                    return this.astFactory.createExpression(scope, IASTExpression.Kind.PRIMARY_CHAR_LITERAL, null, null, null, null, null, t.getCharImage(), null);
                }
                catch (ASTSemanticException e4) {
                    this.throwBacktrack(e4.getProblem());
                }
                catch (Exception e) {
                    this.logException("primaryExpression_5::createExpression()", e);
                    this.throwBacktrack(t.getOffset(), t.getEndOffset(), t.getLineNumber(), t.getFilename());
                }
            }
            case 112: {
                t = this.consume(112);
                try {
                    return this.astFactory.createExpression(scope, IASTExpression.Kind.PRIMARY_THIS, null, null, null, null, null, ExpressionParser.EMPTY_STRING, null);
                }
                catch (ASTSemanticException e7) {
                    this.throwBacktrack(e7.getProblem());
                }
                catch (Exception e) {
                    this.logException("primaryExpression_6::createExpression()", e);
                    this.throwBacktrack(t.getOffset(), t.getEndOffset(), t.getLineNumber(), t.getFilename());
                }
            }
            case 8: {
                t = this.consume();
                if (this.templateIdScopes.size() > 0) {
                    this.templateIdScopes.push(8);
                }
                lhs = this.expression(scope, kind, key);
                endOffset = this.consume(9).getEndOffset();
                if (this.templateIdScopes.size() > 0) {
                    this.templateIdScopes.pop();
                }
                try {
                    return this.astFactory.createExpression(scope, IASTExpression.Kind.PRIMARY_BRACKETED_EXPRESSION, lhs, null, null, null, null, ExpressionParser.EMPTY_STRING, null);
                }
                catch (ASTSemanticException e6) {
                    this.throwBacktrack(e6.getProblem());
                }
                catch (Exception e) {
                    this.logException("primaryExpression_7::createExpression()", e);
                    this.throwBacktrack(t.getOffset(), endOffset, t.getLineNumber(), t.getFilename());
                }
            }
            case 1: 
            case 3: 
            case 34: 
            case 95: {
                duple = null;
                startingOffset = this.LA(1).getOffset();
                line = this.LA(1).getLineNumber();
                try {
                    duple = this.name(scope, kind, key);
                    ** GOTO lbl109
                }
                catch (BacktrackException v0) {
                    mark = this.mark();
                    d = new Declarator(new DeclarationWrapper(scope, mark.getOffset(), mark.getLineNumber(), null, mark.getFilename()));
                    if (this.LT(1) != 3 && this.LT(1) != 1) ** GOTO lbl106
                    start = this.consume();
                    end = null;
                    if (start.getType() == 1) {
                        end = this.consumeTemplateParameters(end);
                    }
                    ** while (this.LT((int)1) == 3 || this.LT((int)1) == 1)
                }
lbl-1000:
                // 1 sources

                {
                    end = this.consume();
                    if (end.getType() != 1) continue;
                    end = this.consumeTemplateParameters(end);
                    continue;
                }
lbl100:
                // 1 sources

                if (this.LT(1) == 95) {
                    this.operatorId(d, start, null, kind);
                } else {
                    this.backup(mark);
                    this.throwBacktrack(startingOffset, end.getEndOffset(), end.getLineNumber(), t.getFilename());
                }
                ** GOTO lbl108
lbl106:
                // 1 sources

                if (this.LT(1) == 95) {
                    this.operatorId(d, null, null, kind);
                }
lbl108:
                // 5 sources

                duple = d.getNameDuple();
lbl109:
                // 2 sources

                endOffset = this.lastToken != null ? this.lastToken.getEndOffset() : 0;
                try {
                    return this.astFactory.createExpression(scope, IASTExpression.Kind.ID_EXPRESSION, null, null, null, null, duple, ExpressionParser.EMPTY_STRING, null);
                }
                catch (ASTSemanticException e8) {
                    this.throwBacktrack(e8.getProblem());
                    break;
                }
                catch (Exception e) {
                    this.logException("primaryExpression_8::createExpression()", e);
                    this.throwBacktrack(startingOffset, endOffset, line, duple.getFilename());
                }
            }
        }
        la = this.LA(1);
        startingOffset = la.getOffset();
        line = la.getLineNumber();
        fn = la.getFilename();
        if (!this.queryLookaheadCapability(2) && this.LA(1).canBeAPrefix()) {
            this.consume();
            this.checkEndOfFile();
        }
        empty = null;
        try {
            empty = this.astFactory.createExpression(scope, IASTExpression.Kind.PRIMARY_EMPTY, null, null, null, null, null, ExpressionParser.EMPTY_STRING, null);
        }
        catch (ASTSemanticException e9) {
            this.throwBacktrack(e9.getProblem());
            return null;
        }
        catch (Exception e) {
            this.logException("primaryExpression_9::createExpression()", e);
            this.throwBacktrack(startingOffset, 0, line, fn);
        }
        return empty;
    }

    protected IToken fetchToken() throws EndOfFileException {
        if (this.limitReached) {
            throw new EndOfFileException();
        }
        try {
            IToken value = this.scanner.nextToken();
            return value;
        }
        catch (OffsetLimitReachedException olre) {
            this.limitReached = true;
            this.handleOffsetLimitException(olre);
            return null;
        }
        catch (ScannerException e) {
            TraceUtil.outputTrace(this.log, "ScannerException thrown : ", e.getProblem());
            return this.fetchToken();
        }
    }

    protected void handleNewToken(IToken value) {
    }

    protected void handleOffsetLimitException(OffsetLimitReachedException exception) throws EndOfFileException {
        throw new EndOfFileException();
    }

    protected IASTExpression assignmentOperatorExpression(IASTScope scope, IASTExpression.Kind kind, IASTExpression lhs, IASTCompletionNode.CompletionKind completionKind, KeywordSetKey key) throws EndOfFileException, BacktrackException {
        IToken t = this.consume();
        IASTExpression assignmentExpression = this.assignmentExpression(scope, completionKind, key);
        int endOffset = this.lastToken != null ? this.lastToken.getEndOffset() : 0;
        try {
            return this.astFactory.createExpression(scope, kind, lhs, assignmentExpression, null, null, null, EMPTY_STRING, null);
        }
        catch (ASTSemanticException e) {
            this.throwBacktrack(e.getProblem());
        }
        catch (Exception e) {
            this.logException("assignmentOperatorExpression::createExpression()", e);
            this.throwBacktrack(t.getOffset(), endOffset, t.getLineNumber(), t.getFilename());
        }
        return null;
    }

    protected void setCompletionValues(IASTScope scope, IASTCompletionNode.CompletionKind kind, KeywordSetKey key) throws EndOfFileException {
    }

    protected void setCompletionValues(IASTScope scope, IASTCompletionNode.CompletionKind kind, KeywordSetKey key, IASTNode node, String prefix) throws EndOfFileException {
    }

    protected void setCompletionValues(IASTScope scope, IASTCompletionNode.CompletionKind kind, KeywordSetKey key, IASTExpression firstExpression, IASTExpression.Kind expressionKind) throws EndOfFileException {
    }

    protected void setCompletionValues(IASTScope scope, IASTCompletionNode.CompletionKind kind, IToken first, IToken last, KeywordSetKey key) throws EndOfFileException {
    }

    protected IASTExpression unaryOperatorCastExpression(IASTScope scope, IASTExpression.Kind kind, IASTCompletionNode.CompletionKind completionKind, KeywordSetKey key) throws EndOfFileException, BacktrackException {
        IToken la = this.LA(1);
        int startingOffset = la.getOffset();
        int line = la.getLineNumber();
        char[] fn = la.getFilename();
        la = null;
        IASTExpression castExpression = this.castExpression(scope, completionKind, key);
        int endOffset = this.lastToken != null ? this.lastToken.getEndOffset() : 0;
        try {
            return this.astFactory.createExpression(scope, kind, castExpression, null, null, null, null, EMPTY_STRING, null);
        }
        catch (ASTSemanticException e) {
            this.throwBacktrack(e.getProblem());
        }
        catch (Exception e) {
            this.logException("unaryOperatorCastExpression::createExpression()", e);
            this.throwBacktrack(startingOffset, endOffset, line, fn);
        }
        return null;
    }

    protected IASTExpression specialCastExpression(IASTScope scope, IASTExpression.Kind kind, KeywordSetKey key) throws EndOfFileException, BacktrackException {
        IToken la = this.LA(1);
        int startingOffset = la.getOffset();
        int line = la.getLineNumber();
        char[] fn = la.getFilename();
        la = null;
        this.consume();
        this.consume(42);
        IASTTypeId duple = this.typeId(scope, false, IASTCompletionNode.CompletionKind.TYPE_REFERENCE);
        this.consume(46);
        this.consume(8);
        IASTExpression lhs = this.expression(scope, IASTCompletionNode.CompletionKind.SINGLE_NAME_REFERENCE, key);
        int endOffset = this.consume(9).getEndOffset();
        try {
            return this.astFactory.createExpression(scope, kind, lhs, null, null, duple, null, EMPTY_STRING, null);
        }
        catch (ASTSemanticException e) {
            this.throwBacktrack(e.getProblem());
        }
        catch (Exception e) {
            this.logException("specialCastExpression::createExpression()", e);
            this.throwBacktrack(startingOffset, endOffset, line, fn);
        }
        return null;
    }

    public IToken getLastToken() {
        return this.lastToken;
    }

    public final ParserLanguage getParserLanguage() {
        return this.language;
    }

    public IToken identifier() throws EndOfFileException, BacktrackException {
        IToken first = this.consume(1);
        if (first instanceof ITokenDuple) {
            this.setGreaterNameContext((ITokenDuple)((Object)first));
        }
        return first;
    }

    public boolean validateCaches() {
        return true;
    }

    public String toString() {
        return this.scanner.toString();
    }

    public final int getBacktrackCount() {
        return this.backtrackCount;
    }

    protected void throwBacktrack(BacktrackException bt) throws BacktrackException {
        throw bt;
    }

    /*
     * Unable to fully structure code
     */
    protected void errorHandling() throws EndOfFileException {
        depth = this.LT(1) == 12 ? 1 : 0;
        type = this.consume().getType();
        if (type != 5) ** GOTO lbl15
        return;
lbl-1000:
        // 1 sources

        {
            switch (this.LT(1)) {
                case 12: {
                    ++depth;
                    break;
                }
                case 13: {
                    --depth;
                }
            }
            if (depth < 0) {
                return;
            }
            this.consume();
lbl15:
            // 2 sources

            ** while ((this.LT((int)1) != 5 || depth != 0) && (this.LT((int)1) != 13 || depth != true))
        }
lbl16:
        // 1 sources

        this.consume();
    }

    private static class ScopeStack {
        private int[] stack = new int[8];
        private int index = -1;

        private void grow() {
            int[] newStack = new int[this.stack.length << 1];
            System.arraycopy(this.stack, 0, newStack, 0, this.stack.length);
            this.stack = newStack;
        }

        public final void push(int i) {
            if (++this.index == this.stack.length) {
                this.grow();
            }
            this.stack[this.index] = i;
        }

        public final int pop() {
            if (this.index >= 0) {
                return this.stack[this.index--];
            }
            return -1;
        }

        public final int peek() {
            if (this.index >= 0) {
                return this.stack[this.index];
            }
            return -1;
        }

        public final int size() {
            return this.index + 1;
        }
    }
}

