/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.scanner;

import java.util.Arrays;
import org.eclipse.cdt.core.parser.IMacroDescriptor;
import org.eclipse.cdt.core.parser.IToken;

public class FunctionMacroDescriptor
implements IMacroDescriptor {
    private String name;
    private String[] identifierParameters;
    private IToken[] tokenizedExpansion;
    private String expansionSignature;

    public FunctionMacroDescriptor(String name, String[] identifiers, IToken[] tokens, String expansionSignature) {
        this.name = name;
        this.identifierParameters = identifiers;
        this.tokenizedExpansion = tokens;
        this.expansionSignature = expansionSignature;
    }

    public final String[] getParameters() {
        return this.identifierParameters;
    }

    public final IToken[] getTokenizedExpansion() {
        return this.tokenizedExpansion;
    }

    public final String getName() {
        return this.name;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(128);
        int count = this.identifierParameters.length;
        buffer.append("MacroDescriptor with name=" + this.getName() + "\n");
        buffer.append("Number of parameters = " + count + "\n");
        int current = 0;
        while (current < count) {
            buffer.append("Parameter #" + current + " with name=" + this.identifierParameters[current] + "\n");
            ++current;
        }
        count = this.tokenizedExpansion.length;
        buffer.append("Number of tokens = " + count + "\n");
        current = 0;
        while (current < count) {
            buffer.append("Token #" + current++ + " is " + this.tokenizedExpansion[current].toString() + "\n");
            ++current;
        }
        return buffer.toString();
    }

    public final String getCompleteSignature() {
        StringBuffer fullSignature = new StringBuffer("#define ");
        fullSignature.append(this.name);
        fullSignature.append('(');
        int current = 0;
        while (current < this.identifierParameters.length) {
            if (current > 0) {
                fullSignature.append(',');
            }
            fullSignature.append(this.identifierParameters[current]);
            ++current;
        }
        fullSignature.append(") ");
        fullSignature.append(this.expansionSignature);
        return fullSignature.toString();
    }

    public boolean compatible(IMacroDescriptor descriptor) {
        if (descriptor.getName() == null) {
            return false;
        }
        if (descriptor.getTokenizedExpansion() == null) {
            return false;
        }
        if (descriptor.getParameters() == null) {
            return false;
        }
        if (descriptor.getMacroType() != this.getMacroType()) {
            return false;
        }
        if (!this.name.equals(descriptor.getName())) {
            return false;
        }
        if (descriptor.getParameters().length != this.identifierParameters.length) {
            return false;
        }
        if (descriptor.getTokenizedExpansion().length != this.tokenizedExpansion.length) {
            return false;
        }
        if (!this.equivalentArrayContents(descriptor.getParameters(), this.getParameters())) {
            return false;
        }
        return this.equivalentArrayContents(descriptor.getTokenizedExpansion(), this.getTokenizedExpansion());
    }

    private boolean equivalentArrayContents(Object[] list1, Object[] list2) {
        if (Arrays.equals(list1, list2)) {
            return true;
        }
        int i = 0;
        while (i < list1.length) {
            block4: {
                Object key = list1[i];
                int j = 0;
                while (j < list2.length) {
                    if (!key.equals(list2[j])) {
                        ++j;
                        continue;
                    }
                    break block4;
                }
                return false;
            }
            ++i;
        }
        return true;
    }

    public IMacroDescriptor.MacroType getMacroType() {
        return IMacroDescriptor.MacroType.FUNCTION_LIKE;
    }

    public String getExpansionSignature() {
        return this.expansionSignature;
    }

    public boolean isCircular() {
        int i = 0;
        while (i < this.tokenizedExpansion.length) {
            IToken t = this.tokenizedExpansion[i];
            if (t.getType() == 1 && t.getImage().equals(this.getName())) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

