/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.token;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.IToken;
import org.eclipse.cdt.core.parser.ITokenDuple;
import org.eclipse.cdt.core.parser.ast.IASTExpression;
import org.eclipse.cdt.core.parser.ast.IReferenceManager;
import org.eclipse.cdt.internal.core.parser.token.BasicTokenDuple;
import org.eclipse.cdt.internal.core.parser.token.TokenFactory;

public class TemplateTokenDuple
extends BasicTokenDuple {
    protected final List[] argLists;
    private final int numSegments;

    public TemplateTokenDuple(IToken first, IToken last, List templateArgLists) {
        super(first, last);
        this.argLists = templateArgLists.toArray(new List[templateArgLists.size()]);
        this.numSegments = this.calculateSegmentCount();
    }

    public int getSegmentCount() {
        return this.numSegments;
    }

    public ITokenDuple getLastSegment() {
        IToken first = null;
        IToken last = null;
        IToken token = null;
        while (token != this.getLastToken()) {
            IToken iToken = token = token != null ? token.getNext() : this.getFirstToken();
            if (first == null) {
                first = token;
            }
            if (token.getType() == 42) {
                token = TokenFactory.consumeTemplateIdArguments(token, this.getLastToken());
            } else if (token.getType() == 3) {
                first = null;
                continue;
            }
            last = token;
        }
        List[] args = this.getTemplateIdArgLists();
        if (args != null && args[args.length - 1] != null) {
            ArrayList<List> newArgs = new ArrayList<List>(1);
            newArgs.add(args[args.length - 1]);
            return TokenFactory.createTokenDuple(first, last, newArgs);
        }
        return TokenFactory.createTokenDuple(first, last);
    }

    public TemplateTokenDuple(ITokenDuple first, ITokenDuple last) {
        super(first, last);
        List[] a1 = first.getTemplateIdArgLists();
        List[] a2 = last.getTemplateIdArgLists();
        int l1 = a1 != null ? a1.length : first.getSegmentCount();
        int l2 = a2 != null ? a2.length : first.getSegmentCount();
        this.argLists = new List[l1 + l2];
        if (a1 != null) {
            System.arraycopy(a1, 0, this.argLists, 0, l1);
        }
        if (a2 != null) {
            System.arraycopy(a2, 0, this.argLists, l1, l2);
        }
        this.numSegments = this.calculateSegmentCount();
    }

    public List[] getTemplateIdArgLists() {
        return this.argLists;
    }

    public void freeReferences(IReferenceManager manager) {
        if (this.argLists == null) {
            return;
        }
        int i = 0;
        while (i < this.argLists.length) {
            if (this.argLists[i] != null) {
                int j = 0;
                while (j < this.argLists[i].size()) {
                    IASTExpression e = (IASTExpression)this.argLists[i].get(j);
                    e.freeReferences(manager);
                    ++j;
                }
            }
            ++i;
        }
    }

    public void acceptElement(ISourceElementRequestor requestor, IReferenceManager manager) {
        if (this.argLists == null) {
            return;
        }
        int i = 0;
        while (i < this.argLists.length) {
            if (this.argLists[i] != null) {
                int j = 0;
                while (j < this.argLists[i].size()) {
                    IASTExpression e = (IASTExpression)this.argLists[i].get(j);
                    e.acceptElement(requestor, manager);
                    ++j;
                }
            }
            ++i;
        }
    }
}

