/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.utils.Addr2line;
import org.eclipse.cdt.utils.BinaryFile;
import org.eclipse.cdt.utils.CPPFilt;
import org.eclipse.cdt.utils.Objdump;
import org.eclipse.core.runtime.IPath;

public abstract class BinaryObjectAdapter
extends BinaryFile
implements IBinaryParser.IBinaryObject,
IBinaryParser.IBinaryExecutable,
IBinaryParser.IBinaryShared {
    protected IBinaryParser.ISymbol[] NO_SYMBOLS = new IBinaryParser.ISymbol[0];

    public BinaryObjectAdapter(IBinaryParser parser, IPath path) {
        super(parser, path);
    }

    public IBinaryParser.ISymbol getSymbol(long addr) {
        Object[] syms = this.getSymbols();
        int insertion = Arrays.binarySearch(syms, new Long(addr));
        if (insertion >= 0) {
            return syms[insertion];
        }
        if (insertion == -1) {
            return null;
        }
        Object symbol = syms[(insertion = -insertion - 1) - 1];
        if (addr < symbol.getAddress() + symbol.getSize()) {
            return syms[insertion - 1];
        }
        return null;
    }

    public long getBSS() {
        BinaryObjectInfo info = this.getBinaryObjectInfo();
        if (info != null) {
            return info.bss;
        }
        return 0L;
    }

    public String getCPU() {
        BinaryObjectInfo info = this.getBinaryObjectInfo();
        if (info != null) {
            return info.cpu;
        }
        return "";
    }

    public long getData() {
        BinaryObjectInfo info = this.getBinaryObjectInfo();
        if (info != null) {
            return info.data;
        }
        return 0L;
    }

    public long getText() {
        BinaryObjectInfo info = this.getBinaryObjectInfo();
        if (info != null) {
            return info.text;
        }
        return 0L;
    }

    public boolean hasDebug() {
        BinaryObjectInfo info = this.getBinaryObjectInfo();
        if (info != null) {
            return info.hasDebug;
        }
        return false;
    }

    public boolean isLittleEndian() {
        BinaryObjectInfo info = this.getBinaryObjectInfo();
        if (info != null) {
            return info.isLittleEndian;
        }
        return false;
    }

    public String[] getNeededSharedLibs() {
        BinaryObjectInfo info = this.getBinaryObjectInfo();
        if (info != null) {
            return info.needed;
        }
        return new String[0];
    }

    public String getSoName() {
        BinaryObjectInfo info = this.getBinaryObjectInfo();
        if (info != null) {
            return info.soname;
        }
        return "";
    }

    public String getName() {
        return this.getPath().lastSegment().toString();
    }

    public InputStream getContents() {
        InputStream stream = null;
        Objdump objdump = this.getObjdump();
        if (objdump != null) {
            try {
                byte[] contents = objdump.getOutput();
                stream = new ByteArrayInputStream(contents);
            }
            catch (IOException iOException) {}
        }
        if (stream == null) {
            stream = super.getContents();
        }
        return stream;
    }

    public String toString() {
        return this.getName();
    }

    public Addr2line getAddr2line() {
        return null;
    }

    public CPPFilt getCPPFilt() {
        return null;
    }

    public Objdump getObjdump() {
        return null;
    }

    public abstract IBinaryParser.ISymbol[] getSymbols();

    protected abstract BinaryObjectInfo getBinaryObjectInfo();

    public class BinaryObjectInfo {
        public long bss;
        public long data;
        public long text;
        public boolean hasDebug;
        public boolean isLittleEndian;
        public String soname = "";
        public String[] needed = new String[0];
        public String cpu = "";
    }
}

