/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.editor;

import java.util.Iterator;
import java.util.Set;
import org.eclipse.cdt.core.ICLogConstants;
import org.eclipse.cdt.core.parser.KeywordSetKey;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.internal.core.model.Util;
import org.eclipse.cdt.internal.core.parser.token.KeywordSets;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewerExtension2;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

class MouseClickListener
implements MouseListener,
KeyListener,
MouseMoveListener,
FocusListener,
PaintListener,
IPropertyChangeListener {
    private final CEditor fEditor;
    private ISourceViewer fViewer;
    private IPreferenceStore fPrefStore;
    private IAction fOpenDeclAction;
    private boolean fActive;
    private IRegion fActiveRegion;
    private Position fRememberedPosition;
    private Cursor fCursor;
    private Color fColor;
    private int fKeyModifierMask;
    private boolean fIncludeMode;
    private Set fgKeywords;

    public MouseClickListener(CEditor editor, ISourceViewer viewer, IPreferenceStore store, IAction openDeclAction) {
        this.fEditor = editor;
        this.fViewer = viewer;
        this.fPrefStore = store;
        this.fOpenDeclAction = openDeclAction;
        this.fgKeywords = KeywordSets.getKeywords((KeywordSetKey)KeywordSetKey.ALL, (ParserLanguage)ParserLanguage.CPP);
    }

    public void deactivate() {
        this.deactivate(false);
    }

    public void deactivate(boolean redrawAll) {
        if (!this.fActive) {
            return;
        }
        this.repairRepresentation(redrawAll);
        this.fActive = false;
        this.fIncludeMode = false;
    }

    private void repairRepresentation(boolean redrawAll) {
        if (this.fActiveRegion == null) {
            return;
        }
        ISourceViewer viewer = this.fViewer;
        if (viewer != null) {
            this.resetCursor(viewer);
            int offset = this.fActiveRegion.getOffset();
            int length = this.fActiveRegion.getLength();
            if (!redrawAll && viewer instanceof ITextViewerExtension2) {
                ((ITextViewerExtension2)viewer).invalidateTextPresentation(offset, length);
            } else {
                viewer.invalidateTextPresentation();
            }
            if (viewer instanceof ITextViewerExtension5) {
                ITextViewerExtension5 extension = (ITextViewerExtension5)viewer;
                offset = extension.modelOffset2WidgetOffset(offset);
            } else {
                offset -= viewer.getVisibleRegion().getOffset();
            }
            StyledText text = viewer.getTextWidget();
            try {
                text.redrawRange(offset, length, true);
            }
            catch (IllegalArgumentException x) {
                Util.log((Throwable)x, (String)"Error in CEditor.MouseClickListener.repairRepresentation", (ICLogConstants.LogConst)ICLogConstants.CDT);
            }
        }
        this.fActiveRegion = null;
    }

    private void activateCursor(ISourceViewer viewer) {
        StyledText text = viewer.getTextWidget();
        if (text == null || text.isDisposed()) {
            return;
        }
        Display display = text.getDisplay();
        if (this.fCursor == null) {
            this.fCursor = new Cursor((Device)display, 21);
        }
        text.setCursor(this.fCursor);
    }

    private void resetCursor(ISourceViewer viewer) {
        StyledText text = viewer.getTextWidget();
        if (text != null && !text.isDisposed()) {
            text.setCursor(null);
        }
        if (this.fCursor != null) {
            this.fCursor.dispose();
            this.fCursor = null;
        }
    }

    public void install() {
        ISourceViewer sourceViewer = this.fViewer;
        if (sourceViewer == null) {
            return;
        }
        StyledText text = sourceViewer.getTextWidget();
        if (text == null || text.isDisposed()) {
            return;
        }
        this.updateColor(sourceViewer);
        text.addKeyListener((KeyListener)this);
        text.addMouseListener((MouseListener)this);
        text.addMouseMoveListener((MouseMoveListener)this);
        text.addFocusListener((FocusListener)this);
        text.addPaintListener((PaintListener)this);
        this.updateKeyModifierMask();
        IPreferenceStore preferenceStore = this.fPrefStore;
        preferenceStore.addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public void uninstall() {
        ISourceViewer sourceViewer;
        IPreferenceStore preferenceStore;
        if (this.fColor != null) {
            this.fColor.dispose();
            this.fColor = null;
        }
        if (this.fCursor != null) {
            this.fCursor.dispose();
            this.fCursor = null;
        }
        if ((preferenceStore = this.fPrefStore) != null) {
            preferenceStore.removePropertyChangeListener((IPropertyChangeListener)this);
        }
        if ((sourceViewer = this.fViewer) == null) {
            return;
        }
        StyledText text = sourceViewer.getTextWidget();
        if (text == null || text.isDisposed()) {
            return;
        }
        text.removeKeyListener((KeyListener)this);
        text.removeMouseListener((MouseListener)this);
        text.removeMouseMoveListener((MouseMoveListener)this);
        text.removeFocusListener((FocusListener)this);
        text.removePaintListener((PaintListener)this);
    }

    private void updateKeyModifierMask() {
        this.fKeyModifierMask = 262144;
    }

    private void updateColor(ISourceViewer viewer) {
        StyledText text;
        if (this.fColor != null) {
            this.fColor.dispose();
        }
        if ((text = viewer.getTextWidget()) == null || text.isDisposed()) {
            return;
        }
        Display display = text.getDisplay();
        this.fColor = this.createColor(this.fPrefStore, "linkedPositionColor", display);
    }

    private Color createColor(IPreferenceStore store, String key, Display display) {
        RGB rgb = null;
        if (store.contains(key) && (rgb = store.isDefault(key) ? PreferenceConverter.getDefaultColor((IPreferenceStore)store, (String)key) : PreferenceConverter.getColor((IPreferenceStore)store, (String)key)) != null) {
            return new Color((Device)display, rgb);
        }
        return null;
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void mouseDown(MouseEvent event) {
        if (!this.fActive) {
            return;
        }
        if (event.stateMask != this.fKeyModifierMask) {
            this.deactivate();
            return;
        }
        if (event.button != 1) {
            this.deactivate();
            return;
        }
    }

    public void mouseUp(MouseEvent e) {
        if (!this.fActive) {
            return;
        }
        if (e.button != 1) {
            this.deactivate();
            return;
        }
        boolean wasActive = this.fCursor != null;
        boolean wasInclude = this.fIncludeMode;
        this.deactivate();
        if (wasActive && !wasInclude && this.fOpenDeclAction != null) {
            this.fOpenDeclAction.run();
        }
    }

    public void keyPressed(KeyEvent event) {
        if (this.fActive) {
            this.deactivate();
            return;
        }
        if (event.keyCode != this.fKeyModifierMask) {
            this.deactivate();
            return;
        }
        this.fActive = true;
    }

    public void keyReleased(KeyEvent event) {
        if (!this.fActive) {
            return;
        }
        this.deactivate();
    }

    public void mouseMove(MouseEvent event) {
        ISourceViewer viewer;
        if (event.widget instanceof Control && !((Control)event.widget).isFocusControl()) {
            this.deactivate();
            return;
        }
        if (!this.fActive) {
            if (event.stateMask != this.fKeyModifierMask) {
                return;
            }
            this.fActive = true;
        }
        if ((viewer = this.fViewer) == null) {
            this.deactivate();
            return;
        }
        StyledText text = viewer.getTextWidget();
        if (text == null || text.isDisposed()) {
            this.deactivate();
            return;
        }
        if ((event.stateMask & 0x80000) != 0 && text.getSelectionCount() != 0) {
            this.deactivate();
            return;
        }
        IRegion region = this.getCurrentTextRegion(viewer);
        if (region == null || region.getLength() == 0) {
            this.repairRepresentation();
            return;
        }
        this.highlightRegion(viewer, region);
        this.activateCursor(viewer);
    }

    IRegion getCurrentTextRegion(ISourceViewer viewer) {
        int offset = this.getCurrentTextOffset(viewer);
        if (offset == -1) {
            return null;
        }
        return this.selectWord(viewer.getDocument(), offset);
    }

    private IRegion selectWord(IDocument document, int anchor) {
        try {
            char c;
            int offset = anchor;
            while (offset >= 0) {
                c = document.getChar(offset);
                if (!Character.isJavaIdentifierPart(c)) break;
                --offset;
            }
            int start = offset;
            offset = anchor;
            int length = document.getLength();
            while (offset < length) {
                c = document.getChar(offset);
                if (!Character.isJavaIdentifierPart(c)) break;
                ++offset;
            }
            int end = offset;
            if (start == end) {
                return new Region(start, 0);
            }
            String selWord = null;
            String slas = document.get(start, 1);
            selWord = slas.equals("\n") || slas.equals("\t") || slas.equals(" ") ? document.get(start + 1, end - start - 1) : document.get(start, end - start);
            if (this.isKeyWord(selWord)) {
                return null;
            }
            char charX = selWord.charAt(0);
            if (charX == '\"' || charX == '.' || charX == '<' || charX == '>') {
                return null;
            }
            if (selWord.equals("#include")) {
                int end2 = end;
                while (!Character.isJavaIdentifierPart(document.getChar(end2))) {
                    ++end2;
                }
                while (end2 < length) {
                    c = document.getChar(end2);
                    if (!Character.isJavaIdentifierPart(c) && c != '.') break;
                    ++end2;
                }
                int finalEnd = end2;
                selWord = document.get(start, finalEnd - start);
                end = finalEnd + 1;
                --start;
                this.fIncludeMode = true;
            }
            return new Region(start + 1, end - start - 1);
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    private boolean isKeyWord(String selWord) {
        Iterator i = this.fgKeywords.iterator();
        while (i.hasNext()) {
            String tempWord = (String)i.next();
            if (!selWord.equals(tempWord)) continue;
            return true;
        }
        return false;
    }

    private int getCurrentTextOffset(ISourceViewer viewer) {
        try {
            StyledText text = viewer.getTextWidget();
            if (text == null || text.isDisposed()) {
                return -1;
            }
            Display display = text.getDisplay();
            Point absolutePosition = display.getCursorLocation();
            Point relativePosition = text.toControl(absolutePosition);
            int widgetOffset = text.getOffsetAtLocation(relativePosition);
            if (viewer instanceof ITextViewerExtension5) {
                ITextViewerExtension5 extension = (ITextViewerExtension5)viewer;
                return extension.widgetOffset2ModelOffset(widgetOffset);
            }
            return widgetOffset + viewer.getVisibleRegion().getOffset();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return -1;
        }
    }

    private void highlightRegion(ISourceViewer viewer, IRegion region) {
        if (region.equals(this.fActiveRegion)) {
            return;
        }
        this.repairRepresentation();
        StyledText text = viewer.getTextWidget();
        if (text == null || text.isDisposed()) {
            return;
        }
        int offset = 0;
        int length = 0;
        if (viewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 extension = (ITextViewerExtension5)viewer;
            IRegion widgetRange = extension.modelRange2WidgetRange(region);
            if (widgetRange == null) {
                return;
            }
            offset = widgetRange.getOffset();
            length = widgetRange.getLength();
        } else {
            offset = region.getOffset() - viewer.getVisibleRegion().getOffset();
            length = region.getLength();
        }
        StyleRange oldStyleRange = text.getStyleRangeAtOffset(offset);
        Color foregroundColor = this.fColor;
        Color backgroundColor = oldStyleRange == null ? text.getBackground() : oldStyleRange.background;
        StyleRange styleRange = new StyleRange(offset, length, foregroundColor, backgroundColor);
        text.setStyleRange(styleRange);
        text.redrawRange(offset, length, true);
        this.fActiveRegion = region;
    }

    private void repairRepresentation() {
        this.repairRepresentation(false);
    }

    public void focusGained(FocusEvent arg0) {
    }

    public void focusLost(FocusEvent arg0) {
        this.deactivate();
    }

    public void paintControl(PaintEvent event) {
        if (this.fActiveRegion == null) {
            return;
        }
        ISourceViewer viewer = this.fViewer;
        if (viewer == null) {
            return;
        }
        StyledText text = viewer.getTextWidget();
        if (text == null || text.isDisposed()) {
            return;
        }
        int offset = 0;
        int length = 0;
        if (viewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 extension = (ITextViewerExtension5)viewer;
            IRegion widgetRange = extension.modelRange2WidgetRange((IRegion)new Region(offset, length));
            if (widgetRange == null) {
                return;
            }
            offset = widgetRange.getOffset();
            length = widgetRange.getLength();
        } else {
            IRegion region = viewer.getVisibleRegion();
            if (!this.includes(region, this.fActiveRegion)) {
                return;
            }
            offset = this.fActiveRegion.getOffset() - region.getOffset();
            length = this.fActiveRegion.getLength();
        }
        Point minLocation = this.getMinimumLocation(text, offset, length);
        Point maxLocation = this.getMaximumLocation(text, offset, length);
        int x1 = minLocation.x;
        int x2 = minLocation.x + maxLocation.x - minLocation.x - 1;
        int y = minLocation.y + text.getLineHeight() - 1;
        GC gc = event.gc;
        if (this.fColor != null && !this.fColor.isDisposed()) {
            gc.setForeground(this.fColor);
        }
        gc.drawLine(x1, y, x2, y);
    }

    private boolean includes(IRegion region, IRegion position) {
        return position.getOffset() >= region.getOffset() && position.getOffset() + position.getLength() <= region.getOffset() + region.getLength();
    }

    private Point getMinimumLocation(StyledText text, int offset, int length) {
        Point minLocation = new Point(Integer.MAX_VALUE, Integer.MAX_VALUE);
        int i = 0;
        while (i <= length) {
            Point location = text.getLocationAtOffset(offset + i);
            if (location.x < minLocation.x) {
                minLocation.x = location.x;
            }
            if (location.y < minLocation.y) {
                minLocation.y = location.y;
            }
            ++i;
        }
        return minLocation;
    }

    private Point getMaximumLocation(StyledText text, int offset, int length) {
        Point maxLocation = new Point(Integer.MIN_VALUE, Integer.MIN_VALUE);
        int i = 0;
        while (i <= length) {
            Point location = text.getLocationAtOffset(offset + i);
            if (location.x > maxLocation.x) {
                maxLocation.x = location.x;
            }
            if (location.y > maxLocation.y) {
                maxLocation.y = location.y;
            }
            ++i;
        }
        return maxLocation;
    }

    public void propertyChange(PropertyChangeEvent event) {
        ISourceViewer viewer;
        if (event.getProperty().equals("linkedPositionColor") && (viewer = this.fViewer) != null) {
            this.updateColor(viewer);
        }
    }
}

