/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.preferences;

import java.util.ArrayList;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.internal.ui.preferences.OverlayPreferenceStore;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.utils.ui.controls.ControlFactory;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class WorkInProgressPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Button fBackgroundTypeCacheEnabled;
    protected OverlayPreferenceStore fOverlayStore;

    public WorkInProgressPreferencePage() {
        this.setPreferenceStore(CUIPlugin.getDefault().getPreferenceStore());
        this.fOverlayStore = this.createOverlayStore();
    }

    private OverlayPreferenceStore createOverlayStore() {
        ArrayList<OverlayPreferenceStore.OverlayKey> overlayKeys = new ArrayList<OverlayPreferenceStore.OverlayKey>();
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "externMatchEnable"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.INT, "externMatchVisible"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "CDT_INDEXER_TIMEOUT"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "enableBackgroundTypeCache"));
        OverlayPreferenceStore.OverlayKey[] keys = new OverlayPreferenceStore.OverlayKey[overlayKeys.size()];
        overlayKeys.toArray(keys);
        return new OverlayPreferenceStore(this.getPreferenceStore(), keys);
    }

    protected Control createContents(Composite parent) {
        this.fOverlayStore.load();
        this.fOverlayStore.start();
        this.initializeDialogUnits((Control)parent);
        Composite result = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = 0;
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(10);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        result.setLayout((Layout)layout);
        Group backgroundTypeCacheGroup = new Group(result, 0);
        backgroundTypeCacheGroup.setLayout((Layout)new GridLayout());
        backgroundTypeCacheGroup.setLayoutData((Object)new GridData(768));
        backgroundTypeCacheGroup.setText("Open Type");
        this.fBackgroundTypeCacheEnabled = this.createCheckButton((Composite)backgroundTypeCacheGroup, "Cache types in background");
        this.fBackgroundTypeCacheEnabled.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                Button button = (Button)e.widget;
                WorkInProgressPreferencePage.this.fOverlayStore.setValue("enableBackgroundTypeCache", button.getSelection());
            }
        });
        Group editorCorrectionGroup = new Group(result, 0);
        editorCorrectionGroup.setLayout((Layout)new GridLayout());
        editorCorrectionGroup.setLayoutData((Object)new GridData(768));
        editorCorrectionGroup.setText("Editor");
        this.initialize();
        return result;
    }

    private void initialize() {
        this.fBackgroundTypeCacheEnabled.setSelection(this.fOverlayStore.getBoolean("enableBackgroundTypeCache"));
    }

    public void init(IWorkbench workbench) {
    }

    private Combo createComboBox(Composite parent, String label, String[] items, String selection) {
        ControlFactory.createLabel(parent, label);
        Combo combo = ControlFactory.createSelectCombo(parent, items, selection);
        combo.setLayoutData((Object)new GridData());
        return combo;
    }

    private Button createCheckButton(Composite parent, String label) {
        Button button = new Button(parent, 16416);
        button.setText(label);
        GridData data = new GridData();
        button.setLayoutData((Object)data);
        return button;
    }

    private Control addTextField(Composite composite, String label, String key, int textLimit, int indentation, boolean isNumber) {
        Label labelControl = new Label(composite, 0);
        labelControl.setText(label);
        GridData gd = new GridData(32);
        gd.horizontalIndent = indentation;
        labelControl.setLayoutData((Object)gd);
        Text textControl = new Text(composite, 2052);
        gd = new GridData(32);
        gd.widthHint = this.convertWidthInCharsToPixels(textLimit + 1);
        textControl.setLayoutData((Object)gd);
        textControl.setTextLimit(textLimit);
        return textControl;
    }

    public boolean performOk() {
        this.fOverlayStore.propagate();
        Preferences prefs = CCorePlugin.getDefault().getPluginPreferences();
        prefs.setValue("enableBackgroundTypeCache", this.fOverlayStore.getString("enableBackgroundTypeCache"));
        CCorePlugin.getDefault().savePluginPreferences();
        return true;
    }

    public static void initDefaults(IPreferenceStore store) {
        store.setDefault("enableBackgroundTypeCache", false);
        Preferences prefs = CCorePlugin.getDefault().getPluginPreferences();
        if (prefs != null) {
            prefs.setValue("enableBackgroundTypeCache", store.getString("enableBackgroundTypeCache"));
            CCorePlugin.getDefault().savePluginPreferences();
        }
    }

    protected void performDefaults() {
        this.fOverlayStore.loadDefaults();
        this.initialize();
        super.performDefaults();
    }
}

