/**********************************************************************
 * Copyright (c) 2004 QNX Software Systems and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * QNX Software Systems - Initial API and implementation
 ***********************************************************************/
package org.eclipse.cdt.debug.internal.ui.views.sharedlibs;

import org.eclipse.cdt.debug.core.model.ICSharedLibrary;
import org.eclipse.cdt.debug.internal.ui.views.AbstractDebugEventHandler;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.ui.AbstractDebugView;

/**
 * Updates the shared libraries view.
 * 
 * @since: Jan 21, 2003
 */
public class SharedLibrariesViewEventHandler extends AbstractDebugEventHandler {

	/**
	 * Constructs a new event handler on the given view
	 * 
	 * @param view shared libraries view
	 */
	public SharedLibrariesViewEventHandler( AbstractDebugView view ) {
		super( view );
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.cdt.debug.internal.ui.views.AbstractDebugEventHandler#doHandleDebugEvents(DebugEvent[])
	 */
	protected void doHandleDebugEvents( DebugEvent[] events ) {
		for ( int i = 0; i < events.length; i++ ) {
			DebugEvent event = events[i];
			switch( event.getKind() ) {
				case DebugEvent.CREATE:
				case DebugEvent.TERMINATE:
					if ( event.getSource() instanceof IDebugTarget || event.getSource() instanceof ICSharedLibrary )
						refresh();
					break;
				case DebugEvent.CHANGE :
					if ( event.getSource() instanceof ICSharedLibrary )
						refresh( event.getSource() );
					break;
			}
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.cdt.debug.internal.ui.views.AbstractDebugEventHandler#refresh()
	 */
	public void refresh() {
		if ( isAvailable() ) {
			getView().showViewer();
			getTableTreeViewer().refresh();
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.cdt.debug.internal.ui.views.AbstractDebugEventHandler#refresh(java.lang.Object)
	 */
	protected void refresh( Object element ) {
		if ( isAvailable() ) {
			getView().showViewer();
			getTableTreeViewer().refresh( element );
		}
	}
}
