/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.dialogs.cpaths;

import java.util.List;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.internal.ui.dialogs.IStatusChangeListener;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.AbstractPathOptionBlock;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPathIncludeSymbolEntryPage;
import org.eclipse.cdt.ui.dialogs.ICOptionPage;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class NewIncludesSymbolsTabBlock
extends AbstractPathOptionBlock
implements IStatusChangeListener {
    private int[] pathTypes = new int[]{4, 6, 5};
    private CPathIncludeSymbolEntryPage fIncludeSymbols;
    private List fCPaths;
    private Composite fComposite;

    public NewIncludesSymbolsTabBlock(IStatusChangeListener context, int pageToShow) {
        super(context, pageToShow);
    }

    protected void addTab(ICOptionPage tab) {
        tab.setContainer(this);
        tab.createControl(this.fComposite);
        this.addOptionPage(tab);
    }

    protected void addTabs() {
    }

    public Control createContents(Composite parent) {
        this.fComposite = new Composite(parent, 0);
        this.fComposite.setLayout((Layout)new GridLayout(1, false));
        this.fIncludeSymbols = new CPathIncludeSymbolEntryPage(this);
        this.addPage(this.fIncludeSymbols);
        this.setCurrentPage(this.fIncludeSymbols);
        this.initializingTabs = false;
        if (this.getCProject() != null) {
            this.fIncludeSymbols.init(this.getCProject(), this.fCPaths);
        }
        Dialog.applyDialogFont((Control)this.fComposite);
        return this.fComposite;
    }

    protected List getCPaths() {
        if (this.fIncludeSymbols != null) {
            return this.fIncludeSymbols.getCPaths();
        }
        return this.fCPaths;
    }

    protected int[] getFilteredTypes() {
        return this.pathTypes;
    }

    protected void initialize(ICElement element, List cPaths) {
        this.fCPaths = cPaths;
        if (this.fIncludeSymbols != null) {
            this.fIncludeSymbols.init(this.getCProject(), cPaths);
        }
        this.doStatusLineUpdate();
        this.initializeTimeStamps();
    }

    public void statusChanged(IStatus status) {
        switch (status.getSeverity()) {
            case 4: {
                this.getPathStatus().setError(status.getMessage());
                break;
            }
            case 1: {
                this.getPathStatus().setInfo(status.getMessage());
                break;
            }
            case 2: {
                this.getPathStatus().setWarning(status.getMessage());
                break;
            }
            default: {
                this.getPathStatus().setOK();
            }
        }
        this.updateBuildPathStatus();
        this.doStatusLineUpdate();
    }
}

